/*
 * Decompiled with CFR 0.152.
 */
package models.resource;

import actions.support.PathParser;
import java.util.EnumSet;
import models.Assignee;
import models.Attachment;
import models.CommentThread;
import models.CommitComment;
import models.Issue;
import models.IssueComment;
import models.IssueLabel;
import models.IssueLabelCategory;
import models.Label;
import models.Milestone;
import models.Organization;
import models.Posting;
import models.PostingComment;
import models.Project;
import models.PullRequest;
import models.ReviewComment;
import models.User;
import models.Webhook;
import models.enumeration.ResourceType;
import models.resource.ResourceConvertible;
import models.resource.ResourceParam;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import playRepository.Commit;
import playRepository.RepositoryService;
import utils.Config;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class Resource {
    public static boolean exists(ResourceType type, String id) {
        Object finder;
        switch (type) {
            case ISSUE_POST: {
                finder = Issue.finder;
                break;
            }
            case ISSUE_ASSIGNEE: {
                finder = Assignee.finder;
                break;
            }
            case ISSUE_COMMENT: {
                finder = IssueComment.find;
                break;
            }
            case NONISSUE_COMMENT: {
                finder = PostingComment.find;
                break;
            }
            case LABEL: {
                finder = Label.find;
                break;
            }
            case BOARD_POST: {
                finder = Posting.finder;
                break;
            }
            case USER: {
                finder = User.find;
                break;
            }
            case PROJECT: {
                finder = Project.find;
                break;
            }
            case ATTACHMENT: {
                finder = Attachment.find;
                break;
            }
            case MILESTONE: {
                finder = Milestone.find;
                break;
            }
            case COMMIT_COMMENT: {
                finder = CommitComment.find;
                break;
            }
            case PULL_REQUEST: {
                finder = PullRequest.finder;
                break;
            }
            case REVIEW_COMMENT: {
                finder = ReviewComment.find;
                break;
            }
            case ORGANIZATION: {
                finder = Organization.find;
                break;
            }
            case COMMIT: {
                try {
                    String[] pair = id.split(":");
                    Project project2 = (Project)Project.find.byId((Object)Long.valueOf(pair[0]));
                    return RepositoryService.getRepository(project2).getCommit(pair[1]) != null;
                }
                catch (Exception e) {
                    Logger.error((String)"Failed to determine whether the commit exists", (Throwable)e);
                    return false;
                }
            }
            case COMMENT_THREAD: {
                finder = CommentThread.find;
                break;
            }
            case WEBHOOK: {
                finder = Webhook.find;
                break;
            }
            default: {
                throw new IllegalArgumentException(Resource.getInvalidResourceTypeMessage(type));
            }
        }
        return finder.byId((Object)Long.valueOf(id)) != null;
    }

    public static String getInvalidResourceTypeMessage(ResourceType resourceType) {
        if (EnumSet.allOf(ResourceType.class).contains((Object)resourceType)) {
            return "Unsupported resource type " + (Object)((Object)resourceType);
        }
        return "Unknown resource type " + (Object)((Object)resourceType);
    }

    public static Resource get(ResourceType resourceType, String resourceId) {
        Resource resource;
        if (resourceType.equals((Object)ResourceType.COMMIT)) {
            return Commit.getAsResource(resourceId);
        }
        Long longId = Long.valueOf(resourceId);
        switch (resourceType) {
            case ISSUE_POST: {
                resource = ((Issue)Issue.finder.byId((Object)longId)).asResource();
                break;
            }
            case ISSUE_COMMENT: {
                resource = ((IssueComment)IssueComment.find.byId((Object)longId)).asResource();
                break;
            }
            case NONISSUE_COMMENT: {
                resource = ((PostingComment)PostingComment.find.byId((Object)longId)).asResource();
                break;
            }
            case LABEL: {
                resource = ((Label)Label.find.byId((Object)longId)).asResource();
                break;
            }
            case BOARD_POST: {
                resource = ((Posting)Posting.finder.byId((Object)longId)).asResource();
                break;
            }
            case USER: {
                resource = ((User)User.find.byId((Object)longId)).asResource();
                break;
            }
            case PROJECT: {
                resource = ((Project)Project.find.byId((Object)longId)).asResource();
                break;
            }
            case ATTACHMENT: {
                resource = ((Attachment)Attachment.find.byId((Object)longId)).asResource();
                break;
            }
            case MILESTONE: {
                resource = ((Milestone)Milestone.find.byId((Object)longId)).asResource();
                break;
            }
            case COMMIT_COMMENT: {
                resource = ((CommitComment)CommitComment.find.byId((Object)longId)).asResource();
                break;
            }
            case PULL_REQUEST: {
                return ((PullRequest)PullRequest.finder.byId((Object)longId)).asResource();
            }
            case USER_AVATAR: {
                return ((User)User.find.byId((Object)longId)).avatarAsResource();
            }
            case REVIEW_COMMENT: {
                return ((ReviewComment)ReviewComment.find.byId((Object)longId)).asResource();
            }
            case ORGANIZATION: {
                resource = ((Organization)Organization.find.byId((Object)longId)).asResource();
                break;
            }
            case COMMENT_THREAD: {
                return ((CommentThread)CommentThread.find.byId((Object)longId)).asResource();
            }
            case WEBHOOK: {
                return ((Webhook)Webhook.find.byId((Object)longId)).asResource();
            }
            default: {
                throw new IllegalArgumentException(Resource.getInvalidResourceTypeMessage(resourceType));
            }
        }
        return resource;
    }

    public ResourceParam asParameter() {
        return ResourceParam.get(this);
    }

    public abstract String getId();

    public abstract Project getProject();

    public abstract ResourceType getType();

    public Resource getContainer() {
        return null;
    }

    public Long getAuthorId() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAuthoredBy(User user) {
        if (this.getAuthorId() == null) return false;
        User user2 = user;
        Long l = null;
        l = user2.getId();
        if (!this.getAuthorId().equals(l)) return false;
        return true;
    }

    public void delete() {
        throw new UnsupportedOperationException();
    }

    public String getDetail() {
        Project project2 = this.getProject();
        String path = this.getPath();
        if (project2 != null && path != null) {
            return project2 + "/" + path;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Resource that = (Resource)object;
        if (!this.getId().equals(that.getId())) {
            return false;
        }
        return this.getType().equals((Object)that.getType());
    }

    public int hashCode() {
        int result2 = 0;
        result2 = 31 * result2 + (this.getId() != null ? this.getId().hashCode() : 0);
        result2 = 31 * result2 + (this.getType() != null ? this.getType().hashCode() : 0);
        return result2;
    }

    public String toString() {
        return this.getPath();
    }

    private String getPath() {
        return this.getType().resource() + "/" + this.getId();
    }

    public static ResourceConvertible getResourceObject(PathParser parser, Project project2, ResourceType resourceType) {
        switch (resourceType) {
            case PROJECT: {
                return project2;
            }
            case MILESTONE: {
                return Milestone.findById(Long.parseLong(parser.getPathSegment(3)));
            }
            case BOARD_POST: {
                return Posting.findByNumber(project2, Long.parseLong(parser.getPathSegment(3)));
            }
            case ISSUE_POST: {
                return Issue.findByNumber(project2, Long.parseLong(parser.getPathSegment(3)));
            }
            case ISSUE_LABEL: {
                return (ResourceConvertible)IssueLabel.finder.byId((Object)Long.parseLong(parser.getPathSegment(4)));
            }
            case PULL_REQUEST: {
                return PullRequest.findOne(project2, Long.parseLong(parser.getPathSegment(3)));
            }
            case COMMIT_COMMENT: {
                return (ResourceConvertible)CommitComment.find.byId((Object)Long.parseLong(parser.getPathSegment(5)));
            }
            case ISSUE_LABEL_CATEGORY: {
                return (ResourceConvertible)IssueLabelCategory.find.byId((Object)Long.parseLong(parser.getPathSegment(5)));
            }
        }
        throw new IllegalAccessError(Resource.getInvalidResourceTypeMessage(resourceType));
    }

    public static Resource findByPath(String path) {
        ResourceType resourceType;
        String[] segments = path.split("/");
        if (segments.length < 2) {
            return null;
        }
        try {
            resourceType = ResourceType.getValue(segments[0]);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return Resource.get(resourceType, segments[1]);
    }

    public String getMessageId() {
        return String.format("<%s@%s>", this, Config.getHostname());
    }
}

