/*
 * Decompiled with CFR 0.152.
 */
package playRepository;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import models.Project;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import playRepository.RepositoryService;
import utils.Config;
import utils.LineEnding;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class BareRepository {
    public static String readREADME(Project project2) {
        ObjectLoader loader = null;
        Repository repository = BareRepository.getRepository(project2);
        try {
            loader = repository.open((AnyObjectId)BareRepository.getFirstFoundREADMEfileObjectId(repository));
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.error((String)e.getMessage());
        }
        if (loader == null) {
            return null;
        }
        return new String(loader.getCachedBytes(), Config.getCharset());
    }

    public static Repository getRepository(Project project2) {
        Repository repository = null;
        try {
            RepositoryCache.FileKey fileKey = RepositoryCache.FileKey.exact((File)RepositoryService.getRepository(project2).getDirectory(), (FS)FS.DETECTED);
            repository = fileKey.open(false);
        }
        catch (IOException | ServletException e) {
            e.printStackTrace();
            Logger.error((String)e.getMessage());
        }
        return repository;
    }

    public static ObjectId getFileObjectId(Repository repository, String fileNameWithPath) throws IOException {
        TreeWalk treeWalk = new TreeWalk(repository);
        RevTree revTree = BareRepository.getRevTreeFromRef(repository, repository.findRef("HEAD"));
        if (revTree == null) {
            return ObjectId.zeroId();
        }
        treeWalk.addTree((AnyObjectId)revTree);
        treeWalk.setRecursive(false);
        treeWalk.setFilter((TreeFilter)PathFilter.create((String)fileNameWithPath));
        return treeWalk.getObjectId(0);
    }

    private static ObjectId getFirstFoundREADMEfileObjectId(Repository repository) throws IOException {
        TreeWalk treeWalk = new TreeWalk(repository);
        RevTree revTree = BareRepository.getRevTreeFromRef(repository, repository.findRef("HEAD"));
        if (revTree == null) {
            return ObjectId.zeroId();
        }
        treeWalk.addTree((AnyObjectId)revTree);
        treeWalk.setRecursive(false);
        treeWalk.setFilter(OrTreeFilter.create((TreeFilter[])BareRepository.READMEFileNameFilter()));
        if (!treeWalk.next()) {
            Logger.info((String)("No tree or no README file found at " + repository.getDirectory()));
        }
        return treeWalk.getObjectId(0);
    }

    private static RevTree getRevTreeFromRef(Repository repository, Ref ref2) throws IOException {
        if (ref2.getObjectId() == null) {
            return null;
        }
        RevWalk revWalk = new RevWalk(repository);
        RevCommit commit = revWalk.parseCommit((AnyObjectId)ref2.getObjectId());
        return commit.getTree();
    }

    private static TreeFilter[] READMEFileNameFilter() {
        TreeFilter[] filters = new TreeFilter[]{PathFilter.create((String)"README.md"), PathFilter.create((String)"readme.md"), PathFilter.create((String)"README.markdown"), PathFilter.create((String)"readme.markdown")};
        return filters;
    }

    public static LineEnding.EndingType findFileLineEnding(Repository repository, String fileNameWithPath) throws IOException {
        ObjectId oldObjectId = BareRepository.getFileObjectId(repository, fileNameWithPath);
        if (oldObjectId.equals((AnyObjectId)ObjectId.zeroId())) {
            return LineEnding.EndingType.UNDEFINED;
        }
        String fileContents = new String(repository.open((AnyObjectId)oldObjectId).getBytes(), Config.getCharset());
        return LineEnding.findLineEnding(fileContents);
    }
}

