/*
 * Decompiled with CFR 0.152.
 */
package playRepository;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import models.CodeRange;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.FileMode;
import play.core.enhancers.PropertiesEnhancer;
import playRepository.DiffLine;
import playRepository.DiffLineType;
import playRepository.Hunk;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class FileDiff {
    public static final int SIZE_LIMIT = 512000;
    public static final int LINE_LIMIT = 5000;
    private Set<Error> errors = new HashSet<Error>();
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public RawText a;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public RawText b;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public EditList editList;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String commitA;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String commitB;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String pathA;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String pathB;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public int context;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public boolean isBinaryA;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public boolean isBinaryB;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public DiffEntry.ChangeType changeType;
    private Integer interestLine;
    private CodeRange.Side interestSide;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public FileMode oldMode;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public FileMode newMode;
    private Hunks hunks;

    public FileDiff() {
        int bl = 3;
        FileDiff fileDiff = this;
        fileDiff.setContext(bl);
        boolean bl2 = false;
        fileDiff = this;
        fileDiff.setIsBinaryA(bl2);
        boolean bl3 = false;
        fileDiff = this;
        fileDiff.setIsBinaryB(bl3);
        this.interestLine = null;
        this.interestSide = null;
    }

    public Integer getInterestLine() {
        return this.interestLine;
    }

    public void setInterestLine(Integer interestLine) {
        this.interestLine = interestLine;
        this.hunks = null;
    }

    public CodeRange.Side getInterestSide() {
        return this.interestSide;
    }

    public void setInterestSide(CodeRange.Side interestSide) {
        this.interestSide = interestSide;
        this.hunks = null;
    }

    public static boolean isRawTextSizeExceeds(RawText rawText) {
        return FileDiff.getRawTextSize(rawText) > 512000 || rawText.size() > 5000;
    }

    public static int getRawTextSize(RawText rawText) {
        int size = 0;
        for (int i = 0; i < rawText.size(); ++i) {
            size += rawText.getString(i).length();
        }
        return size;
    }

    public Hunks getHunks() {
        int lines;
        int size;
        Object object;
        block14: {
            if (this.hunks != null) {
                return this.hunks;
            }
            object = this;
            EditList editList = null;
            editList = ((FileDiff)object).getEditList();
            if (editList == null) {
                return null;
            }
            size = 0;
            lines = 0;
            this.hunks = new Hunks();
            int curIdx = 0;
            do {
                object = this;
                editList = null;
                editList = ((FileDiff)object).getEditList();
                if (curIdx >= editList.size()) break block14;
                Hunk hunk = new Hunk();
                object = this;
                editList = null;
                editList = ((FileDiff)object).getEditList();
                Edit curEdit = (Edit)editList.get(curIdx);
                object = this;
                editList = null;
                editList = ((FileDiff)object).getEditList();
                int endIdx = this.findCombinedEnd((List<Edit>)editList, curIdx);
                object = this;
                editList = null;
                editList = ((FileDiff)object).getEditList();
                Edit endEdit = (Edit)editList.get(endIdx);
                object = this;
                int n = 0;
                n = ((FileDiff)object).getContext();
                int aCur = Math.max(0, curEdit.getBeginA() - n);
                object = this;
                n = 0;
                n = ((FileDiff)object).getContext();
                int bCur = Math.max(0, curEdit.getBeginB() - n);
                object = this;
                RawText rawText = null;
                rawText = ((FileDiff)object).getA();
                object = this;
                int n2 = 0;
                n2 = ((FileDiff)object).getContext();
                int aEnd = Math.min(rawText.size(), endEdit.getEndA() + n2);
                object = this;
                RawText rawText2 = null;
                rawText2 = ((FileDiff)object).getB();
                object = this;
                int n3 = 0;
                n3 = ((FileDiff)object).getContext();
                int bEnd = Math.min(rawText2.size(), endEdit.getEndB() + n3);
                n3 = aCur;
                object = hunk;
                ((Hunk)object).setBeginA(n3);
                n3 = aEnd;
                object = hunk;
                ((Hunk)object).setEndA(n3);
                n3 = bCur;
                object = hunk;
                ((Hunk)object).setBeginB(n3);
                n3 = bEnd;
                object = hunk;
                ((Hunk)object).setEndB(n3);
                while (aCur < aEnd || bCur < bEnd) {
                    if (aCur < curEdit.getBeginA() || endIdx + 1 < curIdx) {
                        object = hunk;
                        RawText rawText3 = null;
                        RawText rawText4 = rawText3 = ((Hunk)object).getLines();
                        object = this;
                        rawText3 = null;
                        rawText3 = ((FileDiff)object).getA();
                        rawText4.add(new DiffLine(this, DiffLineType.CONTEXT, aCur, bCur, rawText3.getString(aCur)));
                        ++aCur;
                        ++bCur;
                    } else if (aCur < curEdit.getEndA()) {
                        object = hunk;
                        RawText rawText5 = null;
                        RawText rawText6 = rawText5 = ((Hunk)object).getLines();
                        object = this;
                        rawText5 = null;
                        rawText5 = ((FileDiff)object).getA();
                        rawText6.add(new DiffLine(this, DiffLineType.REMOVE, aCur, null, rawText5.getString(aCur)));
                        ++aCur;
                    } else if (bCur < curEdit.getEndB()) {
                        object = hunk;
                        RawText rawText7 = null;
                        RawText rawText8 = rawText7 = ((Hunk)object).getLines();
                        object = this;
                        rawText7 = null;
                        rawText7 = ((FileDiff)object).getB();
                        rawText8.add(new DiffLine(this, DiffLineType.ADD, null, bCur, rawText7.getString(bCur)));
                        ++bCur;
                    }
                    if (!FileDiff.end(curEdit, aCur, bCur)) continue;
                    object = this;
                    EditList editList2 = null;
                    editList2 = ((FileDiff)object).getEditList();
                    if (++curIdx >= editList2.size()) continue;
                    object = this;
                    editList2 = null;
                    editList2 = ((FileDiff)object).getEditList();
                    curEdit = (Edit)editList2.get(curIdx);
                }
                if (this.getInterestLine() != null && this.getInterestSide() != null) {
                    boolean added = false;
                    switch (this.getInterestSide()) {
                        case A: {
                            object = hunk;
                            int n4 = 0;
                            n4 = ((Hunk)object).getBeginA();
                            if (n4 > this.getInterestLine()) break;
                            object = hunk;
                            n4 = 0;
                            n4 = ((Hunk)object).getEndA();
                            if (n4 < this.getInterestLine()) break;
                            this.hunks.add(hunk);
                            size += hunk.size();
                            object = hunk;
                            List<DiffLine> list2 = null;
                            list2 = ((Hunk)object).getLines();
                            lines += list2.size();
                            added = true;
                            break;
                        }
                        case B: {
                            object = hunk;
                            int n5 = 0;
                            n5 = ((Hunk)object).getBeginB();
                            if (n5 > this.getInterestLine()) break;
                            object = hunk;
                            n5 = 0;
                            n5 = ((Hunk)object).getEndB();
                            if (n5 < this.getInterestLine()) break;
                            this.hunks.add(hunk);
                            size += hunk.size();
                            object = hunk;
                            List<DiffLine> list3 = null;
                            list3 = ((Hunk)object).getLines();
                            lines += list3.size();
                            added = true;
                            break;
                        }
                    }
                    if (!added) continue;
                    break block14;
                }
                this.hunks.add(hunk);
                size += hunk.size();
                object = hunk;
                List<DiffLine> list4 = null;
                list4 = ((Hunk)object).getLines();
                lines += list4.size();
            } while (size <= 512000 && lines <= 5000);
            this.hunks = new SizeExceededHunks();
            return this.hunks;
        }
        int n = size;
        object = this.hunks;
        ((Hunks)object).setSize(n);
        n = lines;
        object = this.hunks;
        ((Hunks)object).setLines(n);
        return this.hunks;
    }

    private int findCombinedEnd(List<Edit> edits, int i) {
        int end;
        for (end = i + 1; end < edits.size() && (this.combineA(edits, end) || this.combineB(edits, end)); ++end) {
        }
        return end - 1;
    }

    private boolean combineA(List<Edit> e, int i) {
        FileDiff fileDiff = this;
        int n = 0;
        n = fileDiff.getContext();
        return e.get(i).getBeginA() - e.get(i - 1).getEndA() <= 2 * n;
    }

    private boolean combineB(List<Edit> e, int i) {
        FileDiff fileDiff = this;
        int n = 0;
        n = fileDiff.getContext();
        return e.get(i).getBeginB() - e.get(i - 1).getEndB() <= 2 * n;
    }

    private static boolean end(Edit edit2, int a, int b) {
        return edit2.getEndA() <= a && edit2.getEndB() <= b;
    }

    private boolean checkEndOfLineMissing(RawText text, int line) {
        return line + 1 == text.size() && text.isMissingNewlineAtEnd();
    }

    public void updateRange(Integer lineA, Integer lineB) {
        FileDiff fileDiff = this;
        EditList editList = null;
        editList = fileDiff.getEditList();
        if (editList == null) {
            return;
        }
        EditList newEditList = new EditList();
        fileDiff = this;
        editList = null;
        editList = fileDiff.getEditList();
        for (Edit edit2 : editList) {
            if (lineA != null) {
                fileDiff = this;
                int n = 0;
                n = fileDiff.getContext();
                if (lineA >= edit2.getBeginA() - n) {
                    fileDiff = this;
                    n = 0;
                    n = fileDiff.getContext();
                    if (lineA <= edit2.getEndA() + n) {
                        newEditList.add((Object)edit2);
                    }
                }
            }
            if (lineB == null) continue;
            fileDiff = this;
            int n = 0;
            n = fileDiff.getContext();
            if (lineB < edit2.getBeginB() - n) continue;
            fileDiff = this;
            n = 0;
            n = fileDiff.getContext();
            if (lineB > edit2.getEndB() + n) continue;
            newEditList.add((Object)edit2);
        }
        editList = newEditList;
        fileDiff = this;
        fileDiff.setEditList(editList);
    }

    public boolean isFileModeChanged() {
        FileDiff fileDiff = this;
        FileMode fileMode = null;
        fileMode = fileDiff.getOldMode();
        if (FileMode.MISSING.equals(fileMode.getBits())) {
            return false;
        }
        fileDiff = this;
        fileMode = null;
        fileMode = fileDiff.getNewMode();
        if (FileMode.MISSING.equals(fileMode.getBits())) {
            return false;
        }
        fileDiff = this;
        fileMode = null;
        fileMode = fileDiff.getOldMode();
        int n = fileMode.getBits();
        fileDiff = this;
        fileMode = null;
        fileMode = fileDiff.getNewMode();
        return n != fileMode.getBits();
    }

    public void addError(Error error) {
        this.errors.add(error);
    }

    public boolean hasAnyError(Error ... errors) {
        this.refreshErrors();
        for (Error error : errors) {
            if (!this.errors.contains((Object)error)) continue;
            return true;
        }
        return false;
    }

    private void refreshErrors() {
        if (this.getHunks() instanceof SizeExceededHunks) {
            this.addError(Error.DIFF_SIZE_EXCEEDED);
        }
        FileDiff fileDiff = this;
        EditList editList = null;
        editList = fileDiff.getEditList();
        if (editList == null) {
            fileDiff = this;
            editList = null;
            editList = fileDiff.getA();
            if (editList != null) {
                fileDiff = this;
                editList = null;
                editList = fileDiff.getA();
                if (FileDiff.isRawTextSizeExceeds((RawText)editList)) {
                    this.addError(Error.A_SIZE_EXCEEDED);
                }
            }
        }
        fileDiff = this;
        editList = null;
        editList = fileDiff.getEditList();
        if (editList == null) {
            fileDiff = this;
            editList = null;
            editList = fileDiff.getB();
            if (editList != null) {
                fileDiff = this;
                editList = null;
                editList = fileDiff.getB();
                if (FileDiff.isRawTextSizeExceeds((RawText)editList)) {
                    this.addError(Error.B_SIZE_EXCEEDED);
                }
            }
        }
    }

    public boolean hasError(Error error) {
        this.refreshErrors();
        return this.errors.contains((Object)error);
    }

    public boolean hasError() {
        this.refreshErrors();
        return !this.errors.isEmpty();
    }

    public boolean equals(Object o) {
        block36: {
            block37: {
                String string;
                FileDiff fileDiff;
                FileDiff fileDiff2;
                block35: {
                    block33: {
                        block34: {
                            block32: {
                                block30: {
                                    block31: {
                                        block29: {
                                            block27: {
                                                block28: {
                                                    block26: {
                                                        block24: {
                                                            block25: {
                                                                block23: {
                                                                    block21: {
                                                                        block22: {
                                                                            block20: {
                                                                                if (this == o) {
                                                                                    return true;
                                                                                }
                                                                                if (o == null || this.getClass() != o.getClass()) {
                                                                                    return false;
                                                                                }
                                                                                fileDiff2 = (FileDiff)o;
                                                                                fileDiff = this;
                                                                                string = null;
                                                                                string = fileDiff.getCommitA();
                                                                                if (string == null) break block20;
                                                                                fileDiff = this;
                                                                                string = null;
                                                                                String string2 = string = fileDiff.getCommitA();
                                                                                fileDiff = fileDiff2;
                                                                                string = null;
                                                                                string = fileDiff.getCommitA();
                                                                                if (string2.equals(string)) break block21;
                                                                                break block22;
                                                                            }
                                                                            fileDiff = fileDiff2;
                                                                            string = null;
                                                                            string = fileDiff.getCommitA();
                                                                            if (string == null) break block21;
                                                                        }
                                                                        return false;
                                                                    }
                                                                    fileDiff = this;
                                                                    string = null;
                                                                    string = fileDiff.getCommitB();
                                                                    if (string == null) break block23;
                                                                    fileDiff = this;
                                                                    string = null;
                                                                    String string3 = string = fileDiff.getCommitB();
                                                                    fileDiff = fileDiff2;
                                                                    string = null;
                                                                    string = fileDiff.getCommitB();
                                                                    if (string3.equals(string)) break block24;
                                                                    break block25;
                                                                }
                                                                fileDiff = fileDiff2;
                                                                string = null;
                                                                string = fileDiff.getCommitB();
                                                                if (string == null) break block24;
                                                            }
                                                            return false;
                                                        }
                                                        fileDiff = this;
                                                        string = null;
                                                        string = fileDiff.getEditList();
                                                        if (string == null) break block26;
                                                        fileDiff = this;
                                                        string = null;
                                                        String string4 = string = fileDiff.getEditList();
                                                        fileDiff = fileDiff2;
                                                        string = null;
                                                        string = fileDiff.getEditList();
                                                        if (string4.equals((Object)string)) break block27;
                                                        break block28;
                                                    }
                                                    fileDiff = fileDiff2;
                                                    string = null;
                                                    string = fileDiff.getEditList();
                                                    if (string == null) break block27;
                                                }
                                                return false;
                                            }
                                            fileDiff = this;
                                            string = null;
                                            string = fileDiff.getPathA();
                                            if (string == null) break block29;
                                            fileDiff = this;
                                            string = null;
                                            String string5 = string = fileDiff.getPathA();
                                            fileDiff = fileDiff2;
                                            string = null;
                                            string = fileDiff.getPathA();
                                            if (string5.equals(string)) break block30;
                                            break block31;
                                        }
                                        fileDiff = fileDiff2;
                                        string = null;
                                        string = fileDiff.getPathA();
                                        if (string == null) break block30;
                                    }
                                    return false;
                                }
                                fileDiff = this;
                                string = null;
                                string = fileDiff.getPathB();
                                if (string == null) break block32;
                                fileDiff = this;
                                string = null;
                                String string6 = string = fileDiff.getPathB();
                                fileDiff = fileDiff2;
                                string = null;
                                string = fileDiff.getPathB();
                                if (string6.equals(string)) break block33;
                                break block34;
                            }
                            fileDiff = fileDiff2;
                            string = null;
                            string = fileDiff.getPathB();
                            if (string == null) break block33;
                        }
                        return false;
                    }
                    fileDiff = this;
                    string = null;
                    string = fileDiff.getChangeType();
                    if (string == null) break block35;
                    fileDiff = this;
                    string = null;
                    String string7 = string = fileDiff.getChangeType();
                    fileDiff = fileDiff2;
                    string = null;
                    string = fileDiff.getChangeType();
                    if (string7.equals((Object)string)) break block36;
                    break block37;
                }
                fileDiff = fileDiff2;
                string = null;
                string = fileDiff.getChangeType();
                if (string == null) break block36;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        FileDiff fileDiff = this;
        Object object = null;
        object = fileDiff.getEditList();
        if (object != null) {
            fileDiff = this;
            object = null;
            object = fileDiff.getEditList();
            n6 = object.hashCode();
        } else {
            n6 = 0;
        }
        int result2 = n6;
        fileDiff = this;
        object = null;
        object = fileDiff.getCommitA();
        if (object != null) {
            fileDiff = this;
            object = null;
            object = fileDiff.getCommitA();
            n5 = ((String)object).hashCode();
        } else {
            n5 = 0;
        }
        result2 = 31 * result2 + n5;
        fileDiff = this;
        object = null;
        object = fileDiff.getCommitB();
        if (object != null) {
            fileDiff = this;
            object = null;
            object = fileDiff.getCommitB();
            n4 = ((String)object).hashCode();
        } else {
            n4 = 0;
        }
        result2 = 31 * result2 + n4;
        fileDiff = this;
        object = null;
        object = fileDiff.getPathA();
        if (object != null) {
            fileDiff = this;
            object = null;
            object = fileDiff.getPathA();
            n3 = ((String)object).hashCode();
        } else {
            n3 = 0;
        }
        result2 = 31 * result2 + n3;
        fileDiff = this;
        object = null;
        object = fileDiff.getPathB();
        if (object != null) {
            fileDiff = this;
            object = null;
            object = fileDiff.getPathB();
            n2 = ((String)object).hashCode();
        } else {
            n2 = 0;
        }
        result2 = 31 * result2 + n2;
        fileDiff = this;
        object = null;
        object = fileDiff.getChangeType();
        if (object != null) {
            fileDiff = this;
            object = null;
            object = fileDiff.getChangeType();
            n = object.hashCode();
        } else {
            n = 0;
        }
        result2 = 31 * result2 + n;
        return result2;
    }

    public String toString() {
        FileDiff fileDiff = this;
        String string = null;
        string = fileDiff.getCommitA();
        StringBuilder stringBuilder = new StringBuilder().append("FileDiff{commitA='").append(string).append('\'').append(", commitB='");
        fileDiff = this;
        string = null;
        string = fileDiff.getCommitB();
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('\'').append(", pathA='");
        fileDiff = this;
        string = null;
        string = fileDiff.getPathA();
        StringBuilder stringBuilder3 = stringBuilder2.append(string).append('\'').append(", pathB='");
        fileDiff = this;
        string = null;
        string = fileDiff.getPathB();
        StringBuilder stringBuilder4 = stringBuilder3.append(string).append('\'').append(", changeType=");
        fileDiff = this;
        string = null;
        string = fileDiff.getChangeType();
        return stringBuilder4.append((Object)string).append('}').toString();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public RawText getA() {
        return this.a;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setA(RawText rawText) {
        this.a = rawText;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public RawText getB() {
        return this.b;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setB(RawText rawText) {
        this.b = rawText;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public EditList getEditList() {
        return this.editList;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setEditList(EditList editList) {
        this.editList = editList;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getCommitA() {
        return this.commitA;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCommitA(String string) {
        this.commitA = string;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getCommitB() {
        return this.commitB;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCommitB(String string) {
        this.commitB = string;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getPathA() {
        return this.pathA;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setPathA(String string) {
        this.pathA = string;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getPathB() {
        return this.pathB;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setPathB(String string) {
        this.pathB = string;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public int getContext() {
        return this.context;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setContext(int n) {
        this.context = n;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public boolean getIsBinaryA() {
        return this.isBinaryA;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setIsBinaryA(boolean bl) {
        this.isBinaryA = bl;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public boolean getIsBinaryB() {
        return this.isBinaryB;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setIsBinaryB(boolean bl) {
        this.isBinaryB = bl;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public DiffEntry.ChangeType getChangeType() {
        return this.changeType;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setChangeType(DiffEntry.ChangeType changeType) {
        this.changeType = changeType;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public FileMode getOldMode() {
        return this.oldMode;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setOldMode(FileMode fileMode) {
        this.oldMode = fileMode;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public FileMode getNewMode() {
        return this.newMode;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setNewMode(FileMode fileMode) {
        this.newMode = fileMode;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class SizeExceededHunks
    extends Hunks {
        private static final long serialVersionUID = 3089104397758709369L;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class Hunks
    extends ArrayList<Hunk> {
        private static final long serialVersionUID = -2359650678446017697L;
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public int size;
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public int lines;

        @PropertiesEnhancer.GeneratedAccessor
        public int getSize() {
            return this.size;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setSize(int n) {
            this.size = n;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public int getLines() {
            return this.lines;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setLines(int n) {
            this.lines = n;
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static enum Error {
        A_SIZE_EXCEEDED,
        B_SIZE_EXCEEDED,
        DIFF_SIZE_EXCEEDED,
        OTHERS_SIZE_EXCEEDED;

    }
}

