/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.Optional;
import models.Assignee;
import models.Issue;
import models.IssueComment;
import models.Organization;
import models.OrganizationUser;
import models.Project;
import models.ProjectTransfer;
import models.ProjectUser;
import models.User;
import models.enumeration.Operation;
import models.enumeration.ResourceType;
import models.resource.GlobalResource;
import models.resource.Resource;
import org.apache.commons.lang.BooleanUtils;
import play.Configuration;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AccessControl {
    private static boolean allowsAnonymousAccess = true;

    public static boolean isGlobalResourceCreatable(User user) {
        return !user.isAnonymous();
    }

    public static boolean isProjectResourceCreatable(User user, Project project2, ResourceType resourceType) {
        block9: {
            block8: {
                if ((user = User.findUserIfTokenExist(user)) == null || user.isAnonymous()) {
                    return false;
                }
                if (user.isSiteManager()) break block8;
                Model model = project2;
                Object object = null;
                object = model.getOrganization();
                if (OrganizationUser.isAdmin((Organization)object, user)) break block8;
                model = user;
                object = null;
                Object object2 = object = model.getId();
                model = project2;
                object = null;
                object = model.getId();
                if (!ProjectUser.isMember((Long)object2, (Long)object) && !AccessControl.isAllowedIfGroupMember(project2, user)) break block9;
            }
            return true;
        }
        if (!project2.isPublic()) {
            return false;
        }
        switch (resourceType) {
            case ISSUE_POST: 
            case BOARD_POST: 
            case ISSUE_COMMENT: 
            case NONISSUE_COMMENT: 
            case FORK: 
            case COMMIT_COMMENT: 
            case REVIEW_COMMENT: {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAllowedIfGroupMember(Project project2, User user) {
        if (!project2.hasGroup()) return false;
        if (!project2.isPublic()) {
            if (!project2.isProtected()) return false;
        }
        Project project3 = project2;
        Organization organization2 = null;
        organization2 = project3.getOrganization();
        if (!OrganizationUser.isMember(organization2, user)) return false;
        return true;
    }

    public static boolean isAnonymousNotAllowed() {
        return !allowsAnonymousAccess;
    }

    public static boolean isResourceCreatable(User user, Resource container, ResourceType resourceType) {
        Project project2;
        if (AccessControl.isAnonymousNotAllowed() && user.isAnonymous()) {
            return false;
        }
        if (AccessControl.isAllowedIfAuthor(user, container) || AccessControl.isAllowedIfAssignee(user, container) || AccessControl.isAllowedIfSharer(user, container)) {
            return true;
        }
        Project project3 = project2 = container.getType() == ResourceType.PROJECT ? (Project)Project.find.byId((Object)Long.valueOf(container.getId())) : container.getProject();
        if (project2 == null) {
            return AccessControl.isGlobalResourceCreatable(user);
        }
        return AccessControl.isProjectResourceCreatable(user, project2, resourceType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isGlobalResourceAllowed(User user, GlobalResource resource, Operation operation) {
        if (operation == Operation.ASSIGN_ISSUE && resource.getType() == ResourceType.PROJECT) {
            Project project2 = (Project)Project.find.byId((Object)Long.parseLong(resource.getId()));
            if (user.isMemberOf(project2)) return true;
            if (project2.isPrivate()) return false;
            Project project3 = project2;
            Organization organization2 = null;
            organization2 = project3.getOrganization();
            if (!OrganizationUser.isMember(organization2, user)) return false;
            return true;
        }
        if (resource.getType() == ResourceType.ATTACHMENT && resource.getContainer().getType() == ResourceType.USER) {
            User user2 = user;
            Long l = null;
            l = user2.getId();
            return l.toString().equals(resource.getContainer().getId());
        }
        if (operation == Operation.READ) {
            Model model;
            if (resource.getType() != ResourceType.PROJECT) return true;
            Project project4 = (Project)Project.find.byId((Object)Long.valueOf(resource.getId()));
            if (project4 == null) {
                return false;
            }
            if (project4.isPublic()) {
                model = user;
                boolean bl = false;
                bl = model.getIsGuest();
                if (!bl) return true;
            }
            if (user.isMemberOf(project4)) return true;
            model = project4;
            Organization organization3 = null;
            organization3 = model.getOrganization();
            if (OrganizationUser.isAdmin(organization3, user)) return true;
            if (!AccessControl.isAllowedIfGroupMember(project4, user)) return false;
            return true;
        }
        if (operation == Operation.WATCH && resource.getType() == ResourceType.PROJECT) {
            Project project5 = (Project)Project.find.byId((Object)Long.valueOf(resource.getId()));
            if (project5 == null) {
                return false;
            }
            if (project5.isPublic()) {
                if (!user.isAnonymous()) return true;
            }
            if (user.isMemberOf(project5)) return true;
            Project project6 = project5;
            Organization organization4 = null;
            organization4 = project6.getOrganization();
            if (OrganizationUser.isAdmin(organization4, user)) return true;
            if (!AccessControl.isAllowedIfGroupMember(project5, user)) return false;
            return true;
        }
        if (operation == Operation.LEAVE && resource.getType() == ResourceType.PROJECT) {
            Project project7 = (Project)Project.find.byId((Object)Long.valueOf(resource.getId()));
            if (project7 == null) return false;
            if (project7.isOwner(user)) return false;
            if (!user.isMemberOf(project7)) return false;
            return true;
        }
        switch (resource.getType()) {
            case USER: 
            case USER_AVATAR: {
                User user3 = user;
                Long l = null;
                l = user3.getId();
                return l.toString().equals(resource.getId());
            }
            case PROJECT: {
                Model model = user;
                Object object = null;
                object = model.getId();
                if (ProjectUser.isManager((Long)object, Long.valueOf(resource.getId()))) {
                    return true;
                }
                Project project8 = (Project)Project.find.byId((Object)Long.valueOf(resource.getId()));
                if (project8 == null) {
                    return false;
                }
                model = project8;
                object = null;
                object = model.getOrganization();
                return OrganizationUser.isAdmin((Organization)object, user);
            }
            case ORGANIZATION: {
                User user4 = user;
                Long l = null;
                l = user4.getId();
                return OrganizationUser.isAdmin(Long.valueOf(resource.getId()), l);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isProjectResourceAllowed(User user, Project project2, Resource resource, Operation operation) {
        if (user.isSiteManager()) {
            return true;
        }
        if (resource.getType() == ResourceType.PROJECT_TRANSFER) {
            switch (operation) {
                case ACCEPT: {
                    ProjectTransfer pt = (ProjectTransfer)ProjectTransfer.find.byId((Object)Long.parseLong(resource.getId()));
                    Model model = pt;
                    Object object = null;
                    object = model.getDestination();
                    User to = User.findByLoginId((String)object);
                    if (!to.isAnonymous()) {
                        model = user;
                        object = null;
                        object = model.getLoginId();
                        String string = object;
                        model = pt;
                        object = null;
                        object = model.getDestination();
                        return string.equals(object);
                    }
                    model = pt;
                    object = null;
                    object = model.getDestination();
                    Organization receivingOrg = Organization.findByName((String)object);
                    if (receivingOrg == null) return false;
                    model = receivingOrg;
                    object = null;
                    Object object2 = object = model.getId();
                    model = user;
                    object = null;
                    object = model.getId();
                    if (!OrganizationUser.isAdmin((Long)object2, (Long)object)) return false;
                    return true;
                }
            }
            return false;
        }
        Model model = project2;
        Organization organization2 = null;
        organization2 = model.getOrganization();
        if (OrganizationUser.isAdmin(organization2, user)) {
            return true;
        }
        if (user.isManagerOf(project2)) return true;
        if (AccessControl.isAllowedIfAuthor(user, resource)) return true;
        if (AccessControl.isAllowedIfAssignee(user, resource)) {
            return true;
        }
        switch (resource.getType()) {
            case ISSUE_STATE: 
            case ISSUE_ASSIGNEE: 
            case ISSUE_MILESTONE: 
            case ATTACHMENT: {
                switch (operation) {
                    case READ: {
                        if (AccessControl.isAllowed(user, resource.getContainer(), Operation.READ)) return true;
                        if (!AccessControl.isAllowedIfSharer(user, resource.getContainer())) return false;
                        return true;
                    }
                    case UPDATE: 
                    case DELETE: {
                        return AccessControl.isAllowed(user, resource.getContainer(), Operation.UPDATE);
                    }
                }
            }
        }
        switch (operation) {
            case READ: {
                if (project2.isPublic()) {
                    model = user;
                    boolean bl = false;
                    bl = model.getIsGuest();
                    if (!bl) return true;
                }
                if (user.isMemberOf(project2)) return true;
                if (AccessControl.isAllowedIfSharer(user, resource)) return true;
                if (!AccessControl.isAllowedIfGroupMember(project2, user)) return false;
                return true;
            }
            case UPDATE: {
                if (user.isMemberOf(project2)) return true;
                if (!AccessControl.isAllowedIfGroupMember(project2, user)) return false;
                return true;
            }
            case DELETE: {
                if (resource.getType() != ResourceType.CODE) return user.isMemberOf(project2);
                return false;
            }
            case ACCEPT: 
            case CLOSE: 
            case REOPEN: {
                if (user.isMemberOf(project2)) return true;
                if (!AccessControl.isAllowedIfGroupMember(project2, user)) return false;
                return true;
            }
            case WATCH: {
                if (project2.isPublic()) {
                    if (!user.isAnonymous()) return true;
                }
                if (user.isMemberOf(project2)) return true;
                if (!AccessControl.isAllowedIfGroupMember(project2, user)) return false;
                return true;
            }
        }
        return false;
    }

    public static boolean isAllowed(User user, Resource resource, Operation operation) throws IllegalStateException {
        if (AccessControl.isAnonymousNotAllowed() && user.isAnonymous()) {
            return false;
        }
        if (user.isSiteManager()) {
            return true;
        }
        if (resource instanceof GlobalResource) {
            return AccessControl.isGlobalResourceAllowed(user, (GlobalResource)resource, operation);
        }
        Project project2 = resource.getProject();
        if (project2 == null) {
            throw new IllegalStateException("A project resource lost its project");
        }
        return AccessControl.isProjectResourceAllowed(user, project2, resource, operation);
    }

    public static void onStart() {
        allowsAnonymousAccess = BooleanUtils.toBoolean((Boolean)Configuration.root().getBoolean("application.allowsAnonymousAccess", Boolean.valueOf(true)));
    }

    private static boolean isAllowedIfAuthor(User user, Resource resource) {
        switch (resource.getType()) {
            case ISSUE_POST: 
            case BOARD_POST: 
            case ISSUE_COMMENT: 
            case NONISSUE_COMMENT: 
            case COMMIT_COMMENT: 
            case REVIEW_COMMENT: 
            case COMMENT_THREAD: {
                return resource.isAuthoredBy(user);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAllowedIfSharer(User user, Resource resource) {
        switch (resource.getType()) {
            case ISSUE_POST: {
                Object object;
                Model model;
                Issue issue2 = (Issue)Issue.finder.byId((Object)Long.valueOf(resource.getId()));
                if (issue2 != null) {
                    model = issue2;
                    object = null;
                    object = model.getParent();
                    if (object != null) {
                        model = issue2;
                        object = null;
                        Object object2 = object = model.getParent();
                        model = user;
                        object = null;
                        object = model.getId();
                        if (Optional.ofNullable(((Issue)object2).findSharerByUserId((Long)object)).isPresent()) {
                            return true;
                        }
                    }
                }
                if (issue2 == null) return false;
                model = user;
                object = null;
                object = model.getId();
                if (!Optional.ofNullable(issue2.findSharerByUserId((Long)object)).isPresent()) return false;
                return true;
            }
            case ISSUE_COMMENT: {
                IssueComment issueComment = (IssueComment)IssueComment.find.byId((Object)Long.valueOf(resource.getId()));
                if (issueComment == null) return false;
                IssueComment issueComment2 = issueComment;
                Issue issue3 = null;
                issue3 = issueComment2.getIssue();
                if (!AccessControl.isAllowedIfSharer(user, issue3.asResource())) return false;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAllowedIfAssignee(User user, Resource resource) {
        switch (resource.getType()) {
            case ISSUE_POST: {
                Assignee assignee;
                Model model = (Issue)Issue.finder.byId((Object)Long.valueOf(resource.getId()));
                Object var4_3 = null;
                Assignee assignee2 = assignee = model.getAssignee();
                if (assignee2 == null) return false;
                model = assignee2;
                Object var4_5 = null;
                User user2 = model.getUser();
                model = user2;
                Object var4_7 = null;
                Long l = model.getId();
                model = user;
                Object var4_9 = null;
                Long l2 = model.getId();
                if (!l.equals(l2)) return false;
                return true;
            }
        }
        return false;
    }
}

