/*
 * Decompiled with CFR 0.152.
 */
package utils;

import controllers.UserApp;
import java.io.UnsupportedEncodingException;
import models.User;
import org.apache.commons.codec.binary.Base64;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import utils.AccessLogger;
import utils.LdapService;
import utils.MalformedCredentialsException;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class BasicAuthAction
extends Action<Object> {
    private static final String REALM = "Yobi";

    public static Result unauthorized(Http.Response response) {
        String challenge = "Basic realm=\"Yobi\"";
        response.setHeader("WWW-Authenticate", challenge);
        return BasicAuthAction.unauthorized((String)"Invalid username or password");
    }

    public static User parseCredentials(String credentials) throws MalformedCredentialsException, UnsupportedEncodingException {
        if (credentials == null) {
            return null;
        }
        byte[] userpassBytes = Base64.decodeBase64((String)credentials.substring(6));
        String userpass = new String(userpassBytes, "ISO-8859-1");
        int colonAt = userpass.indexOf(58);
        if (colonAt < 0) {
            throw new MalformedCredentialsException();
        }
        User authUser = new User();
        String string = userpass.substring(0, colonAt);
        User user = authUser;
        user.setLoginId(string);
        string = userpass.substring(colonAt + 1);
        user = authUser;
        user.setPassword(string);
        return authUser;
    }

    public User authenticate(Http.Request request) throws UnsupportedEncodingException, MalformedCredentialsException {
        String credential = request.getHeader("Authorization");
        User authUser = BasicAuthAction.parseCredentials(credential);
        if (authUser == null) {
            return User.anonymous;
        }
        User user = authUser;
        String string = null;
        String credentialKey = string = user.getLoginId();
        if (LdapService.useLdap) {
            if (LdapService.USE_EMAIL_BASE_LOGIN) {
                user = authUser;
                string = null;
                string = user.getLoginId();
                User targetUser = User.findByLoginId(string);
                if (!targetUser.isAnonymous()) {
                    user = targetUser;
                    string = null;
                    credentialKey = string = user.getEmail();
                }
            }
            user = authUser;
            string = null;
            string = user.getPassword();
            return UserApp.authenticateWithLdap(credentialKey, string);
        }
        user = authUser;
        string = null;
        string = user.getPassword();
        return UserApp.authenticateWithPlainPassword(credentialKey, string);
    }

    public F.Promise<Result> call(Http.Context context) throws Throwable {
        User user;
        try {
            user = this.authenticate(context.request());
        }
        catch (MalformedCredentialsException error) {
            F.Promise promise = F.Promise.pure((Object)BasicAuthAction.badRequest());
            AccessLogger.log(context.request(), (F.Promise<Result>)promise, null);
            return promise;
        }
        catch (UnsupportedEncodingException e) {
            F.Promise promise = F.Promise.pure((Object)BasicAuthAction.internalServerError());
            AccessLogger.log(context.request(), (F.Promise<Result>)promise, null);
            return promise;
        }
        if (!user.isAnonymous()) {
            UserApp.addUserInfoToSession(user);
        }
        return this.delegate.call(context);
    }
}

