/*
 * Decompiled with CFR 0.152.
 */
package utils;

import controllers.UserApp;
import java.io.IOException;
import models.Project;
import org.eclipse.jgit.lib.ObjectId;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import playRepository.BareCommit;
import playRepository.RepositoryService;
import utils.FileUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class GitUtil {
    public static String getReadTextFile(Project project2, String branchName, String filenameWithPath) {
        try {
            byte[] bytes = RepositoryService.getRepository(project2).getRawFile(branchName, filenameWithPath);
            return new String(bytes, FileUtil.detectCharset(bytes));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static synchronized void commitTextFile(Project project2, String branchName, String path, String text, String msg) {
        BareCommit bare = new BareCommit(project2, UserApp.currentUser());
        bare.setRefName(branchName);
        ObjectId objectId = null;
        try {
            objectId = bare.commitTextFile(branchName, path, text, msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Project project3 = project2;
        String string = null;
        string = project3.getName();
        Logger.debug((String)("Online Commit: " + string + ":" + path + ":" + objectId));
    }
}

