/*
 * Decompiled with CFR 0.152.
 */
package utils;

import controllers.UserApp;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;
import play.core.enhancers.PropertiesEnhancer;
import utils.Config;
import utils.MD5Util;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class GravatarUtil {
    public static final String DEFAULT_GRAVATAR_URL = "https://ko.gravatar.com/userimage/53495145/0eaeeb47c620542ad089f17377298af6.png";
    public static final int DEFAULT_SIZE = 64;

    public static String getAvatar(String email) {
        return GravatarUtil.getAvatar(email, 64);
    }

    public static String getAvatar(String email, int size) {
        return GravatarUtil.getAvatar(email, size, DEFAULT_GRAVATAR_URL);
    }

    public static String getAvatar(String email, int size, String defaultImageUrl) {
        if (!Config.isConnectableToGravatarServer) {
            return UserApp.DEFAULT_AVATAR_URL;
        }
        try {
            String url = "https://www.gravatar.com/avatar/" + MD5Util.md5Hex(email) + "?s=" + size;
            if (StringUtils.isNotEmpty((CharSequence)defaultImageUrl)) {
                url = url + "&d=" + URLEncoder.encode(defaultImageUrl, "UTF-8");
            }
            return url;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

