/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.ext;

import com.feth.play.module.pa.PlayAuthenticate;
import com.feth.play.module.pa.exceptions.ResolverMissingException;
import com.feth.play.module.pa.providers.AuthProvider;
import java.util.Collections;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URLEncodedUtils;
import play.Application;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Call;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class ExternalAuthProvider
extends AuthProvider {
    protected static String generateURI(String location, List<? extends NameValuePair> params) {
        HttpGet m = new HttpGet(location + "?" + URLEncodedUtils.format(params, (String)"UTF-8"));
        return m.getURI().toString();
    }

    @Override
    protected List<String> neededSettingKeys() {
        return Collections.singletonList("timeout");
    }

    protected long getTimeout() {
        return this.getConfiguration().getLong("timeout", Long.valueOf(10000L));
    }

    private boolean useSecureRedirectUri() {
        Boolean secure = this.getConfiguration().getBoolean("redirectUri.secure");
        if (secure == null) {
            secure = this.getConfiguration().getBoolean("secureRedirectUri");
        }
        return secure != null ? secure : false;
    }

    protected String getRedirectUrl(Http.Request request, List<? extends NameValuePair> params) throws ResolverMissingException {
        return ExternalAuthProvider.generateURI(this.getRedirectUrl(request), params);
    }

    protected String getRedirectUrl(Http.Request request) throws ResolverMissingException {
        String overrideHost = this.getConfiguration().getString("redirectUri.host");
        boolean isHttps = this.useSecureRedirectUri();
        PlayAuthenticate.Resolver resolver = PlayAuthenticate.getResolver();
        if (resolver == null) {
            throw new ResolverMissingException("Resolver has not been set.");
        }
        Call c = resolver.auth(this.getKey());
        if (overrideHost != null && !overrideHost.trim().isEmpty()) {
            return "http" + (isHttps ? "s" : "") + "://" + overrideHost + c.url();
        }
        return c.absoluteURL(request, isHttps);
    }

    public ExternalAuthProvider(Application app) {
        super(app);
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static abstract class SettingKeys {
        @Deprecated
        public static final String SECURE_REDIRECT_URI = "secureRedirectUri";
        public static final String REDIRECT_URI_HOST = "redirectUri.host";
        public static final String REDIRECT_URI_SECURE = "redirectUri.secure";
        public static final String TIMEOUT = "timeout";

        private SettingKeys() {
        }
    }
}

