/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth1.twitter;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.exceptions.AccessDeniedException;
import com.feth.play.module.pa.exceptions.AccessTokenException;
import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.providers.oauth1.OAuth1AuthProvider;
import com.feth.play.module.pa.providers.oauth1.twitter.TwitterAuthInfo;
import com.feth.play.module.pa.providers.oauth1.twitter.TwitterAuthUser;
import java.util.List;
import play.Application;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.oauth.OAuth;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class TwitterAuthProvider
extends OAuth1AuthProvider<TwitterAuthUser, TwitterAuthInfo> {
    public static final String PROVIDER_KEY = "twitter";
    private static final String USER_INFO_URL_SETTING_KEY = "userInfoUrl";
    private static final String DENIED_KEY = "denied";

    public TwitterAuthProvider(Application app) {
        super(app);
    }

    @Override
    public String getKey() {
        return PROVIDER_KEY;
    }

    @Override
    protected List<String> neededSettingKeys() {
        List<String> neededSettingKeys = super.neededSettingKeys();
        neededSettingKeys.add(USER_INFO_URL_SETTING_KEY);
        return neededSettingKeys;
    }

    @Override
    protected TwitterAuthUser transform(TwitterAuthInfo info) throws AuthException {
        String userInfoUrl = this.getConfiguration().getString(USER_INFO_URL_SETTING_KEY);
        OAuth.OAuthCalculator op = this.getOAuthCalculator(info);
        JsonNode userJson = this.signedOauthGet(userInfoUrl, op);
        return new TwitterAuthUser(userJson, info);
    }

    @Override
    protected TwitterAuthInfo buildInfo(OAuth.RequestToken rtoken) throws AccessTokenException {
        return new TwitterAuthInfo(rtoken.token, rtoken.secret);
    }

    @Override
    protected void checkError(Http.Request request) throws AuthException {
        String error = request.getQueryString(DENIED_KEY);
        if (error != null) {
            throw new AccessDeniedException(this.getKey());
        }
    }
}

