/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth2.facebook;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.exceptions.AccessTokenException;
import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.providers.oauth2.OAuth2AuthProvider;
import com.feth.play.module.pa.providers.oauth2.facebook.FacebookAuthInfo;
import com.feth.play.module.pa.providers.oauth2.facebook.FacebookAuthUser;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import play.Application;
import play.Configuration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.ws.WS;
import play.libs.ws.WSResponse;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class FacebookAuthProvider
extends OAuth2AuthProvider<FacebookAuthUser, FacebookAuthInfo> {
    private static final String MESSAGE = "message";
    private static final String ERROR = "error";
    private static final String FIELDS = "fields";
    public static final String PROVIDER_KEY = "facebook";
    private static final String USER_INFO_URL_SETTING_KEY = "userInfoUrl";
    private static final String USER_INFO_FIELDS_SETTING_KEY = "userInfoFields";

    public FacebookAuthProvider(Application app) {
        super(app);
    }

    protected FacebookAuthUser transform(FacebookAuthInfo info, String state) throws AuthException {
        String url = this.getConfiguration().getString(USER_INFO_URL_SETTING_KEY);
        String fields = this.getConfiguration().getString(USER_INFO_FIELDS_SETTING_KEY);
        WSResponse r = (WSResponse)WS.url((String)url).setQueryParameter("access_token", info.getAccessToken()).setQueryParameter(FIELDS, fields).get().get(this.getTimeout());
        JsonNode result = r.asJson();
        if (result.get(ERROR) != null) {
            throw new AuthException(result.get(ERROR).get(MESSAGE).asText());
        }
        Logger.debug((String)result.toString());
        return new FacebookAuthUser(result, info, state);
    }

    @Override
    public String getKey() {
        return PROVIDER_KEY;
    }

    @Override
    protected FacebookAuthInfo buildInfo(WSResponse r) throws AccessTokenException {
        if (r.getStatus() >= 400) {
            throw new AccessTokenException(r.asJson().get(ERROR).get(MESSAGE).asText());
        }
        String query = r.getBody();
        Logger.debug((String)query);
        List pairs = URLEncodedUtils.parse((URI)URI.create("/?" + query), (String)"utf-8");
        if (pairs.size() < 2) {
            throw new AccessTokenException();
        }
        HashMap<String, String> m = new HashMap<String, String>(pairs.size());
        for (NameValuePair nameValuePair : pairs) {
            m.put(nameValuePair.getName(), nameValuePair.getValue());
        }
        return new FacebookAuthInfo(m);
    }

    @Override
    protected List<NameValuePair> getAuthParams(Configuration c, Http.Request request, String state) throws AuthException {
        List<NameValuePair> params = super.getAuthParams(c, request, state);
        if (c.getString("display") != null) {
            params.add((NameValuePair)new BasicNameValuePair("display", c.getString("display")));
        }
        return params;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static abstract class FacebookConstants
    extends OAuth2AuthProvider.Constants {
        public static final String DISPLAY = "display";
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static abstract class SettingKeys
    extends OAuth2AuthProvider.SettingKeys {
        public static final String DISPLAY = "display";
    }
}

