/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth2.facebook;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.providers.oauth2.BasicOAuth2AuthUser;
import com.feth.play.module.pa.providers.oauth2.facebook.FacebookAuthInfo;
import com.feth.play.module.pa.user.AuthUser;
import com.feth.play.module.pa.user.ExtendedIdentity;
import com.feth.play.module.pa.user.LocaleIdentity;
import com.feth.play.module.pa.user.PicturedIdentity;
import com.feth.play.module.pa.user.ProfiledIdentity;
import java.util.Locale;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class FacebookAuthUser
extends BasicOAuth2AuthUser
implements ExtendedIdentity,
PicturedIdentity,
ProfiledIdentity,
LocaleIdentity {
    private static final long serialVersionUID = 1L;
    private String name;
    private String firstName;
    private String lastName;
    private String link;
    private String gender;
    private String email;
    private boolean verified = false;
    private int timezone;
    private String locale;
    private String updateTime;
    private String birthday;

    public FacebookAuthUser(JsonNode node, FacebookAuthInfo info, String state) {
        super(node.get("id").asText(), info, state);
        if (node.has("name")) {
            this.name = node.get("name").asText();
        }
        if (node.has("first_name")) {
            this.firstName = node.get("first_name").asText();
        }
        if (node.has("last_name")) {
            this.lastName = node.get("last_name").asText();
        }
        if (node.has("link")) {
            this.link = node.get("link").asText();
        }
        if (node.has("gender")) {
            this.gender = node.get("gender").asText();
        }
        if (node.has("email")) {
            this.email = node.get("email").asText();
        }
        if (node.has("verified")) {
            this.verified = node.get("verified").asBoolean(false);
        }
        if (node.has("timezone")) {
            this.timezone = node.get("timezone").asInt();
        }
        if (node.has("locale")) {
            this.locale = node.get("locale").asText();
        }
        if (node.has("updated_time")) {
            this.updateTime = node.get("updated_time").asText();
        }
        if (node.has("birthday")) {
            this.birthday = node.get("birthday").asText();
        }
    }

    @Override
    public String getProvider() {
        return "facebook";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getProfileLink() {
        return this.link;
    }

    @Override
    public String getGender() {
        return this.gender;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public int getTimezone() {
        return this.timezone;
    }

    @Override
    public String getPicture() {
        return String.format("https://graph.facebook.com/%s/picture", this.getId());
    }

    @Override
    public Locale getLocale() {
        return AuthUser.getLocaleFromString(this.locale);
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public String getBirthday() {
        return this.birthday;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static abstract class Constants {
        public static final String ID = "id";
        public static final String NAME = "name";
        public static final String FIRST_NAME = "first_name";
        public static final String LAST_NAME = "last_name";
        public static final String LINK = "link";
        public static final String GENDER = "gender";
        public static final String EMAIL = "email";
        public static final String TIME_ZONE = "timezone";
        public static final String LOCALE = "locale";
        public static final String VERIFIED = "verified";
        public static final String UPDATE_TIME = "updated_time";
        public static final String BIRTHDAY = "birthday";

        private Constants() {
        }
    }
}

