/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth2.github;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.exceptions.AccessTokenException;
import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.providers.oauth2.OAuth2AuthProvider;
import com.feth.play.module.pa.providers.oauth2.github.GithubAuthInfo;
import com.feth.play.module.pa.providers.oauth2.github.GithubAuthUser;
import java.util.Collections;
import java.util.Map;
import play.Application;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.ws.WS;
import play.libs.ws.WSResponse;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class GithubAuthProvider
extends OAuth2AuthProvider<GithubAuthUser, GithubAuthInfo> {
    public static final String PROVIDER_KEY = "github";
    private static final String USER_INFO_URL_SETTING_KEY = "userInfoUrl";

    public GithubAuthProvider(Application app) {
        super(app);
    }

    @Override
    public String getKey() {
        return PROVIDER_KEY;
    }

    @Override
    protected Map<String, String> getHeaders() {
        return Collections.singletonMap("Accept", "application/json");
    }

    protected GithubAuthUser transform(GithubAuthInfo info, String state) throws AuthException {
        String url = this.getConfiguration().getString(USER_INFO_URL_SETTING_KEY);
        WSResponse r = (WSResponse)WS.url((String)url).setQueryParameter("access_token", info.getAccessToken()).get().get(this.getTimeout());
        JsonNode result = r.asJson();
        if (result.get("error") != null) {
            throw new AuthException(result.get("error").asText());
        }
        return new GithubAuthUser(result, info, state);
    }

    @Override
    protected GithubAuthInfo buildInfo(WSResponse r) throws AccessTokenException {
        JsonNode n = r.asJson();
        if (n.get("error") != null) {
            throw new AccessTokenException(n.get("error").asText());
        }
        return new GithubAuthInfo(n);
    }
}

