/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth2.google;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.providers.oauth2.BasicOAuth2AuthUser;
import com.feth.play.module.pa.providers.oauth2.google.GoogleAuthInfo;
import com.feth.play.module.pa.user.AuthUser;
import com.feth.play.module.pa.user.ExtendedIdentity;
import com.feth.play.module.pa.user.LocaleIdentity;
import com.feth.play.module.pa.user.PicturedIdentity;
import com.feth.play.module.pa.user.ProfiledIdentity;
import java.util.Locale;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class GoogleAuthUser
extends BasicOAuth2AuthUser
implements ExtendedIdentity,
PicturedIdentity,
ProfiledIdentity,
LocaleIdentity {
    private static final long serialVersionUID = 1L;
    private String email;
    private boolean emailIsVerified = false;
    private String name;
    private String firstName;
    private String lastName;
    private String picture;
    private String gender;
    private String locale;
    private String link;

    public GoogleAuthUser(JsonNode n, GoogleAuthInfo info, String state) {
        super(n.get("id").asText(), info, state);
        if (n.has("email")) {
            this.email = n.get("email").asText();
        }
        if (n.has("verified_email")) {
            this.emailIsVerified = n.get("verified_email").asBoolean();
        }
        if (n.has("name")) {
            this.name = n.get("name").asText();
        }
        if (n.has("given_name")) {
            this.firstName = n.get("given_name").asText();
        }
        if (n.has("family_name")) {
            this.lastName = n.get("family_name").asText();
        }
        if (n.has("picture")) {
            this.picture = n.get("picture").asText();
        }
        if (n.has("gender")) {
            this.gender = n.get("gender").asText();
        }
        if (n.has("locale")) {
            this.locale = n.get("locale").asText();
        }
        if (n.has("link")) {
            this.link = n.get("link").asText();
        }
    }

    @Override
    public String getProvider() {
        return "google";
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public boolean isEmailVerified() {
        return this.emailIsVerified;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getPicture() {
        return this.picture;
    }

    @Override
    public String getGender() {
        return this.gender;
    }

    @Override
    public String getProfileLink() {
        return this.link;
    }

    @Override
    public Locale getLocale() {
        return AuthUser.getLocaleFromString(this.locale);
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static class Constants {
        public static final String ID = "id";
        public static final String EMAIL = "email";
        public static final String EMAIL_IS_VERIFIED = "verified_email";
        public static final String NAME = "name";
        public static final String FIRST_NAME = "given_name";
        public static final String LAST_NAME = "family_name";
        public static final String PICTURE = "picture";
        public static final String GENDER = "gender";
        public static final String LOCALE = "locale";
        public static final String LINK = "link";

        private Constants() {
        }
    }
}

