/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth2.vk;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.exceptions.AccessTokenException;
import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.providers.oauth2.OAuth2AuthProvider;
import com.feth.play.module.pa.providers.oauth2.vk.VkAuthInfo;
import com.feth.play.module.pa.providers.oauth2.vk.VkAuthUser;
import play.Application;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.ws.WS;
import play.libs.ws.WSResponse;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class VkAuthProvider
extends OAuth2AuthProvider<VkAuthUser, VkAuthInfo> {
    public static final String PROVIDER_KEY = "vk";
    private static final String USER_INFO_URL_SETTING_KEY = "userInfoUrl";
    private static final String USER_INFO_FIELDS_SETTING_KEY = "userInfoFields";
    private static final String FIELDS_REQUEST_KEY = "fields";
    private static final String UIDS_REQUEST_KEY = "uids";
    private static final String BODY_RESPONSE_KEY = "response";

    public VkAuthProvider(Application app) {
        super(app);
    }

    protected VkAuthUser transform(VkAuthInfo info, String state) throws AuthException {
        String url = this.getConfiguration().getString(USER_INFO_URL_SETTING_KEY);
        String fields = this.getConfiguration().getString(USER_INFO_FIELDS_SETTING_KEY);
        WSResponse r = (WSResponse)WS.url((String)url).setQueryParameter(UIDS_REQUEST_KEY, info.getUserId()).setQueryParameter(FIELDS_REQUEST_KEY, fields).get().get(this.getTimeout());
        JsonNode result = r.asJson();
        if (result.get("error") != null) {
            throw new AuthException(result.get("error").asText());
        }
        return new VkAuthUser(result.get(BODY_RESPONSE_KEY).get(0), info, state);
    }

    @Override
    public String getKey() {
        return PROVIDER_KEY;
    }

    @Override
    protected VkAuthInfo buildInfo(WSResponse r) throws AccessTokenException {
        JsonNode n = r.asJson();
        Logger.debug((String)n.toString());
        if (n.get("error") != null) {
            throw new AccessTokenException(n.get("error").asText());
        }
        return new VkAuthInfo(n);
    }
}

