/*
 * Decompiled with CFR 0.152.
 */
package play.i18n;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import play.api.i18n.Lang;
import play.mvc.Http;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;

public class Messages {
    private static Lang getLang() {
        Lang lang = null;
        if (Http.Context.current.get() != null) {
            lang = Http.Context.current().lang();
        } else {
            Locale locale = Locale.getDefault();
            lang = new Lang(locale.getLanguage(), locale.getCountry());
        }
        return lang;
    }

    private static Buffer<Object> convertArgsToScalaBuffer(Object ... objectArray) {
        return (Buffer)JavaConverters.asScalaBufferConverter(Messages.wrapArgsToListIfNeeded(objectArray)).asScala();
    }

    static <T> List<T> wrapArgsToListIfNeeded(T ... TArray) {
        List list = null;
        list = ArrayUtils.isNotEmpty((Object[])TArray) && TArray.length == 1 && TArray[0] instanceof List ? (List)TArray[0] : Arrays.asList(TArray);
        return list;
    }

    public static String get(Lang lang, String string, Object ... objectArray) {
        Buffer<Object> buffer = Messages.convertArgsToScalaBuffer(objectArray);
        return play.api.i18n.Messages.apply(string, buffer, lang);
    }

    public static String get(Lang lang, List<String> list, Object ... objectArray) {
        Buffer buffer = (Buffer)JavaConverters.asScalaBufferConverter(list).asScala();
        Buffer<Object> buffer2 = Messages.convertArgsToScalaBuffer(objectArray);
        return play.api.i18n.Messages.apply((Seq<String>)buffer.toSeq(), buffer2, lang);
    }

    public static String get(String string, Object ... objectArray) {
        Buffer<Object> buffer = Messages.convertArgsToScalaBuffer(objectArray);
        return play.api.i18n.Messages.apply(string, buffer, Messages.getLang());
    }

    public static String get(List<String> list, Object ... objectArray) {
        Buffer buffer = (Buffer)JavaConverters.asScalaBufferConverter(list).asScala();
        Buffer<Object> buffer2 = Messages.convertArgsToScalaBuffer(objectArray);
        return play.api.i18n.Messages.apply((Seq<String>)buffer.toSeq(), buffer2, Messages.getLang());
    }

    public static Boolean isDefined(Lang lang, String string) {
        return play.api.i18n.Messages.isDefinedAt(string, lang);
    }

    public static Boolean isDefined(String string) {
        return play.api.i18n.Messages.isDefinedAt(string, Messages.getLang());
    }
}

