/*
 * Decompiled with CFR 0.152.
 */
package humanize.text;

import com.google.common.base.Preconditions;
import humanize.Humanize;
import humanize.spi.Expose;
import humanize.spi.FormatProvider;
import humanize.text.FormatFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class HumanizeFormatProvider
implements FormatProvider {
    private static final Map<String, Method> humanizeMethods = HumanizeFormatProvider.getStaticMethods(Humanize.class);

    public static FormatFactory factory() {
        return new FormatFactory(){

            @Override
            public Format getFormat(String name, String args, Locale locale) {
                String camelized = Humanize.camelize(args);
                if (humanizeMethods.containsKey(camelized)) {
                    Method method = (Method)humanizeMethods.get(camelized);
                    return new HumanizeFormat(method, locale);
                }
                return null;
            }
        };
    }

    private static Map<String, Method> getStaticMethods(Class<?> clazz) {
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || method.getAnnotation(Expose.class) == null) continue;
            methods.put(method.getName(), method);
        }
        return Collections.unmodifiableMap(methods);
    }

    @Override
    public FormatFactory getFactory() {
        return HumanizeFormatProvider.factory();
    }

    @Override
    public String getFormatName() {
        return "humanize";
    }

    public static class HumanizeFormat
    extends Format {
        private static final long serialVersionUID = -3261072590121741805L;
        private final Locale locale;
        private final Method method;

        public HumanizeFormat(Method method, Locale locale) {
            this.method = method;
            this.locale = locale;
        }

        @Override
        public StringBuffer format(Object paramObject, StringBuffer toAppendTo, FieldPosition position) {
            Preconditions.checkNotNull((Object)this.method);
            Class<?>[] paramTypes = this.method.getParameterTypes();
            boolean withLocale = false;
            Object retval = null;
            for (Class<?> type : paramTypes) {
                if (!Locale.class.equals(type)) continue;
                withLocale = true;
                break;
            }
            try {
                retval = withLocale ? this.method.invoke(null, paramObject, this.locale) : this.method.invoke(null, paramObject);
            }
            catch (Exception e) {
                retval = String.format("[invalid call: '%s']", e.getMessage());
            }
            return toAppendTo.append(retval);
        }

        @Override
        public Object parseObject(String paramString, ParsePosition paramParsePosition) {
            throw new UnsupportedOperationException();
        }
    }
}

