/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceKind;
import org.tmatesoft.svn.core.internal.server.dav.DAVURIInfo;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVPathUtil {
    private static final String SLASH = "/";

    public static String dropLeadingSlash(String uri) {
        if (uri == null) {
            return "";
        }
        return uri.startsWith(SLASH) ? uri.substring(SLASH.length()) : uri;
    }

    public static String addLeadingSlash(String uri) {
        if (uri == null) {
            return SLASH;
        }
        return uri.startsWith(SLASH) ? uri : SLASH + uri;
    }

    public static String dropTraillingSlash(String uri) {
        if (uri == null) {
            return "";
        }
        return uri.endsWith(SLASH) ? uri.substring(0, uri.length() - SLASH.length()) : uri;
    }

    public static String addTrailingSlash(String uri) {
        if (uri == null) {
            return SLASH;
        }
        return uri.endsWith(SLASH) ? uri : uri + SLASH;
    }

    public static String head(String uri) {
        int slashIndex = (uri = DAVPathUtil.dropLeadingSlash(uri)).indexOf(SLASH);
        if (slashIndex == -1) {
            return uri;
        }
        return uri.substring(0, slashIndex);
    }

    public static String removeHead(String uri, boolean doStandardize) {
        uri = DAVPathUtil.dropLeadingSlash(uri);
        int headLength = DAVPathUtil.head(uri).length();
        return doStandardize ? DAVPathUtil.standardize(uri.substring(headLength)) : uri.substring(headLength);
    }

    public static String tail(String uri) {
        int lastSlashIndex = (uri = DAVPathUtil.dropTraillingSlash(uri)).lastIndexOf(SLASH);
        if (lastSlashIndex == -1) {
            return uri;
        }
        return uri.substring(lastSlashIndex);
    }

    public static String removeTail(String uri, boolean doStandardize) {
        uri = DAVPathUtil.dropTraillingSlash(uri);
        int tailLength = DAVPathUtil.tail(uri).length();
        return doStandardize ? DAVPathUtil.standardize(uri.substring(0, uri.length() - tailLength)) : uri.substring(0, uri.length() - tailLength);
    }

    public static String append(String parent, String child) {
        StringBuffer uriBuffer = new StringBuffer();
        uriBuffer.append(DAVPathUtil.standardize(parent));
        uriBuffer.append(DAVPathUtil.standardize(child));
        return uriBuffer.toString();
    }

    public static String standardize(String uri) {
        if (uri == null) {
            return SLASH;
        }
        return DAVPathUtil.addLeadingSlash(DAVPathUtil.dropTraillingSlash(uri));
    }

    public static String normalize(String uri) {
        return "".equals(uri) ? SLASH : uri;
    }

    public static void testCanonical(String path) throws DAVException {
        if (path != null && !path.equals(SVNPathUtil.canonicalizePath((String)path))) {
            throw new DAVException("Path ''{0}'' is not canonicalized;\nthere is a problem with the client.", new Object[]{path}, 400, null, SVNLogType.NETWORK, Level.FINE, null, "error", "svn:", 0, null);
        }
    }

    public static String buildURI(String context, DAVResourceKind davResourceKind, long revision, String path, boolean addHref) {
        return DAVPathUtil.buildURI(context, davResourceKind, revision, path, addHref, true);
    }

    public static String buildURI(String context, DAVResourceKind davResourceKind, long revision, String path, boolean addHref, boolean urlEncode) {
        StringBuffer resultURI = new StringBuffer();
        if (path == null) {
            path = "";
        } else if (urlEncode) {
            path = SVNEncodingUtil.uriEncode((String)path);
        }
        String string = context = context == null ? "" : context;
        if (addHref) {
            SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.HREF.getName(), (int)2, null, (StringBuffer)resultURI);
        }
        resultURI.append(context);
        resultURI.append(SLASH);
        if (davResourceKind == DAVResourceKind.PUBLIC) {
            resultURI.append(DAVPathUtil.dropLeadingSlash(path));
        } else {
            resultURI.append("!svn").append(SLASH);
            if (davResourceKind == DAVResourceKind.ACT_COLLECTION) {
                resultURI.append(davResourceKind.toString());
                resultURI.append(SLASH);
            } else if (davResourceKind == DAVResourceKind.BASELINE) {
                resultURI.append(davResourceKind.toString());
                resultURI.append(SLASH);
                resultURI.append(String.valueOf(revision));
            } else if (davResourceKind == DAVResourceKind.BASELINE_COLL) {
                resultURI.append(davResourceKind.toString());
                resultURI.append(SLASH);
                resultURI.append(String.valueOf(revision));
                resultURI.append(DAVPathUtil.addLeadingSlash(path));
            } else if (davResourceKind == DAVResourceKind.VERSION) {
                resultURI.append(davResourceKind.toString());
                resultURI.append(SLASH);
                resultURI.append(String.valueOf(revision));
                resultURI.append(DAVPathUtil.addLeadingSlash(path));
            } else if (davResourceKind == DAVResourceKind.VCC) {
                resultURI.append(davResourceKind.toString());
                resultURI.append(SLASH);
                resultURI.append("default");
            }
        }
        if (addHref) {
            SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.HREF.getName(), (StringBuffer)resultURI, (boolean)false);
        }
        return resultURI.toString();
    }

    public static File getActivityPath(File activitiesDB, String activityID) {
        String safeActivityID = SVNFileUtil.computeChecksum((String)activityID);
        File finalActivityFile = new File(activitiesDB, safeActivityID);
        return finalActivityFile;
    }

    public static DAVURIInfo simpleParseURI(String uri, DAVResource relative) throws SVNException {
        int slashInd;
        String specialURI;
        String reposRoot;
        URI parsedURI = null;
        try {
            parsedURI = new URI(uri);
        }
        catch (URISyntaxException urise) {
            DAVPathUtil.throwMalformedURIErrorException();
        }
        String path = parsedURI.getPath();
        if ("".equals(path)) {
            path = SLASH;
        }
        if (!(path.equals(reposRoot = relative.getResourceURI().getContext()) || path.startsWith(reposRoot) && path.charAt(reposRoot.length()) == '/')) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.APMOD_MALFORMED_URI, (String)"Unusable URI: it does not refer to this repository");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.NETWORK);
        }
        long revision = -1L;
        if ("".equals(path = path.substring(reposRoot.length())) || SLASH.equals(path)) {
            return new DAVURIInfo(null, SLASH, revision);
        }
        if (!((path = path.substring(1)).equals(specialURI = "!svn") || path.startsWith(specialURI) && path.charAt(specialURI.length()) == '/')) {
            path = !path.startsWith(SLASH) ? SLASH + path : path;
            return new DAVURIInfo(null, path, revision);
        }
        if ("".equals(path = path.substring(specialURI.length())) || SLASH.equals(path)) {
            DAVPathUtil.throwUnhandledFormException();
        }
        if ((slashInd = path.indexOf(47, 1)) == -1 || slashInd == path.length() - 1) {
            DAVPathUtil.throwUnhandledFormException();
        }
        String segment = path.substring(0, slashInd + 1);
        String activityID = null;
        String reposPath = null;
        if ("/act/".equals(segment)) {
            activityID = path.substring(slashInd + 1);
        } else if ("/ver/".equals(segment)) {
            int nextSlashInd = path.indexOf(47, slashInd + 1);
            if (nextSlashInd == -1) {
                try {
                    revision = Long.parseLong(path.substring(slashInd + 1));
                }
                catch (NumberFormatException nfe) {
                    DAVPathUtil.throwMalformedURIErrorException();
                }
                reposPath = SLASH;
            } else {
                segment = path.substring(slashInd + 1, nextSlashInd);
                try {
                    revision = Long.parseLong(segment);
                }
                catch (NumberFormatException nfe) {
                    DAVPathUtil.throwMalformedURIErrorException();
                }
                reposPath = SVNEncodingUtil.uriDecode((String)path.substring(nextSlashInd));
            }
            if (!SVNRevision.isValidRevisionNumber((long)revision)) {
                DAVPathUtil.throwMalformedURIErrorException();
            }
        } else {
            DAVPathUtil.throwUnhandledFormException();
        }
        return new DAVURIInfo(activityID, reposPath, revision);
    }

    private static void throwMalformedURIErrorException() throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.APMOD_MALFORMED_URI, (String)"The specified URI could not be parsed");
        SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.NETWORK);
    }

    private static void throwUnhandledFormException() throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNSUPPORTED_FEATURE, (String)"Unsupported URI form");
        SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.NETWORK);
    }
}

