/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslatorInputStream;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPathBasedAccess {
    private static final Pattern COMMA = Pattern.compile(",");
    private static final String ANONYMOUS_REPOSITORY = "";
    public static final int SVN_ACCESS_NONE = 0;
    public static final int SVN_ACCESS_READ = 1;
    public static final int SVN_ACCESS_WRITE = 2;
    public static final int SVN_ACCESS_RECURSIVE = 4;
    private String myConfigPath;
    private int myCurrentLineNumber = 1;
    private int myCurrentLineColumn = 0;
    private char myUngottenChar = '\u0000';
    private boolean myHasUngottenChar = false;
    private StringBuffer mySectionName;
    private StringBuffer myOption;
    private StringBuffer myValue;
    private Map myGroups;
    private Map myAliases;
    private Map myRules;

    public SVNPathBasedAccess(File pathBasedAccessConfiguration) throws SVNException {
        this.myConfigPath = pathBasedAccessConfiguration.getAbsolutePath();
        SVNTranslatorInputStream stream = null;
        try {
            stream = new SVNTranslatorInputStream(SVNFileUtil.openFileForReading((File)pathBasedAccessConfiguration, (SVNLogType)SVNLogType.NETWORK), SVNProperty.EOL_LF_BYTES, true, null, false);
        }
        catch (SVNException e) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"Failed to load the AuthzSVNAccessFile: ''{0}''", (Object)pathBasedAccessConfiguration.getAbsolutePath()), (SVNLogType)SVNLogType.NETWORK);
        }
        try {
            this.parse((InputStream)stream);
        }
        catch (IOException e) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (String)e.getLocalizedMessage()), (SVNLogType)SVNLogType.NETWORK);
        }
        this.validate();
    }

    private String getConfigPath() {
        return this.myConfigPath;
    }

    private void increaseCurrentLineNumber() {
        ++this.myCurrentLineNumber;
    }

    private int getCurrentLineNumber() {
        return this.myCurrentLineNumber;
    }

    private void increaseCurrentLineColumn() {
        ++this.myCurrentLineColumn;
    }

    private void resetCurrentLineColumn() {
        this.myCurrentLineColumn = 0;
    }

    private int getCurrentLineColumn() {
        return this.myCurrentLineColumn;
    }

    private char getUngottenChar() {
        return this.myUngottenChar;
    }

    private void setUngottenChar(char ungottenChar) {
        this.myUngottenChar = ungottenChar;
    }

    private boolean hasUngottenChar() {
        return this.myHasUngottenChar;
    }

    private void setHasUngottenChar(boolean hasUngottenChar) {
        this.myHasUngottenChar = hasUngottenChar;
    }

    private StringBuffer getSectionName() {
        if (this.mySectionName == null) {
            this.mySectionName = new StringBuffer();
        }
        return this.mySectionName;
    }

    private StringBuffer getOption() {
        if (this.myOption == null) {
            this.myOption = new StringBuffer();
        }
        return this.myOption;
    }

    private StringBuffer getValue() {
        if (this.myValue == null) {
            this.myValue = new StringBuffer();
        }
        return this.myValue;
    }

    private Map getGroups() {
        if (this.myGroups == null) {
            this.myGroups = new SVNHashMap();
        }
        return this.myGroups;
    }

    private boolean groupContainsUser(String group, String user) {
        String[] groupUsers = (String[])this.getGroups().get(group);
        if (groupUsers == null) {
            return false;
        }
        for (int i = 0; i < groupUsers.length; ++i) {
            if (!(groupUsers[i].startsWith("@") ? this.groupContainsUser(groupUsers[i].substring("@".length()), user) : (groupUsers[i].startsWith("&") ? this.aliasIsUser(groupUsers[i].substring("&".length()), user) : groupUsers[i].equals(user)))) continue;
            return true;
        }
        return false;
    }

    private Map getAliases() {
        if (this.myAliases == null) {
            this.myAliases = new SVNHashMap();
        }
        return this.myAliases;
    }

    private boolean aliasIsUser(String alias, String user) {
        String aliasValue = (String)this.getAliases().get(alias);
        return aliasValue != null && aliasValue.equals(user);
    }

    private Map getRules() {
        if (this.myRules == null) {
            this.myRules = new SVNHashMap();
        }
        return this.myRules;
    }

    public boolean checkAccess(String repository, String path, String user, int access) {
        RepositoryAccess repositoryAccess = (RepositoryAccess)this.getRules().get(repository);
        if (repositoryAccess == null && (repositoryAccess = (RepositoryAccess)this.getRules().get(ANONYMOUS_REPOSITORY)) == null) {
            return false;
        }
        return repositoryAccess.checkPathAccess(path, user, access);
    }

    private void parse(InputStream is) throws IOException, SVNException {
        boolean isEOF = false;
        do {
            int currentByte = this.skipWhitespace(is);
            switch (currentByte) {
                case 91: {
                    if (this.getCurrentLineColumn() == 0) {
                        this.parseSectionName(is);
                        break;
                    }
                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"''{0}'' : ''{1}'' : Section header must start in the first column.", (Object[])new Object[]{this.getConfigPath(), new Integer(this.getCurrentLineNumber())}), (SVNLogType)SVNLogType.NETWORK);
                    break;
                }
                case 35: {
                    if (this.getCurrentLineColumn() == 0) {
                        this.skipToEndOfLine(is);
                        this.increaseCurrentLineNumber();
                        break;
                    }
                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"''{0}'' : ''{1}'' : Comment must start in the first column.", (Object[])new Object[]{this.getConfigPath(), new Integer(this.getCurrentLineNumber())}), (SVNLogType)SVNLogType.NETWORK);
                    break;
                }
                case 10: {
                    this.increaseCurrentLineNumber();
                    break;
                }
                case -1: {
                    isEOF = true;
                    break;
                }
                default: {
                    if (this.getSectionName().length() == 0) {
                        SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"''{0}'' : ''{1}'' : Section header expected.", (Object[])new Object[]{this.getConfigPath(), new Integer(this.getCurrentLineNumber())}), (SVNLogType)SVNLogType.NETWORK);
                        break;
                    }
                    if (this.getCurrentLineColumn() != 0) {
                        SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"''{0}'' : ''{1}'' : Option expected.", (Object[])new Object[]{this.getConfigPath(), new Integer(this.getCurrentLineNumber())}), (SVNLogType)SVNLogType.NETWORK);
                        break;
                    }
                    this.parseOption(is, currentByte);
                }
            }
        } while (!isEOF);
        this.getSectionName().setLength(0);
        this.getOption().setLength(0);
        this.getValue().setLength(0);
    }

    private int parseSectionName(InputStream is) throws IOException, SVNException {
        this.getSectionName().setLength(0);
        int currentByte = this.getc(is);
        while (currentByte != -1 && currentByte != 10 && currentByte != 93) {
            this.getSectionName().append((char)currentByte);
            currentByte = this.getc(is);
        }
        if (currentByte != 93) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"''{0}'' : ''{1}'' : Section header must end with ']'.", (Object[])new Object[]{this.getConfigPath(), new Integer(this.getCurrentLineNumber())}), (SVNLogType)SVNLogType.NETWORK);
        } else {
            currentByte = this.skipToEndOfLine(is);
            if (currentByte != -1) {
                this.increaseCurrentLineNumber();
            }
        }
        return currentByte;
    }

    private int parseOption(InputStream is, int firstByte) throws IOException, SVNException {
        this.getOption().setLength(0);
        int currentByte = firstByte;
        while (currentByte != -1 && currentByte != 58 && currentByte != 61 && currentByte != 10) {
            this.getOption().append((char)currentByte);
            currentByte = this.getc(is);
        }
        if (currentByte != 58 && currentByte != 61) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"''{0}'' : ''{1}'' : Option must end with ':' or '='.", (Object[])new Object[]{this.getConfigPath(), new Integer(this.getCurrentLineNumber())}), (SVNLogType)SVNLogType.NETWORK);
        } else {
            this.trimBuffer(this.getOption());
            currentByte = this.parseValue(is);
        }
        return currentByte;
    }

    private int parseValue(InputStream is) throws IOException, SVNException {
        this.getValue().setLength(0);
        int currentByte = this.getc(is);
        boolean isEndOfValue = false;
        while (currentByte != -1 && currentByte != 10) {
            this.getValue().append((char)currentByte);
            currentByte = this.getc(is);
        }
        this.trimBuffer(this.getValue());
        block5: while (true) {
            if (currentByte == -1 || isEndOfValue) break;
            this.increaseCurrentLineNumber();
            currentByte = this.skipWhitespace(is);
            switch (currentByte) {
                case 10: {
                    this.increaseCurrentLineNumber();
                    isEndOfValue = true;
                    continue block5;
                }
                case -1: {
                    isEndOfValue = true;
                    continue block5;
                }
            }
            if (this.getCurrentLineColumn() == 0) {
                this.ungetc((char)currentByte);
                isEndOfValue = true;
                continue;
            }
            this.getValue().append(' ');
            while (currentByte != -1 && currentByte != 10) {
                this.getValue().append((char)currentByte);
                currentByte = this.getc(is);
            }
            this.trimBuffer(this.getValue());
        }
        this.updateConfiguration();
        return currentByte;
    }

    private int skipWhitespace(InputStream is) throws IOException {
        this.resetCurrentLineColumn();
        int currentByte = this.getc(is);
        while (Character.isWhitespace((char)currentByte)) {
            currentByte = this.getc(is);
            this.increaseCurrentLineColumn();
        }
        return currentByte;
    }

    private int skipToEndOfLine(InputStream is) throws IOException {
        int currentByte = this.getc(is);
        while (currentByte != -1 && currentByte != 10) {
            currentByte = this.getc(is);
            this.resetCurrentLineColumn();
        }
        return currentByte;
    }

    private int getc(InputStream is) throws IOException {
        if (this.hasUngottenChar()) {
            this.setHasUngottenChar(false);
            return this.getUngottenChar();
        }
        return is.read();
    }

    private void ungetc(char ungottenChar) {
        this.setUngottenChar(ungottenChar);
        this.setHasUngottenChar(true);
    }

    private void trimBuffer(StringBuffer buffer) {
        while (buffer.length() > 0 && Character.isWhitespace(buffer.charAt(0))) {
            buffer.deleteCharAt(0);
        }
        while (buffer.length() > 0 && Character.isWhitespace(buffer.charAt(buffer.length() - 1))) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
    }

    private void updateConfiguration() throws SVNException {
        if ("groups".equals(this.getSectionName().toString())) {
            this.updateGroups();
        } else if ("aliases".equals(this.getSectionName().toString())) {
            this.updateAliases();
        } else {
            this.updateRules();
        }
    }

    private void updateGroups() throws SVNException {
        String groupName = this.getOption().toString();
        if (this.getValue().length() == 0) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"An authz rule refers to group ''{0}'', which is undefined", (Object)groupName), (SVNLogType)SVNLogType.NETWORK);
        }
        String[] users = COMMA.split(this.getValue());
        this.getGroups().put(groupName, users);
    }

    private void updateAliases() throws SVNException {
        String alias = this.getOption().toString();
        if (this.getValue().length() == 0) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"An authz rule refers to alies ''{0}'', which is undefined", (Object)alias), (SVNLogType)SVNLogType.NETWORK);
        }
        this.getAliases().put(alias, this.getValue().toString());
    }

    private void updateRules() throws SVNException {
        RepositoryAccess repositoryAccess;
        String token;
        int delimeterIndex = this.getSectionName().indexOf(":");
        String repositoryName = delimeterIndex == -1 ? ANONYMOUS_REPOSITORY : this.getSectionName().substring(0, delimeterIndex);
        String path = delimeterIndex == -1 ? this.getSectionName().toString() : this.getSectionName().substring(delimeterIndex + 1);
        String value = this.getValue().toString();
        if (this.getOption().charAt(0) == '~') {
            if (this.getOption().charAt(1) == '~') {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"Rule ''{0}'' has more than one inversion; double negatives are not permitted.", (Object)this.getOption()), (SVNLogType)SVNLogType.NETWORK);
            }
            if (this.getOption().charAt(1) == '*') {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"Authz rules with match string '~*' are not allowed, because they never match anyone."), (SVNLogType)SVNLogType.NETWORK);
            }
        }
        if (this.getOption().charAt(0) == '$' && !"anonymous".equals(token = this.getOption().substring(1)) && !"authenticated".equals(token)) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"Unrecognized authz token ''{0}''.", (Object)this.getOption()), (SVNLogType)SVNLogType.NETWORK);
        }
        if (value.length() > 0 && !"r".equals(value) && !"rw".equals(value)) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"The value ''{0}'' in rule ''{1}'' is not allowed in authz rules.", (Object[])new Object[]{value, this.getOption()}), (SVNLogType)SVNLogType.NETWORK);
        }
        if ((repositoryAccess = (RepositoryAccess)this.getRules().get(repositoryName)) == null) {
            repositoryAccess = new RepositoryAccess(ANONYMOUS_REPOSITORY.equals(repositoryName));
            this.getRules().put(repositoryName, repositoryAccess);
        }
        repositoryAccess.addRule(path, this.getOption().toString(), this.getValue().toString());
    }

    private void validate() throws SVNException {
        ArrayList checkedPathes = new ArrayList();
        for (String groupName : this.getGroups().keySet()) {
            checkedPathes.clear();
            this.groupWalk(groupName, checkedPathes);
        }
        for (RepositoryAccess repositoryAccess : this.getRules().values()) {
            repositoryAccess.validateRules();
        }
    }

    private void groupWalk(String group, Collection checkedGroups) throws SVNException {
        String[] users = (String[])this.getGroups().get(group);
        if (users == null) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"An authz rule refers to group ''{0}'', which is undefined.", (Object)group), (SVNLogType)SVNLogType.NETWORK);
        }
        for (int i = 0; i < users.length; ++i) {
            users[i] = users[i].trim();
            if (users[i].startsWith("@")) {
                String subGroup = users[i].substring("@".length());
                if (checkedGroups.contains(subGroup)) {
                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"Circular dependency between groups ''{0}'' and ''{1}''", (Object[])new Object[]{group, subGroup}), (SVNLogType)SVNLogType.NETWORK);
                }
                checkedGroups.add(subGroup);
                this.groupWalk(subGroup, checkedGroups);
                checkedGroups.remove(subGroup);
                continue;
            }
            if (!users[i].startsWith("&")) continue;
            String alias = users[i].substring("&".length());
            if (this.getAliases().keySet().contains(alias)) continue;
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"An authz rule refers to alias ''{0}'', which is undefined.", (Object)alias), (SVNLogType)SVNLogType.NETWORK);
        }
    }

    private class PathAccess {
        private Map myRules;

        private PathAccess() {
        }

        private void addRule(String matchString, String value) {
            this.myRules = this.myRules == null ? new SVNHashMap() : this.myRules;
            this.myRules.put(matchString, value);
        }

        private void validateRules() throws SVNException {
            if (this.myRules != null) {
                for (String matchString : this.myRules.keySet()) {
                    if (matchString.startsWith("@")) {
                        if (SVNPathBasedAccess.this.getGroups().keySet().contains(matchString.substring("@".length()))) continue;
                        SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"An authz rule refers to group ''{0}'', which is undefined.", (Object)matchString), (SVNLogType)SVNLogType.NETWORK);
                        continue;
                    }
                    if (!matchString.startsWith("&") || SVNPathBasedAccess.this.getAliases().keySet().contains(matchString.substring("&".length()))) continue;
                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"An authz rule refers to alias ''{0}'', which is undefined.", (Object)matchString), (SVNLogType)SVNLogType.NETWORK);
                }
            }
        }

        private int[] checkAccess(String user) {
            if (this.myRules == null) {
                return null;
            }
            int deny = 0;
            int allow = 0;
            for (Map.Entry entry : this.myRules.entrySet()) {
                String matchString = (String)entry.getKey();
                String accessType = (String)entry.getValue();
                if (!this.ruleApliesToUser(matchString, user)) continue;
                if (accessType.indexOf(114) >= 0) {
                    allow |= 1;
                } else {
                    deny |= 1;
                }
                if (accessType.indexOf(119) >= 0) {
                    allow |= 2;
                    continue;
                }
                deny |= 2;
            }
            return new int[]{allow, deny};
        }

        private boolean ruleApliesToUser(String matchString, String user) {
            if (matchString.startsWith("~")) {
                return !this.ruleApliesToUser(matchString.substring("~".length()), user);
            }
            if (matchString.equals("*")) {
                return true;
            }
            if (matchString.equals("$anonymous")) {
                return user == null;
            }
            if (matchString.equals("$authenticated")) {
                return user != null;
            }
            if (user == null) {
                return false;
            }
            if (matchString.startsWith("@")) {
                return SVNPathBasedAccess.this.groupContainsUser(matchString.substring("@".length()), user);
            }
            if (matchString.startsWith("&")) {
                return SVNPathBasedAccess.this.aliasIsUser(matchString.substring("&".length()), user);
            }
            return matchString.equals(user);
        }
    }

    private class RepositoryAccess {
        boolean myAnonymous = false;
        private Map myPathRules;
        private PathAccess myGlobalAccess;

        private RepositoryAccess(boolean isAnonymous) {
            this.myAnonymous = isAnonymous;
        }

        private void addRule(String path, String matchString, String value) {
            if (path.equals("/") || path.length() == 0) {
                this.myGlobalAccess = this.myGlobalAccess == null ? new PathAccess() : this.myGlobalAccess;
                this.myGlobalAccess.addRule(matchString, value);
            }
            this.myPathRules = this.myPathRules == null ? new SVNHashMap() : this.myPathRules;
            PathAccess pathAccess = (PathAccess)this.myPathRules.get(path);
            if (pathAccess == null) {
                pathAccess = new PathAccess();
                this.myPathRules.put(path, pathAccess);
            }
            pathAccess.addRule(matchString, value);
        }

        private void validateRules() throws SVNException {
            if (this.myGlobalAccess != null) {
                this.myGlobalAccess.validateRules();
            }
            if (this.myPathRules != null) {
                for (PathAccess pathAccess : this.myPathRules.values()) {
                    pathAccess.validateRules();
                }
            }
        }

        private boolean checkPathAccess(String path, String user, int requestedAccess) {
            boolean accessGranted;
            block6: {
                block5: {
                    int[] pathAccess;
                    accessGranted = false;
                    if (path != null && path.length() != 0 && !"/".equals(path)) break block5;
                    if (this.myGlobalAccess == null || !this.isAccessDetermined(pathAccess = this.myGlobalAccess.checkAccess(user), requestedAccess)) break block6;
                    accessGranted = this.isAccessGranted(pathAccess, requestedAccess);
                    break block6;
                }
                if (this.myPathRules == null) {
                    return false;
                }
                int[] pathAccess = this.checkCurrentPath(path, user);
                if (this.isAccessDetermined(pathAccess, requestedAccess)) {
                    accessGranted = this.isAccessGranted(pathAccess, requestedAccess);
                } else {
                    String currentPath = path;
                    while (currentPath.length() > 0 && !"/".equals(currentPath)) {
                        pathAccess = this.checkCurrentPath(currentPath = SVNPathUtil.getAbsolutePath((String)SVNPathUtil.removeTail((String)currentPath)), user);
                        if (!this.isAccessDetermined(pathAccess, requestedAccess)) continue;
                        accessGranted = this.isAccessGranted(pathAccess, requestedAccess);
                        break;
                    }
                }
            }
            if (accessGranted && (requestedAccess & 4) != 0) {
                accessGranted = this.checkTreeAccess(user, path, requestedAccess);
            }
            return accessGranted;
        }

        private int[] checkCurrentPath(String currentPath, String user) {
            RepositoryAccess commonRepositoryAccess;
            int[] pathAccess = new int[]{0, 0};
            PathAccess currentPathAccess = (PathAccess)this.myPathRules.get(currentPath);
            if (currentPathAccess != null) {
                pathAccess = currentPathAccess.checkAccess(user);
            } else if (!this.myAnonymous && (commonRepositoryAccess = (RepositoryAccess)SVNPathBasedAccess.this.getRules().get(SVNPathBasedAccess.ANONYMOUS_REPOSITORY)) != null) {
                pathAccess = commonRepositoryAccess.checkPathAccess(user, currentPath);
            }
            return pathAccess;
        }

        private int[] checkPathAccess(String user, String path) {
            int[] result = new int[]{0, 0};
            PathAccess pathAccess = (PathAccess)this.myPathRules.get(path);
            if (pathAccess != null) {
                result = pathAccess.checkAccess(user);
            }
            return result;
        }

        private boolean checkTreeAccess(String user, String path, int requestedAccess) {
            if (SVNPathBasedAccess.this.myRules == null) {
                return false;
            }
            boolean accessGranted = true;
            for (Map.Entry entry : SVNPathBasedAccess.this.myRules.entrySet()) {
                PathAccess currentPathAccess;
                int[] pathAccess;
                String currentPath = (String)entry.getKey();
                if (!SVNPathUtil.isAncestor((String)path, (String)currentPath) || (accessGranted = this.isAccessGranted(pathAccess = (currentPathAccess = (PathAccess)entry.getValue()).checkAccess(user), requestedAccess) || !this.isAccessDetermined(pathAccess, requestedAccess))) continue;
                return accessGranted;
            }
            return accessGranted;
        }

        private boolean isAccessGranted(int[] pathAccess, int requestedAccess) {
            if (pathAccess == null) {
                return false;
            }
            int allow = pathAccess[0];
            int deny = pathAccess[1];
            int strippedAccess = requestedAccess & 3;
            return (deny & requestedAccess) == 0 || (allow & requestedAccess) == strippedAccess;
        }

        private boolean isAccessDetermined(int[] pathAccess, int requestedAccess) {
            if (pathAccess == null) {
                return false;
            }
            int allow = pathAccess[0];
            int deny = pathAccess[1];
            return (deny & requestedAccess) != 0 || (allow & requestedAccess) != 0;
        }
    }
}

