/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVDatedRevisionRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVReportHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;

public class DAVDatedRevisionHandler
extends DAVReportHandler {
    private DAVDatedRevisionRequest myDAVRequest;

    public DAVDatedRevisionHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response) {
        super(repositoryManager, request, response);
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return this.getDatedRevisionRequest();
    }

    private DAVDatedRevisionRequest getDatedRevisionRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVDatedRevisionRequest();
        }
        return this.myDAVRequest;
    }

    @Override
    public void execute() throws SVNException {
        this.setDAVResource(this.getRequestedDAVResource(false, false));
        String responseBody = this.generateResponseBody();
        try {
            int contentLength = responseBody.getBytes("UTF-8").length;
            this.setResponseContentLength(contentLength);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.write(responseBody);
    }

    private String generateResponseBody() throws SVNException {
        StringBuffer xmlBuffer = new StringBuffer();
        long revision = this.getDatedRevision();
        this.addXMLHeader(xmlBuffer, null);
        SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.VERSION_NAME.getName(), (String)String.valueOf(revision), (StringBuffer)xmlBuffer);
        this.addXMLFooter(xmlBuffer, null);
        return xmlBuffer.toString();
    }

    private long getDatedRevision() throws SVNException {
        return this.getDAVResource().getRepository().getDatedRevision(this.getDatedRevisionRequest().getDate());
    }
}

