/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceURI;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVGetDeletedRevisionRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVReportHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVGetDeletedRevisionHandler
extends DAVReportHandler {
    private DAVGetDeletedRevisionRequest myDAVRequest;
    private DAVReportHandler myCommonReportHandler;

    protected DAVGetDeletedRevisionHandler(DAVRepositoryManager connector, HttpServletRequest request, HttpServletResponse response, DAVReportHandler commonReportHandler) {
        super(connector, request, response);
        this.myCommonReportHandler = commonReportHandler;
    }

    @Override
    public void execute() throws SVNException {
        this.myCommonReportHandler.checkSVNNamespace(null);
        this.setDAVResource(this.getRequestedDAVResource(false, false));
        DAVGetDeletedRevisionRequest request = this.getDeletedRevisionRequest();
        String relPath = request.getPath();
        long pegRev = request.getPegRevision();
        long endRev = request.getEndRevision();
        if (relPath == null || !SVNRevision.isValidRevisionNumber((long)pegRev) || !SVNRevision.isValidRevisionNumber((long)endRev)) {
            throw new DAVException("Not all parameters passed.", null, 400, null, SVNLogType.NETWORK, Level.FINE, null, "error", "svn:", 0, null);
        }
        DAVResourceURI resourceURI = this.getDAVResource().getResourceURI();
        String path = relPath;
        if (!path.startsWith("/")) {
            path = SVNPathUtil.append((String)resourceURI.getPath(), (String)relPath);
        }
        SVNRepository repository = this.getDAVResource().getRepository();
        long deletedRev = -1L;
        try {
            deletedRev = repository.getDeletedRevision(path, pegRev, endRev);
        }
        catch (SVNException svne) {
            throw new DAVException("Could not find revision path was deleted.", 500, 0);
        }
        this.writeXMLHeader(null);
        StringBuffer xmlBuffer = SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.VERSION_NAME.getName(), (String)String.valueOf(deletedRev), null);
        this.write(xmlBuffer);
        this.writeXMLFooter(null);
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return this.getDeletedRevisionRequest();
    }

    private DAVGetDeletedRevisionRequest getDeletedRevisionRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVGetDeletedRevisionRequest();
        }
        return this.myDAVRequest;
    }
}

