/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVGetLocksRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVReportHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVGetLocksHandler
extends DAVReportHandler {
    private DAVGetLocksRequest myDAVRequest;

    protected DAVGetLocksHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response) {
        super(repositoryManager, request, response);
    }

    @Override
    protected DAVRequest getDAVRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVGetLocksRequest();
        }
        return this.myDAVRequest;
    }

    @Override
    public void execute() throws SVNException {
        this.setDAVResource(this.getRequestedDAVResource(false, false));
        String responseBody = this.generateResponseBody();
        try {
            this.setResponseContentLength(responseBody.getBytes("UTF-8").length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.write(responseBody);
    }

    private String generateResponseBody() throws SVNException {
        if (this.getDAVResource().getResourceURI().getPath() == null) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (String)"get-locks-report run on resource which doesn't represent a path within a repository."), (SVNLogType)SVNLogType.NETWORK);
        }
        SVNLock[] locks = this.getDAVResource().getLocks();
        StringBuffer xmlBuffer = new StringBuffer();
        this.addXMLHeader(xmlBuffer, null);
        for (int i = 0; i < locks.length; ++i) {
            this.addLock(locks[i], xmlBuffer);
        }
        this.addXMLFooter(xmlBuffer, null);
        return xmlBuffer.toString();
    }

    private void addLock(SVNLock lock, StringBuffer xmlBuffer) {
        SVNXMLUtil.openXMLTag((String)"S", (String)"lock", (int)1, null, (StringBuffer)xmlBuffer);
        SVNXMLUtil.openCDataTag((String)"S", (String)"path", (String)lock.getPath(), (StringBuffer)xmlBuffer);
        SVNXMLUtil.openCDataTag((String)"S", (String)"token", (String)lock.getID(), (StringBuffer)xmlBuffer);
        SVNXMLUtil.openCDataTag((String)"S", (String)"creationdate", (String)SVNDate.formatDate((Date)lock.getCreationDate()), (StringBuffer)xmlBuffer);
        if (lock.getExpirationDate() != null) {
            SVNXMLUtil.openCDataTag((String)"S", (String)"expirationdate", (String)SVNDate.formatDate((Date)lock.getExpirationDate()), (StringBuffer)xmlBuffer);
        }
        if (lock.getOwner() != null) {
            if (SVNEncodingUtil.isXMLSafe((String)lock.getOwner())) {
                SVNXMLUtil.openCDataTag((String)"S", (String)"owner", (String)lock.getOwner(), (StringBuffer)xmlBuffer);
            } else {
                String ownerEncoded = null;
                try {
                    ownerEncoded = SVNBase64.byteArrayToBase64((byte[])lock.getOwner().getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    ownerEncoded = SVNBase64.byteArrayToBase64((byte[])lock.getOwner().getBytes());
                }
                SVNXMLUtil.openCDataTag((String)"S", (String)"owner", (String)ownerEncoded, (String)"encoding", (String)"base64", (boolean)false, (boolean)false, (StringBuffer)xmlBuffer);
            }
        }
        if (lock.getComment() != null) {
            if (SVNEncodingUtil.isXMLSafe((String)lock.getComment())) {
                SVNXMLUtil.openCDataTag((String)"S", (String)"comment", (String)lock.getComment(), (StringBuffer)xmlBuffer);
            } else {
                String commentEncoded = null;
                try {
                    commentEncoded = SVNBase64.byteArrayToBase64((byte[])lock.getComment().getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    commentEncoded = SVNBase64.byteArrayToBase64((byte[])lock.getComment().getBytes());
                }
                SVNXMLUtil.openCDataTag((String)"S", (String)"comment", (String)commentEncoded, (String)"encoding", (String)"base64", (boolean)false, (boolean)false, (StringBuffer)xmlBuffer);
            }
        }
        SVNXMLUtil.closeXMLTag((String)"S", (String)"lock", (StringBuffer)xmlBuffer);
    }
}

