/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVServletUtil;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVMakeActivityHandler
extends ServletDAVHandler {
    private FSFS myFSFS;

    public DAVMakeActivityHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response) {
        super(repositoryManager, request, response);
    }

    @Override
    public void execute() throws SVNException {
        DAVResource resource = this.getRequestedDAVResource(false, false);
        FSRepository repos = (FSRepository)resource.getRepository();
        this.myFSFS = repos.getFSFS();
        this.readInput(true);
        if (resource.exists()) {
            throw new DAVException("<DAV:resource-must-be-null/>", 409, SVNLogType.NETWORK);
        }
        if (!resource.canBeActivity()) {
            throw new DAVException("<DAV:activity-location-ok/>", 403, SVNLogType.NETWORK);
        }
        try {
            this.makeActivity(resource);
        }
        catch (DAVException dave) {
            throw new DAVException("Could not create activity {0}.", new Object[]{SVNEncodingUtil.xmlEncodeCDATA((String)resource.getResourceURI().getURI())}, dave.getResponseCode(), null, SVNLogType.NETWORK, Level.FINE, dave, null, null, 0, null);
        }
        this.setResponseHeader("Cache-Control", "no-cache");
        this.handleDAVCreated(resource.getResourceURI().getURI(), "Activity", false);
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return null;
    }

    private void makeActivity(DAVResource resource) throws DAVException {
        FSTransactionInfo txnInfo = DAVServletUtil.createActivity(resource, this.myFSFS);
        DAVServletUtil.storeActivity(resource, txnInfo.getTxnId());
        resource.setExists(true);
        resource.setTxnName(txnInfo.getTxnId());
    }
}

