/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceKind;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceType;
import org.tmatesoft.svn.core.internal.server.dav.DAVXMLUtil;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVOptionsRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVOptionsHandler
extends ServletDAVHandler {
    private static final DAVElement OPTIONS = DAVElement.getElement((String)"DAV:", (String)"options");
    private static final DAVElement ACTIVITY_COLLECTION_SET = DAVElement.getElement((String)"DAV:", (String)"activity-collection-set");
    private static final DAVElement SUPPORTED_METHOD_SET = DAVElement.getElement((String)"DAV:", (String)"supported-method-set");
    private static final DAVElement SUPPORTED_METHOD = DAVElement.getElement((String)"DAV:", (String)"supported-method");
    private static final DAVElement SUPPORTED_LIVE_PROPERTY_SET = DAVElement.getElement((String)"DAV:", (String)"supported-live-property-set");
    private static final DAVElement SUPPORTED_LIVE_PROPERTY = DAVElement.getElement((String)"DAV:", (String)"supported-live-property");
    private static final DAVElement SUPPORTED_REPORT_SET = DAVElement.getElement((String)"DAV:", (String)"supported-report-set");
    private static final DAVElement SUPPORTED_REPORT = DAVElement.getElement((String)"DAV:", (String)"supported-report");
    private static final String DAV_HEADER = "DAV";
    private static final String DAV_LEVEL = "1,2";
    private static final String VERSION_OPTIONS_FIRST_PART = "version-control,checkout,working-resource";
    private static final String VERSION_OPTIONS_SECOND_PART = "merge,baseline,activity,version-controlled-collection";
    private static final String MS_AUTHOR_VIA_HEADER = "MS-Author-Via";
    private static final String ALLOW_HEADER = "Allow";
    private DAVOptionsRequest myDAVRequest;

    public DAVOptionsHandler(DAVRepositoryManager connector, HttpServletRequest request, HttpServletResponse response) {
        super(connector, request, response);
    }

    @Override
    protected DAVRequest getDAVRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVOptionsRequest();
        }
        return this.myDAVRequest;
    }

    private DAVOptionsRequest getOptionsRequest() {
        return (DAVOptionsRequest)this.getDAVRequest();
    }

    @Override
    public void execute() throws SVNException {
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "in execute() of DAVOptiondsHandler");
        this.readInput(false);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "read input");
        DAVResource resource = this.getRequestedDAVResource(false, false);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "got resource");
        Collection supportedMethods = DAVOptionsHandler.getSupportedMethods(resource);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "got supported methods");
        StringBuffer body = new StringBuffer();
        this.generateOptionsResponse(resource, supportedMethods, body);
        String responseBody = body.toString();
        try {
            this.setResponseContentLength(responseBody.getBytes("UTF-8").length);
        }
        catch (UnsupportedEncodingException e) {
            this.setResponseContentLength(responseBody.getBytes().length);
        }
        this.setDefaultResponseHeaders();
        this.setResponseHeaders(supportedMethods);
        this.setResponseContentType("text/xml; charset=\"utf-8\"");
        this.setResponseStatus(200);
        try {
            this.getResponseWriter().write(responseBody);
        }
        catch (IOException e) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)e), (Throwable)e, (SVNLogType)SVNLogType.NETWORK);
        }
    }

    @Override
    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (parent == null && element != OPTIONS) {
            this.invalidXML();
        } else if (parent == OPTIONS && element == ACTIVITY_COLLECTION_SET) {
            this.getOptionsRequest().setActivitySetRequest(true);
        } else if (parent == SUPPORTED_METHOD_SET && element == SUPPORTED_METHOD) {
            String requestedMethodName = attrs.getValue("DAV:", "name");
            if (requestedMethodName == null || this.getOptionsRequest().getRequestedMethods() == null) {
                this.invalidXML();
            }
            this.getOptionsRequest().getRequestedMethods().add(requestedMethodName);
        } else if (parent == SUPPORTED_REPORT_SET && element == SUPPORTED_REPORT) {
            String requestedReportName = attrs.getValue("DAV:", "name");
            String requestedReportNamespace = attrs.getValue("DAV:", "namespace");
            if (requestedReportName == null || this.getOptionsRequest().getRequestedReports() == null) {
                this.invalidXML();
            }
            if (requestedReportNamespace == null) {
                requestedReportNamespace = "svn:";
            }
            this.getOptionsRequest().getRequestedReports().add(DAVElement.getElement((String)requestedReportNamespace, (String)requestedReportName));
        } else if (parent == SUPPORTED_LIVE_PROPERTY_SET && element == SUPPORTED_LIVE_PROPERTY) {
            String requestedLivePropertyName = attrs.getValue("DAV:", "name");
            String requestedLivePropertyNamespace = attrs.getValue("DAV:", "namespace");
            if (requestedLivePropertyName == null || this.getOptionsRequest().getRequestedLiveProperties() == null) {
                this.invalidXML();
            }
            if (requestedLivePropertyNamespace == null) {
                requestedLivePropertyNamespace = "DAV:";
            }
            this.getOptionsRequest().getRequestedLiveProperties().add(DAVElement.getElement((String)requestedLivePropertyNamespace, (String)requestedLivePropertyName));
        }
    }

    @Override
    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
    }

    private static Collection getSupportedMethods(DAVResource resource) throws SVNException {
        ArrayList<String> supportedMethods = new ArrayList<String>();
        supportedMethods.add("OPTIONS");
        if (resource.exists()) {
            supportedMethods.add("GET");
            supportedMethods.add("HEAD");
            supportedMethods.add("POST");
            supportedMethods.add("DELETE");
            supportedMethods.add("TRACE");
            supportedMethods.add("PROPFIND");
            supportedMethods.add("PROPPATCH");
            supportedMethods.add("MOVE");
            supportedMethods.add("COPY");
            supportedMethods.add("LOCK");
            supportedMethods.add("UNLOCK");
            if (!resource.isCollection()) {
                supportedMethods.add("PUT");
            }
        }
        if (resource.getResourceURI().getType() == DAVResourceType.ACTIVITY && !resource.exists()) {
            supportedMethods.add("MKACTIVITY");
        } else if (resource.getResourceURI().isWorking()) {
            supportedMethods.add("CHECKIN");
        } else {
            supportedMethods.add("CHECKOUT");
        }
        return supportedMethods;
    }

    private void setResponseHeaders(Collection supportedMethods) {
        this.setResponseHeader(DAV_HEADER, DAV_LEVEL);
        this.addResponseHeader(DAV_HEADER, VERSION_OPTIONS_FIRST_PART);
        this.addResponseHeader(DAV_HEADER, VERSION_OPTIONS_SECOND_PART);
        this.addResponseHeader(DAV_HEADER, "http://subversion.tigris.org/xmlns/dav/svn/depth");
        this.addResponseHeader(DAV_HEADER, "http://subversion.tigris.org/xmlns/dav/svn/log-revprops");
        this.addResponseHeader(DAV_HEADER, "http://subversion.tigris.org/xmlns/dav/svn/partial-replay");
        this.addResponseHeader(DAV_HEADER, "http://subversion.tigris.org/xmlns/dav/svn/mergeinfo");
        this.setResponseHeader(MS_AUTHOR_VIA_HEADER, DAV_HEADER);
        this.setResponseHeader(ALLOW_HEADER, this.generateAllowHeaderValue(supportedMethods));
    }

    private String generateAllowHeaderValue(Collection supportedMethods) {
        StringBuffer allowHeaderBuffer = new StringBuffer();
        Iterator iterator = supportedMethods.iterator();
        while (iterator.hasNext()) {
            allowHeaderBuffer.append(iterator.next());
            allowHeaderBuffer.append(iterator.hasNext() ? "," : "");
        }
        return allowHeaderBuffer.toString();
    }

    private void generateOptionsResponse(DAVResource resource, Collection supportedMethods, StringBuffer xmlBuffer) throws SVNException {
        if (!this.getOptionsRequest().isEmpty()) {
            SVNXMLUtil.addXMLHeader((StringBuffer)xmlBuffer);
            DAVXMLUtil.openNamespaceDeclarationTag("D", "options-response", null, xmlBuffer, false);
            if (this.getOptionsRequest().isActivitySetRequest()) {
                this.generateActivityCollectionSet(resource, xmlBuffer);
            } else if (this.getOptionsRequest().isSupportedLivePropertiesRequest()) {
                this.generateSupportedLivePropertySet(resource, xmlBuffer);
            } else if (this.getOptionsRequest().isSupportedMethodsRequest()) {
                this.generateSupportedMethodSet(supportedMethods, xmlBuffer);
            } else if (this.getOptionsRequest().isSupportedReportsRequest()) {
                this.generateSupportedReportSet(resource, xmlBuffer);
            }
            SVNXMLUtil.addXMLFooter((String)"D", (String)"options-response", (StringBuffer)xmlBuffer);
        }
    }

    private void generateActivityCollectionSet(DAVResource resource, StringBuffer xmlBuffer) {
        SVNXMLUtil.openXMLTag((String)"D", (String)"activity-collection-set", (int)1, null, (StringBuffer)xmlBuffer);
        String uri = DAVPathUtil.buildURI(resource.getResourceURI().getContext(), DAVResourceKind.ACT_COLLECTION, 0L, null, false);
        SVNXMLUtil.openCDataTag((String)"D", (String)"href", (String)uri, (StringBuffer)xmlBuffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)"activity-collection-set", (StringBuffer)xmlBuffer);
    }

    private void generateSupportedLivePropertySet(DAVResource resource, StringBuffer xmlBuffer) throws SVNException {
        SVNXMLUtil.openXMLTag((String)"D", (String)"supported-live-property-set", (int)1, null, (StringBuffer)xmlBuffer);
        Collection supportedLiveProperties = DAVOptionsHandler.getSupportedLiveProperties(resource, null);
        this.generateSupportedElementSet("D", "supported-live-property", supportedLiveProperties, this.getOptionsRequest().getRequestedLiveProperties(), xmlBuffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)"supported-live-property-set", (StringBuffer)xmlBuffer);
    }

    private void generateSupportedMethodSet(Collection supportedMethods, StringBuffer xmlBuffer) {
        SVNXMLUtil.openXMLTag((String)"D", (String)"supported-method-set", (int)1, null, (StringBuffer)xmlBuffer);
        this.generateSupportedElementSet("D", "supported-method", supportedMethods, this.getOptionsRequest().getRequestedMethods(), xmlBuffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)"supported-method-set", (StringBuffer)xmlBuffer);
    }

    private void generateSupportedReportSet(DAVResource resource, StringBuffer xmlBuffer) {
        SVNXMLUtil.openXMLTag((String)"D", (String)"supported-report-set", (int)1, null, (StringBuffer)xmlBuffer);
        if (resource.getResourceURI().getType() == DAVResourceType.REGULAR) {
            this.generateSupportedElementSet("D", "supported-report", REPORT_ELEMENTS, this.getOptionsRequest().getRequestedReports(), xmlBuffer);
            SVNXMLUtil.closeXMLTag((String)"D", (String)"supported-report-set", (StringBuffer)xmlBuffer);
        }
    }

    private void generateSupportedElementSet(String prefix, String tagName, Collection supportedElements, Collection requestedElements, StringBuffer xmlBuffer) {
        for (Object item : supportedElements) {
            if (!requestedElements.isEmpty() && !requestedElements.contains(item)) continue;
            SVNHashMap attrs = new SVNHashMap();
            if (item instanceof DAVElement) {
                DAVElement currentElement = (DAVElement)item;
                attrs.put("name", currentElement.getNamespace());
                attrs.put("namespace", currentElement.getName());
            } else if (item instanceof String) {
                String currentName = (String)item;
                attrs.put("name", currentName);
            }
            SVNXMLUtil.openXMLTag((String)prefix, (String)tagName, (int)4, (Map)attrs, (StringBuffer)xmlBuffer);
        }
    }
}

