/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public abstract class DAVRequest {
    protected static final String NAME_ATTR = "name";
    protected static final String NAMESPACE_ATTR = "namespace";
    private DAVElementProperty myRootElementProperty;
    private DAVElementProperty myCurrentElement;

    public DAVElementProperty getRootElement() {
        return this.myRootElementProperty;
    }

    protected String getRootElementAttributeValue(String name) {
        if (this.myRootElementProperty != null) {
            return this.myRootElementProperty.getAttributeValue(name);
        }
        return null;
    }

    public void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (parent == null) {
            this.myCurrentElement = new DAVElementProperty(element, null);
            this.myCurrentElement.setAttributes(attrs);
            this.myRootElementProperty = this.myCurrentElement;
        } else {
            this.myCurrentElement = this.myCurrentElement.addChild(element, attrs);
        }
    }

    public void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (this.myCurrentElement == null || element != this.myCurrentElement.getName()) {
            this.invalidXML();
        }
        if (cdata != null) {
            this.myCurrentElement.addValue(cdata.toString());
        }
        this.myCurrentElement = this.myCurrentElement.getParent();
        if (this.myCurrentElement == null && parent != null) {
            this.invalidXML();
        }
    }

    protected abstract void init() throws SVNException;

    protected void invalidXML() throws SVNException {
        SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.XML_MALFORMED, (String)"Malformed XML"), (SVNLogType)SVNLogType.NETWORK);
    }

    protected void invalidXML(DAVElement element) throws SVNException {
        SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.XML_MALFORMED, (String)"\"The request's ''{0}'' element is malformed; there is a problem with the client.", (Object)element.getName()), (SVNLogType)SVNLogType.NETWORK);
    }

    protected void assertNullCData(DAVElement element, DAVElementProperty property) throws SVNException {
        if (property.getValues() == null) {
            this.invalidXML(element);
        }
    }
}

