/*
 * Decompiled with CFR 0.152.
 */
package tyrex.resource.jca;

import java.io.PrintWriter;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;

final class ConnectorLoader {
    protected final ManagedConnectionFactory _managedFactory;
    private final Class _connectionClass;
    private final Class _factoryClass;
    protected final boolean _xaSupported;
    protected final boolean _localSupported;

    ConnectorLoader(ClassLoader classLoader, String string, String string2, String string3, boolean bl, boolean bl2) throws Exception {
        if (classLoader == null) {
            throw new IllegalArgumentException("Argument loader is null");
        }
        this._managedFactory = (ManagedConnectionFactory)classLoader.loadClass(string).newInstance();
        this._factoryClass = classLoader.loadClass(string2);
        this._connectionClass = classLoader.loadClass(string3);
        this._xaSupported = bl;
        this._localSupported = bl2;
    }

    protected void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (printWriter != null) {
            this._managedFactory.setLogWriter(printWriter);
        }
    }

    protected ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        ManagedConnection managedConnection = this._managedFactory.matchManagedConnections(set, subject, connectionRequestInfo);
        if (managedConnection == null) {
            return null;
        }
        return managedConnection;
    }

    protected ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        ManagedConnection managedConnection = this._managedFactory.createManagedConnection(subject, connectionRequestInfo);
        if (managedConnection == null) {
            throw new ResourceException("Connector error: returned null from createManagedConnetion");
        }
        return managedConnection;
    }

    protected Object getConnection(ManagedConnection managedConnection, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (managedConnection == null) {
            throw new IllegalArgumentException("Argument managed is null");
        }
        Object object = managedConnection.getConnection(subject, connectionRequestInfo);
        if (object == null) {
            throw new ResourceException("Connector error: returned null from getConnection");
        }
        if (this._connectionClass.isAssignableFrom(object.getClass())) {
            return object;
        }
        throw new ResourceException("Connector error: unexpected connection class " + managedConnection.getClass().getName());
    }

    protected Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        if (connectionManager == null) {
            throw new IllegalArgumentException("Argument manager is null");
        }
        Object object = this._managedFactory.createConnectionFactory(connectionManager);
        if (object == null) {
            throw new ResourceException("Connector error: returned null from createConnectionFactory");
        }
        if (this._factoryClass.isAssignableFrom(object.getClass())) {
            return object;
        }
        throw new ResourceException("Connector error: unexpected connection facotry class " + object.getClass().getName());
    }

    protected ManagedConnectionFactory getConfigFactory() {
        return this._managedFactory;
    }
}

