/*
 * Decompiled with CFR 0.152.
 */
package actions.support;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import play.Configuration;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class PathParser {
    private static final String DELIM = "/";
    @Nonnull
    private final String[] pathSegments;

    public PathParser(String path) {
        this.pathSegments = StringUtils.split((String)path, (String)DELIM);
        if (this.pathSegments == null) {
            throw new NullPointerException();
        }
    }

    public PathParser(String contextPath, String path) {
        String contextRemovedPath = StringUtils.removeStart((String)path, (String)contextPath);
        this.pathSegments = StringUtils.split((String)contextRemovedPath, (String)DELIM);
        if (this.pathSegments == null) {
            throw new NullPointerException();
        }
    }

    public PathParser(Http.Context context) {
        this(Configuration.root().getString("application.context"), context.request().path());
    }

    public String getOwnerLoginId() {
        return this.pathSegments[0];
    }

    public String getProjectName() {
        return this.pathSegments[1];
    }

    public String getPathSegment(int index2) {
        return this.pathSegments[index2];
    }

    public String toString() {
        return DELIM + StringUtils.join((Object[])this.pathSegments, (String)DELIM);
    }

    public String restOfPathExceptOwnerAndProjectName() {
        if (this.pathSegments != null && this.pathSegments.length > 2) {
            return StringUtils.join((Object[])Arrays.copyOfRange(this.pathSegments, 2, this.pathSegments.length), (String)DELIM);
        }
        return "";
    }
}

