/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import actions.CodeAccessCheckAction;
import controllers.annotation.AnonymousCheck;
import controllers.annotation.IsAllowed;
import controllers.annotation.IsOnlyGitAvailable;
import controllers.routes;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import models.Project;
import models.enumeration.Operation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Result;
import play.mvc.With;
import play.twirl.api.Content;
import playRepository.GitBranch;
import playRepository.GitRepository;
import utils.HttpUtil;
import views.html.code.branches;

@IsOnlyGitAvailable
@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class BranchApp
extends Controller {
    @With(value={CodeAccessCheckAction.class})
    public static Result branches(String loginId, String projectName) throws IOException, GitAPIException {
        Project project2 = Project.findByOwnerAndProjectName(loginId, projectName);
        GitRepository gitRepository = new GitRepository(project2);
        List<GitBranch> allBranches = gitRepository.getBranches();
        final GitBranch headBranch = gitRepository.getHeadBranch();
        CollectionUtils.filter(allBranches, (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                GitBranch gitBranch = (GitBranch)o;
                return !gitBranch.getName().equals(headBranch.getName());
            }
        });
        return BranchApp.ok((Content)branches.render(project2, allBranches, headBranch));
    }

    @IsAllowed(value=Operation.DELETE)
    public static Result deleteBranch(String loginId, String projectName, String branchName) throws GitAPIException, UnsupportedEncodingException {
        Project project2 = Project.findByOwnerAndProjectName(loginId, projectName);
        Repository repository = GitRepository.buildGitRepository(project2);
        branchName = HttpUtil.decodePathSegment(branchName);
        GitRepository.deleteBranch(repository, branchName);
        return BranchApp.redirect((Call)routes.BranchApp.branches(loginId, projectName));
    }

    @IsAllowed(value=Operation.UPDATE)
    public static Result setAsDefault(String loginId, String projectName, String branchName) throws IOException, GitAPIException {
        Project project2 = Project.findByOwnerAndProjectName(loginId, projectName);
        GitRepository gitRepository = new GitRepository(project2);
        branchName = HttpUtil.decodePathSegment(branchName);
        gitRepository.setDefaultBranch(branchName);
        return HttpUtil.isRequestedWithXHR(BranchApp.request()) != false ? BranchApp.ok() : BranchApp.redirect((Call)routes.BranchApp.branches(loginId, projectName));
    }
}

