/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import actions.NullProjectCheckAction;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Page;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AbstractPostingApp;
import controllers.Application;
import controllers.LabelApp;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.annotation.IsAllowed;
import controllers.annotation.IsCreatable;
import controllers.routes;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import jxl.write.WriteException;
import models.AbstractPosting;
import models.Assignee;
import models.Comment;
import models.Issue;
import models.IssueComment;
import models.IssueEvent;
import models.IssueLabel;
import models.IssueLabelCategory;
import models.IssueMassUpdate;
import models.Milestone;
import models.NotificationEvent;
import models.Organization;
import models.Project;
import models.User;
import models.enumeration.Operation;
import models.enumeration.ProjectScope;
import models.enumeration.ResourceType;
import models.enumeration.State;
import models.support.SearchCondition;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.Tika;
import play.Configuration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.i18n.Messages;
import play.libs.Json;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.With;
import play.twirl.api.Content;
import play.twirl.api.Html;
import utils.AccessControl;
import utils.Config;
import utils.ErrorViews;
import utils.HttpUtil;
import utils.JodaDateUtil;
import utils.RouteUtil;
import views.html.issue.create;
import views.html.issue.edit;
import views.html.issue.list;
import views.html.issue.my_list;
import views.html.issue.my_partial_search;
import views.html.issue.partial_comments;
import views.html.issue.partial_list_wrap;
import views.html.issue.view;
import views.html.organization.group_issue_list;

@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class IssueApp
extends AbstractPostingApp {
    private static final String EXCEL_EXT = "xls";
    private static final Integer ITEMS_PER_PAGE_MAX = 45;

    @AnonymousCheck(requiresLogin=false, displaysFlashMessage=true)
    public static Result organizationIssues(@Nonnull String organizationName, @Nonnull String state, @Nonnull String format, int pageNum) throws WriteException, IOException {
        Form issueParamForm = new Form(SearchCondition.class);
        SearchCondition searchCondition = (SearchCondition)issueParamForm.bindFromRequest(new String[0]).get();
        int n = pageNum - 1;
        SearchCondition searchCondition2 = searchCondition;
        searchCondition2.setPageNum(n);
        Integer itemsPerPage = IssueApp.getItemsPerPage();
        Organization organization2 = Organization.findByName(organizationName);
        if (organization2 == null) {
            return IssueApp.notFound((Content)ErrorViews.NotFound.render("error.notfound.organization"));
        }
        ExpressionList<Issue> el = searchCondition.asExpressionList(organization2);
        searchCondition2 = searchCondition;
        n = 0;
        n = searchCondition2.getPageNum();
        Page issues2 = el.findPagingList(itemsPerPage.intValue()).getPage(n);
        return IssueApp.ok((Content)group_issue_list.render("title.issueList", (Page<Issue>)issues2, searchCondition, organization2));
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static Result userIssuesPage() throws WriteException, IOException {
        String pageNum = (String)StringUtils.defaultIfBlank((CharSequence)IssueApp.request().getQueryString("pageNum"), (CharSequence)"1");
        return IssueApp.userIssues("", "html", Integer.parseInt(pageNum));
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static Result userIssues(String state, String format, int pageNum) throws WriteException, IOException {
        Object object;
        Project project2 = null;
        Form issueParamForm = new Form(SearchCondition.class);
        SearchCondition searchCondition = (SearchCondition)issueParamForm.bindFromRequest(new String[0]).get();
        if (!searchCondition.hasCondition()) {
            object = UserApp.currentUser();
            Long l = null;
            l = ((User)object).getId();
            searchCondition.assigneeId = l;
        }
        int n = pageNum - 1;
        object = searchCondition;
        ((AbstractPostingApp.SearchCondition)object).setPageNum(n);
        String orderBy = IssueApp.request().getQueryString("orderBy");
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            String string = "updatedDate";
            object = searchCondition;
            ((AbstractPostingApp.SearchCondition)object).setOrderBy(string);
        }
        if (HttpUtil.isRequestedWithXHR(IssueApp.request()).booleanValue()) {
            format = HttpUtil.isPJAXRequest(IssueApp.request()) != false ? "pjax" : "json";
        }
        Integer itemsPerPage = IssueApp.getItemsPerPage();
        ExpressionList<Issue> el = searchCondition.asExpressionList();
        object = searchCondition;
        int n2 = 0;
        n2 = ((AbstractPostingApp.SearchCondition)object).getPageNum();
        Page issues2 = el.findPagingList(itemsPerPage.intValue()).getPage(n2);
        switch (format) {
            case "pjax": {
                return IssueApp.issuesAsPjax(project2, (Page<Issue>)issues2, searchCondition);
            }
            case "json": {
                return IssueApp.issuesAsJson(project2, (Page<Issue>)issues2);
            }
        }
        return IssueApp.issuesAsHTML(project2, (Page<Issue>)issues2, searchCondition);
    }

    @Transactional
    @IsAllowed(value=Operation.READ)
    public static Result issues(String ownerName, String projectName) throws WriteException, IOException {
        return IssueApp.issues(ownerName, projectName, State.OPEN.state(), "html", 1);
    }

    @IsAllowed(value=Operation.READ)
    public static List<Issue> findDraftIssues(String ownerName, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Model model = UserApp.currentUser();
        Object object = null;
        object = model.getLoginId();
        ExpressionList expressionList = Issue.finder.where().eq("authorLoginId", object);
        model = project2;
        object = null;
        object = model.getId();
        return expressionList.eq("project.id", object).eq("isDraft", (Object)true).orderBy("number desc").findList();
    }

    @Transactional
    @IsAllowed(value=Operation.READ)
    public static Result issues(String ownerName, String projectName, String state, String format, int pageNum) throws WriteException, IOException {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Form issueParamForm = new Form(SearchCondition.class);
        SearchCondition searchCondition = (SearchCondition)issueParamForm.bindFromRequest(new String[0]).get();
        int n = pageNum - 1;
        SearchCondition searchCondition2 = searchCondition;
        searchCondition2.setPageNum(n);
        searchCondition2 = searchCondition;
        Set<Long> set = null;
        set = searchCondition2.getLabelIds();
        set.addAll(LabelApp.getLabelIds(IssueApp.request()));
        searchCondition2 = searchCondition;
        set = null;
        set = searchCondition2.getLabelIds();
        set.remove(null);
        if (HttpUtil.isRequestedWithXHR(IssueApp.request()).booleanValue()) {
            format = HttpUtil.isPJAXRequest(IssueApp.request()) != false ? "pjax" : "json";
        }
        Integer itemsPerPage = IssueApp.getItemsPerPage();
        ExpressionList<Issue> el = searchCondition.asExpressionList(project2);
        searchCondition2 = searchCondition;
        int n2 = 0;
        n2 = searchCondition2.getPageNum();
        Page issues2 = el.findPagingList(itemsPerPage.intValue()).getPage(n2);
        switch (format) {
            case "xls": {
                return IssueApp.issuesAsExcel(project2, el);
            }
            case "pjax": {
                return IssueApp.issuesAsPjax(project2, (Page<Issue>)issues2, searchCondition);
            }
            case "json": {
                return IssueApp.issuesAsJson(project2, (Page<Issue>)issues2);
            }
        }
        return IssueApp.issuesAsHTML(project2, (Page<Issue>)issues2, searchCondition);
    }

    private static Integer getItemsPerPage() {
        Integer itemsPerPage = 15;
        String amountStr = IssueApp.request().getQueryString("itemsPerPage");
        if (amountStr != null) {
            try {
                itemsPerPage = Integer.parseInt(amountStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Math.min(itemsPerPage, ITEMS_PER_PAGE_MAX);
    }

    private static Result issuesAsHTML(Project project2, Page<Issue> issues2, SearchCondition searchCondition) {
        if (project2 == null) {
            return IssueApp.ok((Content)my_list.render("menu.issue", issues2, searchCondition, project2));
        }
        UserApp.currentUser().visits(project2);
        return IssueApp.ok((Content)list.render("menu.issue", issues2, searchCondition, project2));
    }

    private static Result issuesAsExcel(Project project2, ExpressionList<Issue> el) throws WriteException, IOException {
        byte[] excelData = Issue.excelFrom(el.findList());
        Project project3 = project2;
        String string = null;
        string = project3.getName();
        String filename = HttpUtil.encodeContentDisposition(string + "_issues_" + JodaDateUtil.getDateStringWithoutSpace(new Date()) + "." + EXCEL_EXT);
        IssueApp.response().setHeader("Content-Type", new Tika().detect(filename));
        IssueApp.response().setHeader("Content-Disposition", "attachment; " + filename);
        return IssueApp.ok((byte[])excelData);
    }

    private static Result issuesAsPjax(Project project2, Page<Issue> issues2, SearchCondition searchCondition) {
        IssueApp.response().setHeader("Cache-Control", "no-cache, no-store");
        if (project2 == null) {
            return IssueApp.ok((Content)my_partial_search.render("title.issueList", issues2, searchCondition, project2));
        }
        return IssueApp.ok((Content)partial_list_wrap.render("title.issueList", issues2, searchCondition, project2));
    }

    private static Result issuesAsJson(Project project2, Page<Issue> issues2) {
        ObjectNode listData = Json.newObject();
        String exceptIdStr = IssueApp.request().getQueryString("exceptId");
        Long exceptId = -1L;
        if (!StringUtils.isEmpty((CharSequence)exceptIdStr)) {
            try {
                exceptId = Long.parseLong(exceptIdStr);
            }
            catch (Exception e) {
                return IssueApp.badRequest((JsonNode)listData);
            }
        }
        List issueList2 = issues2.getList();
        for (Issue issue2 : issueList2) {
            Long issueId = issue2.getNumber();
            if (issueId.equals(exceptId)) continue;
            ObjectNode result2 = Json.newObject();
            result2.put("id", issueId);
            Model model = issue2;
            Object object = null;
            object = model.getTitle();
            result2.put("title", (String)object);
            model = issue2;
            object = null;
            object = model.getState();
            result2.put("state", ((Enum)object).toString());
            model = issue2;
            object = null;
            object = model.getCreatedDate();
            result2.put("createdDate", ((Date)object).toString());
            if (project2 != null) {
                model = project2;
                object = null;
                Object object2 = object = model.getOwner();
                model = project2;
                object = null;
                object = model.getName();
                result2.put("link", routes.IssueApp.issue((String)object2, (String)object, issueId).toString());
            }
            model = issue2;
            object = null;
            object = model.getId();
            listData.put(((Long)object).toString(), (JsonNode)result2);
        }
        return IssueApp.ok((JsonNode)listData);
    }

    @Transactional
    @With(value={NullProjectCheckAction.class})
    public static Result issue(String ownerName, String projectName, Long number) {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Issue issueInfo = Issue.findByNumber(project2, number);
        IssueApp.response().setHeader("Vary", "Accept");
        if (issueInfo == null) {
            if (HttpUtil.isJSONPreferred(IssueApp.request()).booleanValue()) {
                ObjectNode result2 = Json.newObject();
                result2.put("title", number);
                result2.put("body", Messages.get((String)"error.notfound.issue_post", (Object[])new Object[0]));
                return IssueApp.ok((JsonNode)result2);
            }
            return IssueApp.notFound((Content)ErrorViews.NotFound.render("error.notfound", project2, ResourceType.ISSUE_POST.resource()));
        }
        Model model = issueInfo;
        Object object = null;
        object = model.getIsDraft();
        if (((Boolean)object).booleanValue()) {
            model = issueInfo;
            object = null;
            Object object2 = object = model.getAuthorLoginId();
            model = UserApp.currentUser();
            object = null;
            object = model.getLoginId();
            if (!((String)object2).equals(object)) {
                return IssueApp.forbidden((Content)ErrorViews.NotFound.render("error.notfound", project2));
            }
        }
        if (!AccessControl.isAllowed(UserApp.currentUser(), issueInfo.asResource(), Operation.READ)) {
            return IssueApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2));
        }
        for (IssueLabel label : issueInfo.labels) {
            label.refresh();
        }
        Form commentForm2 = new Form(Comment.class);
        Form editForm = new Form(Issue.class).fill((Object)Issue.findByNumber(project2, number));
        UserApp.currentUser().visits(project2);
        UserApp.currentUser().visits(issueInfo);
        if (HttpUtil.isJSONPreferred(IssueApp.request()).booleanValue()) {
            ObjectNode result3 = Json.newObject();
            result3.put("id", issueInfo.getNumber());
            model = issueInfo;
            object = null;
            object = model.getTitle();
            result3.put("title", (String)object);
            model = issueInfo;
            object = null;
            object = model.getState();
            result3.put("state", ((Enum)object).toString());
            model = issueInfo;
            object = null;
            object = model.getBody();
            result3.put("body", StringUtils.abbreviate((String)object, (int)200));
            model = issueInfo;
            object = null;
            object = model.getCreatedDate();
            result3.put("createdDate", ((Date)object).toString());
            model = project2;
            object = null;
            Object object3 = object = model.getOwner();
            model = project2;
            object = null;
            object = model.getName();
            result3.put("link", routes.IssueApp.issue((String)object3, (String)object, issueInfo.getNumber()).toString());
            return IssueApp.ok((JsonNode)result3);
        }
        return IssueApp.ok((Content)view.render("title.issueDetail", issueInfo, (Form<Issue>)editForm, (Form<Comment>)commentForm2, project2));
    }

    @IsAllowed(resourceType=ResourceType.ISSUE_POST, value=Operation.READ)
    public static Result timeline(String ownerName, String projectName, Long number) {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Issue issueInfo = Issue.findByNumber(project2, number);
        for (IssueLabel label : issueInfo.labels) {
            label.refresh();
        }
        return IssueApp.ok((Content)partial_comments.render(project2, issueInfo));
    }

    public static Result newDirectIssueForm(Long commentId) {
        User current = UserApp.currentUser();
        Project project2 = null;
        List<Project> visitedProjects = current.getVisitedProjects();
        if (project2 == null && !CollectionUtils.isEmpty(visitedProjects)) {
            project2 = visitedProjects.get(0);
        }
        if (project2 != null) {
            if (commentId != -1L) {
                Project project3 = project2;
                String string = null;
                String string2 = string = project3.getOwner();
                project3 = project2;
                string = null;
                string = project3.getName();
                return IssueApp.newIssueFormByComment(string2, string, commentId);
            }
            Project project4 = project2;
            String string = null;
            String string3 = string = project4.getOwner();
            project4 = project2;
            string = null;
            string = project4.getName();
            return IssueApp.newIssueForm(string3, string);
        }
        IssueApp.flash((String)"warning", (String)Messages.get((String)"project.is.empty", (Object[])new Object[0]));
        return Application.index();
    }

    public static Result newDirectMyIssueForm() {
        List<Project> projects2;
        User current = UserApp.currentUser();
        Model model = current;
        String string = null;
        string = model.getLoginId();
        Project project2 = Project.findByOwnerAndProjectName(string, "inbox");
        if (project2 == null) {
            model = current;
            string = null;
            string = model.getLoginId();
            project2 = Project.findByOwnerAndProjectName(string, "_private");
        }
        if (project2 == null) {
            model = current;
            string = null;
            string = model.getLoginId();
            projects2 = Project.findProjectsCreatedByUserAndScope(string, ProjectScope.PRIVATE, "createdDate desc");
            if (!CollectionUtils.isEmpty(projects2)) {
                project2 = projects2.get(0);
            }
        }
        if (project2 == null) {
            model = current;
            string = null;
            string = model.getLoginId();
            projects2 = Project.findProjectsCreatedByUserAndScope(string, ProjectScope.PUBLIC, "createdDate desc");
            if (!CollectionUtils.isEmpty(projects2)) {
                project2 = projects2.get(0);
            }
        }
        if (project2 != null) {
            model = project2;
            string = null;
            String string2 = string = model.getOwner();
            model = project2;
            string = null;
            string = model.getName();
            return IssueApp.newIssueForm(string2, string);
        }
        IssueApp.flash((String)"warning", (String)Messages.get((String)"project.is.empty", (Object[])new Object[0]));
        return Application.index();
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsCreatable(value=ResourceType.ISSUE_POST)
    public static Result newIssueForm(String ownerName, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        String issueTemplate = (String)StringUtils.defaultIfBlank((CharSequence)project2.getIssueTemplate(), (CharSequence)"");
        return IssueApp.ok((Content)create.render("title.newIssue", (Form<Issue>)new Form(Issue.class), project2, issueTemplate));
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsCreatable(value=ResourceType.ISSUE_POST)
    public static Result newIssueFormByComment(String ownerName, String projectName, Long commentId) {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Comment comment = (Comment)IssueComment.find.byId((Object)commentId);
        String context = Configuration.root().getString("application.context");
        String contextPath = context == null ? "" : context;
        Comment comment2 = comment;
        String string = null;
        string = comment2.getContents();
        StringBuilder stringBuilder = new StringBuilder().append(string).append("\n\n_Originally posted by @");
        comment2 = comment;
        string = null;
        string = comment2.getAuthorLoginId();
        String reference = stringBuilder.append(string).append(" in ").append(Config.getScheme()).append("://").append(IssueApp.request().host()).append(contextPath).append(RouteUtil.getUrl(comment)).toString();
        String conetent = (String)StringUtils.defaultIfBlank((CharSequence)reference, (CharSequence)"");
        return IssueApp.ok((Content)create.render("title.newIssue", (Form<Issue>)new Form(Issue.class), project2, conetent));
    }

    @Transactional
    @With(value={NullProjectCheckAction.class})
    public static Result massUpdate(String ownerName, String projectName) {
        Form issueMassUpdateForm = new Form(IssueMassUpdate.class).bindFromRequest(new String[0]);
        if (issueMassUpdateForm.hasErrors()) {
            return IssueApp.badRequest((JsonNode)issueMassUpdateForm.errorsAsJson());
        }
        IssueMassUpdate issueMassUpdate = (IssueMassUpdate)issueMassUpdateForm.get();
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        int updatedItems = 0;
        int rejectedByPermission = 0;
        Object object = issueMassUpdate;
        Object object2 = null;
        object2 = ((IssueMassUpdate)object).getIssues();
        Iterator<Issue> iterator = object2.iterator();
        while (iterator.hasNext()) {
            Issue issue2 = iterator.next();
            issue2.refresh();
            object = issue2;
            object2 = null;
            object2 = ((Issue)object).getIsDraft();
            if (((Boolean)object2).booleanValue()) continue;
            object = issueMassUpdate;
            boolean bl = false;
            bl = ((IssueMassUpdate)object).getDelete();
            if (bl) {
                if (AccessControl.isAllowed(UserApp.currentUser(), issue2.asResource(), Operation.DELETE)) {
                    issue2.delete();
                    continue;
                }
                ++rejectedByPermission;
                continue;
            }
            if (!AccessControl.isAllowed(UserApp.currentUser(), issue2.asResource(), Operation.UPDATE)) {
                ++rejectedByPermission;
                continue;
            }
            object = issueMassUpdate;
            Object object3 = null;
            object3 = ((IssueMassUpdate)object).getAssignee();
            IssueApp.updateAssigneeIfChanged(object3, project2, issue2);
            object = issueMassUpdate;
            object3 = null;
            object3 = ((IssueMassUpdate)object).getState();
            IssueApp.updateStateIfChanged((State)((Object)object3), issue2);
            object = issueMassUpdate;
            object3 = null;
            object3 = ((IssueMassUpdate)object).getMilestone();
            IssueApp.updateMilestoneIfChanged((Milestone)object3, issue2);
            object = issueMassUpdate;
            object3 = null;
            Object object4 = object3 = ((IssueMassUpdate)object).getAttachingLabelIds();
            object = issueMassUpdate;
            object3 = null;
            object3 = ((IssueMassUpdate)object).getDetachingLabelIds();
            IssueApp.updateLabelIfChanged((List<Long>)object4, (List<Long>)object3, issue2);
            object = issueMassUpdate;
            boolean bl2 = false;
            bl2 = ((IssueMassUpdate)object).getIsDueDateChanged();
            if (bl2) {
                object = issueMassUpdate;
                Date date = null;
                date = ((IssueMassUpdate)object).getDueDate();
                date = JodaDateUtil.lastSecondOfDay(date);
                object = issue2;
                ((Issue)object).setDueDate(date);
            }
            Date date = JodaDateUtil.now();
            object = issue2;
            ((AbstractPosting)object).setUpdatedDate(date);
            issue2.update();
            ++updatedItems;
        }
        if (updatedItems == 0 && rejectedByPermission > 0) {
            return IssueApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2));
        }
        if (HttpUtil.isJSONPreferred(IssueApp.request()).booleanValue()) {
            object = issueMassUpdate;
            boolean bl = false;
            bl = ((IssueMassUpdate)object).getIsDueDateChanged();
            if (bl) {
                object = issueMassUpdate;
                List<Issue> list2 = null;
                list2 = ((IssueMassUpdate)object).getIssues();
                Issue issue3 = list2.get(0);
                ObjectNode result2 = Json.newObject();
                result2.put("isOverDue", issue3.isOverDueDate());
                result2.put("dueDateMsg", issue3.isOverDueDate() != false ? Messages.get((String)"issue.dueDate.overdue", (Object[])new Object[0]) : issue3.until());
                return IssueApp.ok((JsonNode)result2);
            }
            return IssueApp.ok((String)"{}");
        }
        return IssueApp.redirect((String)IssueApp.request().getHeader("Referer"));
    }

    private static void updateLabelIfChanged(List<Long> attachingLabelIds, List<Long> detachingLabelIds, Issue issue2) {
        Object object;
        Object object2;
        IssueLabel label;
        boolean isLabelChanged = false;
        StringBuilder addedLabels = new StringBuilder();
        StringBuilder deletedLabels = new StringBuilder();
        if (attachingLabelIds != null) {
            for (Long labelId : attachingLabelIds) {
                label = (IssueLabel)IssueLabel.finder.byId((Object)labelId);
                issue2.labels.add(label);
                isLabelChanged = true;
                object2 = label;
                object = null;
                object2 = object = ((IssueLabel)object2).getCategory();
                object = null;
                object = ((IssueLabelCategory)object2).getName();
                StringBuilder stringBuilder = addedLabels.append((String)object).append(" - ");
                object2 = label;
                object = null;
                object = ((IssueLabel)object2).getName();
                StringBuilder stringBuilder2 = stringBuilder.append((String)object).append(" ");
                object2 = label;
                object = null;
                object = ((IssueLabel)object2).getColor();
                stringBuilder2.append((String)object);
            }
        }
        if (detachingLabelIds != null) {
            for (Long labelId : detachingLabelIds) {
                label = (IssueLabel)IssueLabel.finder.byId((Object)labelId);
                issue2.labels.remove(label);
                isLabelChanged = true;
                object2 = label;
                object = null;
                object2 = object = ((IssueLabel)object2).getCategory();
                object = null;
                object = ((IssueLabelCategory)object2).getName();
                StringBuilder stringBuilder = deletedLabels.append((String)object).append(" - ");
                object2 = label;
                object = null;
                object = ((IssueLabel)object2).getName();
                StringBuilder stringBuilder3 = stringBuilder.append((String)object).append(" ");
                object2 = label;
                object = null;
                object = ((IssueLabel)object2).getColor();
                stringBuilder3.append((String)object);
            }
        }
        if (isLabelChanged) {
            NotificationEvent notiEvent = NotificationEvent.afterIssueLabelChanged(addedLabels.toString(), deletedLabels.toString(), issue2);
            object2 = UserApp.currentUser();
            object = null;
            object = ((User)object2).getLoginId();
            IssueEvent.addFromNotificationEventWithoutSkipEvent(notiEvent, issue2, (String)object);
        }
    }

    private static void updateMilestoneIfChanged(Milestone newMilestone2, Issue issue2) {
        Long oldMilestoneId = issue2.milestoneId();
        Model model = issue2;
        Object object = null;
        object = model.getMilestone();
        if (!IssueApp.isMilestoneChanged(newMilestone2, (Milestone)object)) {
            return;
        }
        if (newMilestone2.isNullMilestone()) {
            object = null;
            model = issue2;
            model.setMilestone((Milestone)object);
        } else {
            object = newMilestone2;
            model = issue2;
            model.setMilestone((Milestone)object);
        }
        NotificationEvent notiEvent = NotificationEvent.afterMilestoneChanged(oldMilestoneId, issue2);
        model = UserApp.currentUser();
        object = null;
        object = model.getLoginId();
        IssueEvent.addFromNotificationEvent(notiEvent, issue2, (String)object);
    }

    private static boolean isMilestoneChanged(Milestone newMilestone2, Milestone oldMilestone) {
        if (newMilestone2 == null) {
            return false;
        }
        if (oldMilestone != null) {
            Milestone milestone2 = oldMilestone;
            Long l = null;
            Long l2 = l = milestone2.getId();
            milestone2 = newMilestone2;
            l = null;
            l = milestone2.getId();
            if (l2.equals(l)) {
                return false;
            }
        }
        return true;
    }

    private static void updateStateIfChanged(State newState, Issue issue2) {
        Object object;
        Model model;
        boolean stateChanged = false;
        Object oldState = null;
        if (newState != null) {
            model = issue2;
            object = null;
            object = model.getState();
            if (object != newState) {
                stateChanged = true;
                model = issue2;
                object = null;
                oldState = object = model.getState();
                object = newState;
                model = issue2;
                model.setState((State)((Object)object));
            }
        }
        model = issue2;
        object = null;
        object = model.getIsDraft();
        if (!((Boolean)object).booleanValue() && stateChanged) {
            NotificationEvent notiEvent = NotificationEvent.afterStateChanged(oldState, issue2);
            model = UserApp.currentUser();
            object = null;
            object = model.getLoginId();
            IssueEvent.addFromNotificationEvent(notiEvent, issue2, (String)object);
        }
    }

    private static void updateAssigneeIfChanged(User assignee, Project project2, Issue issue2) {
        Object object;
        Model model;
        boolean assigneeChanged = false;
        Object oldAssignee = null;
        if (assignee != null) {
            Assignee newAssignee;
            if (IssueApp.hasAssignee(issue2)) {
                model = issue2;
                object = null;
                object = model.getAssignee();
                model = object;
                object = null;
                oldAssignee = object = model.getUser();
            }
            if (assignee.isAnonymous()) {
                newAssignee = null;
            } else {
                model = assignee;
                object = null;
                Object object2 = object = model.getId();
                model = project2;
                object = null;
                object = model.getId();
                newAssignee = Assignee.add((Long)object2, (Long)object);
            }
            assigneeChanged = !issue2.assignedUserEquals(newAssignee);
            object = newAssignee;
            model = issue2;
            model.setAssignee((Assignee)((Object)object));
        }
        if (assigneeChanged) {
            NotificationEvent notiEvent = NotificationEvent.afterAssigneeChanged(oldAssignee, issue2);
            model = UserApp.currentUser();
            object = null;
            object = model.getLoginId();
            IssueEvent.addFromNotificationEvent(notiEvent, issue2, (String)object);
        }
    }

    @Transactional
    @IsCreatable(value=ResourceType.ISSUE_POST)
    public static Result newIssue(String ownerName, String projectName) {
        User assigneeUser;
        Object object;
        Object object2;
        Form issueForm = new Form(Issue.class).bindFromRequest(new String[0]);
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        if (issueForm.hasErrors()) {
            String issueTemplate = (String)StringUtils.defaultIfBlank((CharSequence)project2.getIssueTemplate(), (CharSequence)"");
            return IssueApp.badRequest((Content)create.render("error.validation", (Form<Issue>)issueForm, project2, issueTemplate));
        }
        Issue newIssue2 = (Issue)issueForm.get();
        if (IssueApp.hasTargetProject(newIssue2)) {
            object2 = newIssue2;
            object = null;
            object = ((Issue)object2).getTargetProjectId();
            Project toAnotherProject = (Project)Project.find.byId((Object)Long.valueOf((String)object));
            if (toAnotherProject == null) {
                IssueApp.flash((String)"warning", (String)Messages.get((String)"error.notfound.project", (Object[])new Object[0]));
                return IssueApp.badRequest((Content)create.render("title.newIssue", (Form<Issue>)new Form(Issue.class), project2, null));
            }
            if (!AccessControl.isProjectResourceCreatable(UserApp.currentUser(), toAnotherProject, ResourceType.ISSUE_POST)) {
                return IssueApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", toAnotherProject));
            }
            project2 = toAnotherProject;
        }
        object2 = newIssue2;
        object = null;
        object = ((AbstractPosting)object2).getBody();
        if (object == null) {
            return IssueApp.status((int)413, (Content)ErrorViews.RequestTextEntityTooLarge.render());
        }
        object2 = newIssue2;
        object = null;
        object = ((Issue)object2).getParentIssueId();
        if (StringUtils.isNotEmpty((CharSequence)object)) {
            object2 = newIssue2;
            object = null;
            object = ((Issue)object2).getParentIssueId();
            object = (Issue)Issue.finder.byId((Object)Long.valueOf((String)object));
            object2 = newIssue2;
            ((Issue)object2).setParent((Issue)object);
        }
        object = JodaDateUtil.now();
        object2 = newIssue2;
        ((AbstractPosting)object2).setCreatedDate((Date)object);
        object = JodaDateUtil.now();
        object2 = newIssue2;
        ((AbstractPosting)object2).setUpdatedDate((Date)object);
        newIssue2.setAuthor(UserApp.currentUser());
        object = project2;
        object2 = newIssue2;
        ((AbstractPosting)object2).setProject((Project)object);
        String assineeLoginId = null;
        String[] assigneeLoginIds = (String[])IssueApp.request().body().asMultipartFormData().asFormUrlEncoded().get("assigneeLoginId");
        if (assigneeLoginIds != null && assigneeLoginIds.length > 0) {
            assineeLoginId = assigneeLoginIds[0];
        }
        if (!(assigneeUser = User.findByLoginId(assineeLoginId)).isAnonymous()) {
            object2 = assigneeUser;
            object = null;
            Object object3 = object = ((User)object2).getId();
            object2 = project2;
            object = null;
            object = ((Project)object2).getId();
            object = new Assignee((Long)object3, (Long)object);
            object2 = newIssue2;
            ((Issue)object2).setAssignee((Assignee)((Object)object));
        } else {
            object = null;
            object2 = newIssue2;
            ((Issue)object2).setAssignee((Assignee)((Object)object));
        }
        object2 = newIssue2;
        object = null;
        object = ((Issue)object2).getIsDraft();
        if (((Boolean)object).booleanValue()) {
            object = State.DRAFT;
            object2 = newIssue2;
            ((Issue)object2).setState((State)((Object)object));
        } else {
            object = State.OPEN;
            object2 = newIssue2;
            ((Issue)object2).setState((State)((Object)object));
        }
        object2 = newIssue2;
        object = null;
        object2 = object = ((AbstractPosting)object2).getProject();
        object = null;
        Object object4 = object = ((Project)object2).getId();
        object2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        object = null;
        object = ((Project)object2).getId();
        if (((Long)object4).equals(object)) {
            IssueApp.addLabels(newIssue2, IssueApp.request());
        }
        IssueApp.setMilestone((Form<Issue>)issueForm, newIssue2);
        object2 = newIssue2;
        object = null;
        object = ((Issue)object2).getDueDate();
        object = JodaDateUtil.lastSecondOfDay((Date)object);
        object2 = newIssue2;
        ((Issue)object2).setDueDate((Date)object);
        newIssue2.save();
        IssueApp.attachUploadFilesToPost(newIssue2.asResource());
        object2 = newIssue2;
        object = null;
        object = ((Issue)object2).getIsDraft();
        if (!((Boolean)object).booleanValue()) {
            NotificationEvent.afterNewIssue(newIssue2);
        }
        object2 = newIssue2;
        object = null;
        object = ((Issue)object2).getReferCommentId();
        if (StringUtils.isNotEmpty((CharSequence)object)) {
            object2 = newIssue2;
            object = null;
            object = ((Issue)object2).getIsDraft();
            if (!((Boolean)object).booleanValue()) {
                String context = Configuration.root().getString("application.context");
                String contextPath = context == null ? "" : context;
                String content = Messages.get((String)"issue.derived", (Object[])new Object[0]) + ": " + Config.getScheme() + "://" + IssueApp.request().host() + contextPath + RouteUtil.getUrl(newIssue2);
                object2 = newIssue2;
                object = null;
                object = ((Issue)object2).getReferCommentId();
                IssueComment parent = (IssueComment)IssueComment.find.byId((Object)Long.parseLong((String)object));
                object2 = parent;
                object = null;
                object = ((IssueComment)object2).getIssue();
                IssueComment referComment = new IssueComment((Issue)object, UserApp.currentUser(), content);
                object2 = newIssue2;
                object = null;
                object = ((Issue)object2).getReferCommentId();
                object2 = referComment;
                ((Comment)object2).setParentCommentId((String)object);
                IssueApp.newReferComment(referComment);
            }
        }
        object2 = project2;
        object = null;
        Object object5 = object = ((Project)object2).getOwner();
        object2 = project2;
        object = null;
        object = ((Project)object2).getName();
        return IssueApp.redirect((Call)routes.IssueApp.issue((String)object5, (String)object, newIssue2.getNumber()));
    }

    private static void removeAnonymousAssignee(Issue issue2) {
        if (IssueApp.hasAssignee(issue2) && IssueApp.isAnonymousAssignee(issue2)) {
            Assignee assignee = null;
            Issue issue3 = issue2;
            issue3.setAssignee(assignee);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAnonymousAssignee(Issue issue2) {
        Model model = issue2;
        Model model2 = null;
        model = model2 = model.getAssignee();
        model2 = null;
        model2 = model.getUser();
        if (model2 == null) return false;
        model = issue2;
        model2 = null;
        model = model2 = model.getAssignee();
        model2 = null;
        model2 = model.getUser();
        if (!model2.isAnonymous()) return false;
        return true;
    }

    private static boolean hasAssignee(Issue issue2) {
        Issue issue3 = issue2;
        Assignee assignee = null;
        assignee = issue3.getAssignee();
        return assignee != null;
    }

    @With(value={NullProjectCheckAction.class})
    public static Result editIssueForm(String ownerName, String projectName, Long number) {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        if (issue2 == null) {
            return IssueApp.notFound((Content)ErrorViews.Forbidden.render("error.notfound", project2));
        }
        if (!AccessControl.isAllowed(UserApp.currentUser(), issue2.asResource(), Operation.READ)) {
            return IssueApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2));
        }
        Form editForm = new Form(Issue.class).fill((Object)issue2);
        return IssueApp.ok((Content)edit.render("title.editIssue", (Form<Issue>)editForm, issue2, project2));
    }

    @Transactional
    @IsAllowed(value=Operation.UPDATE, resourceType=ResourceType.ISSUE_POST)
    public static Result nextState(String ownerName, String projectName, Long number) {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        Object object = project2;
        Object object2 = null;
        object2 = ((Project)object).getOwner();
        String string = object2;
        object = project2;
        object2 = null;
        object2 = ((Project)object).getName();
        play.api.mvc.Call redirectTo = routes.IssueApp.issue(string, (String)object2, number);
        State state = issue2.toNextState();
        if (state == State.OPEN && issue2.hasParentIssue()) {
            object = issue2;
            object2 = null;
            object = object2 = ((Issue)object).getParent();
            object2 = null;
            object2 = ((Issue)object).getState();
            if (object2 == State.CLOSED) {
                object = issue2;
                object2 = null;
                object2 = ((Issue)object).getParent();
                ((Issue)object2).toNextState();
            }
        }
        NotificationEvent notiEvent = NotificationEvent.afterStateChanged(issue2.previousState(), issue2);
        object = UserApp.currentUser();
        object2 = null;
        object2 = ((User)object).getLoginId();
        IssueEvent.addFromNotificationEvent(notiEvent, issue2, (String)object2);
        return IssueApp.redirect((Call)redirectTo);
    }

    private static void addAssigneeChangedNotification(Issue modifiedIssue, Issue originalIssue) {
        Model model = modifiedIssue;
        Object object = null;
        object = model.getAssignee();
        if (!originalIssue.assignedUserEquals((Assignee)((Object)object))) {
            Object oldAssignee = null;
            if (IssueApp.hasAssignee(originalIssue)) {
                model = originalIssue;
                object = null;
                object = model.getAssignee();
                model = object;
                object = null;
                oldAssignee = object = model.getUser();
            }
            NotificationEvent notiEvent = NotificationEvent.afterAssigneeChanged(oldAssignee, modifiedIssue);
            model = UserApp.currentUser();
            object = null;
            object = model.getLoginId();
            IssueEvent.addFromNotificationEvent(notiEvent, modifiedIssue, (String)object);
        }
    }

    private static void addStateChangedNotification(Issue modifiedIssue, Issue originalIssue) {
        Model model = modifiedIssue;
        Object object = null;
        State state = object = model.getState();
        model = originalIssue;
        object = null;
        object = model.getState();
        if (state != object) {
            model = originalIssue;
            object = null;
            object = model.getState();
            NotificationEvent notiEvent = NotificationEvent.afterStateChanged(object, modifiedIssue);
            model = UserApp.currentUser();
            object = null;
            object = model.getLoginId();
            IssueEvent.addFromNotificationEvent(notiEvent, modifiedIssue, (String)object);
        }
    }

    private static void addBodyChangedNotification(Issue modifiedIssue, Issue originalIssue) {
        Model model = modifiedIssue;
        String string = null;
        String string2 = string = model.getBody();
        model = originalIssue;
        string = null;
        string = model.getBody();
        if (!string2.equals(string)) {
            model = originalIssue;
            string = null;
            string = model.getBody();
            NotificationEvent notiEvent = NotificationEvent.afterIssueBodyChanged(string, modifiedIssue);
            model = UserApp.currentUser();
            string = null;
            string = model.getLoginId();
            IssueEvent.addFromNotificationEvent(notiEvent, modifiedIssue, string);
        }
    }

    private static void addIssueMovedNotification(Project previous, Issue originalIssue, Issue issue2, Set<User> fromWatchers) {
        NotificationEvent notiEvent;
        Model model = originalIssue;
        Object object = null;
        object = model.getProject();
        if (IssueApp.isRequestedToOtherProject(previous, (Project)object)) {
            notiEvent = NotificationEvent.afterIssueMoved(previous, originalIssue, () -> fromWatchers);
            model = UserApp.currentUser();
            object = null;
            object = model.getLoginId();
            IssueEvent.addFromNotificationEvent(notiEvent, originalIssue, object);
            model = notiEvent;
            object = null;
            object = model.getReceivers();
            Logger.debug((String)("addIssueMovedNotification - afterIssueMoved receivers: " + object));
        }
        notiEvent = NotificationEvent.afterNewIssue(issue2);
        model = notiEvent;
        object = null;
        object = model.getReceivers();
        Logger.debug((String)("addIssueMovedNotification - afterNewIssue receivers: " + object));
    }

    @With(value={NullProjectCheckAction.class})
    public static Result editIssue(final String ownerName, final String projectName, Long number) {
        Object object;
        Object object2;
        Form issueForm = new Form(Issue.class).bindFromRequest(new String[0]);
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        if (issueForm.hasErrors()) {
            IssueApp.flash((String)"warning", (String)issueForm.error("name").message());
            return IssueApp.badRequest((Content)edit.render("error.validation", (Form<Issue>)issueForm, Issue.findByNumber(project2, number), project2));
        }
        final Issue issue2 = (Issue)issueForm.get();
        String assineeLoginId = ((String[])IssueApp.request().body().asMultipartFormData().asFormUrlEncoded().get("assigneeLoginId"))[0];
        User assigneeUser = User.findByLoginId(assineeLoginId);
        if (!assigneeUser.isAnonymous()) {
            object2 = assigneeUser;
            object = null;
            Long l = object = ((User)object2).getId();
            object2 = project2;
            object = null;
            object = ((Project)object2).getId();
            object = new Assignee(l, (Long)object);
            object2 = issue2;
            ((Issue)object2).setAssignee((Assignee)((Object)object));
        } else {
            object = null;
            object2 = issue2;
            ((Issue)object2).setAssignee((Assignee)((Object)object));
        }
        IssueApp.setMilestone((Form<Issue>)issueForm, issue2);
        object2 = issue2;
        object = null;
        object = ((Issue)object2).getDueDate();
        object = JodaDateUtil.lastSecondOfDay((Date)object);
        object2 = issue2;
        ((Issue)object2).setDueDate((Date)object);
        final Issue originalIssue = Issue.findByNumber(project2, number);
        final Set<User> fromWatchers = originalIssue.getWatchers();
        if (IssueApp.hasTargetProject(issue2)) {
            object2 = issue2;
            object = null;
            object = ((Issue)object2).getTargetProjectId();
            Project toOtherProject = (Project)Project.find.byId((Object)Long.valueOf((String)object));
            if (toOtherProject == null) {
                IssueApp.flash((String)"warning", (String)Messages.get((String)"error.notfound.project", (Object[])new Object[0]));
                return IssueApp.badRequest((Content)edit.render("error.validation", (Form<Issue>)issueForm, Issue.findByNumber(project2, number), project2));
            }
            if (!AccessControl.isProjectResourceCreatable(UserApp.currentUser(), toOtherProject, ResourceType.ISSUE_POST)) {
                return IssueApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", toOtherProject));
            }
            if (IssueApp.isRequestedToOtherProject(project2, toOtherProject)) {
                IssueApp.moveIssueToOtherProject(originalIssue, toOtherProject);
                object = null;
                object2 = issue2;
                ((Issue)object2).setMilestone((Milestone)object);
            } else {
                IssueApp.updateSubtaskRelation(issue2, originalIssue);
            }
        }
        object2 = issue2;
        object = null;
        object = ((AbstractPosting)object2).getIsPublish();
        if (((Boolean)object).booleanValue()) {
            object = JodaDateUtil.now();
            object2 = originalIssue;
            ((AbstractPosting)object2).setCreatedDate((Date)object);
            object2 = originalIssue;
            object = null;
            object = ((Issue)object2).getState();
            if (object == State.DRAFT) {
                object = State.OPEN;
                object2 = originalIssue;
                ((Issue)object2).setState((State)((Object)object));
            }
            object2 = originalIssue;
            object = null;
            object = ((AbstractPosting)object2).getProject();
            object2 = object;
            object = null;
            object = ((Project)object2).getId();
            originalIssue.setNumber(Project.increaseLastIssueNumber(object));
        }
        object2 = originalIssue;
        object = null;
        object = ((AbstractPosting)object2).getProject();
        object2 = object;
        object = null;
        Object object3 = object = ((Project)object2).getOwner();
        object2 = originalIssue;
        object = null;
        object = ((AbstractPosting)object2).getProject();
        object2 = object;
        object = null;
        object = ((Project)object2).getName();
        play.api.mvc.Call redirectTo = routes.IssueApp.issue((String)object3, (String)object, originalIssue.getNumber());
        Runnable preUpdateHook = new Runnable(){

            @Override
            public void run() {
                Issue issue22 = issue2;
                Object object = null;
                object = issue22.getVoters();
                Set<User> set = object;
                issue22 = originalIssue;
                object = null;
                object = issue22.getVoters();
                set.addAll((Collection<User>)object);
                object = originalIssue.comments;
                issue22 = issue2;
                issue22.setComments((List<IssueComment>)object);
                issue22 = issue2;
                object = null;
                object = issue22.getSharers();
                Collection<Model> collection = object;
                issue22 = originalIssue;
                object = null;
                object = issue22.getSharers();
                collection.addAll((Collection<Model>)object);
                issue22 = originalIssue;
                object = null;
                object = issue22.getWeight();
                issue22 = issue2;
                issue22.setWeight((Integer)object);
                Project previous = Project.findByOwnerAndProjectName(ownerName, projectName);
                issue22 = originalIssue;
                object = null;
                object = issue22.getProject();
                if (IssueApp.isRequestedToOtherProject((Project)object, previous)) {
                    object = originalIssue.labels;
                    issue22 = issue2;
                    issue22.setLabels((Set<IssueLabel>)object);
                    if (IssueApp.isFromMyOwnPrivateProject(previous)) {
                        object = "";
                        issue22 = issue2;
                        issue22.setHistory((String)object);
                    } else {
                        issue22 = issue2;
                        object = null;
                        object = issue22.getIsDraft();
                        if (!((Boolean)object).booleanValue()) {
                            IssueApp.addIssueMovedNotification(previous, originalIssue, issue2, fromWatchers);
                        }
                    }
                } else {
                    IssueApp.addLabels(issue2, Controller.request());
                }
                issue22 = issue2;
                object = null;
                object = issue22.getIsPublish();
                if (((Boolean)object).booleanValue()) {
                    NotificationEvent.afterNewIssue(issue2);
                    return;
                }
                issue22 = issue2;
                object = null;
                object = issue22.getIsDraft();
                if (((Boolean)object).booleanValue()) {
                    return;
                }
                if (AbstractPostingApp.isSelectedToSendNotificationMail() || !originalIssue.isAuthoredBy(UserApp.currentUser())) {
                    IssueApp.addAssigneeChangedNotification(issue2, originalIssue);
                    IssueApp.addStateChangedNotification(issue2, originalIssue);
                    IssueApp.addBodyChangedNotification(issue2, originalIssue);
                }
            }
        };
        return IssueApp.editPosting(originalIssue, issue2, (Form<? extends AbstractPosting>)issueForm, (Call)redirectTo, preUpdateHook);
    }

    private static boolean hasTargetProject(Issue issue2) {
        Issue issue3 = issue2;
        String string = null;
        string = issue3.getTargetProjectId();
        return StringUtils.isNotEmpty((CharSequence)string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isFromMyOwnPrivateProject(Project previous) {
        if (!previous.isPrivate()) return false;
        Model model = previous;
        String string = null;
        String string2 = string = model.getOwner();
        model = UserApp.currentUser();
        string = null;
        string = model.getLoginId();
        if (!string2.equalsIgnoreCase(string)) return false;
        return true;
    }

    private static void moveIssueToOtherProject(Issue originalIssue, Project toOtherProject) {
        IssueApp.updateIssueToOtherProject(originalIssue, toOtherProject);
        IssueApp.moveSubtaskToOtherProject(originalIssue, toOtherProject);
    }

    private static void moveSubtaskToOtherProject(Issue originalIssue, Project toOtherProject) {
        Issue issue2 = originalIssue;
        Long l = null;
        l = issue2.getId();
        List<Issue> subtasks = Issue.findByParentIssueId(l);
        for (Issue issue3 : subtasks) {
            IssueApp.updateIssueToOtherProject(issue3, toOtherProject);
        }
    }

    private static void updateIssueToOtherProject(Issue issue2, Project toOtherProject) {
        Object object = toOtherProject;
        Object object2 = issue2;
        ((AbstractPosting)object2).setProject((Project)object);
        object2 = toOtherProject;
        object = null;
        object = ((Project)object2).getId();
        issue2.setNumber(Project.increaseLastIssueNumber((Long)object));
        object = JodaDateUtil.now();
        object2 = issue2;
        ((AbstractPosting)object2).setCreatedDate((Date)object);
        object = JodaDateUtil.now();
        object2 = issue2;
        ((AbstractPosting)object2).setUpdatedDate((Date)object);
        object = null;
        object2 = issue2;
        ((Issue)object2).setMilestone((Milestone)object);
        for (IssueComment comment : issue2.comments) {
            object2 = issue2;
            object = null;
            object2 = object = ((AbstractPosting)object2).getProject();
            object = null;
            object = ((Project)object2).getId();
            object2 = comment;
            ((Comment)object2).setProjectId((Long)object);
            comment.update();
        }
        if (UserApp.currentUser().isMemberOf(toOtherProject) && issue2.labels.size() > 0) {
            IssueApp.transferLabels(issue2, toOtherProject);
        } else {
            object = new HashSet();
            object2 = issue2;
            ((Issue)object2).setLabels((Set<IssueLabel>)object);
        }
        issue2.update();
    }

    private static void transferLabels(Issue originalIssue, Project toProject) {
        Collection<Model> collection;
        Model model;
        HashSet<IssueLabel> newLabels = new HashSet<IssueLabel>();
        for (IssueLabel label : originalIssue.getLabels()) {
            IssueLabel copiedLabel = IssueLabel.copyIssueLabel(toProject, label);
            IssueLabel existedLabel = copiedLabel.findExistLabel();
            if (existedLabel == null) {
                model = toProject;
                collection = null;
                collection = model.getIssueLabels();
                collection.add(copiedLabel);
                model = copiedLabel;
                collection = null;
                collection = model.getIssues();
                collection.add(originalIssue);
                copiedLabel.save();
                toProject.update();
            } else {
                copiedLabel = existedLabel;
                model = copiedLabel;
                collection = null;
                collection = model.getIssues();
                collection.add((IssueLabel)((Object)originalIssue));
                copiedLabel.update();
            }
            newLabels.add(copiedLabel);
        }
        collection = new HashSet<IssueLabel>(newLabels);
        model = originalIssue;
        model.setLabels((Set<IssueLabel>)collection);
    }

    private static boolean isRequestedToOtherProject(Project project2, Project toOtherProject) {
        Project project3 = project2;
        Long l = null;
        Long l2 = l = project3.getId();
        project3 = toOtherProject;
        l = null;
        l = project3.getId();
        return !l2.equals(l);
    }

    private static void updateSubtaskRelation(Issue issue2, Issue originalIssue) {
        Issue issue3 = issue2;
        Object object = null;
        object = issue3.getParentIssueId();
        if (StringUtils.isEmpty((CharSequence)object)) {
            object = null;
            issue3 = issue2;
            issue3.setParent((Issue)object);
        } else {
            issue3 = issue2;
            object = null;
            object = issue3.getParentIssueId();
            object = (Issue)Issue.finder.byId((Object)Long.valueOf((String)object));
            issue3 = issue2;
            issue3.setParent((Issue)object);
        }
        issue3 = issue2;
        object = null;
        object = issue3.getParent();
        issue3 = originalIssue;
        issue3.setParent((Issue)object);
        originalIssue.update();
    }

    private static void setAssignee(Form<Issue> issueForm, Issue issue2, Project project2) {
        String value = issueForm.field("assignee.user.id").value();
        if (value != null) {
            long userId = Long.parseLong(value);
            Model model = User.anonymous;
            Object object = null;
            object = model.getId();
            if (userId != object) {
                model = project2;
                object = null;
                object = model.getId();
                object = new Assignee(userId, (Long)object);
                model = issue2;
                model.setAssignee((Assignee)((Object)object));
            }
        }
    }

    private static void setMilestone(Form<Issue> issueForm, Issue issue2) {
        String milestoneId = (String)issueForm.data().get("milestoneId");
        if (milestoneId != null && !milestoneId.isEmpty()) {
            Milestone milestone2 = Milestone.findById(Long.parseLong(milestoneId));
            Issue issue3 = issue2;
            issue3.setMilestone(milestone2);
        } else {
            Milestone milestone3 = null;
            Issue issue4 = issue2;
            issue4.setMilestone(milestone3);
        }
    }

    @Transactional
    @With(value={NullProjectCheckAction.class})
    public static Result deleteIssue(String ownerName, String projectName, Long number) {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        if (!issue2.canBeDeleted()) {
            return IssueApp.badRequest((Content)ErrorViews.BadRequest.render());
        }
        Model model = project2;
        Object object = null;
        object = model.getOwner();
        String string = object;
        model = project2;
        object = null;
        object = model.getName();
        play.api.mvc.Call redirectTo = routes.IssueApp.issues(string, (String)object, State.OPEN.state(), "html", 1);
        model = issue2;
        object = null;
        object = model.getIsDraft();
        if (!((Boolean)object).booleanValue()) {
            NotificationEvent.afterResourceDeleted(issue2, UserApp.currentUser());
        }
        return IssueApp.delete(issue2, issue2.asResource(), (Call)redirectTo);
    }

    @Transactional
    @With(value={NullProjectCheckAction.class})
    public static Result newComment(String ownerName, String projectName, Long number) throws IOException {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Issue issue2 = Issue.findByNumber(project2, number);
        Form commentForm2 = new Form(IssueComment.class).bindFromRequest(new String[0]);
        if (!AccessControl.isResourceCreatable(UserApp.currentUser(), issue2.asResource(), ResourceType.ISSUE_COMMENT)) {
            return IssueApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2));
        }
        if (commentForm2.hasErrors()) {
            return IssueApp.badRequest((Content)IssueApp.commentFormValidationResult(project2, (Form<IssueComment>)commentForm2));
        }
        IssueComment comment = (IssueComment)commentForm2.get();
        if (commentForm2.hasErrors()) {
            IssueApp.flash((String)"warning", (String)"common.comment.empty");
            Project project3 = project2;
            String string = null;
            String string2 = string = project3.getOwner();
            project3 = project2;
            string = null;
            string = project3.getName();
            return IssueApp.redirect((Call)routes.IssueApp.issue(string2, string, number));
        }
        Model model = comment;
        Object object = null;
        object = model.getParentCommentId();
        if (StringUtils.isNotEmpty((CharSequence)object)) {
            model = comment;
            object = null;
            object = model.getParentCommentId();
            comment.setParentComment((Comment)IssueComment.find.byId((Object)Long.valueOf((String)object)));
        }
        IssueApp.AddPreviousContent(issue2, comment);
        Comment savedComment = IssueApp.saveComment(project2, issue2, comment);
        if (IssueApp.containsStateTransitionRequest()) {
            IssueApp.toNextState(number, project2);
            model = UserApp.currentUser();
            object = null;
            object = model.getLoginId();
            IssueEvent.addFromNotificationEvent(NotificationEvent.afterStateChanged(issue2.previousState(), issue2), issue2, (String)object);
        } else {
            object = JodaDateUtil.now();
            model = issue2;
            model.setUpdatedDate((Date)object);
            issue2.update();
        }
        return IssueApp.redirect((String)RouteUtil.getUrl(savedComment));
    }

    @Transactional
    @With(value={NullProjectCheckAction.class})
    public static void newReferComment(IssueComment comment) {
        Object object = comment;
        Object object2 = null;
        object2 = ((IssueComment)object).getIssue();
        if (!AccessControl.isResourceCreatable(UserApp.currentUser(), ((Issue)object2).asResource(), ResourceType.ISSUE_COMMENT)) {
            object = comment;
            object2 = null;
            object2 = ((IssueComment)object).getIssue();
            Logger.warn((String)("Http.Status.FORBIDDEN: cannot add issue comment: " + object2));
            return;
        }
        object = comment;
        object2 = null;
        object2 = ((Comment)object).getParentCommentId();
        if (StringUtils.isNotEmpty((CharSequence)object2)) {
            object = comment;
            object2 = null;
            object2 = ((Comment)object).getParentCommentId();
            comment.setParentComment((Comment)IssueComment.find.byId((Object)Long.valueOf((String)object2)));
        }
        object = comment;
        object2 = null;
        object2 = ((IssueComment)object).getIssue();
        IssueApp.AddPreviousContent((Issue)object2, comment);
        object = comment;
        object2 = null;
        object = object2 = ((IssueComment)object).getIssue();
        object2 = null;
        Object object3 = object2 = ((AbstractPosting)object).getProject();
        object = comment;
        object2 = null;
        object2 = ((IssueComment)object).getIssue();
        IssueApp.saveComment((Project)object3, (Issue)object2, comment);
    }

    private static void AddPreviousContent(Issue issue2, IssueComment comment) {
        Object object = issue2;
        int n = 0;
        n = ((AbstractPosting)object).getNumOfComments();
        if (n == 0) {
            object = issue2;
            Object object2 = null;
            object2 = ((AbstractPosting)object).getBody();
            String string = object2;
            object = issue2;
            object2 = null;
            Object object3 = object2 = ((AbstractPosting)object).getUpdatedDate();
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getAuthorLoginId();
            object2 = IssueApp.getPrevious("Original issue", string, (Date)object3, (String)object2);
            object = comment;
            ((Comment)object).setPreviousContents((String)object2);
        } else {
            object = comment;
            Object object4 = null;
            object4 = ((Comment)object).getParentCommentId();
            if (object4 != null) {
                List<IssueComment> siblingComments = comment.getSiblingComments();
                Comment previousComment = siblingComments.size() > 0 ? (Comment)siblingComments.get(siblingComments.size() - 1) : comment.getParentComment();
                object = previousComment;
                object4 = null;
                object4 = ((Comment)object).getContents();
                String string = object4;
                object = previousComment;
                object4 = null;
                Object object5 = object4 = ((Comment)object).getCreatedDate();
                object = previousComment;
                object4 = null;
                object4 = ((Comment)object).getAuthorLoginId();
                object4 = IssueApp.getPrevious("Previous comment", string, (Date)object5, (String)object4);
                object = comment;
                ((Comment)object).setPreviousContents((String)object4);
            } else {
                int commentsSize = issue2.comments.size();
                object = issue2;
                int n2 = 0;
                n2 = ((AbstractPosting)object).getNumOfComments();
                if (n2 != commentsSize) {
                    object = issue2;
                    Object object6 = null;
                    object = object6 = ((AbstractPosting)object).getProject();
                    object6 = null;
                    object6 = ((Project)object).getOwner();
                    StringBuilder stringBuilder = new StringBuilder().append("Recalculate comments number of issue: ").append((String)object6).append("/");
                    object = issue2;
                    object6 = null;
                    object = object6 = ((AbstractPosting)object).getProject();
                    object6 = null;
                    object6 = ((Project)object).getName();
                    object = issue2;
                    n2 = 0;
                    n2 = ((AbstractPosting)object).getNumOfComments();
                    Logger.warn((String)stringBuilder.append((String)object6).append("/").append(issue2.getNumber()).append(" ").append(n2).append(" -> ").append(commentsSize).toString());
                    n2 = commentsSize;
                    object = issue2;
                    ((AbstractPosting)object).setNumOfComments(n2);
                    issue2.update();
                }
                if (commentsSize > 0) {
                    Comment previousComment = issue2.comments.get(commentsSize - 1);
                    object = previousComment;
                    Object object7 = null;
                    object7 = ((Comment)object).getContents();
                    String string = object7;
                    object = previousComment;
                    object7 = null;
                    Object object8 = object7 = ((Comment)object).getCreatedDate();
                    object = previousComment;
                    object7 = null;
                    object7 = ((Comment)object).getAuthorLoginId();
                    object7 = IssueApp.getPrevious("Previous comment", string, (Date)object8, (String)object7);
                    object = comment;
                    ((Comment)object).setPreviousContents((String)object7);
                } else {
                    object = issue2;
                    Object object9 = null;
                    object9 = ((AbstractPosting)object).getBody();
                    String string = object9;
                    object = issue2;
                    object9 = null;
                    Object object10 = object9 = ((AbstractPosting)object).getUpdatedDate();
                    object = issue2;
                    object9 = null;
                    object9 = ((AbstractPosting)object).getAuthorLoginId();
                    object9 = IssueApp.getPrevious("Issue", string, (Date)object10, (String)object9);
                    object = comment;
                    ((Comment)object).setPreviousContents((String)object9);
                    object = issue2;
                    object9 = null;
                    object9 = ((AbstractPosting)object).getId();
                    List list2 = IssueComment.find.where().eq("issue.id", object9).findList();
                    for (IssueComment garbageComment : list2) {
                        Logger.warn((String)("Garbage comment deleted: " + garbageComment));
                        garbageComment.delete();
                    }
                }
            }
        }
    }

    private static String getPrevious(String templateTitle, String contents, Date updatedDate, String authorLoginId) {
        return "\n\n<br />\n\n--- " + templateTitle + " from @" + authorLoginId + "  " + JodaDateUtil.getOptionalShortDate(updatedDate) + " ---\n\n<br />\n\n" + contents;
    }

    public static Result updateComment(String ownerName, String projectName, Long number, Long commentId) throws IOException {
        return IssueApp.newComment(ownerName, projectName, number);
    }

    private static Comment saveComment(Project project2, Issue issue2, IssueComment comment) {
        Comment savedComment;
        Model model = comment;
        Object object = null;
        object = model.getId();
        IssueComment existingComment = (IssueComment)IssueComment.find.where().eq("id", object).findUnique();
        if (existingComment == null) {
            model = project2;
            object = null;
            object = model.getId();
            model = comment;
            model.setProjectId((Long)object);
            savedComment = IssueApp.saveComment(comment, IssueApp.getContainerUpdater(issue2, comment));
            NotificationEvent.afterNewComment(savedComment);
        } else {
            model = comment;
            object = null;
            object = model.getContents();
            model = existingComment;
            model.setContents((String)object);
            savedComment = IssueApp.saveComment(existingComment, IssueApp.getContainerUpdater(issue2, comment));
            if (IssueApp.isSelectedToSendNotificationMail() || !existingComment.isAuthoredBy(UserApp.currentUser())) {
                NotificationEvent.afterCommentUpdated(savedComment);
            }
        }
        return savedComment;
    }

    private static Runnable getContainerUpdater(final Issue issue2, final IssueComment comment) {
        return new Runnable(){

            @Override
            public void run() {
                Issue issue22 = issue2;
                IssueComment issueComment = comment;
                issueComment.setIssue(issue22);
            }
        };
    }

    private static void toNextState(Long number, Project project2) {
        Issue issue2 = Issue.findByNumber(project2, number);
        issue2.toNextState();
    }

    private static boolean containsStateTransitionRequest() {
        if (!IssueApp.isMultipartForm() || IssueApp.getStateTransitionFormValue() == null) {
            return false;
        }
        return StringUtils.isNotBlank((CharSequence)IssueApp.getStateTransitionFormValue()[0]);
    }

    private static String[] getStateTransitionFormValue() {
        return (String[])IssueApp.request().body().asMultipartFormData().asFormUrlEncoded().get("withStateTransition");
    }

    private static boolean isMultipartForm() {
        return IssueApp.request().body().asMultipartFormData() != null;
    }

    private static Html commentFormValidationResult(Project project2, Form<IssueComment> commentForm2) {
        Map errors = commentForm2.errors();
        if (errors.get("contents") != null) {
            return ErrorViews.BadRequest.render("post.comment.empty", project2);
        }
        return ErrorViews.BadRequest.render("error.validation", project2);
    }

    @Transactional
    @With(value={NullProjectCheckAction.class})
    public static Result deleteComment(String ownerName, String projectName, Long issueNumber, Long commentId) {
        Project project2;
        Comment comment = (Comment)IssueComment.find.byId((Object)commentId);
        Project project3 = project2 = comment.asResource().getProject();
        String string = null;
        String string2 = string = project3.getOwner();
        project3 = project2;
        string = null;
        string = project3.getName();
        play.api.mvc.Call redirectTo = routes.IssueApp.issue(string2, string, issueNumber);
        return IssueApp.delete(comment, comment.asResource(), (Call)redirectTo);
    }

    private static void addLabels(Issue issue2, Http.Request request) {
        Http.MultipartFormData multipart;
        Map form;
        String[] labelIds;
        if (issue2.labels == null) {
            HashSet<IssueLabel> hashSet = new HashSet<IssueLabel>();
            Issue issue3 = issue2;
            issue3.setLabels(hashSet);
        }
        if ((labelIds = (String[])(form = (multipart = request.body().asMultipartFormData()) != null ? multipart.asFormUrlEncoded() : request.body().asFormUrlEncoded()).get("labelIds")) != null) {
            for (String labelId : labelIds) {
                if (StringUtils.isEmpty((CharSequence)labelId)) continue;
                issue2.labels.add((IssueLabel)IssueLabel.finder.byId((Object)Long.parseLong(labelId)));
            }
        }
    }
}

