/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import actions.DefaultProjectCheckAction;
import com.avaje.ebean.Expr;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Junction;
import com.avaje.ebean.Page;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.Application;
import controllers.IssueApp;
import controllers.LabelApp;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.annotation.GuestProhibit;
import controllers.annotation.IsAllowed;
import controllers.routes;
import info.schleichardt.play2.mailplugin.Mailer;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import jxl.write.WriteException;
import models.AbstractPosting;
import models.Attachment;
import models.CodeComment;
import models.Comment;
import models.CommentThread;
import models.CommitComment;
import models.FavoriteProject;
import models.History;
import models.Issue;
import models.IssueSharer;
import models.Label;
import models.NotificationEvent;
import models.Organization;
import models.OrganizationUser;
import models.Posting;
import models.Project;
import models.ProjectMenuSetting;
import models.ProjectTransfer;
import models.ProjectUser;
import models.PullRequest;
import models.PushedBranch;
import models.ReviewComment;
import models.Role;
import models.User;
import models.UserIdent;
import models.Watch;
import models.Webhook;
import models.enumeration.Operation;
import models.enumeration.ProjectScope;
import models.enumeration.RequestState;
import models.enumeration.ResourceType;
import models.enumeration.RoleType;
import models.enumeration.UserState;
import models.resource.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.HtmlEmail;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.tmatesoft.svn.core.SVNException;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.data.validation.ValidationError;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.i18n.Messages;
import play.libs.Json;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.With;
import play.twirl.api.Content;
import playRepository.Commit;
import playRepository.PlayRepository;
import playRepository.RepositoryService;
import scala.reflect.io.FileOperationException;
import utils.AccessControl;
import utils.CacheStore;
import utils.Config;
import utils.ErrorViews;
import utils.HttpUtil;
import utils.LogoUtil;
import utils.Markdown;
import utils.TemplateHelper;
import views.html.project.change_vcs;
import views.html.project.create;
import views.html.project.delete;
import views.html.project.home;
import views.html.project.list;
import views.html.project.members;
import views.html.project.setting;
import views.html.project.transfer;
import views.html.project.watchers;
import views.html.project.webhooks;

@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ProjectApp
extends Controller {
    private static final int ISSUE_MENTION_SHOW_LIMIT = 20;
    private static final int MAX_FETCH_PROJECTS = 1000;
    private static final int COMMIT_HISTORY_PAGE = 0;
    private static final int COMMIT_HISTORY_SHOW_LIMIT = 10;
    private static final int RECENLTY_ISSUE_SHOW_LIMIT = 10;
    private static final int RECENLTY_POSTING_SHOW_LIMIT = 10;
    private static final int RECENT_PULL_REQUEST_SHOW_LIMIT = 10;
    private static final int PROJECT_COUNT_PER_PAGE = 10;
    private static final String HTML = "text/html";
    private static final String JSON = "application/json";

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsAllowed(value=Operation.UPDATE)
    public static Result projectOverviewUpdate(String ownerId, String projectName) {
        Project targetProject = Project.findByOwnerAndProjectName(ownerId, projectName);
        if (targetProject == null) {
            return ProjectApp.notFound((Content)ErrorViews.NotFound.render("error.notfound"));
        }
        String string = ProjectApp.request().body().asJson().findPath("overview").textValue();
        Project project2 = targetProject;
        project2.setOverview(string);
        targetProject.save();
        ObjectNode result2 = Json.newObject();
        project2 = targetProject;
        string = null;
        string = project2.getOverview();
        result2.put("overview", string);
        return ProjectApp.ok((JsonNode)result2);
    }

    @IsAllowed(value=Operation.READ)
    @Transactional
    public static Result project(String ownerId, String projectName) throws IOException, ServletException, SVNException, GitAPIException {
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        List<History> histories = null;
        String tabId = (String)StringUtils.defaultIfBlank((CharSequence)ProjectApp.request().getQueryString("tabId"), (CharSequence)"readme");
        if (!tabId.equals("readme")) {
            histories = ProjectApp.getProjectHistory(ownerId, project2);
        }
        UserApp.currentUser().visits(project2);
        return ProjectApp.ok((Content)home.render(ProjectApp.getTitleMessage(tabId), project2, histories, tabId));
    }

    private static String getTitleMessage(String tabId) {
        switch (tabId) {
            case "history": {
                return "project.history.recent";
            }
            case "dashboard": {
                return "title.projectDashboard";
            }
        }
        return "title.projectHome";
    }

    private static List<History> getProjectHistory(String ownerId, Project project2) throws IOException, ServletException, SVNException, GitAPIException {
        project2.fixInvalidForkData();
        PlayRepository repository = RepositoryService.getRepository(project2);
        List<Commit> commits = null;
        try {
            commits = repository.getHistory(0, 10, null, null);
        }
        catch (NoHeadException noHeadException) {
            // empty catch block
        }
        List<Issue> issues2 = Issue.findRecentlyCreated(project2, 10);
        List<Posting> postings = Posting.findRecentlyCreated(project2, 10);
        List<PullRequest> pullRequests2 = PullRequest.findRecentlyReceived(project2, 10);
        return History.makeHistory(ownerId, project2, commits, issues2, postings, pullRequests2);
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static Result newProjectForm() {
        Form projectForm = Form.form(Project.class).bindFromRequest(new String[]{"owner"});
        projectForm.discardErrors();
        User user = UserApp.currentUser();
        Long l = null;
        l = user.getId();
        List<OrganizationUser> orgUserList = OrganizationUser.findByAdmin(l);
        return ProjectApp.ok((Content)create.render("title.newProject", (Form<Project>)projectForm, orgUserList));
    }

    @IsAllowed(value=Operation.UPDATE)
    public static Result settingForm(String ownerId, String projectName) throws Exception {
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        Form projectForm = Form.form(Project.class).fill((Object)project2);
        PlayRepository repository = RepositoryService.getRepository(project2);
        return ProjectApp.ok((Content)setting.render("title.projectSetting", (Form<Project>)projectForm, project2, repository.getRefNames()));
    }

    @Transactional
    public static Result newProject() throws Exception {
        Object object;
        Model model;
        Organization organization2;
        User user;
        String owner;
        Form filledNewProjectForm;
        block6: {
            block5: {
                filledNewProjectForm = Form.form(Project.class).bindFromRequest(new String[0]);
                owner = filledNewProjectForm.field("owner").value();
                user = UserApp.currentUser();
                organization2 = Organization.findByName(owner);
                if (!AccessControl.isGlobalResourceCreatable(user)) break block5;
                if (!Organization.isNameExist(owner)) break block6;
                model = organization2;
                object = null;
                object = model.getId();
                Long l = object;
                model = user;
                object = null;
                object = model.getId();
                if (OrganizationUser.isAdmin(l, (Long)object)) break block6;
            }
            return ProjectApp.forbidden((Content)ErrorViews.Forbidden.render("'" + user.getDisplayName() + "' has no permission"));
        }
        if (ProjectApp.validateWhenNew((Form<Project>)filledNewProjectForm)) {
            model = user;
            object = null;
            object = model.getId();
            return ProjectApp.badRequest((Content)create.render("title.newProject", (Form<Project>)filledNewProjectForm, OrganizationUser.findByAdmin((Long)object)));
        }
        Project project2 = (Project)filledNewProjectForm.get();
        if (Organization.isNameExist(owner)) {
            object = organization2;
            model = project2;
            model.setOrganization((Organization)object);
        }
        model = user;
        object = null;
        object = model.getId();
        ProjectUser.assignRole((Long)object, Project.create(project2), RoleType.MANAGER);
        RepositoryService.createRepository(project2);
        ProjectApp.saveProjectMenuSetting(project2);
        Watch.watch(project2.asResource());
        model = project2;
        object = null;
        Object object2 = object = model.getOwner();
        model = project2;
        object = null;
        object = model.getName();
        String string = CacheStore.getProjectCacheKey((String)object2, (String)object);
        model = project2;
        object = null;
        object = model.getId();
        CacheStore.projectMap.put(string, (Long)object);
        UserApp.currentUser().visits(project2);
        model = project2;
        object = null;
        Object object3 = object = model.getOwner();
        model = project2;
        object = null;
        object = model.getName();
        return ProjectApp.redirect((Call)routes.ProjectApp.project((String)object3, (String)object));
    }

    private static boolean validateWhenNew(Form<Project> newProjectForm2) {
        ValidationError error;
        String owner = newProjectForm2.field("owner").value();
        String name = newProjectForm2.field("name").value();
        User user = User.findByLoginId(owner);
        boolean ownerIsUser = User.isLoginIdExist(owner);
        boolean ownerIsOrganization = Organization.isNameExist(owner);
        if (!ownerIsUser && !ownerIsOrganization) {
            newProjectForm2.reject("owner", "project.owner.invalidate");
        }
        if (ownerIsUser) {
            User user2 = UserApp.currentUser();
            Long l = null;
            Long l2 = l = user2.getId();
            user2 = user;
            l = null;
            l = user2.getId();
            if (!l2.equals(l)) {
                newProjectForm2.reject("owner", "project.owner.invalidate");
            }
        }
        if (Project.exists(owner, name)) {
            newProjectForm2.reject("name", "project.name.duplicate");
        }
        if ((error = newProjectForm2.error("name")) != null) {
            if ("error.pattern".equals(error.message())) {
                newProjectForm2.errors().remove("name");
                newProjectForm2.reject("name", "project.name.alert");
            } else if ("error.restricted".equals(error.message())) {
                newProjectForm2.errors().remove("name");
                newProjectForm2.reject("name", "project.name.reserved.alert");
            }
        }
        return newProjectForm2.hasErrors();
    }

    @Transactional
    @IsAllowed(value=Operation.UPDATE)
    public static Result settingProject(String ownerId, String projectName) throws IOException, NoSuchAlgorithmException, UnsupportedOperationException, ServletException {
        Map data2;
        String defaultBranch;
        Form filledUpdatedProjectForm = Form.form(Project.class).bindFromRequest(new String[0]);
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        PlayRepository repository = RepositoryService.getRepository(project2);
        if (ProjectApp.validateWhenUpdate(ownerId, (Form<Project>)filledUpdatedProjectForm)) {
            return ProjectApp.badRequest((Content)setting.render("title.projectSetting", (Form<Project>)filledUpdatedProjectForm, project2, repository.getRefNames()));
        }
        Project updatedProject = (Project)filledUpdatedProjectForm.get();
        Http.MultipartFormData.FilePart filePart = ProjectApp.request().body().asMultipartFormData().getFile("logoPath");
        if (!LogoUtil.isEmptyFilePart(filePart)) {
            Attachment.deleteAll(updatedProject.asResource());
            new Attachment().store(filePart.getFile(), filePart.getFilename(), updatedProject.asResource());
        }
        if (StringUtils.isNotEmpty((CharSequence)(defaultBranch = HttpUtil.getFirstValueFromQuery(data2 = ProjectApp.request().body().asMultipartFormData().asFormUrlEncoded(), "defaultBranch")))) {
            repository.setDefaultBranch(defaultBranch);
        }
        Project project3 = project2;
        String string = null;
        String string2 = string = project3.getName();
        project3 = updatedProject;
        string = null;
        string = project3.getName();
        if (!string2.equals(string)) {
            updatedProject.recordRenameOrTransferHistoryIfLastChangePassed24HoursFrom(project2);
            project3 = updatedProject;
            string = null;
            string = project3.getName();
            if (!repository.renameTo(string)) {
                project3 = project2;
                string = null;
                string = project3.getOwner();
                StringBuilder stringBuilder = new StringBuilder().append("fail repository rename to ").append(string).append("/");
                project3 = updatedProject;
                string = null;
                string = project3.getName();
                throw new FileOperationException(stringBuilder.append(string).toString());
            }
            CacheStore.refreshProjectMap();
        }
        updatedProject.update();
        ProjectApp.saveProjectMenuSetting(updatedProject);
        UserApp.currentUser().updateFavoriteProject(updatedProject);
        FavoriteProject.updateFavoriteProject(updatedProject);
        project3 = updatedProject;
        string = null;
        string = project3.getName();
        return ProjectApp.redirect((Call)routes.ProjectApp.settingForm(ownerId, string));
    }

    public static void saveProjectMenuSetting(Project project2) {
        Form filledUpdatedProjectMenuSettingForm = Form.form(ProjectMenuSetting.class).bindFromRequest(new String[0]);
        ProjectMenuSetting updatedProjectMenuSetting = (ProjectMenuSetting)((Object)filledUpdatedProjectMenuSettingForm.get());
        project2.refresh();
        Model model = project2;
        Model model2 = updatedProjectMenuSetting;
        model2.setProject((Project)model);
        model2 = project2;
        model = null;
        model = model2.getMenuSetting();
        if (model == null) {
            updatedProjectMenuSetting.save();
        } else {
            model2 = project2;
            model = null;
            model = model2.getMenuSetting();
            model.updateMenuSetting(updatedProjectMenuSetting);
        }
    }

    private static boolean validateWhenUpdate(String loginId, Form<Project> updateProjectForm) {
        ValidationError error;
        Http.MultipartFormData.FilePart filePart;
        String name;
        Long id = Long.parseLong(updateProjectForm.field("id").value());
        if (!Project.projectNameChangeable(id, loginId, name = updateProjectForm.field("name").value())) {
            ProjectApp.flash((String)"warning", (String)"project.name.duplicate");
            updateProjectForm.reject("name", "project.name.duplicate");
        }
        if (!LogoUtil.isEmptyFilePart(filePart = ProjectApp.request().body().asMultipartFormData().getFile("logoPath"))) {
            if (!LogoUtil.isImageFile(filePart.getFilename())) {
                ProjectApp.flash((String)"warning", (String)"project.logo.alert");
                updateProjectForm.reject("logoPath", "project.logo.alert");
            } else if (filePart.getFile().length() > 5120000L) {
                ProjectApp.flash((String)"warning", (String)"project.logo.fileSizeAlert");
                updateProjectForm.reject("logoPath", "project.logo.fileSizeAlert");
            }
        }
        if ((error = updateProjectForm.error("name")) != null) {
            if ("error.pattern".equals(error.message())) {
                ProjectApp.flash((String)"warning", (String)"project.name.alert");
                updateProjectForm.errors().remove("name");
                updateProjectForm.reject("name", "project.name.alert");
            } else if ("error.restricted".equals(error.message())) {
                ProjectApp.flash((String)"warning", (String)"project.name.reserved.alert");
                updateProjectForm.errors().remove("name");
                updateProjectForm.reject("name", "project.name.reserved.alert");
            }
        }
        return updateProjectForm.hasErrors();
    }

    @IsAllowed(value=Operation.DELETE)
    public static Result deleteForm(String ownerId, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        Form projectForm = Form.form(Project.class).fill((Object)project2);
        return ProjectApp.ok((Content)delete.render("title.projectDelete", (Form<Project>)projectForm, project2));
    }

    @Transactional
    @IsAllowed(value=Operation.DELETE)
    public static Result deleteProject(String ownerId, String projectName) throws Exception {
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        if (project2 == null) {
            return ProjectApp.redirect((Call)routes.Application.index());
        }
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        UserApp.currentUser().removeFavoriteProject(l);
        project2.delete();
        RepositoryService.deleteRepository(project2);
        CacheStore.refreshProjectMap();
        if (HttpUtil.isRequestedWithXHR(ProjectApp.request()).booleanValue()) {
            ProjectApp.response().setHeader("Location", routes.Application.index().toString());
            return ProjectApp.status((int)204);
        }
        return ProjectApp.redirect((Call)routes.Application.index());
    }

    @Transactional
    @IsAllowed(value=Operation.UPDATE)
    public static Result members(String loginId, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(loginId, projectName);
        project2.cleanEnrolledUsers();
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        return ProjectApp.ok((Content)members.render("title.projectMembers", ProjectUser.findMemberListByProject(l), project2, Role.findProjectRoles()));
    }

    @Transactional
    @IsAllowed(value=Operation.READ)
    public static Result watchers(String loginId, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(loginId, projectName);
        Resource resource = project2.asResource();
        return ProjectApp.ok((Content)watchers.render("title.projectWatchers", Watch.findActualWatchers(Watch.findWatchers(resource.getType(), resource.getId()), resource, true), project2));
    }

    @AnonymousCheck
    public static Result mentionList(String loginId, String projectName, Long number, String resourceType, String query, String mentionType) {
        String prefer = HttpUtil.getPreferType(ProjectApp.request(), HTML, JSON);
        if (prefer == null) {
            return ProjectApp.status((int)406);
        }
        ProjectApp.response().setHeader("Vary", "Accept");
        Project project2 = Project.findByOwnerAndProjectName(loginId, projectName);
        ArrayList<User> userList2 = new ArrayList<User>();
        HashMap<String, List<Map<String, String>>> result2 = new HashMap<String, List<Map<String, String>>>();
        if ("user".equalsIgnoreCase(mentionType)) {
            if (StringUtils.isEmpty((CharSequence)query) || !project2.isPublic()) {
                ProjectApp.collectAuthorAndCommenter(project2, number, userList2, resourceType);
                ProjectApp.addProjectMemberList(project2, userList2);
                ProjectApp.addGroupMemberList(project2, userList2);
                ProjectApp.addProjectAuthorsAndWatchersList(project2, userList2);
                ProjectApp.addSharers(project2, number, userList2, resourceType);
            } else {
                ProjectApp.addSearchedUsers(query, userList2);
            }
            userList2.remove(UserApp.currentUser());
            userList2.add(UserApp.currentUser());
            result2.put("result", ProjectApp.getUserList(project2, userList2));
        }
        if ("issue".equalsIgnoreCase(mentionType)) {
            result2.put("result", ProjectApp.getIssueList(project2, query));
        }
        return ProjectApp.ok((JsonNode)Json.toJson(result2));
    }

    private static List<Map<String, String>> getIssueList(Project project2, String query) {
        ArrayList<Map<String, String>> mentionListOfIssues = new ArrayList<Map<String, String>>();
        ProjectApp.collectedIssuesToMap(mentionListOfIssues, ProjectApp.getMentionIssueList(project2, query));
        return mentionListOfIssues;
    }

    private static List<Map<String, String>> getUserList(Project project2, List<User> userList2) {
        ArrayList<Map<String, String>> mentionListOfUser = new ArrayList<Map<String, String>>();
        ProjectApp.collectedUsersToMentionList(mentionListOfUser, userList2);
        ProjectApp.addProjectNameToMentionList(mentionListOfUser, project2);
        ProjectApp.addOrganizationNameToMentionList(mentionListOfUser, project2);
        return mentionListOfUser;
    }

    private static void addProjectNameToMentionList(List<Map<String, String>> users2, Project project2) {
        HashMap<String, String> additionalUser = new HashMap<String, String>();
        if (project2 != null) {
            Project project3 = project2;
            Object object = null;
            object = project3.getOwner();
            StringBuilder stringBuilder = new StringBuilder().append((String)object).append("/");
            project3 = project2;
            object = null;
            object = project3.getName();
            additionalUser.put("loginid", stringBuilder.append((String)object).toString());
            project3 = project2;
            object = null;
            object = project3.getName();
            additionalUser.put("username", (String)object);
            additionalUser.put("name", "@project all:");
            project3 = project2;
            object = null;
            object = project3.getOwner();
            StringBuilder stringBuilder2 = new StringBuilder().append((String)object).append("/");
            project3 = project2;
            object = null;
            object = project3.getName();
            additionalUser.put("searchText", stringBuilder2.append((String)object).append("/project/member/all").toString());
            additionalUser.put("image", TemplateHelper.urlToProjectLogo(project2).toString());
            if (users2.size() > 9) {
                project3 = project2;
                object = null;
                object = project3.getOrganization();
                if (object != null) {
                    users2.add(8, additionalUser);
                } else {
                    users2.add(9, additionalUser);
                }
            } else {
                users2.add(additionalUser);
            }
        }
    }

    private static void addOrganizationNameToMentionList(List<Map<String, String>> users2, Project project2) {
        HashMap<String, Object> additionalUser = new HashMap<String, Object>();
        if (project2 != null) {
            Object object = project2;
            Object object2 = null;
            object2 = ((Project)object).getOrganization();
            if (object2 != null) {
                object = project2;
                object2 = null;
                object = object2 = ((Project)object).getOrganization();
                object2 = null;
                object2 = ((Organization)object).getName();
                additionalUser.put("loginid", object2);
                object = project2;
                object2 = null;
                object = object2 = ((Project)object).getOrganization();
                object2 = null;
                object2 = ((Organization)object).getName();
                additionalUser.put("username", object2);
                additionalUser.put("name", "@group all: ");
                object = project2;
                object2 = null;
                object = object2 = ((Project)object).getOrganization();
                object2 = null;
                object2 = ((Organization)object).getName();
                additionalUser.put("searchText", (String)object2 + "/group/org/member/all");
                object = project2;
                object2 = null;
                object2 = ((Project)object).getOrganization();
                additionalUser.put("image", TemplateHelper.urlToOrganizationLogo((Organization)object2).toString());
                if (users2.size() > 9) {
                    users2.add(9, additionalUser);
                }
                users2.add(additionalUser);
            }
        }
    }

    private static void collectedIssuesToMap(List<Map<String, String>> mentionList2, List<Issue> issueList2) {
        for (Issue issue2 : issueList2) {
            HashMap<String, String> projectIssueMap = new HashMap<String, String>();
            Issue issue3 = issue2;
            String string = null;
            string = issue3.getTitle();
            projectIssueMap.put("name", issue2.getNumber().toString() + string);
            projectIssueMap.put("issueNo", issue2.getNumber().toString());
            issue3 = issue2;
            string = null;
            string = issue3.getTitle();
            projectIssueMap.put("title", string);
            mentionList2.add(projectIssueMap);
        }
    }

    private static List<Issue> getMentionIssueList(Project project2, String query) {
        Object object;
        if (StringUtils.isEmpty((CharSequence)query)) {
            Object object2;
            ExpressionList expressionList = Issue.finder.where();
            if (project2.isForkedFromOrigin()) {
                Project project3 = project2;
                Object object3 = null;
                object3 = project3.getOriginalProject();
                project3 = object3;
                object3 = null;
                object2 = object3 = project3.getId();
            } else {
                Project project4 = project2;
                Long l = null;
                l = project4.getId();
                object2 = l;
            }
            return expressionList.eq("project.id", object2).orderBy("createdDate desc").setMaxRows(20).findList();
        }
        ExpressionList expressionList = Issue.finder.where();
        if (project2.isForkedFromOrigin()) {
            Project project5 = project2;
            Object object4 = null;
            object4 = project5.getOriginalProject();
            project5 = object4;
            object4 = null;
            object = object4 = project5.getId();
        } else {
            Project project6 = project2;
            Long l = null;
            l = project6.getId();
            object = l;
        }
        return expressionList.eq("project.id", object).or(Expr.ilike((String)"title", (String)("%" + query + "%")), Expr.ilike((String)"number", (String)(query + "%"))).orderBy("createdDate desc").setMaxRows(20).findList();
    }

    @IsAllowed(value=Operation.READ)
    public static Result mentionListAtCommitDiff(String ownerId, String projectName, String commitId, Long pullRequestId) throws IOException, UnsupportedOperationException, ServletException, SVNException {
        Object object;
        Model model;
        PullRequest pullRequest2;
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        String query = ProjectApp.request().getQueryString("query");
        String mentionType = ProjectApp.request().getQueryString("mentionType");
        Project fromProject = project2;
        if (pullRequestId != -1L && (pullRequest2 = PullRequest.findById(pullRequestId)) != null) {
            model = pullRequest2;
            object = null;
            object = model.getFromProject();
            fromProject = object;
        }
        Commit commit = RepositoryService.getRepository(fromProject).getCommit(commitId);
        ArrayList<User> userList2 = new ArrayList<User>();
        HashMap<String, List<Map<String, String>>> result2 = new HashMap<String, List<Map<String, String>>>();
        if ("user".equalsIgnoreCase(mentionType)) {
            if (StringUtils.isEmpty((CharSequence)query)) {
                ProjectApp.addCommitAuthor(commit, userList2);
                model = fromProject;
                object = null;
                object = model.getId();
                ProjectApp.addCodeCommenters(commitId, (Long)object, userList2);
                ProjectApp.addProjectMemberList(project2, userList2);
                ProjectApp.addGroupMemberList(project2, userList2);
            } else {
                ProjectApp.addSearchedUsers(query, userList2);
            }
            userList2.remove(UserApp.currentUser());
            userList2.add(UserApp.currentUser());
            result2.put("result", ProjectApp.getUserList(project2, userList2));
        }
        if ("issue".equalsIgnoreCase(mentionType)) {
            result2.put("result", ProjectApp.getIssueList(project2, query));
        }
        return ProjectApp.ok((JsonNode)Json.toJson(result2));
    }

    @IsAllowed(value=Operation.READ)
    public static Result mentionListAtPullRequest(String ownerId, String projectName, String commitId, Long pullRequestId) throws IOException, UnsupportedOperationException, ServletException, SVNException {
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        PullRequest pullRequest2 = PullRequest.findById(pullRequestId);
        HashMap<String, List<Map<String, String>>> result2 = new HashMap<String, List<Map<String, String>>>();
        ArrayList<User> userList2 = new ArrayList<User>();
        String query = ProjectApp.request().getQueryString("query");
        String mentionType = ProjectApp.request().getQueryString("mentionType");
        if ("user".equalsIgnoreCase(mentionType)) {
            Model model;
            PullRequest pullRequest3;
            if (StringUtils.isEmpty((CharSequence)query)) {
                ProjectApp.addCommentAuthors(pullRequestId, userList2);
                ProjectApp.addProjectMemberList(project2, userList2);
                ProjectApp.addGroupMemberList(project2, userList2);
                if (!commitId.isEmpty()) {
                    pullRequest3 = pullRequest2;
                    model = null;
                    model = pullRequest3.getFromProject();
                    ProjectApp.addCommitAuthor(RepositoryService.getRepository((Project)model).getCommit(commitId), userList2);
                }
            } else {
                ProjectApp.addSearchedUsers(query, userList2);
            }
            pullRequest3 = pullRequest2;
            model = null;
            model = pullRequest3.getContributor();
            User contributor = model;
            if (!userList2.contains(contributor)) {
                userList2.add(contributor);
            }
            userList2.remove(UserApp.currentUser());
            userList2.add(UserApp.currentUser());
            result2.put("result", ProjectApp.getUserList(project2, userList2));
        }
        if ("issue".equalsIgnoreCase(mentionType)) {
            result2.put("result", ProjectApp.getIssueList(project2, query));
        }
        return ProjectApp.ok((JsonNode)Json.toJson(result2));
    }

    private static void addCommentAuthors(Long pullRequestId, List<User> userList2) {
        Object object = PullRequest.findById(pullRequestId);
        Object object2 = null;
        object2 = ((PullRequest)object).getCommentThreads();
        List<CommentThread> threads = object2;
        for (CommentThread thread : threads) {
            object = thread;
            object2 = null;
            object2 = ((CommentThread)object).getReviewComments();
            Iterator<Model> iterator = object2.iterator();
            while (iterator.hasNext()) {
                ReviewComment comment = (ReviewComment)iterator.next();
                object = comment;
                object2 = null;
                object = object2 = ((ReviewComment)object).getAuthor();
                object2 = null;
                object2 = ((UserIdent)object).getLoginId();
                User commenter = User.findByLoginId((String)object2);
                if (userList2.contains(commenter)) {
                    userList2.remove(commenter);
                }
                userList2.add(commenter);
            }
        }
        Collections.reverse(userList2);
    }

    @IsAllowed(value=Operation.DELETE)
    public static Result transferForm(String ownerId, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        Form projectForm = Form.form(Project.class).fill((Object)project2);
        return ProjectApp.ok((Content)transfer.render("title.projectTransfer", (Form<Project>)projectForm, project2));
    }

    @Transactional
    @IsAllowed(value=Operation.DELETE)
    public static Result transferProject(String ownerId, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        String destination = ProjectApp.request().getQueryString("owner");
        User destOwner = User.findByLoginId(destination);
        Organization destOrg = Organization.findByName(destination);
        if (destOwner.isAnonymous() && destOrg == null) {
            return ProjectApp.badRequest((Content)ErrorViews.BadRequest.render());
        }
        Model model = project2;
        String string = null;
        string = model.getOwner();
        User projectOwner = User.findByLoginId(string);
        model = project2;
        string = null;
        string = model.getOwner();
        Organization projectOrg = Organization.findByName(string);
        if (!destOwner.isAnonymous() && destOwner.equals(projectOwner) || projectOrg != null && projectOrg.equals(destOrg)) {
            ProjectApp.flash((String)"info", (String)"project.transfer.has.same.owner");
            Form projectForm = Form.form(Project.class).fill((Object)project2);
            return ProjectApp.ok((Content)transfer.render("title.projectTransfer", (Form<Project>)projectForm, project2));
        }
        ProjectTransfer pt = null;
        if (!destOwner.isAnonymous()) {
            model = destOwner;
            string = null;
            string = model.getLoginId();
            pt = ProjectTransfer.requestNewTransfer(project2, UserApp.currentUser(), string);
        }
        if (destOrg != null) {
            model = destOrg;
            string = null;
            string = model.getName();
            pt = ProjectTransfer.requestNewTransfer(project2, UserApp.currentUser(), string);
        }
        ProjectApp.sendTransferRequestMail(pt);
        ProjectApp.flash((String)"info", (String)"project.transfer.is.requested");
        String url = routes.ProjectApp.project(ownerId, projectName).url();
        if (HttpUtil.isRequestedWithXHR(ProjectApp.request()).booleanValue()) {
            ProjectApp.response().setHeader("Location", url);
            return ProjectApp.status((int)204);
        }
        return ProjectApp.redirect((String)url);
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static synchronized Result acceptTransfer(Long id, String confirmKey) throws IOException, ServletException {
        Object object;
        Object object2;
        ProjectTransfer pt;
        block10: {
            block9: {
                pt = ProjectTransfer.findValidOne(id);
                if (pt == null) {
                    return ProjectApp.notFound((Content)ErrorViews.NotFound.render());
                }
                if (confirmKey == null) break block9;
                object2 = pt;
                object = null;
                object = ((ProjectTransfer)object2).getConfirmKey();
                if (((String)object).equals(confirmKey)) break block10;
            }
            return ProjectApp.badRequest((Content)ErrorViews.BadRequest.render());
        }
        if (!AccessControl.isAllowed(UserApp.currentUser(), pt.asResource(), Operation.ACCEPT)) {
            return ProjectApp.forbidden((Content)ErrorViews.Forbidden.render());
        }
        object2 = pt;
        object = null;
        Object project2 = object = ((ProjectTransfer)object2).getProject();
        object2 = pt;
        object = null;
        Object object3 = object = ((ProjectTransfer)object2).getDestination();
        object2 = project2;
        object = null;
        object = ((Project)object2).getName();
        String newProjectName = Project.newProjectName((String)object3, (String)object);
        object2 = project2;
        object = null;
        Object originalProjectOwner = object = ((Project)object2).getOwner();
        object2 = project2;
        object = null;
        Object originalProjectName = object = ((Project)object2).getName();
        object2 = pt;
        object = null;
        Object destinationOwner = object = ((ProjectTransfer)object2).getDestination();
        object2 = pt;
        object = null;
        object2 = object = ((ProjectTransfer)object2).getSender();
        object = null;
        Object senderId = object = ((User)object2).getId();
        ProjectApp.disableProjectTransferLink(pt, (Project)project2, newProjectName);
        PlayRepository repository = RepositoryService.getRepository((Project)project2);
        repository.move((String)originalProjectOwner, (String)originalProjectName, (String)destinationOwner, newProjectName);
        User newOwnerUser = User.findByLoginId((String)destinationOwner);
        Organization newOwnerOrg = Organization.findByName((String)destinationOwner);
        ((Project)project2).recordRenameOrTransferHistoryIfLastChangePassed24HoursFrom((Project)project2);
        object = destinationOwner;
        object2 = project2;
        ((Project)object2).setOwner((String)object);
        object = newProjectName;
        object2 = project2;
        ((Project)object2).setName((String)object);
        if (newOwnerOrg != null) {
            object = newOwnerOrg;
            object2 = project2;
            ((Project)object2).setOrganization((Organization)object);
        } else {
            object = null;
            object2 = project2;
            ((Project)object2).setOrganization((Organization)object);
        }
        project2.update();
        object2 = project2;
        object = null;
        object = ((Project)object2).getId();
        if (ProjectUser.isManager((Long)senderId, (Long)object)) {
            object2 = project2;
            object = null;
            object = ((Project)object2).getId();
            ProjectUser.assignRole((Long)senderId, (Long)object, RoleType.MEMBER);
        }
        if (!newOwnerUser.isAnonymous()) {
            object2 = newOwnerUser;
            object = null;
            Object object4 = object = ((User)object2).getId();
            object2 = project2;
            object = null;
            object = ((Project)object2).getId();
            ProjectUser.assignRole((Long)object4, (Long)object, RoleType.MANAGER);
        }
        CacheStore.refreshProjectMap();
        object2 = project2;
        object = null;
        Object object5 = object = ((Project)object2).getOwner();
        object2 = project2;
        object = null;
        object = ((Project)object2).getName();
        return ProjectApp.redirect((Call)routes.ProjectApp.project((String)object5, (String)object));
    }

    private static void disableProjectTransferLink(ProjectTransfer pt, Project project2, String newProjectName) {
        String string = newProjectName;
        ProjectTransfer projectTransfer = pt;
        projectTransfer.setNewProjectName(string);
        boolean bl = true;
        projectTransfer = pt;
        projectTransfer.setAccepted(bl);
        projectTransfer = pt;
        Object object = null;
        object = projectTransfer.getSender();
        User user = object;
        projectTransfer = pt;
        object = null;
        object = projectTransfer.getDestination();
        ProjectTransfer.deleteExisting(project2, user, (String)object);
    }

    @IsAllowed(value=Operation.UPDATE)
    public static Result changeVCSForm(String ownerId, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        Form projectForm = Form.form(Project.class).fill((Object)project2);
        return ProjectApp.ok((Content)change_vcs.render("title.projectChangeVCS", (Form<Project>)projectForm, project2));
    }

    @IsAllowed(value=Operation.UPDATE)
    public static Result changeVCS(String ownerId, String projectName) throws Exception {
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        try {
            Posting posting;
            if (project2.readme() != null && (posting = Posting.findREADMEPosting(project2)) != null) {
                boolean bl = false;
                Posting posting2 = posting;
                posting2.setReadme(bl);
                posting.save();
            }
            project2.changeVCS();
            String url = routes.ProjectApp.project(ownerId, projectName).url();
            ProjectApp.response().setHeader("Location", url);
            return ProjectApp.noContent();
        }
        catch (Exception e) {
            Logger.error((String)e.getMessage());
            return ProjectApp.internalServerError();
        }
    }

    private static void sendTransferRequestMail(ProjectTransfer pt) {
        HtmlEmail email = new HtmlEmail();
        try {
            String acceptUrl = pt.getAcceptUrl();
            Object[] objectArray = new Object[1];
            Object object = pt;
            Object object2 = null;
            objectArray[0] = object2 = ((ProjectTransfer)object).getDestination();
            Object[] objectArray2 = new Object[4];
            object = pt;
            object2 = null;
            object = object2 = ((ProjectTransfer)object).getProject();
            object2 = null;
            objectArray2[0] = object2 = ((Project)object).getName();
            object = pt;
            object2 = null;
            objectArray2[1] = object2 = ((ProjectTransfer)object).getNewProjectName();
            object = pt;
            object2 = null;
            object = object2 = ((ProjectTransfer)object).getProject();
            object2 = null;
            objectArray2[2] = object2 = ((Project)object).getOwner();
            object = pt;
            object2 = null;
            objectArray2[3] = object2 = ((ProjectTransfer)object).getDestination();
            String message = Messages.get((String)"transfer.message.hello", (Object[])objectArray) + "\n\n" + Messages.get((String)"transfer.message.detail", (Object[])objectArray2) + "\n" + Messages.get((String)"transfer.message.link", (Object[])new Object[0]) + "\n\n" + acceptUrl + "\n\n" + Messages.get((String)"transfer.message.deadline", (Object[])new Object[0]) + "\n\n" + Messages.get((String)"transfer.message.thank", (Object[])new Object[0]);
            object = pt;
            object2 = null;
            object = object2 = ((ProjectTransfer)object).getSender();
            object2 = null;
            object2 = ((User)object).getName();
            email.setFrom(Config.getEmailFromSmtp(), (String)object2);
            email.addTo(Config.getEmailFromSmtp(), "Yobi");
            object = pt;
            object2 = null;
            object2 = ((ProjectTransfer)object).getDestination();
            User to = User.findByLoginId((String)object2);
            if (!to.isAnonymous()) {
                object = to;
                object2 = null;
                Object object3 = object2 = ((User)object).getEmail();
                object = to;
                object2 = null;
                object2 = ((User)object).getName();
                email.addBcc((String)object3, (String)object2);
            }
            object = pt;
            object2 = null;
            object2 = ((ProjectTransfer)object).getDestination();
            Organization org = Organization.findByName((String)object2);
            if (org != null) {
                List<OrganizationUser> admins = OrganizationUser.findAdminsOf(org);
                for (OrganizationUser admin : admins) {
                    object = admin;
                    object2 = null;
                    object = object2 = ((OrganizationUser)((Object)object)).getUser();
                    object2 = null;
                    Object object4 = object2 = ((User)object).getEmail();
                    object = admin;
                    object2 = null;
                    object = object2 = ((OrganizationUser)((Object)object)).getUser();
                    object2 = null;
                    object2 = ((User)object).getName();
                    email.addBcc((String)object4, (String)object2);
                }
            }
            Object[] objectArray3 = new Object[2];
            object = pt;
            object2 = null;
            object = object2 = ((ProjectTransfer)object).getProject();
            object2 = null;
            objectArray3[0] = object2 = ((Project)object).getName();
            object = pt;
            object2 = null;
            object = object2 = ((ProjectTransfer)object).getSender();
            object2 = null;
            objectArray3[1] = object2 = ((User)object).getLoginId();
            email.setSubject(String.format("[%s] @%s wants to transfer project", objectArray3));
            email.setHtmlMsg(Markdown.render(message));
            email.setTextMsg(message);
            email.setCharset("utf-8");
            email.addHeader("References", "<" + acceptUrl + "@" + Config.getHostname() + ">");
            object = pt;
            object2 = null;
            object2 = ((ProjectTransfer)object).getRequested();
            email.setSentDate((Date)object2);
            Mailer.send((Email)email);
            String escapedTitle = email.getSubject().replace("\"", "\\\"");
            String logEntry = String.format("\"%s\" %s", escapedTitle, email.getBccAddresses());
            Logger.of((String)"mail").info(logEntry);
        }
        catch (Exception e) {
            Logger.warn((String)("Failed to send a notification: " + email + "\n" + ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    private static void addCodeCommenters(String commitId, Long projectId, List<User> userList2) {
        Project project2 = (Project)Project.find.byId((Object)projectId);
        Object object = project2;
        Object object2 = null;
        object2 = ((Project)object).getVcs();
        if ("GIT".equals(object2)) {
            List comments = ReviewComment.find.fetch("thread").where().eq("thread.commitId", (Object)commitId).eq("thread.project", (Object)project2).eq("thread.pullRequest", null).findList();
            for (ReviewComment comment : comments) {
                object = comment;
                object2 = null;
                object = object2 = ((ReviewComment)object).getAuthor();
                object2 = null;
                object2 = ((UserIdent)object).getLoginId();
                User commentAuthor = User.findByLoginId((String)object2);
                if (userList2.contains(commentAuthor)) {
                    userList2.remove(commentAuthor);
                }
                userList2.add(commentAuthor);
            }
        } else {
            List comments = CommitComment.find.where().eq("commitId", (Object)commitId).eq("project.id", (Object)projectId).findList();
            for (CommitComment codeComment : comments) {
                object = codeComment;
                object2 = null;
                object2 = ((CodeComment)object).getAuthorLoginId();
                User commentAuthor = User.findByLoginId((String)object2);
                if (userList2.contains(commentAuthor)) {
                    userList2.remove(commentAuthor);
                }
                userList2.add(commentAuthor);
            }
        }
        Collections.reverse(userList2);
    }

    private static void addCommitAuthor(Commit commit, List<User> userList2) {
        User authorByEmail;
        if (!commit.getAuthor().isAnonymous() && !userList2.contains(commit.getAuthor())) {
            userList2.add(commit.getAuthor());
        }
        if (commit.getAuthorEmail() != null && !(authorByEmail = User.findByLoginId(commit.getAuthorEmail().substring(0, commit.getAuthorEmail().lastIndexOf("@")))).isAnonymous() && !userList2.contains(authorByEmail)) {
            userList2.add(authorByEmail);
        }
    }

    private static void collectAuthorAndCommenter(Project project2, Long number, List<User> userList2, String resourceType) {
        AbstractPosting posting;
        switch (ResourceType.getValue(resourceType)) {
            case ISSUE_POST: {
                posting = AbstractPosting.findByNumber(Issue.finder, project2, number);
                break;
            }
            case BOARD_POST: {
                posting = AbstractPosting.findByNumber(Posting.finder, project2, number);
                break;
            }
            default: {
                return;
            }
        }
        if (posting != null) {
            String string;
            Model model;
            for (Comment comment : posting.getComments()) {
                model = comment;
                string = null;
                string = model.getAuthorLoginId();
                User commentUser = User.findByLoginId(string);
                if (userList2.contains(commentUser)) {
                    userList2.remove(commentUser);
                }
                userList2.add(commentUser);
            }
            Collections.reverse(userList2);
            model = posting;
            string = null;
            string = model.getAuthorLoginId();
            User postAuthor = User.findByLoginId(string);
            if (!userList2.contains(postAuthor)) {
                userList2.add(postAuthor);
            }
        }
    }

    private static void collectedUsersToMentionList(List<Map<String, String>> users2, List<User> userList2) {
        for (User user : userList2) {
            HashMap<String, String> projectUserMap = new HashMap<String, String>();
            if (user == null) continue;
            User user2 = user;
            String string = null;
            string = user2.getLoginId();
            if (!StringUtils.isNotEmpty((CharSequence)string)) continue;
            user2 = user;
            string = null;
            string = user2.getLoginId();
            if (string.equals("admin")) continue;
            user2 = user;
            string = null;
            string = user2.getLoginId();
            projectUserMap.put("loginid", string);
            user2 = user;
            string = null;
            string = user2.getName();
            StringBuilder stringBuilder = new StringBuilder().append(string).append(user.getDisplayName());
            user2 = user;
            string = null;
            string = user2.getLoginId();
            projectUserMap.put("searchText", stringBuilder.append(string).toString());
            projectUserMap.put("name", user.getDisplayName());
            projectUserMap.put("image", user.avatarUrl());
            users2.add(projectUserMap);
        }
    }

    private static void addSearchedUsers(String query, List<User> userList2) {
        for (User user : User.findUsers(0, query, UserState.ACTIVE).getList()) {
            if (userList2.contains(user)) continue;
            userList2.add(user);
        }
    }

    private static void addProjectMemberList(Project project2, List<User> userList2) {
        Model model = project2;
        Object object = null;
        object = model.getProjectUser();
        Iterator<ProjectUser> iterator = object.iterator();
        while (iterator.hasNext()) {
            ProjectUser projectUser = iterator.next();
            model = projectUser;
            object = null;
            object = model.getUser();
            if (userList2.contains(object)) continue;
            model = projectUser;
            object = null;
            object = model.getUser();
            userList2.add((User)object);
        }
    }

    private static void addGroupMemberList(Project project2, List<User> userList2) {
        if (!project2.hasGroup()) {
            return;
        }
        Model model = project2;
        Object object = null;
        object = model.getOrganization();
        model = object;
        object = null;
        object = model.getUsers();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            OrganizationUser organizationUser = (OrganizationUser)((Object)iterator.next());
            model = organizationUser;
            object = null;
            object = model.getUser();
            if (userList2.contains(object)) continue;
            model = organizationUser;
            object = null;
            object = model.getUser();
            userList2.add((User)object);
        }
    }

    private static void addProjectAuthorsAndWatchersList(Project project2, List<User> userList2) {
        if (project2 == null) {
            return;
        }
        for (User user : project2.findAuthorsAndWatchers()) {
            if (userList2.contains(user)) continue;
            userList2.add(user);
        }
    }

    private static void addSharers(Project project2, Long number, List<User> userList2, String resourceType) {
        Issue issue2;
        if (project2 == null) {
            return;
        }
        switch (ResourceType.getValue(resourceType)) {
            case ISSUE_POST: {
                issue2 = Issue.findByNumber(Issue.finder, project2, number);
                break;
            }
            default: {
                return;
            }
        }
        if (issue2 != null) {
            Model model = issue2;
            Object object = null;
            object = model.getSharers();
            Iterator<IssueSharer> iterator = object.iterator();
            while (iterator.hasNext()) {
                IssueSharer issueSharer = iterator.next();
                model = issueSharer;
                object = null;
                object = model.getUser();
                if (userList2.contains(object)) continue;
                model = issueSharer;
                object = null;
                object = model.getUser();
                userList2.add((User)object);
            }
        }
    }

    @Transactional
    @With(value={DefaultProjectCheckAction.class})
    @IsAllowed(value=Operation.UPDATE)
    public static Result newMember(String ownerId, String projectName) {
        Project project2;
        Form addMemberForm = Form.form(User.class).bindFromRequest(new String[0]);
        User newMember2 = User.findByLoginId(addMemberForm.field("loginId").value());
        if (ProjectApp.isErrorOnAddMemberForm(newMember2, project2 = Project.findByOwnerAndProjectName(ownerId, projectName), (Form<User>)addMemberForm)) {
            if (HttpUtil.isJSONPreferred(ProjectApp.request()).booleanValue()) {
                return ProjectApp.badRequest((JsonNode)addMemberForm.errorsAsJson());
            }
            List errors = (List)addMemberForm.errors().get("loginId");
            ProjectApp.flash((String)"warning", (String)((ValidationError)errors.get(errors.size() - 1)).message());
            return ProjectApp.redirect((Call)routes.ProjectApp.members(ownerId, projectName));
        }
        Model model = newMember2;
        Long l = null;
        Long l2 = l = model.getId();
        model = project2;
        l = null;
        l = model.getId();
        ProjectUser.assignRole(l2, l, RoleType.MEMBER);
        project2.cleanEnrolledUsers();
        NotificationEvent.afterMemberRequest(project2, newMember2, RequestState.ACCEPT);
        if (HttpUtil.isJSONPreferred(ProjectApp.request()).booleanValue()) {
            return ProjectApp.ok((String)"{}");
        }
        Watch.watch(newMember2, project2.asResource());
        return ProjectApp.redirect((Call)routes.ProjectApp.members(ownerId, projectName));
    }

    private static boolean isErrorOnAddMemberForm(User user, Project project2, Form<User> addMemberForm) {
        if (addMemberForm.hasErrors()) {
            addMemberForm.reject("loginId", "project.members.addMember");
        } else if (!AccessControl.isAllowed(UserApp.currentUser(), project2.asResource(), Operation.UPDATE)) {
            addMemberForm.reject("loginId", "project.member.isManager");
        } else if (user.isAnonymous()) {
            addMemberForm.reject("loginId", "project.member.notExist");
        } else if (user.isMemberOf(project2)) {
            addMemberForm.reject("loginId", "project.member.alreadyMember");
        }
        return addMemberForm.hasErrors();
    }

    private static Result okWithLocation(String location) {
        ObjectNode result2 = Json.newObject();
        result2.put("location", location);
        return ProjectApp.ok((JsonNode)result2);
    }

    @Transactional
    @With(value={DefaultProjectCheckAction.class})
    public static Result deleteMember(String ownerId, String projectName, Long userId) {
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        User deleteMember2 = (User)User.find.byId((Object)userId);
        Model model = UserApp.currentUser();
        Object object = null;
        object = model.getId();
        if (!((Long)object).equals(userId) && !AccessControl.isAllowed(UserApp.currentUser(), project2.asResource(), Operation.UPDATE)) {
            return ProjectApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2));
        }
        if (project2.isOwner(deleteMember2)) {
            return ProjectApp.forbidden((Content)ErrorViews.Forbidden.render("project.member.ownerCannotLeave", project2));
        }
        model = project2;
        object = null;
        object = model.getId();
        ProjectUser.delete(userId, (Long)object);
        model = UserApp.currentUser();
        object = null;
        object = model.getId();
        if (((Long)object).equals(userId)) {
            if (AccessControl.isAllowed(UserApp.currentUser(), project2.asResource(), Operation.READ)) {
                model = project2;
                object = null;
                Object object2 = object = model.getOwner();
                model = project2;
                object = null;
                object = model.getName();
                return ProjectApp.okWithLocation(routes.ProjectApp.project((String)object2, (String)object).url());
            }
            return ProjectApp.okWithLocation(routes.Application.index().url());
        }
        return ProjectApp.okWithLocation(routes.ProjectApp.members(ownerId, projectName).url());
    }

    @Transactional
    @IsAllowed(value=Operation.UPDATE)
    public static Result editMember(String ownerId, String projectName, Long userId) {
        User editMember2;
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        if (project2.isOwner(editMember2 = (User)User.find.byId((Object)userId))) {
            return ProjectApp.badRequest((Content)ErrorViews.Forbidden.render("project.member.ownerMustBeAManager", project2));
        }
        Model model = project2;
        Long l = null;
        Long l2 = l = model.getId();
        model = (Role)((Object)Form.form(Role.class).bindFromRequest(new String[0]).get());
        l = null;
        l = model.getId();
        ProjectUser.assignRole(userId, l2, l);
        return ProjectApp.status((int)204);
    }

    @GuestProhibit
    public static Result projects(String query, int pageNum) {
        if (Application.HIDE_PROJECT_LISTING) {
            return ProjectApp.forbidden((Content)ErrorViews.Forbidden.render("error.auth.unauthorized.waringMessage"));
        }
        String prefer = HttpUtil.getPreferType(ProjectApp.request(), HTML, JSON);
        if (prefer == null) {
            return ProjectApp.status((int)406);
        }
        ProjectApp.response().setHeader("Vary", "Accept");
        if (prefer.equals(JSON)) {
            return ProjectApp.getProjectsToJSON(query);
        }
        return ProjectApp.getPagingProjects(query, pageNum);
    }

    private static Result getPagingProjects(String query, int pageNum) {
        if (pageNum < 1) {
            return ProjectApp.notFound((Content)ErrorViews.NotFound.render("error.notfound"));
        }
        ExpressionList<Project> el = ProjectApp.createProjectSearchExpressionList(query);
        Set<Long> labelIds = LabelApp.getLabelIds(ProjectApp.request());
        if (CollectionUtils.isNotEmpty(labelIds)) {
            el.in("labels.id", labelIds);
        }
        el.orderBy("createdDate desc");
        Page<Project> projects2 = ProjectApp.getProjectPage(pageNum, el);
        return ProjectApp.ok((Content)list.render("title.projectList", projects2, query));
    }

    private static Page<Project> getProjectPage(int pageNum, ExpressionList<Project> el) {
        return el.findPagingList(10).getPage(pageNum - 1);
    }

    private static Result getProjectsToJSON(String query) {
        ExpressionList<Project> el = ProjectApp.createProjectSearchExpressionList(query);
        int total = el.findRowCount();
        if (total > 1000) {
            el.setMaxRows(1000);
            ProjectApp.response().setHeader("Content-Range", "items 1000/" + total);
        }
        ArrayList<String> projectNames = new ArrayList<String>();
        Iterator iterator = el.findList().iterator();
        while (iterator.hasNext()) {
            Project project2;
            Project project3 = project2 = (Project)iterator.next();
            String string = null;
            string = project3.getOwner();
            StringBuilder stringBuilder = new StringBuilder().append(string).append("/");
            project3 = project2;
            string = null;
            string = project3.getName();
            projectNames.add(stringBuilder.append(string).toString());
        }
        return ProjectApp.ok((JsonNode)Json.toJson(projectNames));
    }

    private static ExpressionList<Project> createProjectSearchExpressionList(String query) {
        User user;
        ExpressionList el = Project.find.where();
        if (StringUtils.isNotBlank((CharSequence)query)) {
            Junction junction = el.disjunction();
            junction.icontains("owner", query).icontains("name", query).icontains("overview", query);
            List ids = Project.find.where().icontains("labels.name", query).findIds();
            if (!ids.isEmpty()) {
                junction.idIn(ids);
            }
            junction.endJunction();
        }
        if (!(user = UserApp.currentUser()).isSiteManager() && !Config.displayPrivateRepositories()) {
            el.eq("projectScope", (Object)ProjectScope.PUBLIC);
        }
        return el;
    }

    @IsAllowed(value=Operation.READ)
    public static Result labels(String ownerId, String projectName) {
        if (!ProjectApp.request().accepts(JSON)) {
            return ProjectApp.status((int)406);
        }
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        HashMap<Long, Map<String, String>> labels2 = new HashMap<Long, Map<String, String>>();
        Iterator<Label> iterator = project2.labels.iterator();
        while (iterator.hasNext()) {
            Label label;
            Label label2 = label = iterator.next();
            Long l = null;
            l = label2.getId();
            labels2.put(l, ProjectApp.convertToMap(label));
        }
        return ProjectApp.ok((JsonNode)Json.toJson(labels2));
    }

    private static Map<String, String> convertToMap(Label label) {
        HashMap<String, String> tagMap = new HashMap<String, String>();
        Label label2 = label;
        String string = null;
        string = label2.getCategory();
        tagMap.put("category", string);
        label2 = label;
        string = null;
        string = label2.getName();
        tagMap.put("name", string);
        return tagMap;
    }

    @Transactional
    @With(value={DefaultProjectCheckAction.class})
    public static Result attachLabel(String ownerId, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        if (!AccessControl.isAllowed(UserApp.currentUser(), project2.labelsAsResource(), Operation.UPDATE)) {
            return ProjectApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2));
        }
        Map data2 = ProjectApp.request().body().asFormUrlEncoded();
        String category2 = HttpUtil.getFirstValueFromQuery(data2, "category");
        String name = HttpUtil.getFirstValueFromQuery(data2, "name");
        if (StringUtils.isEmpty((CharSequence)name)) {
            return ProjectApp.badRequest((Content)ErrorViews.BadRequest.render("Label name is missing.", project2));
        }
        Label label = (Label)Label.find.where().eq("category", (Object)category2).eq("name", (Object)name).findUnique();
        boolean isCreated = false;
        if (label == null) {
            label = new Label(category2, name);
            label.save();
            isCreated = true;
        }
        Boolean isAttached = project2.attachLabel(label);
        if (isCreated && !isAttached.booleanValue()) {
            Logger.warn((String)("A label '" + label + "' is created but failed to attach to project '" + project2 + "'."));
        }
        if (isAttached.booleanValue()) {
            HashMap<Long, Map<String, String>> labels2 = new HashMap<Long, Map<String, String>>();
            Label label2 = label;
            Long l = null;
            l = label2.getId();
            labels2.put(l, ProjectApp.convertToMap(label));
            if (isCreated) {
                return ProjectApp.created((JsonNode)Json.toJson(labels2));
            }
            return ProjectApp.ok((JsonNode)Json.toJson(labels2));
        }
        return ProjectApp.status((int)204);
    }

    @Transactional
    @With(value={DefaultProjectCheckAction.class})
    public static Result detachLabel(String ownerId, String projectName, Long id) {
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        if (!AccessControl.isAllowed(UserApp.currentUser(), project2.labelsAsResource(), Operation.UPDATE)) {
            return ProjectApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2));
        }
        Map data2 = ProjectApp.request().body().asFormUrlEncoded();
        if (!HttpUtil.getFirstValueFromQuery(data2, "_method").toLowerCase().equals("delete")) {
            return ProjectApp.badRequest((Content)ErrorViews.BadRequest.render("_method must be 'delete'.", project2));
        }
        Label tag = (Label)Label.find.byId((Object)id);
        if (tag == null) {
            return ProjectApp.notFound((Content)ErrorViews.NotFound.render("error.notfound"));
        }
        project2.detachLabel(tag);
        return ProjectApp.status((int)204);
    }

    @IsAllowed(value=Operation.UPDATE)
    public static Result webhooks(String ownerId, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        if (project2 == null) {
            return ProjectApp.notFound((Content)ErrorViews.NotFound.render("error.notfound"));
        }
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        return ProjectApp.ok((Content)webhooks.render("project.webhook", Webhook.findByProject(l), project2));
    }

    @Transactional
    @IsAllowed(value=Operation.UPDATE)
    public static Result newWebhook(String ownerId, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        if (project2 == null) {
            return ProjectApp.notFound((Content)ErrorViews.NotFound.render("error.notfound"));
        }
        Form addNewWebhookForm = Form.form(Webhook.class).bindFromRequest(new String[0]);
        if (addNewWebhookForm == null) {
            Logger.warn((String)"Failed creating webhook: got null form from newWebhook request");
            return ProjectApp.badRequest((String)"Failed creating webhook: got null form from newWebhook request");
        }
        if (addNewWebhookForm.hasErrors()) {
            return ProjectApp.badRequest((Content)ErrorViews.BadRequest.render(addNewWebhookForm.errorsAsJson().toString()));
        }
        ProjectApp.createWebhook(project2, (Form<Webhook>)addNewWebhookForm);
        Project project3 = project2;
        String string = null;
        String string2 = string = project3.getOwner();
        project3 = project2;
        string = null;
        string = project3.getName();
        return ProjectApp.redirect((Call)routes.ProjectApp.webhooks(string2, string));
    }

    private static void createWebhook(Project project2, Form<Webhook> forms) {
        Webhook webhook = (Webhook)forms.get();
        Object object = project2;
        Webhook webhook2 = webhook;
        webhook2.setProject((Project)object);
        webhook2 = webhook;
        object = null;
        object = webhook2.getGitPush();
        if (object == null) {
            object = false;
            webhook2 = webhook;
            webhook2.setGitPush((Boolean)object);
        }
        object = new Date();
        webhook2 = webhook;
        webhook2.setCreatedAt((Date)object);
        webhook.save();
    }

    @Transactional
    @IsAllowed(value=Operation.UPDATE)
    public static Result deleteWebhook(String ownerId, String projectName, Long id) {
        Webhook webhook = (Webhook)Webhook.find.byId((Object)id);
        if (webhook != null) {
            webhook.delete();
            return ProjectApp.ok();
        }
        return ProjectApp.notFound((Content)ErrorViews.NotFound.render("error.notfound"));
    }

    @Transactional
    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsAllowed(value=Operation.DELETE)
    public static Result deletePushedBranch(String ownerId, String projectName, Long id) {
        PushedBranch pushedBranch = (PushedBranch)((Object)PushedBranch.find.byId((Object)id));
        if (pushedBranch != null) {
            pushedBranch.delete();
        }
        return ProjectApp.ok();
    }

    @IsAllowed(value=Operation.READ)
    @Transactional
    public static Result goConventionMenu(String ownerId, String projectName, String state, String format, int pageNum) throws IOException, ServletException, SVNException, GitAPIException, WriteException {
        Project project2 = Project.findByOwnerAndProjectName(ownerId, projectName);
        Object histories = null;
        Model model = project2;
        ProjectMenuSetting projectMenuSetting = null;
        projectMenuSetting = model.getMenuSetting();
        model = projectMenuSetting;
        boolean bl = false;
        bl = model.getIssue();
        if (bl) {
            model = project2;
            String string = null;
            String string2 = string = model.getOwner();
            model = project2;
            string = null;
            string = model.getName();
            return IssueApp.issues(string2, string, state, format, pageNum);
        }
        model = project2;
        ProjectMenuSetting projectMenuSetting2 = null;
        projectMenuSetting2 = model.getMenuSetting();
        model = projectMenuSetting2;
        boolean bl2 = false;
        bl2 = model.getBoard();
        if (bl2) {
            model = project2;
            String string = null;
            String string3 = string = model.getOwner();
            model = project2;
            string = null;
            string = model.getName();
            return ProjectApp.redirect((Call)routes.BoardApp.posts(string3, string, pageNum));
        }
        model = project2;
        String string = null;
        String string4 = string = model.getOwner();
        model = project2;
        string = null;
        string = model.getName();
        return ProjectApp.redirect((Call)routes.ProjectApp.project(string4, string));
    }
}

