/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import actors.PullRequestMergingActor;
import akka.actor.Props;
import com.avaje.ebean.Page;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AbstractPostingApp;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.annotation.IsAllowed;
import controllers.annotation.IsCreatable;
import controllers.annotation.IsOnlyGitAvailable;
import controllers.routes;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import models.CodeCommentThread;
import models.CodeRange;
import models.CommentThread;
import models.NonRangedCodeCommentThread;
import models.NotificationEvent;
import models.Organization;
import models.OrganizationUser;
import models.Project;
import models.ProjectMenuSetting;
import models.ProjectUser;
import models.PullRequest;
import models.PullRequestEvent;
import models.PullRequestEventMessage;
import models.PullRequestMergeResult;
import models.PushedBranch;
import models.ReviewComment;
import models.User;
import models.UserIdent;
import models.enumeration.EventType;
import models.enumeration.Operation;
import models.enumeration.ProjectScope;
import models.enumeration.ResourceType;
import models.enumeration.RoleType;
import models.enumeration.State;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.tmatesoft.svn.core.SVNException;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.libs.Akka;
import play.libs.F;
import play.libs.Json;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Result;
import play.mvc.Results;
import play.twirl.api.Content;
import playRepository.GitBranch;
import playRepository.GitRepository;
import playRepository.RepositoryService;
import utils.AccessControl;
import utils.ErrorViews;
import utils.HttpUtil;
import utils.JodaDateUtil;
import utils.MenuType;
import utils.ValidationUtils;
import views.html.error.notfound;
import views.html.git.clone;
import views.html.git.create;
import views.html.git.edit;
import views.html.git.fork;
import views.html.git.list;
import views.html.git.partial_merge_result;
import views.html.git.partial_search;
import views.html.git.partial_state;
import views.html.git.view;
import views.html.git.viewChanges;

@IsOnlyGitAvailable
@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class PullRequestApp
extends Controller {
    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsCreatable(value=ResourceType.FORK)
    public static Result newFork(String userName, String projectName, String forkOwner) {
        String destination = PullRequestApp.findDestination(forkOwner);
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        User user = UserApp.currentUser();
        Long l = null;
        l = user.getId();
        List<OrganizationUser> orgUserList = OrganizationUser.findByAdmin(l);
        List<Project> forkedProjects = Project.findByOwnerAndOriginalProject(destination, project2);
        Project forkProject = Project.copy(project2, destination);
        return PullRequestApp.ok((Content)fork.render("fork", project2, forkProject, forkedProjects, (Form<Project>)new Form(Project.class), orgUserList));
    }

    private static String findDestination(String forkOwner) {
        Organization organization2 = Organization.findByName(forkOwner);
        if (UserApp.currentUser().isAdminOf(organization2)) {
            return forkOwner;
        }
        User user = UserApp.currentUser();
        String string = null;
        string = user.getLoginId();
        return string;
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsCreatable(value=ResourceType.FORK)
    public static Result fork(String userName, String projectName) {
        Project projectForm;
        Form forkProjectForm = new Form(Project.class).bindFromRequest(new String[0]);
        Project project2 = projectForm = (Project)forkProjectForm.get();
        Object object = null;
        object = project2.getOwner();
        String destination = PullRequestApp.findDestination(object);
        Project originalProject = Project.findByOwnerAndProjectName(userName, projectName);
        project2 = projectForm;
        object = null;
        object = project2.getName();
        if (Project.exists(destination, object)) {
            PullRequestApp.flash((String)"warning", (String)"project.name.duplicate");
            forkProjectForm.reject("name");
            project2 = originalProject;
            object = null;
            String string = object = project2.getOwner();
            project2 = originalProject;
            object = null;
            object = project2.getName();
            return PullRequestApp.redirect((Call)routes.PullRequestApp.newFork(string, (String)object, destination));
        }
        Project forkProject = Project.copy(originalProject, destination);
        project2 = projectForm;
        object = null;
        object = project2.getName();
        project2 = forkProject;
        project2.setName((String)object);
        project2 = projectForm;
        object = null;
        object = project2.getProjectScope();
        project2 = forkProject;
        project2.setProjectScope((ProjectScope)((Object)object));
        originalProject.addFork(forkProject);
        return PullRequestApp.ok((Content)clone.render("fork", forkProject));
    }

    @Transactional
    @IsCreatable(value=ResourceType.FORK)
    public static Result doClone(String userName, String projectName) {
        Form form = new Form(Project.class).bindFromRequest(new String[0]);
        Project projectForm = (Project)form.get();
        Model model = projectForm;
        Object object = null;
        object = model.getOwner();
        String destination = PullRequestApp.findDestination(object);
        String status = "status";
        String failed = "failed";
        String url = "url";
        ObjectNode result2 = Json.newObject();
        Project originalProject = Project.findByOwnerAndProjectName(userName, projectName);
        if (originalProject == null) {
            result2.put(status, failed);
            result2.put(url, routes.Application.index().url());
            return PullRequestApp.ok((JsonNode)result2);
        }
        User currentUser = UserApp.currentUser();
        if (!AccessControl.isProjectResourceCreatable(currentUser, originalProject, ResourceType.FORK)) {
            result2.put(status, failed);
            result2.put(url, routes.UserApp.loginForm().url());
            return PullRequestApp.ok((JsonNode)result2);
        }
        Project forkProject = Project.copy(originalProject, destination);
        model = projectForm;
        object = null;
        object = model.getName();
        model = forkProject;
        model.setName((String)object);
        model = projectForm;
        object = null;
        object = model.getProjectScope();
        model = forkProject;
        model.setProjectScope((ProjectScope)((Object)object));
        if (Organization.isNameExist(destination)) {
            object = Organization.findByName(destination);
            model = forkProject;
            model.setOrganization((Organization)object);
        }
        originalProject.addFork(forkProject);
        try {
            GitRepository.cloneLocalRepository(originalProject, forkProject);
            Long projectId = Project.create(forkProject);
            model = currentUser;
            object = null;
            object = model.getId();
            ProjectUser.assignRole((Long)object, projectId, RoleType.MANAGER);
            result2.put(status, "success");
            model = forkProject;
            object = null;
            Object object2 = object = model.getOwner();
            model = forkProject;
            object = null;
            object = model.getName();
            result2.put(url, routes.ProjectApp.project((String)object2, (String)object).url());
            return PullRequestApp.ok((JsonNode)result2);
        }
        catch (Exception e) {
            Logger.error((String)MessageFormat.format("Failed to fork \"{0}\"", originalProject), (Throwable)e);
            result2.put(status, failed);
            model = originalProject;
            object = null;
            Object object3 = object = model.getOwner();
            model = originalProject;
            object = null;
            object = model.getName();
            result2.put(url, routes.PullRequestApp.pullRequests((String)object3, (String)object).url());
            return PullRequestApp.ok((JsonNode)result2);
        }
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsCreatable(value=ResourceType.FORK)
    public static Result newPullRequestForm(String userName, String projectName) throws IOException, GitAPIException {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        ValidationResult validation = PullRequestApp.validateBeforePullRequest(project2);
        if (validation.hasError()) {
            return validation.getResult();
        }
        List<Project> projects2 = project2.getAssociationProjects();
        Project fromProject = PullRequestApp.getSelectedProject(project2, PullRequestApp.request().getQueryString("fromProjectId"), false);
        Project toProject = PullRequestApp.getSelectedProject(project2, PullRequestApp.request().getQueryString("toProjectId"), true);
        List<GitBranch> fromBranches = new GitRepository(fromProject).getBranches();
        List<GitBranch> toBranches = new GitRepository(toProject).getBranches();
        if (fromBranches.isEmpty()) {
            return PullRequestApp.badRequest((Content)ErrorViews.BadRequest.render("error.pullRequest.empty.from.repository", fromProject, MenuType.PULL_REQUEST));
        }
        if (toBranches.isEmpty()) {
            return PullRequestApp.badRequest((Content)ErrorViews.BadRequest.render("error.pullRequest.empty.to.repository", toProject));
        }
        PullRequest pullRequest2 = PullRequest.createNewPullRequest(fromProject, toProject, (String)StringUtils.defaultIfBlank((CharSequence)PullRequestApp.request().getQueryString("fromBranch"), (CharSequence)fromBranches.get(0).getName()), (String)StringUtils.defaultIfBlank((CharSequence)PullRequestApp.request().getQueryString("toBranch"), (CharSequence)project2.defaultBranch()));
        return PullRequestApp.ok((Content)create.render("title.newPullRequest", (Form<PullRequest>)new Form(PullRequest.class).fill((Object)pullRequest2), project2, projects2, fromProject, toProject, fromBranches, toBranches, pullRequest2));
    }

    private static Project getSelectedProject(Project project2, String projectId, boolean isToProject) {
        Project selectedProject = project2;
        if (isToProject && project2.isForkedFromOrigin()) {
            Project project3 = project2;
            Model model = null;
            project3 = model = project3.getOriginalProject();
            model = null;
            project3 = model = project3.getMenuSetting();
            boolean bl = false;
            bl = ((ProjectMenuSetting)((Object)project3)).getCode();
            if (bl) {
                project3 = project2;
                Model model2 = null;
                project3 = model2 = project3.getOriginalProject();
                model2 = null;
                project3 = model2 = project3.getMenuSetting();
                boolean bl2 = false;
                bl2 = ((ProjectMenuSetting)((Object)project3)).getPullRequest();
                if (bl2) {
                    project3 = project2;
                    Project project4 = null;
                    selectedProject = project4 = project3.getOriginalProject();
                }
            }
        }
        if (StringUtils.isNumeric((CharSequence)projectId)) {
            selectedProject = (Project)Project.find.byId((Object)Long.parseLong(projectId));
        }
        return selectedProject;
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsCreatable(value=ResourceType.FORK)
    public static Result mergeResult(String userName, String projectName) throws IOException, GitAPIException {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        ValidationResult validation = PullRequestApp.validateBeforePullRequest(project2);
        if (validation.hasError()) {
            return validation.getResult();
        }
        Project fromProject = PullRequestApp.getSelectedProject(project2, PullRequestApp.request().getQueryString("fromProjectId"), false);
        Project toProject = PullRequestApp.getSelectedProject(project2, PullRequestApp.request().getQueryString("toProjectId"), true);
        List<GitBranch> fromBranches = new GitRepository(fromProject).getBranches();
        List<GitBranch> toBranches = new GitRepository(toProject).getBranches();
        PullRequest pullRequest2 = PullRequest.createNewPullRequest(fromProject, toProject, (String)StringUtils.defaultIfBlank((CharSequence)PullRequestApp.request().getQueryString("fromBranch"), (CharSequence)fromBranches.get(0).getName()), (String)StringUtils.defaultIfBlank((CharSequence)PullRequestApp.request().getQueryString("toBranch"), (CharSequence)toBranches.get(0).getName()));
        PullRequestMergeResult mergeResult2 = pullRequest2.getPullRequestMergeResult();
        PullRequestApp.response().setHeader("Cache-Control", "no-cache, no-store");
        return PullRequestApp.ok((Content)partial_merge_result.render(project2, pullRequest2, mergeResult2.getGitCommits(), mergeResult2.conflicts()));
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsCreatable(value=ResourceType.FORK)
    public static Result newPullRequest(String userName, String projectName) throws IOException, GitAPIException {
        PullRequestCreationResult result2 = PullRequestApp.createPullRequest(userName, projectName);
        result2.runMergingActor();
        return result2.result;
    }

    @Transactional
    private static PullRequestCreationResult createPullRequest(String userName, String projectName) throws IOException, GitAPIException {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        ValidationResult validation = PullRequestApp.validateBeforePullRequest(project2);
        if (validation.hasError()) {
            return new PullRequestCreationResult(validation.getResult(), null);
        }
        Form form = new Form(PullRequest.class).bindFromRequest(new String[0]);
        PullRequestApp.validateForm((Form<PullRequest>)form);
        if (form.hasErrors()) {
            List<GitBranch> fromBranches = new GitRepository(project2).getBranches();
            Project project3 = project2;
            Project project4 = null;
            project4 = project3.getOriginalProject();
            List<GitBranch> toBranches = new GitRepository(project4).getBranches();
            return new PullRequestCreationResult((Result)PullRequestApp.ok((Content)create.render("title.newPullRequest", (Form<PullRequest>)new Form(PullRequest.class), project2, null, null, null, fromBranches, toBranches, null)), null);
        }
        PullRequest pullRequest2 = (PullRequest)form.get();
        Object object = pullRequest2;
        Object object2 = null;
        object2 = ((PullRequest)object).getBody();
        if (object2 == null) {
            return new PullRequestCreationResult((Result)PullRequestApp.status((int)413, (Content)ErrorViews.RequestTextEntityTooLarge.render()), null);
        }
        object2 = JodaDateUtil.now();
        object = pullRequest2;
        ((PullRequest)object).setCreated((Date)object2);
        object2 = UserApp.currentUser();
        object = pullRequest2;
        ((PullRequest)object).setContributor((User)object2);
        object = pullRequest2;
        object2 = null;
        object2 = ((PullRequest)object).getToProjectId();
        object2 = (Project)Project.find.byId(object2);
        object = pullRequest2;
        ((PullRequest)object).setToProject((Project)object2);
        object = pullRequest2;
        object2 = null;
        object2 = ((PullRequest)object).getFromProjectId();
        object2 = (Project)Project.find.byId(object2);
        object = pullRequest2;
        ((PullRequest)object).setFromProject((Project)object2);
        object2 = false;
        object = pullRequest2;
        ((PullRequest)object).setIsMerging((Boolean)object2);
        object2 = false;
        object = pullRequest2;
        ((PullRequest)object).setIsConflict((Boolean)object2);
        PullRequest sentRequest = PullRequest.findDuplicatedPullRequest(pullRequest2);
        if (sentRequest != null) {
            object = pullRequest2;
            object2 = null;
            object = object2 = ((PullRequest)object).getToProject();
            object2 = null;
            Object object3 = object2 = ((Project)object).getOwner();
            object = pullRequest2;
            object2 = null;
            object = object2 = ((PullRequest)object).getToProject();
            object2 = null;
            Object object4 = object2 = ((Project)object).getName();
            object = sentRequest;
            object2 = null;
            object2 = ((PullRequest)object).getNumber();
            return new PullRequestCreationResult(PullRequestApp.redirect((Call)routes.PullRequestApp.pullRequest((String)object3, (String)object4, (Long)object2)), null);
        }
        pullRequest2.save();
        PushedBranch.removeByPullRequestFrom(pullRequest2);
        AbstractPostingApp.attachUploadFilesToPost(pullRequest2.asResource());
        object = pullRequest2;
        object2 = null;
        object = object2 = ((PullRequest)object).getToProject();
        object2 = null;
        Object object5 = object2 = ((Project)object).getOwner();
        object = pullRequest2;
        object2 = null;
        object = object2 = ((PullRequest)object).getToProject();
        object2 = null;
        Object object6 = object2 = ((Project)object).getName();
        object = pullRequest2;
        object2 = null;
        object2 = ((PullRequest)object).getNumber();
        play.api.mvc.Call pullRequestCall = routes.PullRequestApp.pullRequest((String)object5, (String)object6, (Long)object2);
        NotificationEvent notiEvent = NotificationEvent.afterNewPullRequest(pullRequest2);
        PullRequestEvent.addFromNotificationEvent(notiEvent, pullRequest2);
        object = notiEvent;
        object2 = null;
        object2 = ((NotificationEvent)object).getEventType();
        PullRequestEventMessage message = new PullRequestEventMessage(UserApp.currentUser(), PullRequestApp.request(), pullRequest2, (EventType)((Object)object2));
        return new PullRequestCreationResult(PullRequestApp.redirect((Call)pullRequestCall), message);
    }

    private static void validateForm(Form<PullRequest> form) {
        Map data2 = form.data();
        ValidationUtils.rejectIfEmpty(PullRequestApp.flash(), (String)data2.get("fromBranch"), "pullRequest.fromBranch.required");
        ValidationUtils.rejectIfEmpty(PullRequestApp.flash(), (String)data2.get("toBranch"), "pullRequest.toBranch.required");
        ValidationUtils.rejectIfEmpty(PullRequestApp.flash(), (String)data2.get("title"), "pullRequest.title.required");
    }

    @IsAllowed(value=Operation.READ)
    public static Result pullRequests(String userName, String projectName) {
        return PullRequestApp.pullRequests(userName, projectName, Category.OPEN);
    }

    @IsAllowed(value=Operation.READ)
    public static Result closedPullRequests(String userName, String projectName) {
        return PullRequestApp.pullRequests(userName, projectName, Category.CLOSED);
    }

    @IsAllowed(value=Operation.READ)
    public static Result sentPullRequests(String userName, String projectName) {
        return PullRequestApp.pullRequests(userName, projectName, Category.SENT);
    }

    @Transactional
    private static Result pullRequests(String userName, String projectName, Category category2) {
        Project project2;
        Project project3 = project2 = Project.findByOwnerAndProjectName(userName, projectName);
        boolean bl = false;
        bl = project3.getIsCodeAccessibleMemberOnly();
        if (bl && !project2.hasMember(UserApp.currentUser())) {
            return PullRequestApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2));
        }
        SearchCondition condition = (SearchCondition)Form.form(SearchCondition.class).bindFromRequest(new String[0]).get();
        condition.setProject(project2).setCategory(category2);
        Page<PullRequest> page = PullRequest.findPagingList(condition);
        if (HttpUtil.isPJAXRequest(PullRequestApp.request()).booleanValue()) {
            PullRequestApp.response().setHeader("Cache-Control", "no-cache, no-store");
            return PullRequestApp.ok((Content)partial_search.render(project2, page, condition, category2.code));
        }
        return PullRequestApp.ok((Content)list.render(project2, page, condition, category2.code));
    }

    @IsAllowed(value=Operation.READ, resourceType=ResourceType.PULL_REQUEST)
    public static Result pullRequest(String userName, String projectName, long pullRequestNumber) {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        PullRequest pullRequest2 = PullRequest.findOne(project2, pullRequestNumber);
        boolean canDeleteBranch = false;
        boolean canRestoreBranch = false;
        if (pullRequest2.isMerged()) {
            canDeleteBranch = GitRepository.canDeleteFromBranch(pullRequest2);
            canRestoreBranch = GitRepository.canRestoreBranch(pullRequest2);
        }
        UserApp.currentUser().visits(project2);
        return PullRequestApp.ok((Content)view.render(project2, pullRequest2, canDeleteBranch, canRestoreBranch));
    }

    @IsAllowed(value=Operation.READ, resourceType=ResourceType.PULL_REQUEST)
    public static Result pullRequestState(String userName, String projectName, long pullRequestNumber) {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        PullRequest pullRequest2 = PullRequest.findOne(project2, pullRequestNumber);
        boolean canDeleteBranch = false;
        boolean canRestoreBranch = false;
        if (pullRequest2.isMerged()) {
            canDeleteBranch = GitRepository.canDeleteFromBranch(pullRequest2);
            canRestoreBranch = GitRepository.canRestoreBranch(pullRequest2);
        }
        if (HttpUtil.isRequestedWithXHR(PullRequestApp.request()).booleanValue() && !HttpUtil.isPJAXRequest(PullRequestApp.request()).booleanValue()) {
            ObjectNode requestState = Json.newObject();
            requestState.put("id", pullRequestNumber);
            requestState.put("isOpen", pullRequest2.isOpen());
            requestState.put("isClosed", pullRequest2.isClosed());
            requestState.put("isMerged", pullRequest2.isMerged());
            PullRequest pullRequest3 = pullRequest2;
            Boolean bl = null;
            bl = pullRequest3.getIsMerging();
            requestState.put("isMerging", bl);
            pullRequest3 = pullRequest2;
            bl = null;
            bl = pullRequest3.getIsConflict();
            requestState.put("isConflict", bl);
            requestState.put("canDeleteBranch", canDeleteBranch);
            requestState.put("canRestoreBranch", canRestoreBranch);
            requestState.put("html", partial_state.render(project2, pullRequest2, canDeleteBranch, canRestoreBranch).toString());
            return PullRequestApp.ok((JsonNode)requestState);
        }
        return PullRequestApp.ok((Content)partial_state.render(project2, pullRequest2, canDeleteBranch, canRestoreBranch));
    }

    @IsAllowed(value=Operation.READ, resourceType=ResourceType.PULL_REQUEST)
    public static Result pullRequestChanges(String userName, String projectName, long pullRequestNumber) {
        return PullRequestApp.specificChange(userName, projectName, pullRequestNumber, null);
    }

    @IsAllowed(value=Operation.READ, resourceType=ResourceType.PULL_REQUEST)
    public static Result specificChange(String userName, String projectName, long pullRequestNumber, String commitId) {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        PullRequest pullRequest2 = PullRequest.findOne(project2, pullRequestNumber);
        return PullRequestApp.ok((Content)viewChanges.render(project2, pullRequest2, commitId));
    }

    @Transactional
    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsAllowed(value=Operation.ACCEPT, resourceType=ResourceType.PULL_REQUEST)
    public static F.Promise<Result> accept(final String userName, final String projectName, final long pullRequestNumber) {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        final PullRequest pullRequest2 = PullRequest.findOne(project2, pullRequestNumber);
        Object object = true;
        Model model = pullRequest2;
        model.setIsMerging((Boolean)object);
        pullRequest2.update();
        model = pullRequest2;
        object = null;
        object = model.getToBranch();
        final PullRequestEventMessage message = new PullRequestEventMessage(UserApp.currentUser(), PullRequestApp.request(), project2, (String)object);
        model = project2;
        boolean bl = false;
        bl = model.getIsUsingReviewerCount();
        if (bl && !pullRequest2.isReviewed()) {
            return F.Promise.pure((Object)PullRequestApp.badRequest((Content)ErrorViews.BadRequest.render("pullRequest.not.enough.review.point")));
        }
        F.Promise promise = F.Promise.promise((F.Function0)new F.Function0<Void>(){

            public Void apply() throws Exception {
                pullRequest2.merge(message);
                pullRequest2.endMerge();
                pullRequest2.update();
                return null;
            }
        });
        return promise.map((F.Function)new F.Function<Void, Result>(){

            public Result apply(Void v) throws Throwable {
                return Results.redirect((Call)routes.PullRequestApp.pullRequest(userName, projectName, pullRequestNumber));
            }
        });
    }

    private static void addNotification(PullRequest pullRequest2, State from, State to) {
        NotificationEvent notiEvent = NotificationEvent.afterPullRequestUpdated(pullRequest2, from, to);
        PullRequestEvent.addFromNotificationEvent(notiEvent, pullRequest2);
    }

    @Transactional
    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsAllowed(value=Operation.CLOSE, resourceType=ResourceType.PULL_REQUEST)
    public static Result close(String userName, String projectName, Long pullRequestNumber) {
        PullRequest pullRequest2;
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        PullRequest pullRequest3 = pullRequest2 = PullRequest.findOne(project2, pullRequestNumber);
        State state = null;
        State beforeState = state = pullRequest3.getState();
        pullRequest2.close();
        pullRequest2.update();
        play.api.mvc.Call call = routes.PullRequestApp.pullRequest(userName, projectName, pullRequestNumber);
        PullRequestApp.addNotification(pullRequest2, beforeState, State.CLOSED);
        return PullRequestApp.redirect((Call)call);
    }

    @Transactional
    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsAllowed(value=Operation.REOPEN, resourceType=ResourceType.PULL_REQUEST)
    public static Result open(String userName, String projectName, Long pullRequestNumber) {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        PullRequest pullRequest2 = PullRequest.findOne(project2, pullRequestNumber);
        if (pullRequest2.isMerged() || pullRequest2.isOpen()) {
            return PullRequestApp.badRequest((Content)ErrorViews.BadRequest.render());
        }
        PullRequest pullRequest3 = pullRequest2;
        State state = null;
        State beforeState = state = pullRequest3.getState();
        pullRequest2.reopen();
        pullRequest2.update();
        play.api.mvc.Call call = routes.PullRequestApp.pullRequest(userName, projectName, pullRequestNumber);
        PullRequestApp.addNotification(pullRequest2, beforeState, State.OPEN);
        PullRequestEventMessage message = new PullRequestEventMessage(UserApp.currentUser(), PullRequestApp.request(), pullRequest2);
        Akka.system().actorOf(Props.create(PullRequestMergingActor.class, (Object[])new Object[0])).tell((Object)message, null);
        return PullRequestApp.redirect((Call)call);
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsAllowed(value=Operation.UPDATE, resourceType=ResourceType.PULL_REQUEST)
    public static Result editPullRequestForm(String userName, String projectName, Long pullRequestNumber) throws IOException, GitAPIException {
        PullRequest pullRequest2;
        Project toProject = Project.findByOwnerAndProjectName(userName, projectName);
        PullRequest pullRequest3 = pullRequest2 = PullRequest.findOne(toProject, pullRequestNumber);
        Project project2 = null;
        Project fromProject = project2 = pullRequest3.getFromProject();
        Form editForm = new Form(PullRequest.class).fill((Object)pullRequest2);
        pullRequest3 = pullRequest2;
        project2 = null;
        project2 = pullRequest3.getFromProject();
        List<GitBranch> fromBranches = new GitRepository(project2).getBranches();
        pullRequest3 = pullRequest2;
        project2 = null;
        project2 = pullRequest3.getToProject();
        List<GitBranch> toBranches = new GitRepository(project2).getBranches();
        return PullRequestApp.ok((Content)edit.render("title.editPullRequest", (Form<PullRequest>)editForm, fromProject, fromBranches, toBranches, pullRequest2));
    }

    @Transactional
    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsAllowed(value=Operation.UPDATE, resourceType=ResourceType.PULL_REQUEST)
    public static Result editPullRequest(String userName, String projectName, Long pullRequestNumber) {
        PullRequest sentRequest;
        Project toProject = Project.findByOwnerAndProjectName(userName, projectName);
        PullRequest pullRequest2 = PullRequest.findOne(toProject, pullRequestNumber);
        Model model = pullRequest2;
        Object object = null;
        object = model.getFromProject();
        Project fromProject = object;
        Form pullRequestForm = new Form(PullRequest.class).bindFromRequest(new String[0]);
        PullRequest updatedPullRequest = (PullRequest)pullRequestForm.get();
        model = pullRequest2;
        object = null;
        object = model.getBody();
        if (object == null) {
            return PullRequestApp.status((int)413, (Content)ErrorViews.RequestTextEntityTooLarge.render());
        }
        object = toProject;
        model = updatedPullRequest;
        model.setToProject((Project)object);
        object = fromProject;
        model = updatedPullRequest;
        model.setFromProject((Project)object);
        if (!updatedPullRequest.hasSameBranchesWith(pullRequest2) && (sentRequest = PullRequest.findDuplicatedPullRequest(updatedPullRequest)) != null) {
            PullRequestApp.flash((String)"warning", (String)"pullRequest.duplicated");
            model = fromProject;
            object = null;
            Object object2 = object = model.getOwner();
            model = fromProject;
            object = null;
            object = model.getName();
            return PullRequestApp.redirect((Call)routes.PullRequestApp.editPullRequestForm((String)object2, (String)object, pullRequestNumber));
        }
        pullRequest2.updateWith(updatedPullRequest);
        AbstractPostingApp.attachUploadFilesToPost(pullRequest2.asResource());
        model = toProject;
        object = null;
        Object object3 = object = model.getOwner();
        model = toProject;
        object = null;
        Object object4 = object = model.getName();
        model = pullRequest2;
        object = null;
        object = model.getNumber();
        return PullRequestApp.redirect((Call)routes.PullRequestApp.pullRequest((String)object3, (String)object4, (Long)object));
    }

    @Transactional
    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsAllowed(value=Operation.UPDATE, resourceType=ResourceType.PULL_REQUEST)
    public static Result deleteFromBranch(String userName, String projectName, Long pullRequestNumber) {
        Project toProject = Project.findByOwnerAndProjectName(userName, projectName);
        PullRequest pullRequest2 = PullRequest.findOne(toProject, pullRequestNumber);
        pullRequest2.deleteFromBranch();
        Project project2 = toProject;
        String string = null;
        String string2 = string = project2.getOwner();
        project2 = toProject;
        string = null;
        string = project2.getName();
        return PullRequestApp.redirect((Call)routes.PullRequestApp.pullRequest(string2, string, pullRequestNumber));
    }

    @Transactional
    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsAllowed(value=Operation.UPDATE, resourceType=ResourceType.PULL_REQUEST)
    public static Result restoreFromBranch(String userName, String projectName, Long pullRequestNumber) {
        Project toProject = Project.findByOwnerAndProjectName(userName, projectName);
        PullRequest pullRequest2 = PullRequest.findOne(toProject, pullRequestNumber);
        pullRequest2.restoreFromBranch();
        Project project2 = toProject;
        String string = null;
        String string2 = string = project2.getOwner();
        project2 = toProject;
        string = null;
        string = project2.getName();
        return PullRequestApp.redirect((Call)routes.PullRequestApp.pullRequest(string2, string, pullRequestNumber));
    }

    private static ValidationResult validateBeforePullRequest(Project project2) {
        Results.Status result2 = null;
        boolean hasError = false;
        if (ProjectUser.isGuest(project2, UserApp.currentUser())) {
            result2 = PullRequestApp.forbidden((Content)ErrorViews.BadRequest.render("Guest is not allowed this request", project2));
            hasError = true;
        }
        return new ValidationResult((Result)result2, hasError);
    }

    @IsCreatable(value=ResourceType.REVIEW_COMMENT)
    public static Result newComment(String ownerName, String projectName, Long pullRequestId, String commitId) throws IOException, ServletException, SVNException {
        play.api.mvc.Call toView;
        Form codeRangeForm = new Form(CodeRange.class).bindFromRequest(new String[0]);
        Form reviewCommentForm = new Form(ReviewComment.class).bindFromRequest(new String[0]);
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        if (reviewCommentForm.hasErrors()) {
            return PullRequestApp.badRequest((Content)ErrorViews.BadRequest.render("error.validation", project2));
        }
        PullRequest pullRequest2 = PullRequest.findById(pullRequestId);
        if (pullRequest2 == null) {
            return PullRequestApp.notFound((Content)notfound.render("error.notfound", project2, PullRequestApp.request().path()));
        }
        ReviewComment comment = (ReviewComment)reviewCommentForm.get();
        Object object = new UserIdent(UserApp.currentUser());
        Object object2 = comment;
        ((ReviewComment)object2).setAuthor((UserIdent)object);
        object2 = comment;
        object = null;
        object = ((ReviewComment)object2).getThread();
        if (object == null) {
            CommentThread thread;
            if (codeRangeForm.errors().isEmpty()) {
                thread = new CodeCommentThread();
                if (commitId != null) {
                    object = commitId;
                    object2 = thread;
                    ((CodeCommentThread)object2).setCommitId((String)object);
                } else {
                    object2 = pullRequest2;
                    object = null;
                    object = ((PullRequest)object2).getMergedCommitIdTo();
                    object2 = thread;
                    ((CodeCommentThread)object2).setCommitId((String)object);
                    object2 = pullRequest2;
                    object = null;
                    object = ((PullRequest)object2).getMergedCommitIdFrom();
                    object2 = thread;
                    ((CodeCommentThread)object2).setPrevCommitId((String)object);
                }
                object2 = thread;
                object = null;
                object = ((CodeCommentThread)object2).getCommitId();
                User codeAuthor = RepositoryService.getRepository(project2).getCommit((String)object).getAuthor();
                if (!codeAuthor.isAnonymous()) {
                    object2 = thread;
                    object = null;
                    object = ((CodeCommentThread)object2).getCodeAuthors();
                    object.add((User)codeAuthor);
                }
                object = (CodeRange)codeRangeForm.get();
                object2 = thread;
                ((CodeCommentThread)object2).setCodeRange((CodeRange)object);
                object = thread;
                object2 = comment;
                ((ReviewComment)object2).setThread((CommentThread)object);
            } else {
                thread = new NonRangedCodeCommentThread();
                if (commitId != null) {
                    object = commitId;
                    object2 = thread;
                    ((NonRangedCodeCommentThread)object2).setCommitId((String)object);
                } else {
                    object2 = pullRequest2;
                    object = null;
                    object = ((PullRequest)object2).getMergedCommitIdTo();
                    object2 = thread;
                    ((NonRangedCodeCommentThread)object2).setCommitId((String)object);
                    object2 = pullRequest2;
                    object = null;
                    object = ((PullRequest)object2).getMergedCommitIdFrom();
                    object2 = thread;
                    ((NonRangedCodeCommentThread)object2).setPrevCommitId((String)object);
                }
                object = thread;
                object2 = comment;
                ((ReviewComment)object2).setThread((CommentThread)object);
            }
            object2 = comment;
            object = null;
            object = ((ReviewComment)object2).getThread();
            List<User> list2 = object;
            object = project2;
            object2 = list2;
            ((CommentThread)object2).setProject((Project)object);
            object2 = comment;
            object = null;
            Object object3 = object = ((ReviewComment)object2).getThread();
            object = CommentThread.ThreadState.OPEN;
            object2 = object3;
            ((CommentThread)object2).setState((CommentThread.ThreadState)((Object)object));
            object2 = comment;
            object = null;
            Object object4 = object = ((ReviewComment)object2).getThread();
            object2 = comment;
            object = null;
            object = ((ReviewComment)object2).getCreatedDate();
            object2 = object4;
            ((CommentThread)object2).setCreatedDate((Date)object);
            object2 = comment;
            object = null;
            Object object5 = object = ((ReviewComment)object2).getThread();
            object2 = comment;
            object = null;
            object = ((ReviewComment)object2).getAuthor();
            object2 = object5;
            ((CommentThread)object2).setAuthor((UserIdent)object);
            object2 = comment;
            object = null;
            object = ((ReviewComment)object2).getThread();
            pullRequest2.addCommentThread((CommentThread)object);
        } else {
            object2 = comment;
            object = null;
            object2 = object = ((ReviewComment)object2).getThread();
            object = null;
            object = ((CommentThread)object2).getId();
            object = (CommentThread)CommentThread.find.byId(object);
            object2 = comment;
            ((ReviewComment)object2).setThread((CommentThread)object);
        }
        comment.save();
        pullRequest2.update();
        AbstractPostingApp.attachUploadFilesToPost(comment.asResource());
        if (commitId != null) {
            object2 = pullRequest2;
            object = null;
            object = ((PullRequest)object2).getNumber();
            toView = routes.PullRequestApp.specificChange(ownerName, projectName, (Long)object, commitId);
        } else {
            object2 = pullRequest2;
            object = null;
            object = ((PullRequest)object2).getNumber();
            toView = routes.PullRequestApp.pullRequestChanges(ownerName, projectName, (Long)object);
        }
        object2 = comment;
        object = null;
        object = ((ReviewComment)object2).getId();
        String urlToView = toView + "#comment-" + object;
        NotificationEvent.afterNewComment(UserApp.currentUser(), pullRequest2, comment, urlToView);
        return PullRequestApp.redirect((String)urlToView);
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static enum Category {
        OPEN("open", "toProject", "number", State.OPEN),
        CLOSED("closed", "toProject", "received", State.CLOSED, State.MERGED),
        SENT("sent", "fromProject", "created", new State[0]),
        ACCEPTED("accepted", "fromProject", "created", State.MERGED);

        private String code;
        private String project;
        private String order;
        private State[] states;

        private Category(String code, String project2, String order, State ... states) {
            this.code = code;
            this.project = project2;
            this.order = order;
            this.states = states;
        }

        public String code() {
            return this.code;
        }

        public String project() {
            return this.project;
        }

        public String order() {
            return this.order;
        }

        public State[] states() {
            return this.states;
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class SearchCondition
    implements Cloneable {
        @PropertiesEnhancer.GeneratedGetAccessor
        public Project project;
        @PropertiesEnhancer.GeneratedGetAccessor
        public String filter;
        @PropertiesEnhancer.GeneratedGetAccessor
        public Long contributorId;
        @PropertiesEnhancer.GeneratedGetAccessor
        public int pageNum = 1;
        @PropertiesEnhancer.GeneratedGetAccessor
        public Category category;
        @PropertiesEnhancer.GeneratedGetAccessor
        public Organization organization;

        public SearchCondition setOrganization(Organization organization2) {
            this.organization = organization2;
            return this;
        }

        public SearchCondition setProject(Project project2) {
            this.project = project2;
            return this;
        }

        public SearchCondition setFilter(String filter) {
            this.filter = filter;
            return this;
        }

        public SearchCondition setContributorId(Long contributorId) {
            this.contributorId = contributorId;
            return this;
        }

        public SearchCondition setPageNum(int pageNum) {
            this.pageNum = pageNum;
            return this;
        }

        public SearchCondition setCategory(Category category2) {
            this.category = category2;
            return this;
        }

        public SearchCondition clone() throws CloneNotSupportedException {
            SearchCondition clone2 = new SearchCondition();
            SearchCondition searchCondition = this;
            Object object = null;
            object = searchCondition.getProject();
            clone2.project = object;
            searchCondition = this;
            object = null;
            clone2.filter = object = searchCondition.getFilter();
            searchCondition = this;
            object = null;
            clone2.contributorId = object = searchCondition.getContributorId();
            searchCondition = this;
            int n = 0;
            clone2.pageNum = n = searchCondition.getPageNum();
            searchCondition = this;
            Object object2 = null;
            clone2.category = object2 = searchCondition.getCategory();
            searchCondition = this;
            object2 = null;
            object2 = searchCondition.getOrganization();
            clone2.organization = object2;
            return clone2;
        }

        public String queryString() throws UnsupportedEncodingException {
            ArrayList<String> queryStrings = new ArrayList<String>();
            SearchCondition searchCondition = this;
            Object object = null;
            object = searchCondition.getFilter();
            if (StringUtils.isNotBlank((CharSequence)object)) {
                searchCondition = this;
                object = null;
                object = searchCondition.getFilter();
                queryStrings.add("filter=" + URLEncoder.encode(object, "UTF-8"));
            }
            searchCondition = this;
            object = null;
            object = searchCondition.getCategory();
            if (object != Category.SENT) {
                searchCondition = this;
                object = null;
                object = searchCondition.getContributorId();
                if (object != null) {
                    searchCondition = this;
                    object = null;
                    object = searchCondition.getContributorId();
                    queryStrings.add("contributorId=" + object);
                }
            }
            searchCondition = this;
            int n = 0;
            n = searchCondition.getPageNum();
            if (n != 1) {
                searchCondition = this;
                n = 0;
                n = searchCondition.getPageNum();
                queryStrings.add("pageNum=" + n);
            }
            if (queryStrings.isEmpty()) {
                return "";
            }
            return "?" + StringUtils.join(queryStrings, (String)"&");
        }

        @PropertiesEnhancer.GeneratedAccessor
        public Project getProject() {
            return this.project;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public String getFilter() {
            return this.filter;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public Long getContributorId() {
            return this.contributorId;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public int getPageNum() {
            return this.pageNum;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public Category getCategory() {
            return this.category;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public Organization getOrganization() {
            return this.organization;
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    static class ValidationResult {
        private Result result;
        private boolean hasError;

        ValidationResult(Result result2, boolean hasError) {
            this.result = result2;
            this.hasError = hasError;
        }

        public boolean hasError() {
            return this.hasError;
        }

        public Result getResult() {
            return this.result;
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    static class PullRequestCreationResult {
        @Nonnull
        Result result;
        @Nullable
        private PullRequestEventMessage message;

        PullRequestCreationResult(@Nonnull Result result2, PullRequestEventMessage message) {
            this.result = Objects.requireNonNull(result2);
            this.message = message;
        }

        void runMergingActor() {
            if (this.message != null) {
                Akka.system().actorOf(Props.create(PullRequestMergingActor.class, (Object[])new Object[0])).tell((Object)this.message, null);
            }
        }
    }
}

