/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.annotation.IsAllowed;
import controllers.routes;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import models.Issue;
import models.IssueComment;
import models.Project;
import models.User;
import models.enumeration.Operation;
import play.Logger;
import play.api.mvc.Call;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Transactional;
import play.mvc.Controller;
import play.mvc.Result;
import utils.RouteUtil;

@AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class VoteApp
extends Controller {
    @Transactional
    @IsAllowed(value=Operation.READ)
    public static Result vote(String ownerName, String projectName, Long issueNumber) {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Issue issue2 = Issue.findByNumber(project2, issueNumber);
        issue2.addVoter(UserApp.currentUser());
        Call call = routes.IssueApp.issue(ownerName, projectName, issueNumber);
        return VoteApp.redirect((play.mvc.Call)call);
    }

    @Transactional
    @IsAllowed(value=Operation.READ)
    public static Result unvote(String ownerName, String projectName, Long issueNumber) {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Issue issue2 = Issue.findByNumber(project2, issueNumber);
        issue2.removeVoter(UserApp.currentUser());
        Call call = routes.IssueApp.issue(ownerName, projectName, issueNumber);
        return VoteApp.redirect((play.mvc.Call)call);
    }

    @Transactional
    @IsAllowed(value=Operation.READ)
    public static Result voteComment(String user, String project2, Long number, Long commentId) {
        IssueComment issueComment = (IssueComment)IssueComment.find.byId((Object)commentId);
        if (issueComment == null) {
            return VoteApp.notFound((String)"issue.comment.error.vote");
        }
        issueComment.addVoter(UserApp.currentUser());
        return VoteApp.redirect((String)RouteUtil.getUrl(issueComment));
    }

    @Transactional
    @IsAllowed(value=Operation.READ)
    public static Result unvoteComment(String user, String project2, Long number, Long commentId) {
        IssueComment issueComment = (IssueComment)IssueComment.find.byId((Object)commentId);
        if (issueComment == null) {
            return VoteApp.notFound((String)"issue.comment.error.unvote");
        }
        IssueComment issueComment2 = issueComment;
        Set<User> set = null;
        set = issueComment2.getVoters();
        if (!set.contains(UserApp.currentUser())) {
            return VoteApp.notFound((String)"issue.comment.error.have.not.voted");
        }
        issueComment.removeVoter(UserApp.currentUser());
        return VoteApp.redirect((String)RouteUtil.getUrl(issueComment));
    }

    public static List<User> getVotersForAvatar(Set<User> voters, int size) {
        return VoteApp.getSubList(voters, 0, size);
    }

    public static List<User> getVotersForName(Set<User> voters, int fromIndex, int size) {
        return VoteApp.getSubList(voters, fromIndex, fromIndex + size);
    }

    public static Set<User> getVotersExceptCurrentUser(Set<User> voters) {
        voters.remove(UserApp.currentUser());
        return voters;
    }

    private static List<User> getSubList(Set<User> voters, int fromIndex, int toIndex) {
        try {
            return new ArrayList<User>(voters).subList(Math.max(0, fromIndex), Math.min(voters.size(), toIndex));
        }
        catch (IndexOutOfBoundsException e) {
            Logger.warn((String)"Failed to get subList of voters", (Throwable)e);
            return new ArrayList<User>();
        }
    }
}

