/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.avaje.ebean.annotation.Transactional;
import controllers.UserApp;
import models.Unwatch;
import models.User;
import models.Watch;
import models.enumeration.Operation;
import models.resource.Resource;
import models.resource.ResourceParam;
import org.apache.commons.lang3.StringUtils;
import play.core.enhancers.PropertiesEnhancer;
import play.i18n.Messages;
import play.mvc.Controller;
import play.mvc.Result;
import play.twirl.api.Content;
import utils.AccessControl;
import utils.HttpUtil;
import utils.RouteUtil;
import views.html.error.forbidden;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class WatchApp
extends Controller {
    public static Result watch(ResourceParam resourceParam) {
        User user = UserApp.currentUser();
        ResourceParam resourceParam2 = resourceParam;
        Resource resource = null;
        Resource resource2 = resource = resourceParam2.getResource();
        if (user.isAnonymous()) {
            return WatchApp.forbidden((String)"Anonymous cannot watch it.");
        }
        if (!AccessControl.isAllowed(user, resource2, Operation.READ)) {
            return WatchApp.forbidden((String)"You have no permission to watch it.");
        }
        Watch.watch(user, resource2);
        return WatchApp.ok();
    }

    @Transactional
    public static Result unwatch(ResourceParam resourceParam) {
        String message;
        User user = UserApp.currentUser();
        ResourceParam resourceParam2 = resourceParam;
        Resource resource = null;
        Resource resource2 = resource = resourceParam2.getResource();
        if (user.isAnonymous()) {
            return WatchApp.forbidden((Content)forbidden.render(Messages.get((String)"issue.error.unwatch.anonymous", (Object[])new Object[0]), resource2.getProject()));
        }
        if (!AccessControl.isAllowed(user, resource2, Operation.READ)) {
            return WatchApp.forbidden((Content)forbidden.render(Messages.get((String)"issue.error.unwatch.permission", (Object[])new Object[0]), resource2.getProject()));
        }
        Unwatch unwatch2 = Unwatch.findBy(user, resource2.getType(), resource2.getId());
        Watch.unwatch(user, resource2);
        if (HttpUtil.isJSONPreferred(WatchApp.request()).booleanValue()) {
            return WatchApp.ok();
        }
        if (unwatch2 == null && !StringUtils.isEmpty((CharSequence)(message = WatchApp.getUnwatchMessage(resource2)))) {
            WatchApp.flash((String)"success", (String)message);
        }
        return WatchApp.redirect((String)RouteUtil.getUrl(resource2.getType(), resource2.getId()));
    }

    private static String getUnwatchMessage(Resource resource) {
        switch (resource.getType()) {
            case ISSUE_POST: 
            case ISSUE_COMMENT: {
                return Messages.get((String)"issue.unwatch.start", (Object[])new Object[0]);
            }
            case BOARD_POST: 
            case NONISSUE_COMMENT: {
                return Messages.get((String)"post.unwatch.start", (Object[])new Object[0]);
            }
            case PULL_REQUEST: 
            case REVIEW_COMMENT: {
                return Messages.get((String)"pullRequest.unwatch.start", (Object[])new Object[0]);
            }
            case PROJECT: {
                return Messages.get((String)"project.unwatch.start", (Object[])new Object[0]);
            }
        }
        return "";
    }
}

