/*
 * Decompiled with CFR 0.152.
 */
package controllers.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AbstractPostingApp;
import controllers.MigrationApp;
import controllers.annotation.IsCreatable;
import java.util.ArrayList;
import java.util.Date;
import models.Milestone;
import models.Project;
import models.enumeration.ResourceType;
import models.enumeration.State;
import org.joda.time.DateTime;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.i18n.Messages;
import play.libs.Json;
import play.mvc.Result;
import utils.JodaDateUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class MilestoneApi
extends AbstractPostingApp {
    @Transactional
    @IsCreatable(value=ResourceType.MILESTONE)
    public static Result newMilestone(String owner, String projectName) {
        ObjectNode result2 = Json.newObject();
        JsonNode json = MilestoneApi.request().body().asJson();
        if (json == null) {
            return MilestoneApi.badRequest((JsonNode)result2.put("message", "Expecting Json data"));
        }
        JsonNode milestonesNode = json.findValue("milestones");
        if (milestonesNode == null || !milestonesNode.isArray()) {
            return MilestoneApi.badRequest((JsonNode)result2.put("message", "No milestones key exists or value wasn't array!"));
        }
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        ArrayList<JsonNode> createdMilestones = new ArrayList<JsonNode>();
        for (JsonNode milestoneNode : milestonesNode) {
            createdMilestones.add(MilestoneApi.createMilestoneNode(milestoneNode, project2));
        }
        return MilestoneApi.created((JsonNode)Json.toJson(createdMilestones));
    }

    private static JsonNode createMilestoneNode(JsonNode milestoneNode, Project project2) {
        ObjectNode result2 = Json.newObject();
        Model model = project2;
        Object object = null;
        object = model.getId();
        if (!Milestone.isUniqueProjectIdAndTitle((Long)object, milestoneNode.findValue("title").asText())) {
            result2.put("milestone", milestoneNode);
            return result2.put("message", Messages.get((String)"milestone.title.duplicated", (Object[])new Object[0]));
        }
        Milestone newMilestone2 = new Milestone();
        object = MilestoneApi.parseMilestoneTitle(milestoneNode);
        model = newMilestone2;
        model.setTitle((String)object);
        object = MilestoneApi.parseMilestoneContents(milestoneNode);
        model = newMilestone2;
        model.setContents((String)object);
        object = project2;
        model = newMilestone2;
        model.setProject((Project)object);
        object = MilestoneApi.parseDuedate(milestoneNode);
        model = newMilestone2;
        model.setDueDate((Date)object);
        object = MilestoneApi.parseMilestoneState(milestoneNode);
        model = newMilestone2;
        model.setState((State)((Object)object));
        Milestone.create(newMilestone2);
        return MigrationApp.getMilestoneNode(newMilestone2);
    }

    private static State parseMilestoneState(JsonNode json) {
        JsonNode stateNode = json.findValue("state");
        if (stateNode == null) {
            return State.OPEN;
        }
        if ("closed".equalsIgnoreCase(stateNode.asText())) {
            return State.CLOSED;
        }
        return State.OPEN;
    }

    private static Date parseDuedate(JsonNode json) {
        JsonNode dueOnNode = json.findValue("due_on");
        if (dueOnNode == null) {
            return null;
        }
        DateTime dateTime = new DateTime((Object)dueOnNode.asText());
        return JodaDateUtil.lastSecondOfDay(dateTime.toDate());
    }

    private static String parseMilestoneTitle(JsonNode json) {
        JsonNode contentsNode = json.findValue("title");
        if (contentsNode == null) {
            return "No title";
        }
        return contentsNode.asText();
    }

    private static String parseMilestoneContents(JsonNode json) {
        JsonNode contentsNode = json.findValue("description");
        if (contentsNode == null) {
            return "";
        }
        return contentsNode.asText();
    }
}

