/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Page;
import com.avaje.ebean.bean.EntityBean;
import com.fasterxml.jackson.annotation.JsonIgnore;
import controllers.AttachmentApp;
import controllers.UserApp;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NotDirectoryException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Transient;
import models.Project;
import models.User;
import models.enumeration.ResourceType;
import models.resource.GlobalResource;
import models.resource.Resource;
import models.resource.ResourceConvertible;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.mime.MimeTypeException;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.data.validation.Constraints;
import play.db.ebean.Model;
import play.libs.Akka;
import play.libs.F;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import utils.AttachmentCache;
import utils.Config;
import utils.FileUtil;
import utils.JodaDateUtil;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Attachment
extends Model
implements ResourceConvertible,
EntityBean {
    private static final long serialVersionUID = 7856282252495067924L;
    public static final Model.Finder<Long, Attachment> find = new Model.Finder(Long.class, Attachment.class);
    public static final int NOTHING_TO_ATTACH = 0;
    private static String uploadDirectory = "uploads";
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @Constraints.Required
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String name;
    @Constraints.Required
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String hash;
    @Enumerated(value=EnumType.STRING)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public ResourceType containerType;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String mimeType;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long size;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String containerId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date createdDate;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String ownerLoginId;
    private static String _EBEAN_MARKER = "models.Attachment";

    private static Attachment findBy(Attachment attach) {
        Attachment attachment = attach;
        Object object = null;
        object = attachment.getName();
        ExpressionList expressionList = find.where().eq("name", object);
        attachment = attach;
        object = null;
        object = attachment.getHash();
        ExpressionList expressionList2 = expressionList.eq("hash", object);
        attachment = attach;
        object = null;
        object = attachment.getContainerType();
        ExpressionList expressionList3 = expressionList2.eq("containerType", object);
        attachment = attach;
        object = null;
        object = attachment.getContainerId();
        List list2 = expressionList3.eq("containerId", object).findList();
        if (list2.size() > 0) {
            return (Attachment)list2.get(0);
        }
        return null;
    }

    public static boolean exists(String hash) {
        return find.where().eq("hash", (Object)hash).findRowCount() > 0;
    }

    public static List<Attachment> findByContainer(ResourceType containerType, String containerId) {
        List<Attachment> cachedData = AttachmentCache.get(containerType, containerId);
        if (cachedData != null) {
            return cachedData;
        }
        List list2 = find.where().eq("containerType", (Object)containerType).eq("containerId", (Object)containerId).findList();
        AttachmentCache.set(containerType.name() + containerId, (List<Attachment>)list2);
        return list2;
    }

    public static List<Attachment> findByContainer(Resource container) {
        List<Attachment> cachedData = AttachmentCache.get(container);
        if (cachedData != null) {
            return cachedData;
        }
        List<Attachment> list2 = Attachment.findByContainer(container.getType(), container.getId());
        AttachmentCache.set(container, list2);
        return list2;
    }

    public static int countByContainer(Resource container) {
        return find.where().eq("containerType", (Object)container.getType()).eq("containerId", (Object)container.getId()).findRowCount();
    }

    public static int moveAll(Resource from, Resource to) {
        List<Attachment> attachments = Attachment.findByContainer(from);
        for (Attachment attachment : attachments) {
            attachment.moveTo(to);
        }
        return attachments.size();
    }

    public static int moveOnlySelected(Resource from, Resource to, String[] selectedFileIds) {
        if (selectedFileIds.length == 0) {
            return 0;
        }
        List attachments = find.where().idIn(Arrays.asList(selectedFileIds)).findList();
        Iterator iterator = attachments.iterator();
        while (iterator.hasNext()) {
            Attachment attachment;
            block6: {
                block5: {
                    Attachment attachment2 = attachment = (Attachment)iterator.next();
                    Object object = null;
                    object = attachment2.getContainerId();
                    if (!object.equals(from.getId())) break block5;
                    attachment2 = attachment;
                    object = null;
                    object = attachment2.getContainerType();
                    if (object == from.getType()) break block6;
                }
                if (!UserApp.currentUser().isSiteManager()) continue;
            }
            attachment.moveTo(to);
        }
        return attachments.size();
    }

    public void moveTo(Resource to) {
        Object object = to.getType();
        Attachment attachment = this;
        attachment.setContainerType((ResourceType)((Object)object));
        object = to.getId();
        attachment = this;
        attachment.setContainerId((String)object);
        this.update();
    }

    private static File moveFileIntoUploadDirectory(File file) throws NoSuchAlgorithmException, IOException {
        FileInputStream is = new FileInputStream(file);
        byte[] buf = new byte[10240];
        MessageDigest algorithm = MessageDigest.getInstance("SHA-256");
        int readSize = 0;
        while (readSize >= 0) {
            algorithm.update(buf, 0, readSize);
            readSize = ((InputStream)is).read(buf);
        }
        ((InputStream)is).close();
        String hash = Attachment.toHex(algorithm.digest());
        return Attachment.moveFileIntoUploadDirectory(file, hash);
    }

    private static File moveFileIntoUploadDirectory(File file, String hash) throws NoSuchAlgorithmException, IOException {
        File attachedFile = new File(Attachment.createUploadDirectory(), hash);
        boolean isMoved = file.renameTo(attachedFile);
        if (!isMoved) {
            FileUtils.copyFile((File)file, (File)attachedFile);
            file.delete();
        }
        return attachedFile;
    }

    @Transient
    public boolean store(File file, String name, Resource container) throws IOException, NoSuchAlgorithmException {
        return this.save(Attachment.moveFileIntoUploadDirectory(file), name, container);
    }

    @JsonIgnore
    public File getFile() {
        Attachment attachment = this;
        String string = null;
        string = attachment.getHash();
        return new File(Attachment.getUploadDirectory(), string);
    }

    public static File getUploadDirectory() {
        return new File(Config.getYonaDataDir(), uploadDirectory);
    }

    public static void setUploadDirectory(String path) {
        uploadDirectory = path;
    }

    public static boolean fileExists(String hash) {
        return new File(Attachment.getUploadDirectory(), hash).isFile();
    }

    public void delete() {
        super.delete();
        Attachment attachment = this;
        String string = null;
        string = attachment.getHash();
        if (!Attachment.exists(string)) {
            try {
                boolean isSafelyDeleted = Files.deleteIfExists(this.getFile().toPath());
                if (!isSafelyDeleted) {
                    Logger.error((String)("tried to delete already deleted: " + this));
                }
            }
            catch (Exception e) {
                Logger.error((String)("Failed to delete: " + this), (Throwable)e);
            }
        }
        AttachmentCache.remove(this);
    }

    public void update() {
        super.update();
        AttachmentCache.remove(this);
    }

    public static void deleteAll(Resource container) {
        List<Attachment> attachments = Attachment.findByContainer(container);
        for (Attachment attachment : attachments) {
            attachment.delete();
        }
    }

    private String messageForLosingProject() {
        return "An attachment '" + this + "' lost the project it belongs to";
    }

    @Override
    public Resource asResource() {
        Resource container;
        Project project2;
        Attachment attachment = this;
        Object object = null;
        object = attachment.getContainerType();
        boolean isContainerProject = object.equals((Object)ResourceType.PROJECT);
        if (isContainerProject) {
            attachment = this;
            object = null;
            object = attachment.getContainerId();
            project2 = (Project)Project.find.byId((Object)Long.parseLong((String)object));
            if (project2 == null) {
                throw new RuntimeException(this.messageForLosingProject());
            }
            container = project2.asResource();
        } else {
            attachment = this;
            object = null;
            Object object2 = object = attachment.getContainerType();
            attachment = this;
            object = null;
            object = attachment.getContainerId();
            container = Resource.get(object2, (String)object);
            if (!(container instanceof GlobalResource)) {
                project2 = container.getProject();
                if (project2 == null) {
                    throw new RuntimeException(this.messageForLosingProject());
                }
            } else {
                project2 = null;
            }
        }
        if (project2 != null) {
            return new Resource(){

                @Override
                public String getId() {
                    Attachment attachment = Attachment.this;
                    Long l = null;
                    l = attachment.getId();
                    return l.toString();
                }

                @Override
                public Project getProject() {
                    return project2;
                }

                @Override
                public ResourceType getType() {
                    return ResourceType.ATTACHMENT;
                }

                @Override
                public Resource getContainer() {
                    return container;
                }
            };
        }
        return new GlobalResource(){

            @Override
            public String getId() {
                Attachment attachment = Attachment.this;
                Long l = null;
                l = attachment.getId();
                return l.toString();
            }

            @Override
            public ResourceType getType() {
                return ResourceType.ATTACHMENT;
            }

            @Override
            public Resource getContainer() {
                return container;
            }
        };
    }

    private static void cleanupTemporaryUploadFilesWithSchedule() {
        Akka.system().scheduler().schedule(Duration.create((long)AttachmentApp.TEMPORARYFILES_KEEPUP_TIME_MILLIS, (TimeUnit)TimeUnit.MILLISECONDS), Duration.create((long)AttachmentApp.TEMPORARYFILES_KEEPUP_TIME_MILLIS, (TimeUnit)TimeUnit.MILLISECONDS), new Runnable(){

            @Override
            public void run() {
                try {
                    String result2 = this.removeUserTemporaryFiles();
                    Logger.info((String)("User uploaded temporary files are cleaned up..." + result2));
                }
                catch (Exception e) {
                    Logger.warn((String)"Failed!! User uploaded temporary files clean-up action failed!", (Throwable)e);
                }
            }

            private String removeUserTemporaryFiles() {
                List attachmentList = find.where().eq("containerType", (Object)ResourceType.USER).ge("createdDate", (Object)JodaDateUtil.beforeByMillis(AttachmentApp.TEMPORARYFILES_KEEPUP_TIME_MILLIS)).findList();
                int deletedFileCount = 0;
                for (Attachment attachment : attachmentList) {
                    attachment.delete();
                    ++deletedFileCount;
                }
                if (attachmentList.size() != deletedFileCount) {
                    Logger.error((String)String.format("Failed to delete user temporary files.\nExpected: %d  Actual: %d", attachmentList.size(), deletedFileCount));
                }
                return String.format("(%d of %d)", attachmentList.size(), deletedFileCount);
            }
        }, (ExecutionContext)Akka.system().dispatcher());
    }

    public static void onStart() {
        Attachment.cleanupTemporaryUploadFilesWithSchedule();
    }

    public String toString() {
        Attachment attachment = this;
        Object object = null;
        object = attachment.getId();
        StringBuilder stringBuilder = new StringBuilder().append("Attachment{id=").append(object).append(", name='");
        attachment = this;
        object = null;
        object = attachment.getName();
        StringBuilder stringBuilder2 = stringBuilder.append((String)object).append('\'').append(", hash='");
        attachment = this;
        object = null;
        object = attachment.getHash();
        StringBuilder stringBuilder3 = stringBuilder2.append((String)object).append('\'').append(", containerType=");
        attachment = this;
        object = null;
        object = attachment.getContainerType();
        StringBuilder stringBuilder4 = stringBuilder3.append(object).append(", mimeType='");
        attachment = this;
        object = null;
        object = attachment.getMimeType();
        StringBuilder stringBuilder5 = stringBuilder4.append((String)object).append('\'').append(", size=");
        attachment = this;
        object = null;
        object = attachment.getSize();
        StringBuilder stringBuilder6 = stringBuilder5.append(object).append(", containerId='");
        attachment = this;
        object = null;
        object = attachment.getContainerId();
        StringBuilder stringBuilder7 = stringBuilder6.append((String)object).append('\'').append(", createdDate=");
        attachment = this;
        object = null;
        object = attachment.getCreatedDate();
        return stringBuilder7.append(object).append('}').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean store(InputStream inputStream, @Nullable String fileName, Resource container) throws IOException, NoSuchAlgorithmException {
        String tempFileHash;
        byte[] buf = new byte[10240];
        MessageDigest algorithm = MessageDigest.getInstance("SHA-256");
        File tmpFile = File.createTempFile("yobi", null);
        try (FileOutputStream fos = new FileOutputStream(tmpFile);){
            int readSize;
            while ((readSize = inputStream.read(buf)) != -1) {
                algorithm.update(buf, 0, readSize);
                fos.write(buf, 0, readSize);
            }
            tempFileHash = Attachment.toHex(algorithm.digest());
            fos.flush();
        }
        return this.save(Attachment.moveFileIntoUploadDirectory(tmpFile, tempFileHash), fileName, container);
    }

    public static Page<Attachment> findByUser(User user, int pageSize, int pageNo, String filter) {
        if (StringUtils.isEmpty((CharSequence)filter)) {
            User user2 = user;
            String string = null;
            string = user2.getLoginId();
            return find.where().eq("owner_login_id", (Object)string).order("created_date desc").findPagingList(pageSize).getPage(pageNo - 1);
        }
        User user3 = user;
        String string = null;
        string = user3.getLoginId();
        return find.where().eq("owner_login_id", (Object)string).ilike("name", "%" + filter + "%").order("created_date desc").findPagingList(pageSize).getPage(pageNo - 1);
    }

    private boolean save(File file, String fileName, Resource container) throws IOException {
        Object object = container.getType();
        Model model = this;
        model.setContainerType((ResourceType)((Object)object));
        object = container.getId();
        model = this;
        model.setContainerId((String)object);
        object = JodaDateUtil.now();
        model = this;
        model.setCreatedDate((Date)object);
        object = file.getName();
        model = this;
        model.setHash((String)object);
        object = file.length();
        model = this;
        model.setSize((Long)object);
        model = UserApp.currentUser();
        object = null;
        object = model.getLoginId();
        model = this;
        model.setOwnerLoginId((String)object);
        model = this;
        object = null;
        object = model.getMimeType();
        if (object == null) {
            model = this;
            object = null;
            object = model.getName();
            object = FileUtil.detectMediaType(file, (String)object).toString();
            model = this;
            model.setMimeType((String)object);
        }
        if (fileName == null) {
            object = String.valueOf(new Date().getTime());
            model = this;
            model.setName((String)object);
            try {
                Attachment attachment = this;
                model = attachment;
                object = null;
                object = model.getName();
                StringBuilder stringBuilder = new StringBuilder().append((String)object).append(".");
                model = this;
                object = null;
                object = model.getMimeType();
                object = stringBuilder.append(TikaConfig.getDefaultConfig().getMimeRepository().forName((String)object).getExtension()).toString();
                model = attachment;
                model.setName((String)object);
            }
            catch (MimeTypeException mimeTypeException) {}
        } else {
            object = fileName;
            model = this;
            model.setName((String)object);
        }
        AttachmentCache.remove(this);
        Attachment sameAttach = Attachment.findBy(this);
        if (sameAttach == null) {
            super.save();
            return true;
        }
        model = sameAttach;
        object = null;
        object = model.getId();
        model = this;
        model.setId((Long)object);
        return false;
    }

    private static String toHex(byte[] bytes) {
        Formatter formatter = new Formatter();
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        String hex = formatter.toString();
        formatter.close();
        return hex;
    }

    private static File createUploadDirectory() throws NotDirectoryException {
        File uploads = Attachment.getUploadDirectory();
        uploads.mkdirs();
        if (!uploads.isDirectory()) {
            throw new NotDirectoryException("'" + uploads.getAbsolutePath() + "' is not a directory.");
        }
        return uploads;
    }

    public static Attachment copyAs(Attachment other) {
        Attachment attachment = new Attachment();
        Attachment attachment2 = other;
        Object object = null;
        object = attachment2.getName();
        attachment2 = attachment;
        attachment2.setName((String)object);
        attachment2 = other;
        object = null;
        object = attachment2.getHash();
        attachment2 = attachment;
        attachment2.setHash((String)object);
        attachment2 = other;
        object = null;
        object = attachment2.getContainerType();
        attachment2 = attachment;
        attachment2.setContainerType((ResourceType)((Object)object));
        attachment2 = other;
        object = null;
        object = attachment2.getMimeType();
        attachment2 = attachment;
        attachment2.setMimeType((String)object);
        attachment2 = other;
        object = null;
        object = attachment2.getSize();
        attachment2 = attachment;
        attachment2.setSize((Long)object);
        attachment2 = other;
        object = null;
        object = attachment2.getContainerId();
        attachment2 = attachment;
        attachment2.setContainerId((String)object);
        attachment2 = other;
        object = null;
        object = attachment2.getCreatedDate();
        attachment2 = attachment;
        attachment2.setCreatedDate((Date)object);
        attachment2 = other;
        object = null;
        object = attachment2.getOwnerLoginId();
        attachment2 = attachment;
        attachment2.setOwnerLoginId((String)object);
        return attachment;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getName() {
        return this._ebean_get_name();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setName(String string) {
        this._ebean_set_name(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getHash() {
        return this._ebean_get_hash();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setHash(String string) {
        this._ebean_set_hash(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public ResourceType getContainerType() {
        return this._ebean_get_containerType();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setContainerType(ResourceType resourceType) {
        this._ebean_set_containerType(resourceType);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getMimeType() {
        return this._ebean_get_mimeType();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setMimeType(String string) {
        this._ebean_set_mimeType(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getSize() {
        return this._ebean_get_size();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setSize(Long l) {
        this._ebean_set_size(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getContainerId() {
        return this._ebean_get_containerId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setContainerId(String string) {
        this._ebean_set_containerId(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getCreatedDate() {
        return this._ebean_get_createdDate();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCreatedDate(Date date) {
        this._ebean_set_createdDate(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getOwnerLoginId() {
        return this._ebean_get_ownerLoginId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setOwnerLoginId(String string) {
        this._ebean_set_ownerLoginId(string);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected String _ebean_get_name() {
        this._ebean_intercept.preGetter("name");
        return this.name;
    }

    protected void _ebean_set_name(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "name", (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_name() {
        return this.name;
    }

    protected void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
    }

    protected String _ebean_get_hash() {
        this._ebean_intercept.preGetter("hash");
        return this.hash;
    }

    protected void _ebean_set_hash(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "hash", (Object)this._ebean_get_hash(), (Object)newValue);
        this.hash = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_hash() {
        return this.hash;
    }

    protected void _ebean_setni_hash(String _newValue) {
        this.hash = _newValue;
    }

    protected ResourceType _ebean_get_containerType() {
        this._ebean_intercept.preGetter("containerType");
        return this.containerType;
    }

    protected void _ebean_set_containerType(ResourceType newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "containerType", (Object)this._ebean_get_containerType(), (Object)newValue);
        this.containerType = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected ResourceType _ebean_getni_containerType() {
        return this.containerType;
    }

    protected void _ebean_setni_containerType(ResourceType _newValue) {
        this.containerType = _newValue;
    }

    protected String _ebean_get_mimeType() {
        this._ebean_intercept.preGetter("mimeType");
        return this.mimeType;
    }

    protected void _ebean_set_mimeType(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "mimeType", (Object)this._ebean_get_mimeType(), (Object)newValue);
        this.mimeType = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_mimeType() {
        return this.mimeType;
    }

    protected void _ebean_setni_mimeType(String _newValue) {
        this.mimeType = _newValue;
    }

    protected Long _ebean_get_size() {
        this._ebean_intercept.preGetter("size");
        return this.size;
    }

    protected void _ebean_set_size(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "size", (Object)this._ebean_get_size(), (Object)newValue);
        this.size = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_size() {
        return this.size;
    }

    protected void _ebean_setni_size(Long _newValue) {
        this.size = _newValue;
    }

    protected String _ebean_get_containerId() {
        this._ebean_intercept.preGetter("containerId");
        return this.containerId;
    }

    protected void _ebean_set_containerId(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "containerId", (Object)this._ebean_get_containerId(), (Object)newValue);
        this.containerId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_containerId() {
        return this.containerId;
    }

    protected void _ebean_setni_containerId(String _newValue) {
        this.containerId = _newValue;
    }

    protected Date _ebean_get_createdDate() {
        this._ebean_intercept.preGetter("createdDate");
        return this.createdDate;
    }

    protected void _ebean_set_createdDate(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "createdDate", (Object)this._ebean_get_createdDate(), (Object)newValue);
        this.createdDate = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_createdDate() {
        return this.createdDate;
    }

    protected void _ebean_setni_createdDate(Date _newValue) {
        this.createdDate = _newValue;
    }

    protected String _ebean_get_ownerLoginId() {
        this._ebean_intercept.preGetter("ownerLoginId");
        return this.ownerLoginId;
    }

    protected void _ebean_set_ownerLoginId(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "ownerLoginId", (Object)this._ebean_get_ownerLoginId(), (Object)newValue);
        this.ownerLoginId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_ownerLoginId() {
        return this.ownerLoginId;
    }

    protected void _ebean_setni_ownerLoginId(String _newValue) {
        this.ownerLoginId = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        Attachment attachment = new Attachment();
        attachment.id = this.id;
        attachment.name = this.name;
        attachment.hash = this.hash;
        attachment.containerType = this.containerType;
        attachment.mimeType = this.mimeType;
        attachment.size = this.size;
        attachment.containerId = this.containerId;
        attachment.createdDate = this.createdDate;
        attachment.ownerLoginId = this.ownerLoginId;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        Attachment p = (Attachment)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.name;
            }
            case 3: {
                return p.hash;
            }
            case 4: {
                return p.containerType;
            }
            case 5: {
                return p.mimeType;
            }
            case 6: {
                return p.size;
            }
            case 7: {
                return p.containerId;
            }
            case 8: {
                return p.createdDate;
            }
            case 9: {
                return p.ownerLoginId;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        Attachment p = (Attachment)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_name();
            }
            case 3: {
                return p._ebean_get_hash();
            }
            case 4: {
                return p._ebean_get_containerType();
            }
            case 5: {
                return p._ebean_get_mimeType();
            }
            case 6: {
                return p._ebean_get_size();
            }
            case 7: {
                return p._ebean_get_containerId();
            }
            case 8: {
                return p._ebean_get_createdDate();
            }
            case 9: {
                return p._ebean_get_ownerLoginId();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        Attachment p = (Attachment)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.name = (String)arg;
                return;
            }
            case 3: {
                p.hash = (String)arg;
                return;
            }
            case 4: {
                p.containerType = (ResourceType)((Object)arg);
                return;
            }
            case 5: {
                p.mimeType = (String)arg;
                return;
            }
            case 6: {
                p.size = (Long)arg;
                return;
            }
            case 7: {
                p.containerId = (String)arg;
                return;
            }
            case 8: {
                p.createdDate = (Date)arg;
                return;
            }
            case 9: {
                p.ownerLoginId = (String)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        Attachment p = (Attachment)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_name((String)arg);
                return;
            }
            case 3: {
                p._ebean_set_hash((String)arg);
                return;
            }
            case 4: {
                p._ebean_set_containerType((ResourceType)((Object)arg));
                return;
            }
            case 5: {
                p._ebean_set_mimeType((String)arg);
                return;
            }
            case 6: {
                p._ebean_set_size((Long)arg);
                return;
            }
            case 7: {
                p._ebean_set_containerId((String)arg);
                return;
            }
            case 8: {
                p._ebean_set_createdDate((Date)arg);
                return;
            }
            case 9: {
                p._ebean_set_ownerLoginId((String)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "name", "hash", "containerType", "mimeType", "size", "containerId", "createdDate", "ownerLoginId"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        Attachment attachment = this;
        synchronized (attachment) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((Attachment)obj)._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new Attachment();
    }
}

