/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.common.BeanList;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.Transient;
import models.CodeRange;
import models.CommentThread;
import models.Project;
import models.PullRequest;
import models.PullRequestCommit;
import models.User;
import models.UserIdent;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.Repository;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.F;

@Entity
@DiscriminatorValue(value="ranged")
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class CodeCommentThread
extends CommentThread
implements EntityBean {
    private static final long serialVersionUID = 1L;
    public static final Model.Finder<Long, CodeCommentThread> find = new Model.Finder(Long.class, CodeCommentThread.class);
    @Embedded
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public CodeRange codeRange;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String prevCommitId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String commitId;
    @Transient
    private Boolean _isOutdated;
    @ManyToMany(cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<User> codeAuthors;
    private static String _EBEAN_MARKER = "models.CodeCommentThread";

    public CodeCommentThread() {
        ArrayList<User> arrayList = new CodeRange();
        CodeCommentThread codeCommentThread = this;
        codeCommentThread.setCodeRange((CodeRange)((Object)arrayList));
        arrayList = "";
        codeCommentThread = this;
        codeCommentThread.setPrevCommitId((String)((Object)arrayList));
        arrayList = new ArrayList<User>();
        codeCommentThread = this;
        codeCommentThread.setCodeAuthors(arrayList);
    }

    public boolean isCommitComment() {
        CodeCommentThread codeCommentThread = this;
        String string = null;
        string = codeCommentThread.getPrevCommitId();
        return ObjectUtils.equals((Object)string, (Object)"");
    }

    private String unexpectedSideMessage(CodeRange.Side side) {
        return String.format("Expected '%s' or '%s', but '%s'", new Object[]{CodeRange.Side.A, CodeRange.Side.B, side});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOnChangesOfPullRequest() {
        if (!this.isOnPullRequest()) return false;
        CodeCommentThread codeCommentThread = this;
        String string = null;
        string = codeCommentThread.getCommitId();
        if (!StringUtils.isNotEmpty((CharSequence)string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOnAllChangesOfPullRequest() {
        if (!this.isOnChangesOfPullRequest()) return false;
        CodeCommentThread codeCommentThread = this;
        String string = null;
        string = codeCommentThread.getPrevCommitId();
        if (!StringUtils.isNotEmpty((CharSequence)string)) return false;
        return true;
    }

    public boolean isOutdated() throws IOException, GitAPIException {
        Object object;
        Object object2;
        block17: {
            block16: {
                block15: {
                    block14: {
                        object2 = this;
                        object = null;
                        object2 = object = ((CodeCommentThread)object2).getCodeRange();
                        object = null;
                        object = ((CodeRange)object2).getStartLine();
                        if (object == null) break block14;
                        object2 = this;
                        object = null;
                        object = ((CodeCommentThread)object2).getPrevCommitId();
                        if (object == null) break block14;
                        object2 = this;
                        object = null;
                        object = ((CodeCommentThread)object2).getCommitId();
                        if (object != null) break block15;
                    }
                    return false;
                }
                if (this._isOutdated != null) {
                    return this._isOutdated;
                }
                if (!this.isOnPullRequest()) {
                    return false;
                }
                object2 = this;
                object = null;
                object2 = object = ((CommentThread)object2).getPullRequest();
                object = null;
                object = ((PullRequest)object2).getMergedCommitIdFrom();
                if (object == null) break block16;
                object2 = this;
                object = null;
                object2 = object = ((CommentThread)object2).getPullRequest();
                object = null;
                object = ((PullRequest)object2).getMergedCommitIdTo();
                if (object != null) break block17;
            }
            return false;
        }
        if (this.isCommitComment()) {
            object2 = this;
            object = null;
            Object object3 = object = ((CommentThread)object2).getPullRequest();
            object2 = this;
            object = null;
            object = ((CodeCommentThread)object2).getCommitId();
            return PullRequestCommit.getByCommitId((PullRequest)object3, (String)object) == null;
        }
        object2 = this;
        object = null;
        object2 = object = ((CodeCommentThread)object2).getCodeRange();
        object = null;
        object = ((CodeRange)object2).getPath();
        Object path = object;
        if (((String)path).length() > 0 && ((String)path).charAt(0) == '/') {
            path = ((String)path).substring(1);
        }
        object2 = this;
        object = null;
        object = ((CommentThread)object2).getPullRequest();
        Repository repository = ((PullRequest)object).getRepository();
        try {
            object2 = this;
            object = null;
            object = ((CodeCommentThread)object2).getPrevCommitId();
            if (StringUtils.isNotEmpty((CharSequence)object)) {
                object2 = this;
                object = null;
                object2 = object = ((CommentThread)object2).getPullRequest();
                object = null;
                Object object4 = object = ((PullRequest)object2).getMergedCommitIdFrom();
                object2 = this;
                object = null;
                object = ((CodeCommentThread)object2).getPrevCommitId();
                this._isOutdated = !PullRequest.noChangesBetween(repository, (String)object4, repository, (String)object, (String)path);
            }
            if (this._isOutdated.booleanValue()) {
                return this._isOutdated;
            }
            object2 = this;
            object = null;
            object2 = object = ((CommentThread)object2).getPullRequest();
            object = null;
            Object object5 = object = ((PullRequest)object2).getMergedCommitIdTo();
            object2 = this;
            object = null;
            object = ((CodeCommentThread)object2).getCommitId();
            this._isOutdated = !PullRequest.noChangesBetween(repository, (String)object5, repository, (String)object, (String)path);
        }
        catch (MissingObjectException e) {
            Logger.warn((String)("Possible false positive of outdated detection because of missing git object: " + e.getMessage()));
            return true;
        }
        return this._isOutdated;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public CodeRange getCodeRange() {
        return this._ebean_get_codeRange();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCodeRange(CodeRange codeRange) {
        this._ebean_set_codeRange(codeRange);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getPrevCommitId() {
        return this._ebean_get_prevCommitId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setPrevCommitId(String string) {
        this._ebean_set_prevCommitId(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getCommitId() {
        return this._ebean_get_commitId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCommitId(String string) {
        this._ebean_set_commitId(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<User> getCodeAuthors() {
        return this._ebean_get_codeAuthors();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCodeAuthors(List<User> list2) {
        this._ebean_set_codeAuthors(list2);
    }

    @Override
    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected CodeRange _ebean_get_codeRange() {
        this._ebean_intercept.preGetter("codeRange");
        return this.codeRange;
    }

    protected void _ebean_set_codeRange(CodeRange newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "codeRange", (Object)this._ebean_get_codeRange(), (Object)newValue);
        this.codeRange = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected CodeRange _ebean_getni_codeRange() {
        return this.codeRange;
    }

    protected void _ebean_setni_codeRange(CodeRange _newValue) {
        this.codeRange = _newValue;
    }

    protected String _ebean_get_prevCommitId() {
        this._ebean_intercept.preGetter("prevCommitId");
        return this.prevCommitId;
    }

    protected void _ebean_set_prevCommitId(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "prevCommitId", (Object)this._ebean_get_prevCommitId(), (Object)newValue);
        this.prevCommitId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_prevCommitId() {
        return this.prevCommitId;
    }

    protected void _ebean_setni_prevCommitId(String _newValue) {
        this.prevCommitId = _newValue;
    }

    protected String _ebean_get_commitId() {
        this._ebean_intercept.preGetter("commitId");
        return this.commitId;
    }

    protected void _ebean_set_commitId(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "commitId", (Object)this._ebean_get_commitId(), (Object)newValue);
        this.commitId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_commitId() {
        return this.commitId;
    }

    protected void _ebean_setni_commitId(String _newValue) {
        this.commitId = _newValue;
    }

    protected Boolean _ebean_get__isOutdated() {
        return this._isOutdated;
    }

    protected void _ebean_set__isOutdated(Boolean newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "_isOutdated", (Object)this._ebean_get__isOutdated(), (Object)newValue);
        this._isOutdated = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Boolean _ebean_getni__isOutdated() {
        return this._isOutdated;
    }

    protected void _ebean_setni__isOutdated(Boolean _newValue) {
        this._isOutdated = _newValue;
    }

    protected List _ebean_get_codeAuthors() {
        this._ebean_intercept.preGetter("codeAuthors");
        if (this.codeAuthors == null) {
            this.codeAuthors = new BeanList();
            ((BeanCollection)this.codeAuthors).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.codeAuthors;
    }

    protected void _ebean_set_codeAuthors(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "codeAuthors", (Object)this._ebean_get_codeAuthors(), (Object)newValue);
        this.codeAuthors = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_codeAuthors() {
        return this.codeAuthors;
    }

    protected void _ebean_setni_codeAuthors(List _newValue) {
        this.codeAuthors = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object _ebean_createCopy() {
        void p;
        CodeCommentThread codeCommentThread = new CodeCommentThread();
        codeCommentThread._ebean_setni_id(this._ebean_getni_id());
        codeCommentThread._ebean_setni_author(this._ebean_getni_author());
        codeCommentThread._ebean_setni_reviewComments(this._ebean_getni_reviewComments());
        codeCommentThread._ebean_setni_state(this._ebean_getni_state());
        codeCommentThread._ebean_setni_createdDate(this._ebean_getni_createdDate());
        codeCommentThread._ebean_setni_pullRequest(this._ebean_getni_pullRequest());
        codeCommentThread._ebean_setni_project(this._ebean_getni_project());
        codeCommentThread.codeRange = this.codeRange;
        codeCommentThread.prevCommitId = this.prevCommitId;
        codeCommentThread.commitId = this.commitId;
        codeCommentThread.codeAuthors = this.codeAuthors;
        return p;
    }

    @Override
    public Object _ebean_getField(int index2, Object o) {
        CodeCommentThread p = (CodeCommentThread)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p._ebean_getni_id();
            }
            case 2: {
                return p._ebean_getni_author();
            }
            case 3: {
                return p._ebean_getni_reviewComments();
            }
            case 4: {
                return p._ebean_getni_state();
            }
            case 5: {
                return p._ebean_getni_createdDate();
            }
            case 6: {
                return p._ebean_getni_pullRequest();
            }
            case 7: {
                return p._ebean_getni_project();
            }
            case 8: {
                return p.codeRange;
            }
            case 9: {
                return p.prevCommitId;
            }
            case 10: {
                return p.commitId;
            }
            case 11: {
                return p._isOutdated;
            }
            case 12: {
                return p.codeAuthors;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public Object _ebean_getFieldIntercept(int index2, Object o) {
        CodeCommentThread p = (CodeCommentThread)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_author();
            }
            case 3: {
                return p._ebean_get_reviewComments();
            }
            case 4: {
                return p._ebean_get_state();
            }
            case 5: {
                return p._ebean_get_createdDate();
            }
            case 6: {
                return p._ebean_get_pullRequest();
            }
            case 7: {
                return p._ebean_get_project();
            }
            case 8: {
                return p._ebean_get_codeRange();
            }
            case 9: {
                return p._ebean_get_prevCommitId();
            }
            case 10: {
                return p._ebean_get_commitId();
            }
            case 11: {
                return p._ebean_get__isOutdated();
            }
            case 12: {
                return p._ebean_get_codeAuthors();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public void _ebean_setField(int index2, Object o, Object arg) {
        CodeCommentThread p = (CodeCommentThread)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_setni_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_setni_author((UserIdent)arg);
                return;
            }
            case 3: {
                p._ebean_setni_reviewComments((List)arg);
                return;
            }
            case 4: {
                p._ebean_setni_state((CommentThread.ThreadState)((Object)arg));
                return;
            }
            case 5: {
                p._ebean_setni_createdDate((Date)arg);
                return;
            }
            case 6: {
                p._ebean_setni_pullRequest((PullRequest)arg);
                return;
            }
            case 7: {
                p._ebean_setni_project((Project)arg);
                return;
            }
            case 8: {
                p.codeRange = (CodeRange)arg;
                return;
            }
            case 9: {
                p.prevCommitId = (String)arg;
                return;
            }
            case 10: {
                p.commitId = (String)arg;
                return;
            }
            case 11: {
                p._isOutdated = (Boolean)arg;
                return;
            }
            case 12: {
                p.codeAuthors = (List)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        CodeCommentThread p = (CodeCommentThread)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_author((UserIdent)arg);
                return;
            }
            case 3: {
                p._ebean_set_reviewComments((List)arg);
                return;
            }
            case 4: {
                p._ebean_set_state((CommentThread.ThreadState)((Object)arg));
                return;
            }
            case 5: {
                p._ebean_set_createdDate((Date)arg);
                return;
            }
            case 6: {
                p._ebean_set_pullRequest((PullRequest)arg);
                return;
            }
            case 7: {
                p._ebean_set_project((Project)arg);
                return;
            }
            case 8: {
                p._ebean_set_codeRange((CodeRange)arg);
                return;
            }
            case 9: {
                p._ebean_set_prevCommitId((String)arg);
                return;
            }
            case 10: {
                p._ebean_set_commitId((String)arg);
                return;
            }
            case 11: {
                p._ebean_set__isOutdated((Boolean)arg);
                return;
            }
            case 12: {
                p._ebean_set_codeAuthors((List)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    @Override
    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "author", "reviewComments", "state", "createdDate", "pullRequest", "project", "codeRange", "prevCommitId", "commitId", "_isOutdated", "codeAuthors"};
    }

    @Override
    public void _ebean_setEmbeddedLoaded() {
        this._ebean_intercept.setEmbeddedLoaded((Object)this._ebean_getni_author());
        this._ebean_intercept.setEmbeddedLoaded((Object)this.codeRange);
    }

    @Override
    public boolean _ebean_isEmbeddedNewOrDirty() {
        if (this._ebean_intercept.isEmbeddedNewOrDirty((Object)this._ebean_getni_author())) {
            return true;
        }
        return this._ebean_intercept.isEmbeddedNewOrDirty((Object)this.codeRange);
    }

    @Override
    public Object _ebean_newInstance() {
        return new CodeCommentThread();
    }
}

