/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.TxScope;
import com.avaje.ebean.annotation.Transactional;
import com.avaje.ebean.bean.EnhancedTransactional;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.api.HelpScopeTrans;
import com.avaje.ebeaninternal.api.ScopeTrans;
import java.beans.PropertyChangeEvent;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import models.AbstractPosting;
import models.Attachment;
import models.Mention;
import models.NotificationEvent;
import models.TimelineItem;
import models.User;
import models.resource.Resource;
import models.resource.ResourceConvertible;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.joda.time.Duration;
import play.core.enhancers.PropertiesEnhancer;
import play.data.validation.Constraints;
import play.db.ebean.Model;
import play.libs.F;
import utils.JodaDateUtil;

@MappedSuperclass
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class Comment
extends Model
implements TimelineItem,
ResourceConvertible,
EntityBean,
EnhancedTransactional {
    private static final long serialVersionUID = 1L;
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @Lob
    @Constraints.Required
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String contents;
    @Constraints.Required
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date createdDate;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long authorId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String authorLoginId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String authorName;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long projectId;
    @Transient
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String parentCommentId;
    @Transient
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String previousContents;
    private static String _EBEAN_MARKER = "models.Comment";

    public Comment() {
        Date date = new Date();
        Comment comment = this;
        comment.setCreatedDate(date);
    }

    public Comment(User author, String contents) {
        this();
        this.setAuthor(author);
        String string = contents;
        Comment comment = this;
        comment.setContents(string);
    }

    public Duration ago() {
        Comment comment = this;
        Date date = null;
        date = comment.getCreatedDate();
        return JodaDateUtil.ago(date);
    }

    @Override
    public abstract Resource asResource();

    public abstract AbstractPosting getParent();

    @Transient
    public void setAuthor(User user) {
        Model model = user;
        Object object = null;
        object = model.getId();
        model = this;
        model.setAuthorId((Long)object);
        model = user;
        object = null;
        object = model.getLoginId();
        model = this;
        model.setAuthorLoginId((String)object);
        model = user;
        object = null;
        object = model.getName();
        model = this;
        model.setAuthorName((String)object);
        return;
    }

    @Transactional
    public void save() {
        TxScope txScope = new TxScope();
        ScopeTrans scopeTrans = HelpScopeTrans.createScopeTrans((TxScope)txScope);
        try {
            super.save();
            this.updateMention();
            this.getParent().update();
            HelpScopeTrans.onExitScopeTrans(null, (int)177, (ScopeTrans)scopeTrans);
            return;
        }
        catch (Throwable throwable) {
            HelpScopeTrans.onExitScopeTrans((Object)throwable, (int)191, (ScopeTrans)scopeTrans);
            throw throwable;
        }
    }

    @Transactional
    public void update() {
        TxScope txScope = new TxScope();
        ScopeTrans scopeTrans = HelpScopeTrans.createScopeTrans((TxScope)txScope);
        try {
            super.update();
            this.updateMention();
            HelpScopeTrans.onExitScopeTrans(null, (int)177, (ScopeTrans)scopeTrans);
            return;
        }
        catch (Throwable throwable) {
            HelpScopeTrans.onExitScopeTrans((Object)throwable, (int)191, (ScopeTrans)scopeTrans);
            throw throwable;
        }
    }

    protected void updateMention() {
        Comment comment = this;
        String string = null;
        string = comment.getContents();
        Mention.update(this.asResource(), NotificationEvent.getMentionedUsers(string));
        return;
    }

    public void delete() {
        Attachment.deleteAll(this.asResource());
        NotificationEvent.deleteBy(this.asResource());
        super.delete();
        this.getParent().update();
        return;
    }

    public static Comparator<Comment> comparator() {
        return new Comparator<Comment>(){

            @Override
            public int compare(Comment o1, Comment o2) {
                Comment comment = o1;
                Date date = null;
                Date date2 = date = comment.getCreatedDate();
                comment = o2;
                date = null;
                date = comment.getCreatedDate();
                return date2.compareTo(date);
            }
        };
    }

    @Override
    public Date getDate() {
        Comment comment = this;
        Date date = null;
        date = comment.getCreatedDate();
        return date;
    }

    public abstract Comment getParentComment();

    public abstract void setParentComment(Comment var1);

    public abstract List<? extends Comment> getSiblingComments();

    public abstract List<? extends Comment> getChildComments();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Comment rhs = (Comment)obj;
        Comment comment = this;
        Object object = null;
        object = comment.getId();
        Long l = object;
        comment = rhs;
        object = null;
        object = comment.getId();
        EqualsBuilder equalsBuilder = new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)l, object);
        comment = this;
        object = null;
        Object object2 = object = comment.getContents();
        comment = rhs;
        object = null;
        object = comment.getContents();
        EqualsBuilder equalsBuilder2 = equalsBuilder.append(object2, object);
        comment = this;
        object = null;
        Object object3 = object = comment.getCreatedDate();
        comment = rhs;
        object = null;
        object = comment.getCreatedDate();
        EqualsBuilder equalsBuilder3 = equalsBuilder2.append(object3, object);
        comment = this;
        object = null;
        Object object4 = object = comment.getAuthorId();
        comment = rhs;
        object = null;
        object = comment.getAuthorId();
        EqualsBuilder equalsBuilder4 = equalsBuilder3.append(object4, object);
        comment = this;
        object = null;
        Object object5 = object = comment.getAuthorLoginId();
        comment = rhs;
        object = null;
        object = comment.getAuthorLoginId();
        EqualsBuilder equalsBuilder5 = equalsBuilder4.append(object5, object);
        comment = this;
        object = null;
        Object object6 = object = comment.getAuthorName();
        comment = rhs;
        object = null;
        object = comment.getAuthorName();
        return equalsBuilder5.append(object6, object).isEquals();
    }

    public int hashCode() {
        Comment comment = this;
        Object object = null;
        object = comment.getId();
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder().appendSuper(super.hashCode()).append(object);
        comment = this;
        object = null;
        object = comment.getContents();
        HashCodeBuilder hashCodeBuilder2 = hashCodeBuilder.append(object);
        comment = this;
        object = null;
        object = comment.getCreatedDate();
        HashCodeBuilder hashCodeBuilder3 = hashCodeBuilder2.append(object);
        comment = this;
        object = null;
        object = comment.getAuthorId();
        HashCodeBuilder hashCodeBuilder4 = hashCodeBuilder3.append(object);
        comment = this;
        object = null;
        object = comment.getAuthorLoginId();
        HashCodeBuilder hashCodeBuilder5 = hashCodeBuilder4.append(object);
        comment = this;
        object = null;
        object = comment.getAuthorName();
        return hashCodeBuilder5.append(object).toHashCode();
    }

    public boolean isAuthoredBy(@Nonnull User user) {
        Model model = this;
        String string = null;
        String string2 = string = model.getAuthorLoginId();
        model = user;
        string = null;
        string = model.getLoginId();
        return StringUtils.equalsIgnoreCase((String)string2, (String)string);
    }

    public String toString() {
        Comment comment = this;
        Object object = null;
        object = comment.getId();
        StringBuilder stringBuilder = new StringBuilder().append("Comment{id=").append(object).append(", contents='");
        comment = this;
        object = null;
        object = comment.getContents();
        StringBuilder stringBuilder2 = stringBuilder.append((String)object).append('\'').append(", createdDate=");
        comment = this;
        object = null;
        object = comment.getCreatedDate();
        StringBuilder stringBuilder3 = stringBuilder2.append(object).append(", authorId=");
        comment = this;
        object = null;
        object = comment.getAuthorId();
        StringBuilder stringBuilder4 = stringBuilder3.append(object).append(", authorLoginId='");
        comment = this;
        object = null;
        object = comment.getAuthorLoginId();
        StringBuilder stringBuilder5 = stringBuilder4.append((String)object).append('\'').append(", authorName='");
        comment = this;
        object = null;
        object = comment.getAuthorName();
        StringBuilder stringBuilder6 = stringBuilder5.append((String)object).append('\'').append(", projectId=");
        comment = this;
        object = null;
        object = comment.getProjectId();
        return stringBuilder6.append(object).append(", getParentComment=").append(this.getParentComment()).append('}').toString();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
        return;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getContents() {
        return this._ebean_get_contents();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setContents(String string) {
        this._ebean_set_contents(string);
        return;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getCreatedDate() {
        return this._ebean_get_createdDate();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCreatedDate(Date date) {
        this._ebean_set_createdDate(date);
        return;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getAuthorId() {
        return this._ebean_get_authorId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setAuthorId(Long l) {
        this._ebean_set_authorId(l);
        return;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getAuthorLoginId() {
        return this._ebean_get_authorLoginId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setAuthorLoginId(String string) {
        this._ebean_set_authorLoginId(string);
        return;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getAuthorName() {
        return this._ebean_get_authorName();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setAuthorName(String string) {
        this._ebean_set_authorName(string);
        return;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getProjectId() {
        return this._ebean_get_projectId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProjectId(Long l) {
        this._ebean_set_projectId(l);
        return;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getParentCommentId() {
        return this.parentCommentId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setParentCommentId(String string) {
        this.parentCommentId = string;
        return;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getPreviousContents() {
        return this.previousContents;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setPreviousContents(String string) {
        this.previousContents = string;
        return;
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
        return;
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
        return;
    }

    protected String _ebean_get_contents() {
        this._ebean_intercept.preGetter("contents");
        return this.contents;
    }

    protected void _ebean_set_contents(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "contents", (Object)this._ebean_get_contents(), (Object)newValue);
        this.contents = newValue;
        this._ebean_intercept.postSetter(evt);
        return;
    }

    protected String _ebean_getni_contents() {
        return this.contents;
    }

    protected void _ebean_setni_contents(String _newValue) {
        this.contents = _newValue;
        return;
    }

    protected Date _ebean_get_createdDate() {
        this._ebean_intercept.preGetter("createdDate");
        return this.createdDate;
    }

    protected void _ebean_set_createdDate(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "createdDate", (Object)this._ebean_get_createdDate(), (Object)newValue);
        this.createdDate = newValue;
        this._ebean_intercept.postSetter(evt);
        return;
    }

    protected Date _ebean_getni_createdDate() {
        return this.createdDate;
    }

    protected void _ebean_setni_createdDate(Date _newValue) {
        this.createdDate = _newValue;
        return;
    }

    protected Long _ebean_get_authorId() {
        this._ebean_intercept.preGetter("authorId");
        return this.authorId;
    }

    protected void _ebean_set_authorId(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "authorId", (Object)this._ebean_get_authorId(), (Object)newValue);
        this.authorId = newValue;
        this._ebean_intercept.postSetter(evt);
        return;
    }

    protected Long _ebean_getni_authorId() {
        return this.authorId;
    }

    protected void _ebean_setni_authorId(Long _newValue) {
        this.authorId = _newValue;
        return;
    }

    protected String _ebean_get_authorLoginId() {
        this._ebean_intercept.preGetter("authorLoginId");
        return this.authorLoginId;
    }

    protected void _ebean_set_authorLoginId(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "authorLoginId", (Object)this._ebean_get_authorLoginId(), (Object)newValue);
        this.authorLoginId = newValue;
        this._ebean_intercept.postSetter(evt);
        return;
    }

    protected String _ebean_getni_authorLoginId() {
        return this.authorLoginId;
    }

    protected void _ebean_setni_authorLoginId(String _newValue) {
        this.authorLoginId = _newValue;
        return;
    }

    protected String _ebean_get_authorName() {
        this._ebean_intercept.preGetter("authorName");
        return this.authorName;
    }

    protected void _ebean_set_authorName(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "authorName", (Object)this._ebean_get_authorName(), (Object)newValue);
        this.authorName = newValue;
        this._ebean_intercept.postSetter(evt);
        return;
    }

    protected String _ebean_getni_authorName() {
        return this.authorName;
    }

    protected void _ebean_setni_authorName(String _newValue) {
        this.authorName = _newValue;
        return;
    }

    protected Long _ebean_get_projectId() {
        this._ebean_intercept.preGetter("projectId");
        return this.projectId;
    }

    protected void _ebean_set_projectId(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "projectId", (Object)this._ebean_get_projectId(), (Object)newValue);
        this.projectId = newValue;
        this._ebean_intercept.postSetter(evt);
        return;
    }

    protected Long _ebean_getni_projectId() {
        return this.projectId;
    }

    protected void _ebean_setni_projectId(Long _newValue) {
        this.projectId = _newValue;
        return;
    }

    protected String _ebean_get_parentCommentId() {
        return this.parentCommentId;
    }

    protected void _ebean_set_parentCommentId(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "parentCommentId", (Object)this._ebean_get_parentCommentId(), (Object)newValue);
        this.parentCommentId = newValue;
        this._ebean_intercept.postSetter(evt);
        return;
    }

    protected String _ebean_getni_parentCommentId() {
        return this.parentCommentId;
    }

    protected void _ebean_setni_parentCommentId(String _newValue) {
        this.parentCommentId = _newValue;
        return;
    }

    protected String _ebean_get_previousContents() {
        return this.previousContents;
    }

    protected void _ebean_set_previousContents(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "previousContents", (Object)this._ebean_get_previousContents(), (Object)newValue);
        this.previousContents = newValue;
        this._ebean_intercept.postSetter(evt);
        return;
    }

    protected String _ebean_getni_previousContents() {
        return this.previousContents;
    }

    protected void _ebean_setni_previousContents(String _newValue) {
        this.previousContents = _newValue;
        return;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        Comment comment = new Comment();
        comment.id = this.id;
        comment.contents = this.contents;
        comment.createdDate = this.createdDate;
        comment.authorId = this.authorId;
        comment.authorLoginId = this.authorLoginId;
        comment.authorName = this.authorName;
        comment.projectId = this.projectId;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        Comment p = (Comment)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.contents;
            }
            case 3: {
                return p.createdDate;
            }
            case 4: {
                return p.authorId;
            }
            case 5: {
                return p.authorLoginId;
            }
            case 6: {
                return p.authorName;
            }
            case 7: {
                return p.projectId;
            }
            case 8: {
                return p.parentCommentId;
            }
            case 9: {
                return p.previousContents;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        Comment p = (Comment)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_contents();
            }
            case 3: {
                return p._ebean_get_createdDate();
            }
            case 4: {
                return p._ebean_get_authorId();
            }
            case 5: {
                return p._ebean_get_authorLoginId();
            }
            case 6: {
                return p._ebean_get_authorName();
            }
            case 7: {
                return p._ebean_get_projectId();
            }
            case 8: {
                return p._ebean_get_parentCommentId();
            }
            case 9: {
                return p._ebean_get_previousContents();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        Comment p = (Comment)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.contents = (String)arg;
                return;
            }
            case 3: {
                p.createdDate = (Date)arg;
                return;
            }
            case 4: {
                p.authorId = (Long)arg;
                return;
            }
            case 5: {
                p.authorLoginId = (String)arg;
                return;
            }
            case 6: {
                p.authorName = (String)arg;
                return;
            }
            case 7: {
                p.projectId = (Long)arg;
                return;
            }
            case 8: {
                p.parentCommentId = (String)arg;
                return;
            }
            case 9: {
                p.previousContents = (String)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        Comment p = (Comment)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_contents((String)arg);
                return;
            }
            case 3: {
                p._ebean_set_createdDate((Date)arg);
                return;
            }
            case 4: {
                p._ebean_set_authorId((Long)arg);
                return;
            }
            case 5: {
                p._ebean_set_authorLoginId((String)arg);
                return;
            }
            case 6: {
                p._ebean_set_authorName((String)arg);
                return;
            }
            case 7: {
                p._ebean_set_projectId((Long)arg);
                return;
            }
            case 8: {
                p._ebean_set_parentCommentId((String)arg);
                return;
            }
            case 9: {
                p._ebean_set_previousContents((String)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "contents", "createdDate", "authorId", "authorLoginId", "authorName", "projectId", "parentCommentId", "previousContents"};
    }

    public void _ebean_setEmbeddedLoaded() {
        return;
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new Comment();
    }
}

