/*
 * Decompiled with CFR 0.152.
 */
package models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import models.Issue;
import models.Posting;
import models.Project;
import models.PullRequest;
import models.User;
import org.apache.commons.lang3.StringUtils;
import play.Configuration;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import playRepository.Commit;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class History {
    private String who;
    private String userPageUrl;
    private String userAvatarUrl;
    private Date when;
    private String where;
    private String what;
    private String how;
    private String shortTitle;
    private String url;

    public String getWho() {
        return this.who;
    }

    public void setWho(String who) {
        this.who = who;
    }

    public Date getWhen() {
        return this.when;
    }

    public void setWhen(Date when) {
        this.when = when;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public String getWhat() {
        return this.what;
    }

    public void setWhat(String what) {
        this.what = what;
    }

    public String getHow() {
        return this.how;
    }

    public void setHow(String how) {
        this.how = how;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        String contextRoot = Configuration.root().getString("application.context");
        this.url = StringUtils.isBlank((CharSequence)contextRoot) ? url : (contextRoot + "/" + url).replaceAll("//", "/");
    }

    public String getUserPageUrl() {
        return this.userPageUrl;
    }

    public void setUserPageUrl(String userPageUrl) {
        this.userPageUrl = userPageUrl;
    }

    public void setUserAvatarUrl(String userAvatarUrl) {
        this.userAvatarUrl = userAvatarUrl;
    }

    public String getUserAvatarUrl() {
        return this.userAvatarUrl;
    }

    public String getShortTitle() {
        return this.shortTitle;
    }

    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    public static List<History> makeHistory(String userName, Project project2, List<Commit> commits, List<Issue> issues2, List<Posting> postings, List<PullRequest> pullRequests2) {
        ArrayList<History> histories = new ArrayList<History>();
        History.buildCommitHistory(userName, project2, commits, histories);
        History.buildIssueHistory(userName, project2, issues2, histories);
        History.buildPostingHistory(userName, project2, postings, histories);
        History.buildPullRequestsHistory(userName, project2, pullRequests2, histories);
        History.sort(histories);
        return histories;
    }

    private static void buildPullRequestsHistory(String userName, Project project2, List<PullRequest> pullRequests2, List<History> histories) {
        for (PullRequest pull : pullRequests2) {
            History pullHistory = new History();
            Model model = pull;
            Object object = null;
            object = model.getContributor();
            User contributor = object;
            model = contributor;
            object = null;
            object = model.getLoginId();
            pullHistory.setWho((String)object);
            model = contributor;
            object = null;
            object = model.getLoginId();
            History.setUserPageUrl(pullHistory, User.findByLoginId((String)object));
            model = pull;
            object = null;
            object = model.getCreated();
            pullHistory.setWhen((Date)object);
            model = project2;
            object = null;
            object = model.getName();
            pullHistory.setWhere((String)object);
            pullHistory.setWhat("pullrequest");
            model = pull;
            object = null;
            object = model.getNumber();
            pullHistory.setShortTitle("#" + object);
            model = pull;
            object = null;
            object = model.getTitle();
            pullHistory.setHow((String)object);
            model = project2;
            object = null;
            object = model.getName();
            StringBuilder stringBuilder = new StringBuilder().append("/").append(userName).append("/").append((String)object).append("/pullRequest/");
            model = pull;
            object = null;
            object = model.getNumber();
            pullHistory.setUrl(stringBuilder.append(object).toString());
            histories.add(pullHistory);
        }
    }

    private static void sort(List<History> histories) {
        Collections.sort(histories, new Comparator<History>(){

            @Override
            public int compare(History h1, History h2) {
                return h2.getWhen().compareTo(h1.getWhen());
            }
        });
    }

    private static void buildPostingHistory(String userName, Project project2, List<Posting> postings, List<History> histories) {
        for (Posting posting : postings) {
            History postingHistory = new History();
            Model model = posting;
            Object object = null;
            object = model.getAuthorName();
            String authorName = object;
            postingHistory.setWho(authorName);
            model = posting;
            object = null;
            object = model.getAuthorLoginId();
            History.setUserPageUrl(postingHistory, User.findByLoginId((String)object));
            model = posting;
            object = null;
            object = model.getCreatedDate();
            postingHistory.setWhen((Date)object);
            model = project2;
            object = null;
            object = model.getName();
            postingHistory.setWhere((String)object);
            postingHistory.setWhat("post");
            postingHistory.setShortTitle("#" + posting.number);
            model = posting;
            object = null;
            object = model.getTitle();
            postingHistory.setHow((String)object);
            model = project2;
            object = null;
            object = model.getName();
            postingHistory.setUrl("/" + userName + "/" + (String)object + "/post/" + posting.number);
            histories.add(postingHistory);
        }
    }

    private static void buildIssueHistory(String userName, Project project2, List<Issue> issues2, List<History> histories) {
        for (Issue issue2 : issues2) {
            History issueHistory = new History();
            Model model = issue2;
            Object object = null;
            object = model.getAuthorName();
            String authorName = object;
            issueHistory.setWho(authorName);
            model = issue2;
            object = null;
            object = model.getAuthorLoginId();
            History.setUserPageUrl(issueHistory, User.findByLoginId((String)object));
            model = issue2;
            object = null;
            object = model.getCreatedDate();
            issueHistory.setWhen((Date)object);
            model = project2;
            object = null;
            object = model.getName();
            issueHistory.setWhere((String)object);
            issueHistory.setWhat("issue");
            issueHistory.setShortTitle("#" + issue2.number);
            model = issue2;
            object = null;
            object = model.getTitle();
            issueHistory.setHow((String)object);
            model = project2;
            object = null;
            object = model.getName();
            issueHistory.setUrl("/" + userName + "/" + (String)object + "/issue/" + issue2.number);
            histories.add(issueHistory);
        }
    }

    private static void buildCommitHistory(String userName, Project project2, List<Commit> commits, List<History> histories) {
        if (commits != null) {
            for (Commit commit : commits) {
                History commitHistory = new History();
                String authorEmail = commit.getAuthorEmail();
                if (User.isEmailExist(authorEmail)) {
                    History.setUserPageUrl(commitHistory, User.findByEmail(authorEmail));
                } else {
                    commitHistory.setWho(commit.getAuthorName());
                }
                commitHistory.setWhen(commit.getCommitterDate());
                Project project3 = project2;
                String string = null;
                string = project3.getName();
                commitHistory.setWhere(string);
                commitHistory.setWhat("commit");
                commitHistory.setShortTitle(commit.getShortId());
                commitHistory.setHow(commit.getShortMessage());
                project3 = project2;
                string = null;
                string = project3.getName();
                commitHistory.setUrl("/" + userName + "/" + string + "/commit/" + commit.getId());
                histories.add(commitHistory);
            }
        }
    }

    private static void setUserPageUrl(History history2, User user) {
        User user2 = user;
        String string = null;
        string = user2.getName();
        history2.setWho(string);
        user2 = user;
        string = null;
        string = user2.getLoginId();
        history2.setUserPageUrl("/" + string);
        history2.setUserAvatarUrl(user.avatarUrl());
    }
}

