/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.bean.EntityBean;
import controllers.routes;
import java.beans.PropertyChangeEvent;
import java.util.Date;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import models.Project;
import models.User;
import models.enumeration.ResourceType;
import models.resource.Resource;
import models.resource.ResourceConvertible;
import org.apache.commons.lang3.RandomStringUtils;
import org.joda.time.DateTime;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.F;
import utils.Url;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ProjectTransfer
extends Model
implements ResourceConvertible,
EntityBean {
    private static final long serialVersionUID = 1L;
    public static final Model.Finder<Long, ProjectTransfer> find = new Model.Finder(Long.class, ProjectTransfer.class);
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public User sender;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String destination;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Project project;
    @Temporal(value=TemporalType.TIMESTAMP)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date requested;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String confirmKey;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public boolean accepted;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String newProjectName;
    private static String _EBEAN_MARKER = "models.ProjectTransfer";

    public static ProjectTransfer requestNewTransfer(Project project2, User sender, String destination) {
        ProjectTransfer pt = (ProjectTransfer)find.where().eq("project", (Object)project2).eq("sender", (Object)sender).eq("destination", (Object)destination).findUnique();
        if (pt != null) {
            Object object = new Date();
            ProjectTransfer projectTransfer = pt;
            projectTransfer.setRequested((Date)object);
            object = RandomStringUtils.randomAlphanumeric((int)50);
            projectTransfer = pt;
            projectTransfer.setConfirmKey((String)object);
            pt.update();
        } else {
            pt = new ProjectTransfer();
            Object object = project2;
            Model model = pt;
            model.setProject((Project)object);
            object = sender;
            model = pt;
            model.setSender((User)object);
            object = destination;
            model = pt;
            model.setDestination((String)object);
            object = new Date();
            model = pt;
            model.setRequested((Date)object);
            object = RandomStringUtils.randomAlphanumeric((int)50);
            model = pt;
            model.setConfirmKey((String)object);
            model = project2;
            object = null;
            object = model.getName();
            object = Project.newProjectName(destination, (String)object);
            model = pt;
            model.setNewProjectName((String)object);
            pt.save();
        }
        return pt;
    }

    public String getAcceptUrl() {
        ProjectTransfer projectTransfer = this;
        Object object = null;
        object = projectTransfer.getId();
        long l = (Long)object;
        projectTransfer = this;
        object = null;
        object = projectTransfer.getConfirmKey();
        return Url.create(routes.ProjectApp.acceptTransfer(l, (String)object).url());
    }

    public static ProjectTransfer findValidOne(Long id) {
        Date now = new Date();
        DateTime oneDayBefore = new DateTime((Object)now).minusDays(1);
        return (ProjectTransfer)find.where().eq("id", (Object)id).eq("accepted", (Object)false).between("requested", (Object)oneDayBefore, (Object)now).findUnique();
    }

    public static void deleteExisting(Project project2, User sender, String destination) {
        ProjectTransfer pt = (ProjectTransfer)find.where().eq("project", (Object)project2).eq("sender", (Object)sender).eq("destination", (Object)destination).findUnique();
        if (pt != null) {
            pt.delete();
        }
    }

    @Override
    public Resource asResource() {
        return new Resource(){

            @Override
            public String getId() {
                ProjectTransfer projectTransfer = ProjectTransfer.this;
                Long l = null;
                l = projectTransfer.getId();
                return l.toString();
            }

            @Override
            public Project getProject() {
                ProjectTransfer projectTransfer = ProjectTransfer.this;
                Project project2 = null;
                project2 = projectTransfer.getProject();
                return project2;
            }

            @Override
            public ResourceType getType() {
                return ResourceType.PROJECT_TRANSFER;
            }
        };
    }

    public static List<ProjectTransfer> findByProject(Project project2) {
        return find.where().eq("project", (Object)project2).findList();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public User getSender() {
        return this._ebean_get_sender();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setSender(User user) {
        this._ebean_set_sender(user);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getDestination() {
        return this._ebean_get_destination();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setDestination(String string) {
        this._ebean_set_destination(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Project getProject() {
        return this._ebean_get_project();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProject(Project project2) {
        this._ebean_set_project(project2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getRequested() {
        return this._ebean_get_requested();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setRequested(Date date) {
        this._ebean_set_requested(date);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getConfirmKey() {
        return this._ebean_get_confirmKey();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setConfirmKey(String string) {
        this._ebean_set_confirmKey(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public boolean getAccepted() {
        return this._ebean_get_accepted();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setAccepted(boolean bl) {
        this._ebean_set_accepted(bl);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getNewProjectName() {
        return this._ebean_get_newProjectName();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setNewProjectName(String string) {
        this._ebean_set_newProjectName(string);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected User _ebean_get_sender() {
        this._ebean_intercept.preGetter("sender");
        return this.sender;
    }

    protected void _ebean_set_sender(User newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "sender", (Object)this._ebean_get_sender(), (Object)newValue);
        this.sender = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected User _ebean_getni_sender() {
        return this.sender;
    }

    protected void _ebean_setni_sender(User _newValue) {
        this.sender = _newValue;
    }

    protected String _ebean_get_destination() {
        this._ebean_intercept.preGetter("destination");
        return this.destination;
    }

    protected void _ebean_set_destination(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "destination", (Object)this._ebean_get_destination(), (Object)newValue);
        this.destination = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_destination() {
        return this.destination;
    }

    protected void _ebean_setni_destination(String _newValue) {
        this.destination = _newValue;
    }

    protected Project _ebean_get_project() {
        this._ebean_intercept.preGetter("project");
        return this.project;
    }

    protected void _ebean_set_project(Project newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "project", (Object)this._ebean_get_project(), (Object)newValue);
        this.project = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Project _ebean_getni_project() {
        return this.project;
    }

    protected void _ebean_setni_project(Project _newValue) {
        this.project = _newValue;
    }

    protected Date _ebean_get_requested() {
        this._ebean_intercept.preGetter("requested");
        return this.requested;
    }

    protected void _ebean_set_requested(Date newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "requested", (Object)this._ebean_get_requested(), (Object)newValue);
        this.requested = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Date _ebean_getni_requested() {
        return this.requested;
    }

    protected void _ebean_setni_requested(Date _newValue) {
        this.requested = _newValue;
    }

    protected String _ebean_get_confirmKey() {
        this._ebean_intercept.preGetter("confirmKey");
        return this.confirmKey;
    }

    protected void _ebean_set_confirmKey(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "confirmKey", (Object)this._ebean_get_confirmKey(), (Object)newValue);
        this.confirmKey = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_confirmKey() {
        return this.confirmKey;
    }

    protected void _ebean_setni_confirmKey(String _newValue) {
        this.confirmKey = _newValue;
    }

    protected boolean _ebean_get_accepted() {
        this._ebean_intercept.preGetter("accepted");
        return this.accepted;
    }

    protected void _ebean_set_accepted(boolean newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "accepted", this._ebean_get_accepted(), newValue);
        this.accepted = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected boolean _ebean_getni_accepted() {
        return this.accepted;
    }

    protected void _ebean_setni_accepted(boolean _newValue) {
        this.accepted = _newValue;
    }

    protected String _ebean_get_newProjectName() {
        this._ebean_intercept.preGetter("newProjectName");
        return this.newProjectName;
    }

    protected void _ebean_set_newProjectName(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "newProjectName", (Object)this._ebean_get_newProjectName(), (Object)newValue);
        this.newProjectName = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_newProjectName() {
        return this.newProjectName;
    }

    protected void _ebean_setni_newProjectName(String _newValue) {
        this.newProjectName = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        ProjectTransfer projectTransfer = new ProjectTransfer();
        projectTransfer.id = this.id;
        projectTransfer.sender = this.sender;
        projectTransfer.destination = this.destination;
        projectTransfer.project = this.project;
        projectTransfer.requested = this.requested;
        projectTransfer.confirmKey = this.confirmKey;
        projectTransfer.accepted = this.accepted;
        projectTransfer.newProjectName = this.newProjectName;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        ProjectTransfer p = (ProjectTransfer)o;
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.sender;
            }
            case 3: {
                return p.destination;
            }
            case 4: {
                return p.project;
            }
            case 5: {
                return p.requested;
            }
            case 6: {
                return p.confirmKey;
            }
            case 7: {
                return p.accepted;
            }
            case 8: {
                return p.newProjectName;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        ProjectTransfer p = (ProjectTransfer)o;
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_sender();
            }
            case 3: {
                return p._ebean_get_destination();
            }
            case 4: {
                return p._ebean_get_project();
            }
            case 5: {
                return p._ebean_get_requested();
            }
            case 6: {
                return p._ebean_get_confirmKey();
            }
            case 7: {
                return p._ebean_get_accepted();
            }
            case 8: {
                return p._ebean_get_newProjectName();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        ProjectTransfer p = (ProjectTransfer)o;
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.sender = (User)arg;
                return;
            }
            case 3: {
                p.destination = (String)arg;
                return;
            }
            case 4: {
                p.project = (Project)arg;
                return;
            }
            case 5: {
                p.requested = (Date)arg;
                return;
            }
            case 6: {
                p.confirmKey = (String)arg;
                return;
            }
            case 7: {
                p.accepted = (Boolean)arg;
                return;
            }
            case 8: {
                p.newProjectName = (String)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        ProjectTransfer p = (ProjectTransfer)o;
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_sender((User)arg);
                return;
            }
            case 3: {
                p._ebean_set_destination((String)arg);
                return;
            }
            case 4: {
                p._ebean_set_project((Project)arg);
                return;
            }
            case 5: {
                p._ebean_set_requested((Date)arg);
                return;
            }
            case 6: {
                p._ebean_set_confirmKey((String)arg);
                return;
            }
            case 7: {
                p._ebean_set_accepted((Boolean)arg);
                return;
            }
            case 8: {
                p._ebean_set_newProjectName((String)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "sender", "destination", "project", "requested", "confirmKey", "accepted", "newProjectName"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        ProjectTransfer projectTransfer = this;
        synchronized (projectTransfer) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((ProjectTransfer)obj)._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new ProjectTransfer();
    }
}

