/*
 * Decompiled with CFR 0.152.
 */
package models;

import java.util.ArrayList;
import java.util.List;
import models.PullRequest;
import models.PullRequestCommit;
import models.User;
import models.enumeration.State;
import play.core.enhancers.PropertiesEnhancer;
import playRepository.GitCommit;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class PullRequestMergeResult {
    private List<GitCommit> gitCommits;
    private List<PullRequestCommit> newCommits;
    private PullRequest pullRequest;

    public List<GitCommit> getGitCommits() {
        return this.gitCommits;
    }

    public void setGitCommits(List<GitCommit> commits) {
        this.gitCommits = commits;
    }

    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    public void setPullRequest(PullRequest pullRequest2) {
        this.pullRequest = pullRequest2;
    }

    public boolean hasDiffCommits() {
        return this.gitCommits.size() > 0;
    }

    public boolean conflicts() {
        PullRequest pullRequest2 = this.pullRequest;
        Boolean bl = null;
        bl = pullRequest2.getIsConflict();
        return bl;
    }

    public List<PullRequestCommit> getNewCommits() {
        return this.newCommits;
    }

    public List<PullRequestCommit> findNewCommits() {
        ArrayList<PullRequestCommit> currentCommits = new ArrayList<PullRequestCommit>();
        for (GitCommit commit : this.gitCommits) {
            boolean existCommit = false;
            List pullRequestCommits = PullRequestCommit.find.where().eq("pullRequest", (Object)this.pullRequest).eq("state", (Object)PullRequestCommit.State.CURRENT).findList();
            for (PullRequestCommit pullRequestCommit : pullRequestCommits) {
                if (!commit.getId().equals(pullRequestCommit.commitId)) continue;
                existCommit = true;
                break;
            }
            if (existCommit) continue;
            PullRequestCommit pullRequestCommit = PullRequestCommit.bindPullRequestCommit(commit, this.pullRequest);
            currentCommits.add(pullRequestCommit);
        }
        return currentCommits;
    }

    public void save() {
        this.pullRequest.endMerge();
        this.pullRequest.update();
    }

    public void saveCommits() {
        this.newCommits = this.findNewCommits();
        this.saveNewCommits();
        this.updatePriorCommits();
    }

    public void saveNewCommits() {
        for (PullRequestCommit commit : this.newCommits) {
            commit.save();
        }
    }

    public void updatePriorCommits() {
        for (PullRequestCommit pullRequestCommit : PullRequestCommit.find.where().eq("pullRequest", (Object)this.pullRequest).findList()) {
            boolean existCommit = false;
            for (GitCommit commit : this.gitCommits) {
                if (!commit.getId().equals(pullRequestCommit.commitId)) continue;
                existCommit = true;
                break;
            }
            if (existCommit) continue;
            PullRequestCommit.State state = PullRequestCommit.State.PRIOR;
            PullRequestCommit pullRequestCommit2 = pullRequestCommit;
            pullRequestCommit2.setState(state);
            pullRequestCommit.update();
        }
    }

    public void setConflictStateOfPullRequest() {
        Boolean bl = true;
        PullRequest pullRequest2 = this.pullRequest;
        pullRequest2.setIsConflict(bl);
    }

    public void setResolvedStateOfPullRequest() {
        Boolean bl = false;
        PullRequest pullRequest2 = this.pullRequest;
        pullRequest2.setIsConflict(bl);
    }

    public void setMergedStateOfPullRequest(User receiver) {
        Object object = false;
        PullRequest pullRequest2 = this.pullRequest;
        pullRequest2.setIsConflict((Boolean)object);
        object = State.MERGED;
        pullRequest2 = this.pullRequest;
        pullRequest2.setState((State)((Object)object));
        object = receiver;
        pullRequest2 = this.pullRequest;
        pullRequest2.setReceiver((User)object);
    }
}

