/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.bean.EntityBean;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OptimisticLockException;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import models.Project;
import models.User;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.libs.F;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"user_id", "project_id"})})
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class RecentProject
extends Model
implements EntityBean {
    private static final long serialVersionUID = 7306890271871188281L;
    public static int MAX_RECENT_LIST_PER_USER = 30;
    public static Model.Finder<Long, RecentProject> find = new Model.Finder(Long.class, RecentProject.class);
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long userId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String owner;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long projectId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String projectName;
    private static String _EBEAN_MARKER = "models.RecentProject";

    public RecentProject(User user, Project project2) {
        Model model = user;
        Object object = null;
        object = model.getId();
        model = this;
        model.setUserId((Long)object);
        model = project2;
        object = null;
        object = model.getOwner();
        model = this;
        model.setOwner((String)object);
        model = project2;
        object = null;
        object = model.getId();
        model = this;
        model.setProjectId((Long)object);
        model = project2;
        object = null;
        object = model.getName();
        model = this;
        model.setProjectName((String)object);
    }

    public static List<Project> getRecentProjects(@Nonnull User user) {
        Model model = user;
        Long l = null;
        l = model.getId();
        List recentProjects = find.where().eq("userId", (Object)l).orderBy("id desc").findList();
        ArrayList<Project> found = new ArrayList<Project>();
        for (RecentProject rp : recentProjects) {
            model = rp;
            l = null;
            l = model.getProjectId();
            Project project2 = (Project)Project.find.byId((Object)l);
            if (project2 == null) continue;
            found.add(project2);
        }
        return found;
    }

    public static void addNew(final User user, final Project project2) {
        F.Promise promise = F.Promise.promise((F.Function0)new F.Function0<Void>(){

            public Void apply() {
                RecentProject.addVisitHistory(user, project2);
                return null;
            }
        });
    }

    @Transactional
    private static void addVisitHistory(User user, Project project2) {
        try {
            RecentProject.deletePrevious(user, project2);
            RecentProject recentProject = new RecentProject(user, project2);
            recentProject.save();
            Logger.debug((String)"recentProject {}", (Object[])new Object[]{recentProject});
            RecentProject.deleteOldestIfOverflow(user);
        }
        catch (OptimisticLockException ole) {
            ole.printStackTrace();
        }
    }

    public static void deletePrevious(User user, Project project2) {
        Model model = user;
        Long l = null;
        l = model.getId();
        ExpressionList expressionList = find.where().eq("userId", (Object)l);
        model = project2;
        l = null;
        l = model.getId();
        RecentProject existed = (RecentProject)((Object)expressionList.eq("projectId", (Object)l).findUnique());
        if (existed != null) {
            existed.delete();
        }
    }

    private static void deleteOldestIfOverflow(User user) {
        User user2 = user;
        Long l = null;
        l = user2.getId();
        List recentProjects = find.where().eq("userId", (Object)l).findList();
        while (recentProjects.size() > MAX_RECENT_LIST_PER_USER) {
            Comparator<RecentProject> comparator = new Comparator<RecentProject>(){

                @Override
                public int compare(RecentProject p1, RecentProject p2) {
                    RecentProject recentProject = p1;
                    Long l = null;
                    l = recentProject.getId();
                    long l2 = l;
                    recentProject = p2;
                    l = null;
                    l = recentProject.getId();
                    return Long.compare(l2, l);
                }
            };
            RecentProject oldest = Collections.min(recentProjects, comparator);
            oldest.refresh();
            oldest.delete();
        }
    }

    public static void deleteAll(User user) {
        User user2 = user;
        Long l = null;
        l = user2.getId();
        List recentProjects = find.where().eq("userId", (Object)l).findList();
        for (RecentProject rp : recentProjects) {
            rp.delete();
        }
    }

    public String toString() {
        RecentProject recentProject = this;
        Object object = null;
        object = recentProject.getId();
        StringBuilder stringBuilder = new StringBuilder().append("RecentProject{id=").append(object).append(", userId=");
        recentProject = this;
        object = null;
        object = recentProject.getUserId();
        StringBuilder stringBuilder2 = stringBuilder.append(object).append(", owner='");
        recentProject = this;
        object = null;
        object = recentProject.getOwner();
        StringBuilder stringBuilder3 = stringBuilder2.append((String)object).append('\'').append(", projectId=");
        recentProject = this;
        object = null;
        object = recentProject.getProjectId();
        StringBuilder stringBuilder4 = stringBuilder3.append(object).append(", projectName='");
        recentProject = this;
        object = null;
        object = recentProject.getProjectName();
        return stringBuilder4.append((String)object).append('\'').append('}').toString();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getUserId() {
        return this._ebean_get_userId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setUserId(Long l) {
        this._ebean_set_userId(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getOwner() {
        return this._ebean_get_owner();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setOwner(String string) {
        this._ebean_set_owner(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getProjectId() {
        return this._ebean_get_projectId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProjectId(Long l) {
        this._ebean_set_projectId(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getProjectName() {
        return this._ebean_get_projectName();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProjectName(String string) {
        this._ebean_set_projectName(string);
    }

    public RecentProject() {
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected Long _ebean_get_userId() {
        this._ebean_intercept.preGetter("userId");
        return this.userId;
    }

    protected void _ebean_set_userId(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "userId", (Object)this._ebean_get_userId(), (Object)newValue);
        this.userId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_userId() {
        return this.userId;
    }

    protected void _ebean_setni_userId(Long _newValue) {
        this.userId = _newValue;
    }

    protected String _ebean_get_owner() {
        this._ebean_intercept.preGetter("owner");
        return this.owner;
    }

    protected void _ebean_set_owner(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "owner", (Object)this._ebean_get_owner(), (Object)newValue);
        this.owner = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_owner() {
        return this.owner;
    }

    protected void _ebean_setni_owner(String _newValue) {
        this.owner = _newValue;
    }

    protected Long _ebean_get_projectId() {
        this._ebean_intercept.preGetter("projectId");
        return this.projectId;
    }

    protected void _ebean_set_projectId(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "projectId", (Object)this._ebean_get_projectId(), (Object)newValue);
        this.projectId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_projectId() {
        return this.projectId;
    }

    protected void _ebean_setni_projectId(Long _newValue) {
        this.projectId = _newValue;
    }

    protected String _ebean_get_projectName() {
        this._ebean_intercept.preGetter("projectName");
        return this.projectName;
    }

    protected void _ebean_set_projectName(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "projectName", (Object)this._ebean_get_projectName(), (Object)newValue);
        this.projectName = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_projectName() {
        return this.projectName;
    }

    protected void _ebean_setni_projectName(String _newValue) {
        this.projectName = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        RecentProject recentProject = new RecentProject();
        recentProject.id = this.id;
        recentProject.userId = this.userId;
        recentProject.owner = this.owner;
        recentProject.projectId = this.projectId;
        recentProject.projectName = this.projectName;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        RecentProject p = (RecentProject)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.userId;
            }
            case 3: {
                return p.owner;
            }
            case 4: {
                return p.projectId;
            }
            case 5: {
                return p.projectName;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        RecentProject p = (RecentProject)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_userId();
            }
            case 3: {
                return p._ebean_get_owner();
            }
            case 4: {
                return p._ebean_get_projectId();
            }
            case 5: {
                return p._ebean_get_projectName();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        RecentProject p = (RecentProject)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.userId = (Long)arg;
                return;
            }
            case 3: {
                p.owner = (String)arg;
                return;
            }
            case 4: {
                p.projectId = (Long)arg;
                return;
            }
            case 5: {
                p.projectName = (String)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        RecentProject p = (RecentProject)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_userId((Long)arg);
                return;
            }
            case 3: {
                p._ebean_set_owner((String)arg);
                return;
            }
            case 4: {
                p._ebean_set_projectId((Long)arg);
                return;
            }
            case 5: {
                p._ebean_set_projectName((String)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "userId", "owner", "projectId", "projectName"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        RecentProject recentProject = this;
        synchronized (recentProject) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, (Object)this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((RecentProject)((Object)obj))._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new RecentProject();
    }
}

