/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.common.BeanList;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import models.OrganizationUser;
import models.ProjectUser;
import models.enumeration.RoleType;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.F;

@Entity
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Role
extends Model
implements EntityBean {
    private static final long serialVersionUID = 1L;
    public static final Model.Finder<Long, Role> find = new Model.Finder(Long.class, Role.class);
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String name;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public boolean active;
    @OneToMany(mappedBy="role", cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<ProjectUser> projectUsers;
    @OneToMany(mappedBy="role", cascade={CascadeType.ALL})
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<OrganizationUser> organizationUsers;
    private static String _EBEAN_MARKER = "models.Role";

    public static Role findById(Long id) {
        return (Role)((Object)find.byId((Object)id));
    }

    public static Role findByRoleType(RoleType roleType) {
        return (Role)((Object)find.byId((Object)roleType.roleType()));
    }

    public static Role findByName(String name) {
        return (Role)((Object)find.where().eq("name", (Object)name).findUnique());
    }

    public static Role findOrganizationRoleByIds(Long userId, Long organizationId) {
        return (Role)((Object)find.where().eq("organizationUsers.user.id", (Object)userId).eq("organizationUsers.organization.id", (Object)organizationId).findUnique());
    }

    public static Role findRoleByIds(Long userId, Long projectId) {
        return (Role)((Object)find.where().eq("projectUsers.user.id", (Object)userId).eq("projectUsers.project.id", (Object)projectId).findUnique());
    }

    public static List<Role> findProjectRoles() {
        ArrayList<Long> projectRoleIds = new ArrayList<Long>();
        projectRoleIds.add(RoleType.MANAGER.roleType());
        projectRoleIds.add(RoleType.MEMBER.roleType());
        return find.where().in("id", projectRoleIds).findList();
    }

    public static List<Role> findOrganizationRoles() {
        ArrayList<Long> organizationRoleIds = new ArrayList<Long>();
        organizationRoleIds.add(RoleType.ORG_ADMIN.roleType());
        organizationRoleIds.add(RoleType.ORG_MEMBER.roleType());
        return find.where().in("id", organizationRoleIds).findList();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getName() {
        return this._ebean_get_name();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setName(String string) {
        this._ebean_set_name(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public boolean getActive() {
        return this._ebean_get_active();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setActive(boolean bl) {
        this._ebean_set_active(bl);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<ProjectUser> getProjectUsers() {
        return this._ebean_get_projectUsers();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProjectUsers(List<ProjectUser> list2) {
        this._ebean_set_projectUsers(list2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<OrganizationUser> getOrganizationUsers() {
        return this._ebean_get_organizationUsers();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setOrganizationUsers(List<OrganizationUser> list2) {
        this._ebean_set_organizationUsers(list2);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected String _ebean_get_name() {
        this._ebean_intercept.preGetter("name");
        return this.name;
    }

    protected void _ebean_set_name(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "name", (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_name() {
        return this.name;
    }

    protected void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
    }

    protected boolean _ebean_get_active() {
        this._ebean_intercept.preGetter("active");
        return this.active;
    }

    protected void _ebean_set_active(boolean newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "active", this._ebean_get_active(), newValue);
        this.active = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected boolean _ebean_getni_active() {
        return this.active;
    }

    protected void _ebean_setni_active(boolean _newValue) {
        this.active = _newValue;
    }

    protected List _ebean_get_projectUsers() {
        this._ebean_intercept.preGetter("projectUsers");
        if (this.projectUsers == null) {
            this.projectUsers = new BeanList();
        }
        return this.projectUsers;
    }

    protected void _ebean_set_projectUsers(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "projectUsers", (Object)this._ebean_get_projectUsers(), (Object)newValue);
        this.projectUsers = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_projectUsers() {
        return this.projectUsers;
    }

    protected void _ebean_setni_projectUsers(List _newValue) {
        this.projectUsers = _newValue;
    }

    protected List _ebean_get_organizationUsers() {
        this._ebean_intercept.preGetter("organizationUsers");
        if (this.organizationUsers == null) {
            this.organizationUsers = new BeanList();
        }
        return this.organizationUsers;
    }

    protected void _ebean_set_organizationUsers(List newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetterMany(false, "organizationUsers", (Object)this._ebean_get_organizationUsers(), (Object)newValue);
        this.organizationUsers = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected List _ebean_getni_organizationUsers() {
        return this.organizationUsers;
    }

    protected void _ebean_setni_organizationUsers(List _newValue) {
        this.organizationUsers = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        Role role = new Role();
        role.id = this.id;
        role.name = this.name;
        role.active = this.active;
        role.projectUsers = this.projectUsers;
        role.organizationUsers = this.organizationUsers;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        Role p = (Role)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.name;
            }
            case 3: {
                return p.active;
            }
            case 4: {
                return p.projectUsers;
            }
            case 5: {
                return p.organizationUsers;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        Role p = (Role)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_name();
            }
            case 3: {
                return p._ebean_get_active();
            }
            case 4: {
                return p._ebean_get_projectUsers();
            }
            case 5: {
                return p._ebean_get_organizationUsers();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        Role p = (Role)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.name = (String)arg;
                return;
            }
            case 3: {
                p.active = (Boolean)arg;
                return;
            }
            case 4: {
                p.projectUsers = (List)arg;
                return;
            }
            case 5: {
                p.organizationUsers = (List)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        Role p = (Role)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_name((String)arg);
                return;
            }
            case 3: {
                p._ebean_set_active((Boolean)arg);
                return;
            }
            case 4: {
                p._ebean_set_projectUsers((List)arg);
                return;
            }
            case 5: {
                p._ebean_set_organizationUsers((List)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "name", "active", "projectUsers", "organizationUsers"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        Role role = this;
        synchronized (role) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, (Object)this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((Role)((Object)obj))._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new Role();
    }
}

