/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.bean.EntityBean;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import models.Project;
import models.User;
import models.enumeration.EventType;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.F;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"project_id", "user_id", "notification_type"})})
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class UserProjectNotification
extends Model
implements EntityBean {
    private static final long serialVersionUID = 1L;
    public static final Model.Finder<Long, UserProjectNotification> find = new Model.Finder(Long.class, UserProjectNotification.class);
    @Id
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long id;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public User user;
    @ManyToOne
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Project project;
    @Enumerated(value=EnumType.STRING)
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public EventType notificationType;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public boolean allowed;
    private static String _EBEAN_MARKER = "models.UserProjectNotification";

    public static Map<Project, Map<EventType, Boolean>> getProjectNotifications(User user) {
        HashMap<Project, Map<EventType, Boolean>> result2 = new HashMap<Project, Map<EventType, Boolean>>();
        List list2 = find.where().eq("user", (Object)user).findList();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            UserProjectNotification noti;
            UserProjectNotification userProjectNotification = noti = (UserProjectNotification)((Object)iterator.next());
            Object object = null;
            object = userProjectNotification.getProject();
            Project notiProject = object;
            HashMap<Project, Boolean> pn = (HashMap<Project, Boolean>)result2.get(notiProject);
            if (pn == null) {
                pn = new HashMap<Project, Boolean>();
                result2.put(notiProject, pn);
            }
            userProjectNotification = noti;
            object = null;
            object = userProjectNotification.getNotificationType();
            userProjectNotification = noti;
            boolean bl = false;
            bl = userProjectNotification.getAllowed();
            pn.put((Project)object, bl);
        }
        return result2;
    }

    public static boolean isEnabledNotiType(Map<Project, Map<EventType, Boolean>> notiMap, Project project2, EventType notiType) {
        if (UserProjectNotification.isJustDefaultWatching(notiMap, project2)) {
            return UserProjectNotification.isNotifiedByDefault(notiType);
        }
        Map<EventType, Boolean> projectNoti = notiMap.get(project2);
        if (UserProjectNotification.isCustomizedByUser(notiType, projectNoti)) {
            return projectNoti.get((Object)notiType);
        }
        return UserProjectNotification.isNotifiedByDefault(notiType);
    }

    private static boolean isCustomizedByUser(EventType notiType, Map<EventType, Boolean> projectNoti) {
        return projectNoti.containsKey((Object)notiType);
    }

    private static boolean isJustDefaultWatching(Map<Project, Map<EventType, Boolean>> notiMap, Project project2) {
        return !notiMap.containsKey(project2);
    }

    public static UserProjectNotification findOne(User user, Project project2, EventType notificationType) {
        return (UserProjectNotification)((Object)find.where().eq("user", (Object)user).eq("project", (Object)project2).eq("notificationType", (Object)notificationType.name()).findUnique());
    }

    public void toggle(EventType notificationType) {
        UserProjectNotification userProjectNotification = this;
        boolean bl = false;
        bl = userProjectNotification.getAllowed();
        bl = !bl;
        userProjectNotification = this;
        userProjectNotification.setAllowed(bl);
        userProjectNotification = this;
        bl = false;
        bl = userProjectNotification.getAllowed();
        if (bl == UserProjectNotification.isNotifiedByDefault(notificationType)) {
            this.delete();
        } else {
            this.update();
        }
    }

    public static void unwatchExplictly(User user, Project project2, EventType notiType) {
        UserProjectNotification newOne = new UserProjectNotification();
        Object object = user;
        UserProjectNotification userProjectNotification = newOne;
        userProjectNotification.setUser((User)object);
        object = project2;
        userProjectNotification = newOne;
        userProjectNotification.setProject((Project)object);
        object = notiType;
        userProjectNotification = newOne;
        userProjectNotification.setNotificationType((EventType)((Object)object));
        boolean bl = false;
        userProjectNotification = newOne;
        userProjectNotification.setAllowed(bl);
        newOne.save();
    }

    public static void watchExplictly(User user, Project project2, EventType notiType) {
        UserProjectNotification newOne = new UserProjectNotification();
        Object object = user;
        UserProjectNotification userProjectNotification = newOne;
        userProjectNotification.setUser((User)object);
        object = project2;
        userProjectNotification = newOne;
        userProjectNotification.setProject((Project)object);
        object = notiType;
        userProjectNotification = newOne;
        userProjectNotification.setNotificationType((EventType)((Object)object));
        boolean bl = true;
        userProjectNotification = newOne;
        userProjectNotification.setAllowed(bl);
        newOne.save();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEnabledNotiType(User user, Project project2, EventType eventType) {
        UserProjectNotification notification = UserProjectNotification.findOne(user, project2, eventType);
        if (notification == null) return true;
        UserProjectNotification userProjectNotification = notification;
        boolean bl = false;
        bl = userProjectNotification.getAllowed();
        if (!bl) return false;
        return true;
    }

    public static boolean isNotifiedByDefault(EventType eventType) {
        switch (eventType) {
            case NEW_COMMENT: {
                return false;
            }
        }
        return true;
    }

    public static Set<User> findEventWatchersByEventType(Long projectId, EventType eventType) {
        return UserProjectNotification.findByEventTypeAndOption(projectId, eventType, true);
    }

    public static Set<User> findEventUnwatchersByEventType(Long projectId, EventType eventType) {
        return UserProjectNotification.findByEventTypeAndOption(projectId, eventType, false);
    }

    private static Set<User> findByEventTypeAndOption(Long projectId, EventType eventType, boolean isAllowd) {
        List userProjectNotifications = find.where().eq("project.id", (Object)projectId).eq("notificationType", (Object)eventType).eq("allowed", (Object)isAllowd).findList();
        LinkedHashSet<User> users2 = new LinkedHashSet<User>();
        Iterator iterator = userProjectNotifications.iterator();
        while (iterator.hasNext()) {
            UserProjectNotification notification;
            UserProjectNotification userProjectNotification = notification = (UserProjectNotification)((Object)iterator.next());
            User user = null;
            user = userProjectNotification.getUser();
            users2.add(user);
        }
        return users2;
    }

    public static void deleteUnwatchedProjectNotifications(User user, Project project2) {
        Model model = user;
        Long l = null;
        l = model.getId();
        ExpressionList expressionList = find.where().eq("user.id", (Object)l);
        model = project2;
        l = null;
        l = model.getId();
        List userProjectNotifications = expressionList.eq("project.id", (Object)l).findList();
        for (UserProjectNotification notification : userProjectNotifications) {
            notification.delete();
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(Long l) {
        this._ebean_set_id(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public User getUser() {
        return this._ebean_get_user();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setUser(User user) {
        this._ebean_set_user(user);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Project getProject() {
        return this._ebean_get_project();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProject(Project project2) {
        this._ebean_set_project(project2);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public EventType getNotificationType() {
        return this._ebean_get_notificationType();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setNotificationType(EventType eventType) {
        this._ebean_set_notificationType(eventType);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public boolean getAllowed() {
        return this._ebean_get_allowed();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setAllowed(boolean bl) {
        this._ebean_set_allowed(bl);
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(Long _newValue) {
        this.id = _newValue;
    }

    protected User _ebean_get_user() {
        this._ebean_intercept.preGetter("user");
        return this.user;
    }

    protected void _ebean_set_user(User newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "user", (Object)this._ebean_get_user(), (Object)newValue);
        this.user = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected User _ebean_getni_user() {
        return this.user;
    }

    protected void _ebean_setni_user(User _newValue) {
        this.user = _newValue;
    }

    protected Project _ebean_get_project() {
        this._ebean_intercept.preGetter("project");
        return this.project;
    }

    protected void _ebean_set_project(Project newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "project", (Object)this._ebean_get_project(), (Object)newValue);
        this.project = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Project _ebean_getni_project() {
        return this.project;
    }

    protected void _ebean_setni_project(Project _newValue) {
        this.project = _newValue;
    }

    protected EventType _ebean_get_notificationType() {
        this._ebean_intercept.preGetter("notificationType");
        return this.notificationType;
    }

    protected void _ebean_set_notificationType(EventType newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "notificationType", (Object)this._ebean_get_notificationType(), (Object)newValue);
        this.notificationType = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected EventType _ebean_getni_notificationType() {
        return this.notificationType;
    }

    protected void _ebean_setni_notificationType(EventType _newValue) {
        this.notificationType = _newValue;
    }

    protected boolean _ebean_get_allowed() {
        this._ebean_intercept.preGetter("allowed");
        return this.allowed;
    }

    protected void _ebean_set_allowed(boolean newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "allowed", this._ebean_get_allowed(), newValue);
        this.allowed = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected boolean _ebean_getni_allowed() {
        return this.allowed;
    }

    protected void _ebean_setni_allowed(boolean _newValue) {
        this.allowed = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        UserProjectNotification userProjectNotification = new UserProjectNotification();
        userProjectNotification.id = this.id;
        userProjectNotification.user = this.user;
        userProjectNotification.project = this.project;
        userProjectNotification.notificationType = this.notificationType;
        userProjectNotification.allowed = this.allowed;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        UserProjectNotification p = (UserProjectNotification)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.user;
            }
            case 3: {
                return p.project;
            }
            case 4: {
                return p.notificationType;
            }
            case 5: {
                return p.allowed;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        UserProjectNotification p = (UserProjectNotification)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_user();
            }
            case 3: {
                return p._ebean_get_project();
            }
            case 4: {
                return p._ebean_get_notificationType();
            }
            case 5: {
                return p._ebean_get_allowed();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        UserProjectNotification p = (UserProjectNotification)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (Long)arg;
                return;
            }
            case 2: {
                p.user = (User)arg;
                return;
            }
            case 3: {
                p.project = (Project)arg;
                return;
            }
            case 4: {
                p.notificationType = (EventType)((Object)arg);
                return;
            }
            case 5: {
                p.allowed = (Boolean)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        UserProjectNotification p = (UserProjectNotification)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_user((User)arg);
                return;
            }
            case 3: {
                p._ebean_set_project((Project)arg);
                return;
            }
            case 4: {
                p._ebean_set_notificationType((EventType)((Object)arg));
                return;
            }
            case 5: {
                p._ebean_set_allowed((Boolean)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "user", "project", "notificationType", "allowed"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        UserProjectNotification userProjectNotification = this;
        synchronized (userProjectNotification) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, (Object)this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((UserProjectNotification)((Object)obj))._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new UserProjectNotification();
    }
}

