/*
 * Decompiled with CFR 0.152.
 */
package models.resource;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.Query;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.event.BeanPersistAdapter;
import com.avaje.ebean.event.BeanPersistRequest;
import java.util.Collection;
import models.Unwatch;
import models.Watch;
import models.resource.Resource;
import models.resource.ResourceConvertible;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ResourcePersistAdapter
extends BeanPersistAdapter {
    public boolean isRegisterFor(Class<?> cls) {
        return ResourceConvertible.class.isAssignableFrom(cls);
    }

    public void postDelete(BeanPersistRequest<?> request) {
        Resource resource = ((ResourceConvertible)request.getBean()).asResource();
        Transaction transaction = request.getTransaction();
        EbeanServer server = request.getEbeanServer();
        this.deleteRelatedWatch(resource, server, transaction);
        this.deleteRelatedUnwatch(resource, server, transaction);
    }

    private void deleteRelatedWatch(Resource resource, EbeanServer server, Transaction transaction) {
        Query query = server.createQuery(Watch.class);
        query.where().eq("resourceType", (Object)resource.getType()).eq("resourceId", (Object)resource.getId());
        server.delete(Watch.class, (Collection)query.findIds(), transaction);
    }

    private void deleteRelatedUnwatch(Resource resource, EbeanServer server, Transaction transaction) {
        Query query = server.createQuery(Unwatch.class);
        query.where().eq("resourceType", (Object)resource.getType()).eq("resourceId", (Object)resource.getId());
        server.delete(Unwatch.class, (Collection)query.findIds(), transaction);
    }
}

