/*
 * Decompiled with CFR 0.152.
 */
package models.support;

import com.avaje.ebean.Expr;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Junction;
import controllers.AbstractPostingApp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import models.FavoriteIssue;
import models.Issue;
import models.Mention;
import models.User;
import models.enumeration.IssueFilterType;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class IssueSearchCondition
extends AbstractPostingApp.SearchCondition {
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long authorId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long assigneeId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long mentionId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long favoriteId;

    public ExpressionList<Issue> getExpressionListByFilter(IssueFilterType filter, User user) {
        if (filter.equals((Object)IssueFilterType.ALL)) {
            Object object = user;
            Long l = null;
            l = ((User)object).getId();
            object = this;
            ((IssueSearchCondition)object).setAssigneeId(l);
            object = user;
            l = null;
            l = ((User)object).getId();
            object = this;
            ((IssueSearchCondition)object).setAuthorId(l);
            object = user;
            l = null;
            l = ((User)object).getId();
            object = this;
            ((IssueSearchCondition)object).setMentionId(l);
            object = user;
            l = null;
            l = ((User)object).getId();
            object = this;
            ((IssueSearchCondition)object).setFavoriteId(l);
            return this.asExpressionListForAll();
        }
        switch (filter) {
            case ASSIGNED: {
                Object object = user;
                Long l = null;
                l = ((User)object).getId();
                object = this;
                ((IssueSearchCondition)object).setAssigneeId(l);
                break;
            }
            case CREATED: {
                Object object = user;
                Long l = null;
                l = ((User)object).getId();
                object = this;
                ((IssueSearchCondition)object).setAuthorId(l);
                break;
            }
            case MENTIONED: {
                Object object = user;
                Long l = null;
                l = ((User)object).getId();
                object = this;
                ((IssueSearchCondition)object).setMentionId(l);
                break;
            }
            case FAVORITE: {
                Object object = user;
                Long l = null;
                l = ((User)object).getId();
                object = this;
                ((IssueSearchCondition)object).setFavoriteId(l);
            }
        }
        return this.asExpressionList();
    }

    private ExpressionList<Issue> asExpressionList() {
        ExpressionList el = Issue.finder.where();
        this.setAssigneeIfExists((ExpressionList<Issue>)el);
        this.setAuthorIfExist((ExpressionList<Issue>)el);
        this.setMentionedIssuesIfExist((ExpressionList<Issue>)el);
        this.setFavoriteIssuesIfExist((ExpressionList<Issue>)el);
        el.orderBy("updatedDate desc");
        return el;
    }

    private ExpressionList<Issue> asExpressionListForAll() {
        ExpressionList el = Issue.finder.where();
        IssueSearchCondition issueSearchCondition = this;
        Long l = null;
        l = issueSearchCondition.getMentionId();
        List<Long> mentioningIssueIds = Mention.getMentioningIssueIds(l);
        issueSearchCondition = this;
        l = null;
        l = issueSearchCondition.getFavoriteId();
        List<Long> favoriteIssueIdsids = this.getFavoriteIssueIds(l);
        Junction junction = el.disjunction();
        issueSearchCondition = this;
        l = null;
        l = issueSearchCondition.getAuthorId();
        junction.add(Expr.eq((String)"authorId", (Object)l));
        issueSearchCondition = this;
        l = null;
        l = issueSearchCondition.getAssigneeId();
        junction.add(Expr.eq((String)"assignee.user.id", (Object)l));
        junction.add(Expr.in((String)"id", mentioningIssueIds));
        junction.add(Expr.in((String)"id", favoriteIssueIdsids));
        junction.endJunction();
        el.orderBy("updatedDate desc");
        return el;
    }

    private void setAuthorIfExist(ExpressionList<Issue> el) {
        IssueSearchCondition issueSearchCondition = this;
        Long l = null;
        l = issueSearchCondition.getAuthorId();
        if (l != null) {
            issueSearchCondition = this;
            l = null;
            l = issueSearchCondition.getAuthorId();
            el.eq("authorId", (Object)l);
        }
    }

    private void setAssigneeIfExists(ExpressionList<Issue> el) {
        IssueSearchCondition issueSearchCondition = this;
        Long l = null;
        l = issueSearchCondition.getAssigneeId();
        if (l != null) {
            issueSearchCondition = this;
            l = null;
            l = issueSearchCondition.getAssigneeId();
            el.eq("assignee.user.id", (Object)l);
        }
    }

    private void setMentionedIssuesIfExist(ExpressionList<Issue> el) {
        IssueSearchCondition issueSearchCondition = this;
        Long l = null;
        l = issueSearchCondition.getMentionId();
        if (l != null) {
            issueSearchCondition = this;
            l = null;
            l = issueSearchCondition.getMentionId();
            List<Long> ids = Mention.getMentioningIssueIds(l);
            this.updateElWhenIdsEmpty(el, ids);
        }
    }

    private void setFavoriteIssuesIfExist(ExpressionList<Issue> el) {
        IssueSearchCondition issueSearchCondition = this;
        Long l = null;
        l = issueSearchCondition.getFavoriteId();
        if (l != null) {
            issueSearchCondition = this;
            l = null;
            l = issueSearchCondition.getFavoriteId();
            List<Long> ids = this.getFavoriteIssueIds(l);
            this.updateElWhenIdsEmpty(el, ids);
        }
    }

    private void updateElWhenIdsEmpty(ExpressionList<Issue> el, List<Long> ids) {
        if (ids.isEmpty()) {
            el.idEq((Object)-1);
        } else {
            el.idIn(ids);
        }
    }

    private List<Long> getFavoriteIssueIds(Long userId) {
        HashSet<Object> ids = new HashSet<Object>();
        List favoriteIssues = FavoriteIssue.find.where().eq("user.id", (Object)userId).findList();
        for (FavoriteIssue favoriteIssue : favoriteIssues) {
            Model model = favoriteIssue;
            Object object = null;
            object = model.getIssue();
            model = object;
            object = null;
            object = model.getId();
            ids.add(object);
        }
        return new ArrayList<Long>(ids);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getAuthorId() {
        return this.authorId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setAuthorId(Long l) {
        this.authorId = l;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getAssigneeId() {
        return this.assigneeId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setAssigneeId(Long l) {
        this.assigneeId = l;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getMentionId() {
        return this.mentionId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setMentionId(Long l) {
        this.mentionId = l;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getFavoriteId() {
        return this.favoriteId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setFavoriteId(Long l) {
        this.favoriteId = l;
    }
}

