/*
 * Decompiled with CFR 0.152.
 */
package models.support;

import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Junction;
import controllers.AbstractPostingApp;
import controllers.UserApp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import models.AbstractPosting;
import models.Comment;
import models.FavoriteIssue;
import models.Issue;
import models.IssueComment;
import models.IssueLabel;
import models.IssueSharer;
import models.Mention;
import models.Milestone;
import models.Organization;
import models.Project;
import models.User;
import models.enumeration.State;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import play.core.enhancers.PropertiesEnhancer;
import play.data.format.Formats;
import play.db.ebean.Model;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class SearchCondition
extends AbstractPostingApp.SearchCondition
implements Cloneable {
    @PropertiesEnhancer.GeneratedGetAccessor
    public String state;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Boolean commentedCheck;
    @PropertiesEnhancer.GeneratedGetAccessor
    public Long milestoneId = null;
    @PropertiesEnhancer.GeneratedGetAccessor
    public Set<Long> labelIds = new HashSet<Long>();
    @PropertiesEnhancer.GeneratedGetAccessor
    public Long authorId;
    @PropertiesEnhancer.GeneratedGetAccessor
    public Long assigneeId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Project project;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long mentionId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long sharerId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long favoriteId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Organization organization;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public List<String> projectNames;
    @PropertiesEnhancer.GeneratedGetAccessor
    public Long commenterId;
    @Formats.DateTime(pattern="yyyy-MM-dd")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Date dueDate;
    private User byUser = UserApp.currentUser();

    public SearchCondition clone() {
        SearchCondition one = new SearchCondition();
        SearchCondition searchCondition = this;
        List<String> list2 = null;
        list2 = searchCondition.getOrderBy();
        searchCondition = one;
        searchCondition.setOrderBy((String)((Object)list2));
        searchCondition = this;
        list2 = null;
        list2 = searchCondition.getOrderDir();
        searchCondition = one;
        searchCondition.setOrderDir((String)((Object)list2));
        searchCondition = this;
        list2 = null;
        list2 = searchCondition.getFilter();
        searchCondition = one;
        searchCondition.setFilter((String)((Object)list2));
        searchCondition = this;
        list2 = null;
        list2 = searchCondition.getState();
        one.state = list2;
        searchCondition = this;
        list2 = null;
        list2 = searchCondition.getCommentedCheck();
        searchCondition = one;
        searchCondition.setCommentedCheck((Boolean)((Object)list2));
        searchCondition = this;
        list2 = null;
        list2 = searchCondition.getMilestoneId();
        one.milestoneId = list2;
        searchCondition = this;
        list2 = null;
        list2 = searchCondition.getLabelIds();
        one.labelIds = new HashSet<Long>(list2);
        searchCondition = this;
        list2 = null;
        list2 = searchCondition.getAuthorId();
        one.authorId = list2;
        searchCondition = this;
        list2 = null;
        list2 = searchCondition.getAssigneeId();
        one.assigneeId = list2;
        searchCondition = this;
        list2 = null;
        list2 = searchCondition.getCommenterId();
        one.commenterId = list2;
        searchCondition = this;
        list2 = null;
        list2 = searchCondition.getMentionId();
        searchCondition = one;
        searchCondition.setMentionId((Long)((Object)list2));
        searchCondition = this;
        list2 = null;
        list2 = searchCondition.getSharerId();
        searchCondition = one;
        searchCondition.setSharerId((Long)((Object)list2));
        searchCondition = this;
        list2 = null;
        list2 = searchCondition.getFavoriteId();
        searchCondition = one;
        searchCondition.setFavoriteId((Long)((Object)list2));
        searchCondition = this;
        list2 = null;
        list2 = searchCondition.getDueDate();
        searchCondition = one;
        searchCondition.setDueDate((Date)((Object)list2));
        searchCondition = this;
        list2 = null;
        list2 = searchCondition.getProjectNames();
        searchCondition = one;
        searchCondition.setProjectNames(list2);
        return one;
    }

    public SearchCondition setState(String state) {
        this.state = state;
        return this;
    }

    public SearchCondition setState(State state) {
        this.state = state.state();
        return this;
    }

    public SearchCondition setMilestoneId(Long milestoneId) {
        this.milestoneId = milestoneId;
        return this;
    }

    public SearchCondition setLabelIds(Set<Long> labelIds) {
        this.labelIds = labelIds;
        return this;
    }

    public SearchCondition setAuthorId(Long authorId) {
        this.authorId = authorId;
        return this;
    }

    public SearchCondition setAssigneeId(Long assigneeId) {
        this.assigneeId = assigneeId;
        return this;
    }

    public SearchCondition setCommenterId(Long commenterId) {
        this.commenterId = commenterId;
        return this;
    }

    public ExpressionList<Issue> asExpressionList(@Nonnull Organization organization2) {
        ExpressionList el = Issue.finder.where();
        if (this.isFilteredByProject()) {
            el.in("project.id", this.getFilteredProjectIds(organization2));
        } else {
            el.in("project.id", this.getVisibleProjectIds(organization2));
        }
        el.eq("isDraft", (Object)false);
        this.setAssigneeIfExists((ExpressionList<Issue>)el);
        this.setAuthorIfExist((ExpressionList<Issue>)el);
        this.setMentionedIssuesIfExist((ExpressionList<Issue>)el);
        this.setSharedIssuesIfExist((ExpressionList<Issue>)el);
        this.setFavoriteIssuesIfExist((ExpressionList<Issue>)el);
        this.setFilteredStringIfExist((ExpressionList<Issue>)el);
        SearchCondition searchCondition = this;
        Comparable<Boolean> comparable = null;
        comparable = searchCondition.getCommentedCheck();
        if (comparable.booleanValue()) {
            el.ge("numOfComments", (Object)1);
        }
        this.setIssueState((ExpressionList<Issue>)el);
        this.setOrderByIfExist((ExpressionList<Issue>)el);
        searchCondition = this;
        comparable = null;
        comparable = searchCondition.getDueDate();
        if (comparable != null) {
            searchCondition = this;
            comparable = null;
            comparable = searchCondition.getDueDate();
            el.lt("dueDate", (Object)DateUtils.addDays((Date)comparable, (int)1));
        }
        return el;
    }

    private boolean isFilteredByProject() {
        SearchCondition searchCondition = this;
        List<String> list2 = null;
        list2 = searchCondition.getProjectNames();
        return CollectionUtils.isNotEmpty(list2);
    }

    private List<Long> getFilteredProjectIds(Organization organization2) {
        ArrayList<Long> projectIdsFilter = new ArrayList<Long>();
        Object object = this;
        Object object2 = null;
        object2 = ((SearchCondition)object).getProjectNames();
        Iterator<String> iterator = object2.iterator();
        block0: while (iterator.hasNext()) {
            String projectName = iterator.next();
            object = organization2;
            object2 = null;
            object2 = ((Organization)object).getProjects();
            Iterator<Object> iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                Project project2 = (Project)iterator2.next();
                object = project2;
                object2 = null;
                object2 = ((Project)object).getName();
                if (!((String)object2).equalsIgnoreCase(projectName)) continue;
                object = project2;
                object2 = null;
                object2 = ((Project)object).getId();
                if (!this.getVisibleProjectIds(organization2).contains(((Long)object2).toString())) continue;
                object = project2;
                object2 = null;
                object2 = ((Project)object).getId();
                projectIdsFilter.add((Long)object2);
                continue block0;
            }
        }
        return projectIdsFilter;
    }

    private void setOrderByIfExist(ExpressionList<Issue> el) {
        SearchCondition searchCondition = this;
        String string = null;
        string = searchCondition.getOrderBy();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            searchCondition = this;
            string = null;
            string = searchCondition.getOrderBy();
            if (string.equals("dueDate")) {
                searchCondition = this;
                string = null;
                string = searchCondition.getOrderDir();
                String formulaName = string.equals("asc") ? "dueDateAsc" : "dueDateDesc";
                searchCondition = this;
                string = null;
                string = searchCondition.getOrderDir();
                el.orderBy("weight desc, isDraft desc, " + formulaName + " " + string);
            } else {
                searchCondition = this;
                string = null;
                string = searchCondition.getOrderBy();
                StringBuilder stringBuilder = new StringBuilder().append("weight desc, isDraft desc, ").append(string).append(" ");
                searchCondition = this;
                string = null;
                string = searchCondition.getOrderDir();
                el.orderBy(stringBuilder.append(string).toString());
            }
        }
    }

    private void setFilteredStringIfExist(ExpressionList<Issue> el) {
        SearchCondition searchCondition = this;
        String string = null;
        string = searchCondition.getFilter();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            Junction junction = el.disjunction();
            searchCondition = this;
            string = null;
            string = searchCondition.getFilter();
            ExpressionList expressionList = junction.icontains("title", string);
            searchCondition = this;
            string = null;
            string = searchCondition.getFilter();
            expressionList.icontains("body", string);
            searchCondition = this;
            string = null;
            string = searchCondition.getFilter();
            List ids = Issue.finder.where().icontains("comments.contents", string).findIds();
            if (!ids.isEmpty()) {
                junction.idIn(ids);
            }
            junction.endJunction();
        }
    }

    private void setAuthorIfExist(ExpressionList<Issue> el) {
        Object object = this;
        Long l = null;
        l = ((SearchCondition)object).getAuthorId();
        if (l != null) {
            object = this.byUser;
            l = null;
            l = ((User)object).getId();
            el.eq("authorId", (Object)l);
        }
    }

    private void setCommenterIfExist(ExpressionList<Issue> el, Project project2) {
        SearchCondition searchCondition = this;
        Long l = null;
        l = searchCondition.getCommenterId();
        if (l != null) {
            searchCondition = this;
            l = null;
            l = searchCondition.getCommenterId();
            User commenter = (User)User.find.byId((Object)l);
            if (!commenter.isAnonymous()) {
                List<Long> ids = this.getCommentedIssueIds(this.byUser, project2);
                this.updateElWhenIdsEmpty(el, ids);
            }
        }
    }

    private void setAssigneeIfExists(ExpressionList<Issue> el) {
        Object object = this;
        Long l = null;
        l = ((SearchCondition)object).getAssigneeId();
        if (l != null) {
            object = this;
            l = null;
            Long l2 = l = ((SearchCondition)object).getAssigneeId();
            object = User.anonymous;
            l = null;
            l = ((User)object).getId();
            if (l2.equals(l)) {
                el.isNull("assignee");
            } else {
                object = this.byUser;
                l = null;
                l = ((User)object).getId();
                el.eq("assignee.user.id", (Object)l);
            }
        }
    }

    private List<String> getVisibleProjectIds(Organization organization2) {
        List<Project> projects2 = organization2.getVisibleProjects(this.byUser);
        ArrayList<String> projectsIds = new ArrayList<String>();
        Iterator<Project> iterator = projects2.iterator();
        while (iterator.hasNext()) {
            Project project2;
            Project project3 = project2 = iterator.next();
            Long l = null;
            l = project3.getId();
            projectsIds.add(l.toString());
        }
        return projectsIds;
    }

    public SearchCondition() {
        this.state = State.OPEN.name().toLowerCase();
        Object object = "createdDate";
        SearchCondition searchCondition = this;
        searchCondition.setOrderBy((String)object);
        object = false;
        searchCondition = this;
        searchCondition.setCommentedCheck((Boolean)object);
    }

    public ExpressionList<Issue> asExpressionList() {
        ExpressionList el = Issue.finder.where();
        this.setAssigneeIfExists((ExpressionList<Issue>)el);
        this.setAuthorIfExist((ExpressionList<Issue>)el);
        this.setCommenterIfExist((ExpressionList<Issue>)el, null);
        this.setMentionedIssuesIfExist((ExpressionList<Issue>)el);
        this.setSharedIssuesIfExist((ExpressionList<Issue>)el);
        this.setFavoriteIssuesIfExist((ExpressionList<Issue>)el);
        this.setFilteredStringIfExist((ExpressionList<Issue>)el);
        this.setIssueState((ExpressionList<Issue>)el);
        this.setOrderByIfExist((ExpressionList<Issue>)el);
        el.eq("isDraft", (Object)false);
        SearchCondition searchCondition = this;
        Comparable<Boolean> comparable = null;
        comparable = searchCondition.getCommentedCheck();
        if (comparable.booleanValue()) {
            el.ge("numOfComments", (Object)1);
        }
        searchCondition = this;
        comparable = null;
        comparable = searchCondition.getDueDate();
        if (comparable != null) {
            searchCondition = this;
            comparable = null;
            comparable = searchCondition.getDueDate();
            el.lt("dueDate", (Object)DateUtils.addDays((Date)comparable, (int)1));
        }
        return el;
    }

    private void setIssueState(ExpressionList<Issue> el) {
        SearchCondition searchCondition = this;
        String string = null;
        string = searchCondition.getState();
        State st = State.getValue(string);
        if (st.equals((Object)State.OPEN) || st.equals((Object)State.CLOSED)) {
            el.eq("state", (Object)st);
        }
    }

    private void setMentionedIssuesIfExist(ExpressionList<Issue> el) {
        Object object = this;
        Long l = null;
        l = ((SearchCondition)object).getMentionId();
        if (l != null && !this.byUser.isAnonymous()) {
            object = this.byUser;
            l = null;
            l = ((User)object).getId();
            List<Long> ids = Mention.getMentioningIssueIds(l);
            this.updateElWhenIdsEmpty(el, ids);
        }
    }

    private void setSharedIssuesIfExist(ExpressionList<Issue> el) {
        SearchCondition searchCondition = this;
        Long l = null;
        l = searchCondition.getSharerId();
        if (l != null && !this.byUser.isAnonymous()) {
            List<Long> ids = this.getSharedIssueIds(this.byUser);
            this.updateElWhenIdsEmpty(el, ids);
        }
    }

    private void updateElWhenIdsEmpty(ExpressionList<Issue> el, List<Long> ids) {
        if (ids.isEmpty()) {
            el.idEq((Object)-1);
        } else {
            el.idIn(ids);
        }
    }

    private void setFavoriteIssuesIfExist(ExpressionList<Issue> el) {
        SearchCondition searchCondition = this;
        Long l = null;
        l = searchCondition.getFavoriteId();
        if (l != null && !this.byUser.isAnonymous()) {
            List<Long> ids = this.getFavoriteIssueIds(this.byUser);
            this.updateElWhenIdsEmpty(el, ids);
        }
    }

    private List<Long> getCommentedIssueIds(User commenter, Project project2) {
        HashSet<Long> issueIds = new HashSet<Long>();
        Model model = commenter;
        Long l = null;
        l = model.getId();
        List comments = IssueComment.find.where().eq("authorId", (Object)l).findList();
        if (project2 == null) {
            for (Comment comment : comments) {
                model = comment.getParent();
                l = null;
                l = model.getId();
                issueIds.add(l);
            }
        } else {
            for (Comment comment : comments) {
                model = comment;
                l = null;
                Long l2 = l = model.getProjectId();
                model = project2;
                l = null;
                l = model.getId();
                if (!l2.equals(l)) continue;
                model = comment.getParent();
                l = null;
                l = model.getId();
                issueIds.add(l);
            }
        }
        return new ArrayList<Long>(issueIds);
    }

    private List<Long> getSharedIssueIds(User user) {
        HashSet<Object> ids = new HashSet<Object>();
        Object object = user;
        Object object2 = null;
        object2 = ((User)object).getId();
        List issueSharers = IssueSharer.find.where().eq("user.id", object2).findList();
        for (IssueSharer issueSharer : issueSharers) {
            object = issueSharer;
            object2 = null;
            object = object2 = ((IssueSharer)((Object)object)).getIssue();
            object2 = null;
            object2 = ((AbstractPosting)object).getId();
            ids.add(object2);
        }
        return new ArrayList<Long>(ids);
    }

    private List<Long> getFavoriteIssueIds(User user) {
        HashSet<Object> ids = new HashSet<Object>();
        Object object = user;
        Object object2 = null;
        object2 = ((User)object).getId();
        List favoriteIssues = FavoriteIssue.find.where().eq("user.id", object2).findList();
        for (FavoriteIssue favoriteIssue : favoriteIssues) {
            object = favoriteIssue;
            object2 = null;
            object = object2 = ((FavoriteIssue)((Object)object)).getIssue();
            object2 = null;
            object2 = ((AbstractPosting)object).getId();
            ids.add(object2);
        }
        return new ArrayList<Long>(ids);
    }

    public ExpressionList<Issue> asExpressionList(Project project2) {
        Object object;
        Object object2;
        ExpressionList el = Issue.finder.where();
        if (project2 != null) {
            object2 = project2;
            object = null;
            object = ((Project)object2).getId();
            el.eq("project.id", object);
        }
        object2 = this;
        object = null;
        object = ((AbstractPostingApp.SearchCondition)object2).getFilter();
        if (StringUtils.isNotBlank((CharSequence)object)) {
            List ids;
            Junction junction = el.disjunction();
            object2 = this;
            object = null;
            object = ((AbstractPostingApp.SearchCondition)object2).getFilter();
            ExpressionList expressionList = junction.icontains("title", (String)object);
            object2 = this;
            object = null;
            object = ((AbstractPostingApp.SearchCondition)object2).getFilter();
            expressionList.icontains("body", (String)object);
            if (project2 == null) {
                object2 = this;
                object = null;
                object = ((AbstractPostingApp.SearchCondition)object2).getFilter();
                ids = Issue.finder.where().icontains("comments.contents", (String)object).findIds();
            } else {
                object2 = project2;
                object = null;
                object = ((Project)object2).getId();
                ExpressionList expressionList2 = Issue.finder.where().eq("project.id", object);
                object2 = this;
                object = null;
                object = ((AbstractPostingApp.SearchCondition)object2).getFilter();
                ids = expressionList2.icontains("comments.contents", (String)object).findIds();
            }
            if (!ids.isEmpty()) {
                junction.idIn(ids);
            }
            junction.endJunction();
        }
        object2 = this;
        object = null;
        object = ((SearchCondition)object2).getAuthorId();
        if (object != null) {
            object2 = this;
            object = null;
            object = ((SearchCondition)object2).getAuthorId();
            Set<Long> set = object;
            object2 = User.anonymous;
            object = null;
            object = ((User)object2).getId();
            if (((Long)((Object)set)).equals(object)) {
                el.isNull("authorId");
            } else {
                object2 = this;
                object = null;
                object = ((SearchCondition)object2).getAuthorId();
                el.eq("authorId", object);
            }
        }
        object2 = this;
        object = null;
        object = ((SearchCondition)object2).getAssigneeId();
        if (object != null) {
            object2 = this;
            object = null;
            object = ((SearchCondition)object2).getAssigneeId();
            Set<Long> set = object;
            object2 = User.anonymous;
            object = null;
            object = ((User)object2).getId();
            if (((Long)((Object)set)).equals(object)) {
                el.isNull("assignee");
            } else {
                object2 = this;
                object = null;
                object = ((SearchCondition)object2).getAssigneeId();
                el.eq("assignee.user.id", object);
                if (project2 != null) {
                    object2 = project2;
                    object = null;
                    object = ((Project)object2).getId();
                    el.eq("assignee.project.id", object);
                }
            }
        }
        el.eq("isDraft", (Object)false);
        this.setCommenterIfExist((ExpressionList<Issue>)el, project2);
        this.setSharedIssuesIfExist((ExpressionList<Issue>)el);
        this.setFavoriteIssuesIfExist((ExpressionList<Issue>)el);
        this.setIssueState((ExpressionList<Issue>)el);
        this.setLabelsIfExist(project2, (ExpressionList<Issue>)el);
        this.setOrderByIfExist((ExpressionList<Issue>)el);
        object2 = this;
        object = null;
        object = ((SearchCondition)object2).getMilestoneId();
        if (object != null) {
            object2 = this;
            object = null;
            object = ((SearchCondition)object2).getMilestoneId();
            if (((Long)object).equals(Milestone.NULL_MILESTONE_ID)) {
                el.isNull("milestone");
            } else {
                object2 = this;
                object = null;
                object = ((SearchCondition)object2).getMilestoneId();
                el.eq("milestone.id", object);
            }
        }
        object2 = this;
        object = null;
        object = ((SearchCondition)object2).getCommentedCheck();
        if (((Boolean)object).booleanValue()) {
            el.ge("numOfComments", (Object)1);
        }
        object2 = this;
        object = null;
        object = ((SearchCondition)object2).getDueDate();
        if (object != null) {
            object2 = this;
            object = null;
            object = ((SearchCondition)object2).getDueDate();
            el.lt("dueDate", (Object)DateUtils.addDays((Date)object, (int)1));
        }
        object2 = this;
        object = null;
        object = ((SearchCondition)object2).getAuthorId();
        if (object == null) {
            object2 = this;
            object = null;
            object = ((AbstractPostingApp.SearchCondition)object2).getFilter();
            if (StringUtils.isBlank((CharSequence)object)) {
                object2 = this;
                object = null;
                object = ((SearchCondition)object2).getLabelIds();
                if (object.isEmpty()) {
                    object2 = this;
                    object = null;
                    object = ((SearchCondition)object2).getAssigneeId();
                    if (object == null) {
                        object2 = this;
                        object = null;
                        object = ((SearchCondition)object2).getMentionId();
                        if (object == null) {
                            el.isNull("parent.id");
                        }
                    }
                }
            }
        }
        return el;
    }

    private void setLabelsIfExist(Project project2, ExpressionList<Issue> el) {
        SearchCondition searchCondition = this;
        Set<Long> set = null;
        set = searchCondition.getLabelIds();
        if (CollectionUtils.isNotEmpty(set)) {
            searchCondition = this;
            set = null;
            set = searchCondition.getLabelIds();
            Set labels2 = IssueLabel.finder.where().idIn(new ArrayList<Long>(set)).findSet();
            List<Issue> issues2 = Issue.finder.where().eq("project", (Object)project2).in("labels", (Collection)labels2).findList();
            for (IssueLabel issueLabel : labels2) {
                issues2 = this.findIssueByLabel(issues2, issueLabel);
            }
            el.in("id", this.extractIssueIds(issues2));
        }
    }

    private Set<Long> extractIssueIds(List<Issue> issues2) {
        HashSet<Long> ids = new HashSet<Long>();
        Iterator<Issue> iterator = issues2.iterator();
        while (iterator.hasNext()) {
            Issue issue2;
            Issue issue3 = issue2 = iterator.next();
            Long l = null;
            l = issue3.getId();
            ids.add(l);
        }
        return ids;
    }

    private List<Issue> findIssueByLabel(List<Issue> issues2, IssueLabel label) {
        ArrayList<Issue> result2 = new ArrayList<Issue>();
        for (Issue issue2 : issues2) {
            if (!issue2.labels.contains(label)) continue;
            result2.add(issue2);
        }
        return result2;
    }

    public String getDueDateString() {
        SearchCondition searchCondition = this;
        Date date = null;
        date = searchCondition.getDueDate();
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        searchCondition = this;
        date = null;
        date = searchCondition.getDueDate();
        return sdf.format(date);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasCondition() {
        SearchCondition searchCondition = this;
        Long l = null;
        l = searchCondition.getAssigneeId();
        if (l != null) return true;
        searchCondition = this;
        l = null;
        l = searchCondition.getAuthorId();
        if (l != null) return true;
        searchCondition = this;
        l = null;
        l = searchCondition.getMentionId();
        if (l != null) return true;
        searchCondition = this;
        l = null;
        l = searchCondition.getCommenterId();
        if (l != null) return true;
        searchCondition = this;
        l = null;
        l = searchCondition.getSharerId();
        if (l != null) return true;
        searchCondition = this;
        l = null;
        l = searchCondition.getFavoriteId();
        if (l == null) return false;
        return true;
    }

    public String toString() {
        SearchCondition searchCondition = this;
        Object object = null;
        object = searchCondition.getState();
        StringBuilder stringBuilder = new StringBuilder().append("SearchCondition{state='").append((String)object).append('\'').append(", commentedCheck=");
        searchCondition = this;
        object = null;
        object = searchCondition.getCommentedCheck();
        StringBuilder stringBuilder2 = stringBuilder.append(object).append(", milestoneId=");
        searchCondition = this;
        object = null;
        object = searchCondition.getMilestoneId();
        StringBuilder stringBuilder3 = stringBuilder2.append(object).append(", labelIds=");
        searchCondition = this;
        object = null;
        object = searchCondition.getLabelIds();
        StringBuilder stringBuilder4 = stringBuilder3.append(object).append(", authorId=");
        searchCondition = this;
        object = null;
        object = searchCondition.getAuthorId();
        StringBuilder stringBuilder5 = stringBuilder4.append(object).append(", assigneeId=");
        searchCondition = this;
        object = null;
        object = searchCondition.getAssigneeId();
        StringBuilder stringBuilder6 = stringBuilder5.append(object).append(", project=");
        searchCondition = this;
        object = null;
        object = searchCondition.getProject();
        StringBuilder stringBuilder7 = stringBuilder6.append(object).append(", mentionId=");
        searchCondition = this;
        object = null;
        object = searchCondition.getMentionId();
        StringBuilder stringBuilder8 = stringBuilder7.append(object).append(", sharerId=");
        searchCondition = this;
        object = null;
        object = searchCondition.getSharerId();
        StringBuilder stringBuilder9 = stringBuilder8.append(object).append(", favoriteId=");
        searchCondition = this;
        object = null;
        object = searchCondition.getFavoriteId();
        StringBuilder stringBuilder10 = stringBuilder9.append(object).append(", organization=");
        searchCondition = this;
        object = null;
        object = searchCondition.getOrganization();
        StringBuilder stringBuilder11 = stringBuilder10.append(object).append(", projectNames=");
        searchCondition = this;
        object = null;
        object = searchCondition.getProjectNames();
        StringBuilder stringBuilder12 = stringBuilder11.append(object).append(", commenterId=");
        searchCondition = this;
        object = null;
        object = searchCondition.getCommenterId();
        StringBuilder stringBuilder13 = stringBuilder12.append(object).append(", dueDate=");
        searchCondition = this;
        object = null;
        object = searchCondition.getDueDate();
        return stringBuilder13.append(object).append('}').toString();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getState() {
        return this.state;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Boolean getCommentedCheck() {
        return this.commentedCheck;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setCommentedCheck(Boolean bl) {
        this.commentedCheck = bl;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getMilestoneId() {
        return this.milestoneId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Set<Long> getLabelIds() {
        return this.labelIds;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getAuthorId() {
        return this.authorId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getAssigneeId() {
        return this.assigneeId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Project getProject() {
        return this.project;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProject(Project project2) {
        this.project = project2;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getMentionId() {
        return this.mentionId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setMentionId(Long l) {
        this.mentionId = l;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getSharerId() {
        return this.sharerId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setSharerId(Long l) {
        this.sharerId = l;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getFavoriteId() {
        return this.favoriteId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setFavoriteId(Long l) {
        this.favoriteId = l;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Organization getOrganization() {
        return this.organization;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setOrganization(Organization organization2) {
        this.organization = organization2;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public List<String> getProjectNames() {
        return this.projectNames;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setProjectNames(List<String> list2) {
        this.projectNames = list2;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getCommenterId() {
        return this.commenterId;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Date getDueDate() {
        return this.dueDate;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setDueDate(Date date) {
        this.dueDate = date;
    }
}

