/*
 * Decompiled with CFR 0.152.
 */
package playRepository;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import models.CodeComment;
import models.CommentThread;
import models.CommitComment;
import models.Project;
import models.ReviewComment;
import models.User;
import models.UserIdent;
import models.Watch;
import models.enumeration.ResourceType;
import models.resource.Resource;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class Commit {
    public abstract String getShortId();

    public abstract String getId();

    public abstract String getShortMessage();

    public abstract String getMessage();

    public abstract User getAuthor();

    public abstract String getAuthorName();

    public abstract String getAuthorEmail();

    public abstract Date getAuthorDate();

    public abstract TimeZone getAuthorTimezone();

    public abstract String getCommitterName();

    public abstract String getCommitterEmail();

    public abstract Date getCommitterDate();

    public abstract TimeZone getCommitterTimezone();

    public abstract int getParentCount();

    public Set<User> getWatchers(Project project2) {
        return this.getWatchers(project2, true);
    }

    public Set<User> getWatchers(Project project2, boolean allowedWatchersOnly) {
        HashSet<User> actualWatchers = new HashSet<User>();
        if (!this.getAuthor().isAnonymous()) {
            actualWatchers.add(this.getAuthor());
        }
        Object object = project2;
        Object object2 = null;
        object2 = ((Project)object).getVcs();
        if (((String)object2).equals("GIT")) {
            object = project2;
            object2 = null;
            object2 = ((Project)object).getId();
            List threads = CommentThread.find.where().eq("project.id", object2).eq("commitId", (Object)this.getId()).eq("pullRequest.id", null).findList();
            for (CommentThread thread : threads) {
                object = thread;
                object2 = null;
                object2 = ((CommentThread)object).getReviewComments();
                Iterator<ReviewComment> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    ReviewComment comment = iterator.next();
                    object = comment;
                    object2 = null;
                    object = object2 = ((ReviewComment)object).getAuthor();
                    object2 = null;
                    object2 = ((UserIdent)object).getId();
                    User user = (User)User.find.byId(object2);
                    if (user == null) continue;
                    actualWatchers.add(user);
                }
            }
        } else {
            object = project2;
            object2 = null;
            object2 = ((Project)object).getId();
            List comments = CommitComment.find.where().eq("project.id", object2).eq("commitId", (Object)this.getId()).findList();
            for (CommitComment c : comments) {
                object = c;
                object2 = null;
                object2 = ((CodeComment)object).getAuthorId();
                User user = (User)User.find.byId(object2);
                if (user == null) continue;
                actualWatchers.add(user);
            }
        }
        return Watch.findActualWatchers(actualWatchers, this.asResource(project2), allowedWatchersOnly);
    }

    public static Project getProjectFromResourceId(String resourceId) {
        String[] pair = resourceId.split(":");
        return (Project)Project.find.byId((Object)Long.valueOf(pair[0]));
    }

    public static Resource getAsResource(Project project2, String commitId) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        return Commit.getAsResource(l + ":" + commitId);
    }

    public static Resource getAsResource(final String resourceId) {
        return new Resource(){

            @Override
            public String getId() {
                return resourceId;
            }

            @Override
            public Project getProject() {
                return Commit.getProjectFromResourceId(resourceId);
            }

            @Override
            public ResourceType getType() {
                return ResourceType.COMMIT;
            }
        };
    }

    public Resource asResource(final Project project2) {
        return new Resource(){

            @Override
            public String getId() {
                Project project22 = project2;
                Long l = null;
                l = project22.getId();
                return l + ":" + Commit.this.getId();
            }

            @Override
            public Project getProject() {
                return project2;
            }

            @Override
            public ResourceType getType() {
                return ResourceType.COMMIT;
            }

            @Override
            public Long getAuthorId() {
                User author = Commit.this.getAuthor();
                if (author != null) {
                    User user = Commit.this.getAuthor();
                    Long l = null;
                    l = user.getId();
                    return l;
                }
                return null;
            }
        };
    }
}

