/*
 * Decompiled with CFR 0.152.
 */
package playRepository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.UserApp;
import controllers.routes;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import models.Project;
import models.User;
import models.enumeration.ResourceType;
import models.resource.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.tika.Tika;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.RawText;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Json;
import play.mvc.Results;
import playRepository.Commit;
import playRepository.FileDiff;
import playRepository.PlayRepository;
import playRepository.SvnCommit;
import utils.Config;
import utils.FileUtil;
import utils.GravatarUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class SVNRepository
implements PlayRepository {
    private static String repoPrefix = "repo/svn/";
    private final String projectName;
    private final String ownerName;

    public static String getRepoPrefix() {
        return repoPrefix;
    }

    public static void setRepoPrefix(String repoPrefix) {
        SVNRepository.repoPrefix = repoPrefix;
    }

    public SVNRepository(String userName, String projectName) {
        this.ownerName = userName;
        this.projectName = projectName;
    }

    @Override
    public byte[] getRawFile(String revision, String path) throws SVNException, FileNotFoundException {
        Long revId = revision.equals("HEAD") ? -1L : Long.parseLong(revision);
        org.tmatesoft.svn.core.io.SVNRepository repository = this.getSVNRepository();
        if (!repository.checkPath(path, revId.longValue()).equals(SVNNodeKind.FILE)) {
            throw new FileNotFoundException();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        repository.getFile(path, revId.longValue(), null, (OutputStream)baos);
        return baos.toByteArray();
    }

    @Override
    public boolean isIntermediateFolder(String path) {
        return false;
    }

    @Override
    public ObjectNode getMetaDataFromPath(String path) throws SVNException, IOException {
        return this.getMetaDataFromPath(-1, path);
    }

    private ObjectNode getMetaDataFromPath(int revision, String path) throws SVNException, IOException {
        org.tmatesoft.svn.core.io.SVNRepository repository = this.getSVNRepository();
        SVNNodeKind nodeKind = repository.checkPath(path, (long)revision);
        if (nodeKind == SVNNodeKind.DIR) {
            ObjectNode result2 = Json.newObject();
            ObjectNode listData = Json.newObject();
            SVNProperties prop = new SVNProperties();
            Collection entries = repository.getDir(path, -1L, prop, -1, (Collection)null);
            result2.put("type", "folder");
            for (SVNDirEntry entry : entries) {
                ObjectNode data2 = Json.newObject();
                String author = entry.getAuthor();
                User user = User.findByLoginId(author);
                Long commitTime = entry.getDate().getTime();
                data2.put("type", entry.getKind() == SVNNodeKind.DIR ? "folder" : "file");
                data2.put("msg", entry.getCommitMessage());
                data2.put("author", author);
                data2.put("avatar", SVNRepository.getAvatar(user));
                User user2 = user;
                String string = null;
                string = user2.getName();
                data2.put("userName", string);
                user2 = user;
                string = null;
                string = user2.getLoginId();
                data2.put("userLoginId", string);
                data2.put("createdDate", commitTime);
                data2.put("commitMessage", entry.getCommitMessage());
                data2.put("commiter", author);
                data2.put("commitDate", commitTime);
                data2.put("commitId", entry.getRevision());
                data2.put("commitUrl", routes.CodeHistoryApp.show(this.ownerName, this.projectName, String.valueOf(entry.getRevision())).url());
                data2.put("size", entry.getSize());
                listData.put(entry.getName(), (JsonNode)data2);
            }
            result2.put("data", (JsonNode)listData);
            return result2;
        }
        if (nodeKind == SVNNodeKind.FILE) {
            return this.fileAsJson(path, repository);
        }
        return null;
    }

    private static String getAvatar(User user) {
        if (user.isAnonymous() || user.avatarUrl().equals(UserApp.DEFAULT_AVATAR_URL)) {
            String defaultImageUrl = "http://ko.gravatar.com/userimage/53495145/0eaeeb47c620542ad089f17377298af6.png";
            User user2 = user;
            String string = null;
            string = user2.getEmail();
            return GravatarUtil.getAvatar(string, 34, defaultImageUrl);
        }
        return user.avatarUrl();
    }

    @Override
    public ObjectNode getMetaDataFromPath(String revision, String path) throws IOException, SVNException {
        int revisionNumber = -1;
        try {
            revisionNumber = Integer.parseInt(revision);
        }
        catch (NumberFormatException e) {
            Logger.info((String)("Illegal SVN revision: " + revision));
        }
        return this.getMetaDataFromPath(revisionNumber, path);
    }

    private ObjectNode fileAsJson(String path, org.tmatesoft.svn.core.io.SVNRepository repository) throws SVNException, IOException {
        String mimeType;
        boolean isBinary;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SVNProperties prop = new SVNProperties();
        repository.getFile(path, -1L, prop, (OutputStream)baos);
        SVNDirEntry entry = repository.info(path, -1L);
        long size = entry.getSize();
        String data2 = null;
        if (size > MAX_FILE_SIZE_CAN_BE_VIEWED) {
            isBinary = true;
            mimeType = "application/octet-stream";
        } else {
            byte[] bytes = baos.toByteArray();
            isBinary = RawText.isBinary((byte[])bytes);
            if (!isBinary) {
                data2 = new String(bytes, FileUtil.detectCharset(bytes));
            }
            mimeType = new Tika().detect(bytes, path);
        }
        String author = prop.getStringValue("svn:entry:last-author");
        User user = User.findByLoginId(author);
        String commitDate = prop.getStringValue("svn:entry:committed-date");
        DateTimeFormatter dateFormatter = ISODateTimeFormat.dateTime();
        Long commitTime = dateFormatter.parseMillis(commitDate);
        ObjectNode result2 = Json.newObject();
        result2.put("type", "file");
        result2.put("revisionNo", prop.getStringValue("svn:entry:committed-rev"));
        result2.put("author", author);
        result2.put("avatar", SVNRepository.getAvatar(user));
        User user2 = user;
        String string = null;
        string = user2.getName();
        result2.put("userName", string);
        user2 = user;
        string = null;
        string = user2.getLoginId();
        result2.put("userLoginId", string);
        result2.put("createdDate", commitTime);
        result2.put("commitMessage", entry.getCommitMessage());
        result2.put("commiter", author);
        result2.put("size", size);
        result2.put("isBinary", isBinary);
        result2.put("mimeType", mimeType);
        result2.put("data", data2);
        return result2;
    }

    @Override
    public void create() throws SVNException {
        SVNRepositoryFactory.createLocalRepository((File)this.getDirectory(), (boolean)true, (boolean)false);
    }

    @Override
    public void delete() throws Exception {
        FileUtil.rm_rf(this.getDirectory());
    }

    @Override
    public String getPatch(String commitId) throws SVNException, UnsupportedEncodingException {
        long rev = Integer.parseInt(commitId);
        return this.getPatch(rev - 1L, rev);
    }

    @Override
    public String getPatch(String revA, String revB) throws SVNException, UnsupportedEncodingException {
        return this.getPatch(Long.parseLong(revA), Long.parseLong(revB));
    }

    private String getPatch(long revA, long revB) throws SVNException, UnsupportedEncodingException {
        SVNURL svnURL = SVNURL.fromFile((File)this.getDirectory());
        SVNClientManager clientManager = SVNClientManager.newInstance();
        SVNDiffClient diffClient = clientManager.getDiffClient();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        diffClient.doDiff(svnURL, null, SVNRevision.create((long)revA), SVNRevision.create((long)revB), SVNDepth.INFINITY, true, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toString(Config.getCharset().name());
    }

    @Override
    public List<FileDiff> getDiff(String commitId) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<FileDiff> getDiff(String revA, String revB) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Commit> getHistory(int page, int limit, String until, String path) throws IOException, GitAPIException, SVNException {
        long startRevision;
        long endRevision;
        SVNURL svnURL = SVNURL.fromFile((File)this.getDirectory());
        org.tmatesoft.svn.core.io.SVNRepository repository = SVNRepositoryFactory.create((SVNURL)svnURL);
        String[] paths = new String[]{"/"};
        if (path != null) {
            paths[0] = "/" + path;
        }
        if ((endRevision = (startRevision = repository.getLatestRevision() - (long)(page * limit)) - (long)limit) < 1L) {
            endRevision = 1L;
        }
        if (startRevision < endRevision) {
            return new ArrayList<Commit>();
        }
        ArrayList<Commit> result2 = new ArrayList<Commit>();
        for (Object entry : repository.log(paths, null, startRevision, endRevision, false, false)) {
            result2.add(new SvnCommit((SVNLogEntry)entry));
        }
        return result2;
    }

    @Override
    public Commit getCommit(String revNumber) throws IOException, SVNException {
        long rev = Integer.parseInt(revNumber);
        String[] paths = new String[]{"/"};
        SVNURL svnURL = SVNURL.fromFile((File)this.getDirectory());
        org.tmatesoft.svn.core.io.SVNRepository repository = SVNRepositoryFactory.create((SVNURL)svnURL);
        Iterator iterator = repository.log(paths, null, rev, rev, false, false).iterator();
        if (iterator.hasNext()) {
            Object entry = iterator.next();
            return new SvnCommit((SVNLogEntry)entry);
        }
        return null;
    }

    @Override
    public List<String> getRefNames() {
        ArrayList<String> branches2 = new ArrayList<String>();
        branches2.add(SVNRevision.HEAD.getName());
        return branches2;
    }

    @Override
    public Resource asResource() {
        return new Resource(){

            @Override
            public String getId() {
                return null;
            }

            @Override
            public Project getProject() {
                return Project.findByOwnerAndProjectName(SVNRepository.this.ownerName, SVNRepository.this.projectName);
            }

            @Override
            public ResourceType getType() {
                return ResourceType.CODE;
            }
        };
    }

    private org.tmatesoft.svn.core.io.SVNRepository getSVNRepository() throws SVNException {
        SVNURL svnURL = SVNURL.fromFile((File)this.getDirectory());
        return SVNRepositoryFactory.create((SVNURL)svnURL);
    }

    public boolean isFile(String path, long rev) throws SVNException {
        return this.getSVNRepository().checkPath(path, rev) == SVNNodeKind.FILE;
    }

    @Override
    public boolean isFile(String path) throws SVNException, IOException {
        return this.isFile(path, this.getSVNRepository().getLatestRevision());
    }

    @Override
    public boolean isFile(String path, String revStr) throws SVNException {
        return this.isFile(path, Long.parseLong(revStr));
    }

    @Override
    public boolean renameTo(String projectName) {
        return this.move(this.ownerName, this.projectName, this.ownerName, projectName);
    }

    @Override
    public String getDefaultBranch() throws IOException {
        return "HEAD";
    }

    @Override
    public void setDefaultBranch(String target) throws IOException {
    }

    @Override
    public Commit getParentCommitOf(String revNumber) {
        Long rev = Long.parseLong(revNumber) - 1L;
        try {
            return this.getCommit(rev.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isEmpty() {
        org.tmatesoft.svn.core.io.SVNRepository repository = null;
        try {
            SVNURL svnURL = SVNURL.fromFile((File)this.getDirectory());
            repository = SVNRepositoryFactory.create((SVNURL)svnURL);
            boolean bl = repository.getLatestRevision() == 0L;
            return bl;
        }
        catch (SVNException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (repository != null) {
                repository.closeSession();
            }
        }
    }

    @Override
    public boolean move(String srcProjectOwner, String srcProjectName, String desrProjectOwner, String destProjectName) {
        File src = new File(SVNRepository.getRootDirectory(), srcProjectOwner + "/" + srcProjectName);
        File dest = new File(SVNRepository.getRootDirectory(), desrProjectOwner + "/" + destProjectName);
        src.setWritable(true);
        try {
            if (src.exists()) {
                FileUtils.moveDirectory((File)src, (File)dest);
            }
            return true;
        }
        catch (IOException e) {
            Logger.error((String)"Move Failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public File getDirectory() {
        return new File(SVNRepository.getRootDirectory(), this.ownerName + "/" + this.projectName);
    }

    @Override
    public void getArchive(Results.Chunks.Out<byte[]> out, String branchName) {
    }

    public static File getRootDirectory() {
        return new File(Config.getYonaDataDir(), SVNRepository.getRepoPrefix());
    }
}

