/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.List;
import models.Attachment;
import models.enumeration.ResourceType;
import models.resource.Resource;
import play.cache.Cache;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AttachmentCache {
    private static final int ONE_DAY = 86400;

    public static List<Attachment> get(ResourceType containerType, String containerId) {
        String cacheKey = containerType.name() + containerId;
        List cachedData = (List)Cache.get((String)cacheKey);
        if (cachedData != null) {
            return cachedData;
        }
        return null;
    }

    public static void set(String key, List<Attachment> list2) {
        Cache.set((String)key, list2, (int)86400);
    }

    public static void set(Resource container, List<Attachment> list2) {
        Cache.set((String)AttachmentCache.cacheKey(container), list2, (int)86400);
    }

    public static List<Attachment> get(Resource container) {
        String cacheKey = AttachmentCache.cacheKey(container);
        List cachedData = (List)Cache.get((String)cacheKey);
        if (cachedData != null) {
            return cachedData;
        }
        return null;
    }

    private static String cacheKey(Resource container) {
        return container.getType().name() + container.getId();
    }

    public static void remove(Resource container) {
        Cache.remove((String)AttachmentCache.cacheKey(container));
    }

    public static void remove(Attachment attachment) {
        Attachment attachment2 = attachment;
        Object object = null;
        object = attachment2.getContainerType();
        StringBuilder stringBuilder = new StringBuilder().append(object.name());
        attachment2 = attachment;
        object = null;
        object = attachment2.getContainerId();
        Cache.remove((String)stringBuilder.append((String)object).toString());
    }
}

