/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.exception.ExceptionUtils;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class Diagnostic {
    private static final List<Diagnostic> diagnostics = new CopyOnWriteArrayList<Diagnostic>();

    public static void register(@Nonnull Diagnostic diagnostic2) {
        diagnostics.add(diagnostic2);
    }

    @Nonnull
    public static List<String> checkAll() {
        ArrayList<String> errors = new ArrayList<String>();
        for (Diagnostic diagnostic2 : diagnostics) {
            try {
                errors.addAll(diagnostic2.check());
            }
            catch (Exception e) {
                errors.add("Failed to diagnose: " + ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return errors;
    }

    @Nonnull
    public abstract List<String> check();
}

