/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.mozilla.universalchardet.UniversalDetector;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class FileUtil {
    public static void rm_rf(File file) throws Exception {
        if (file.isDirectory()) {
            File[] list2 = file.listFiles();
            if (list2 == null) {
                throw new Exception("Unexpected error while deleting: " + file);
            }
            for (File f2 : list2) {
                FileUtil.rm_rf(f2);
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    private static String or(String a, String b) {
        return StringUtils.isNotEmpty((String)a) ? a : b;
    }

    public static String detectCharset(byte[] bytes) {
        int blockSize;
        UniversalDetector detector = new UniversalDetector(null);
        int offset = 0;
        do {
            blockSize = Math.min(4096, bytes.length - offset);
            detector.handleData(bytes, offset, blockSize);
        } while ((offset += blockSize) < bytes.length);
        detector.dataEnd();
        return FileUtil.or(detector.getDetectedCharset(), "UTF-8");
    }

    public static String detectCharset(InputStream is) throws IOException {
        int nRead;
        UniversalDetector detector = new UniversalDetector(null);
        byte[] buf = new byte[4096];
        while ((nRead = is.read(buf)) > 0 && !detector.isDone()) {
            detector.handleData(buf, 0, nRead);
        }
        detector.dataEnd();
        return FileUtil.or(detector.getDetectedCharset(), "UTF-8");
    }

    public static MediaType detectMediaType(File file, String name) throws IOException {
        return FileUtil.detectMediaType(new FileInputStream(file), name);
    }

    public static MediaType detectMediaType(byte[] bytes, String name) throws IOException {
        return FileUtil.detectMediaType(new ByteArrayInputStream(bytes), name);
    }

    public static MediaType detectMediaType(InputStream is, String name) throws IOException {
        Metadata meta = new Metadata();
        meta.add("resourceName", name);
        MediaType mediaType = new Tika().getDetector().detect((InputStream)new BufferedInputStream(is), meta);
        if (mediaType.getType().toLowerCase().equals("text")) {
            return new MediaType(mediaType, Charset.forName(FileUtil.detectCharset(is)));
        }
        if (mediaType.equals((Object)MediaType.audio((String)"ogg")) && FilenameUtils.getExtension((String)name).toLowerCase().equals("ogv")) {
            return new MediaType("video", "ogg");
        }
        return mediaType;
    }

    public static String getCharset(MediaType mediaType) {
        return mediaType.hasParameters() ? (String)mediaType.getParameters().get("charset") : null;
    }

    public static boolean isSubpathOf(Path subpath, Path path) throws IOException {
        return FileUtil.isSubpathOf(subpath, path, true);
    }

    public static boolean isSubpathOf(Path subpath, Path path, boolean resolveSymlink) throws IOException {
        if (resolveSymlink) {
            path = path.toRealPath(new LinkOption[0]);
            subpath = subpath.toRealPath(new LinkOption[0]);
        }
        return subpath.normalize().startsWith(path.normalize());
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }
}

